/*
 * Decompiled with CFR 0.152.
 */
package com.goide.quickfix;

import com.goide.i18n.GoBundle;
import com.goide.psi.GoFile;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoParameterDeclaration;
import com.goide.psi.GoParameters;
import com.goide.psi.GoReferencesSearch;
import com.goide.psi.GoResult;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeList;
import com.goide.psi.GoTypeOwner;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoLightType;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.impl.fake.GoFakeTypeOwner;
import com.goide.refactor.GoNameSuggestionProvider;
import com.goide.refactor.changeSignature.GoChangeSignatureBuilder;
import com.goide.refactor.changeSignature.GoChangeSignatureHandler;
import com.goide.refactor.changeSignature.GoParameterInfo;
import com.goide.refactor.util.GoRefactoringUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.core.CoreBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class GoChangeSignatureQuickFixBase
extends LocalQuickFixAndIntentionActionOnPsiElement {
    protected HtmlChunk myText;
    private final boolean myCheckIdentical;

    protected GoChangeSignatureQuickFixBase(@NotNull PsiElement element) {
        if (element == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(0);
        }
        this(element, false);
    }

    protected GoChangeSignatureQuickFixBase(@NotNull PsiElement element, boolean checkIdentical) {
        if (element == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(1);
        }
        super(element);
        this.myText = HtmlChunk.text((String)GoBundle.message((String)"go.fix.change.signature.from.usage.text", (Object[])new Object[0]));
        this.myCheckIdentical = checkIdentical;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(2);
        }
        return currentFile;
    }

    public void addIfAvailable(@NotNull @NotNull List<? super @NotNull LocalQuickFix> fixes) {
        if (fixes == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(3);
        }
        if (this.isAvailable()) {
            fixes.add((LocalQuickFix)this);
        }
    }

    protected static void refactorImplementations(@NotNull GoNamedSignatureOwner method, @Nullable Editor editor, @NotNull BiConsumer<GoNamedSignatureOwner, Boolean> refactoring) {
        if (method == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(4);
        }
        if (refactoring == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(5);
        }
        if (FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{method})) {
            GoMethodSpec methodSpec = GoChangeSignatureHandler.findMethodSpec(method);
            boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
            if (editor != null && methodSpec != null && !unitTestMode) {
                String action = GoBundle.message((String)"go.refactoring.refactor.action", (Object[])new Object[0]);
                GoChangeSignatureHandler.createPopup(method, methodSpec, action, refactoring).showInBestPositionFor(editor);
            } else {
                refactoring.accept(methodSpec != null && unitTestMode ? methodSpec : method, unitTestMode);
            }
        } else {
            String message = RefactoringBundle.getCannotRefactorMessage((String)CoreBundle.message((String)"editing.read.only.file.hint", (Object[])new Object[0]));
            String title = RefactoringBundle.message((String)"changeSignature.refactoring.name");
            CommonRefactoringUtil.showErrorHint((Project)method.getProject(), (Editor)editor, (String)message, (String)title, null);
        }
    }

    protected static void doRefactoring(@NotNull GoNamedSignatureOwner method, @NotNull Project project, @NotNull GoChangeSignatureBuilder refactoring) {
        if (method == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(6);
        }
        if (project == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(7);
        }
        if (refactoring == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(8);
        }
        if (GoChangeSignatureQuickFixBase.shouldRunImmediately(method, project)) {
            refactoring.run();
        } else {
            refactoring.show();
        }
    }

    private static boolean shouldRunImmediately(@NotNull GoNamedSignatureOwner method, @NotNull Project project) {
        if (method == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(9);
        }
        if (project == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(10);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        if (method instanceof GoMethodSpec) {
            return false;
        }
        SmartList usages2 = new SmartList();
        Runnable runnable = () -> GoChangeSignatureQuickFixBase.lambda$shouldRunImmediately$1(method, (List)usages2);
        String title = GoBundle.message((String)"go.fix.searching.for.usages.progress.title", (Object[])new Object[0]);
        boolean success = ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, title, true, project);
        return success && usages2.size() < 2;
    }

    @Nullable
    protected List<GoParameterInfo> buildParameters(@NotNull List<TypeOwnerHolder> expressions, @NotNull List<GoParameterInfo> parameters, @NotNull HtmlBuilder preview, @NotNull Set<String> existingNames) {
        if (expressions == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(11);
        }
        if (parameters == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(12);
        }
        if (preview == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(13);
        }
        if (existingNames == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(14);
        }
        return this.buildParameters(expressions, parameters, preview, (List<GoParameterInfo>)new SmartList(), (List<GoParameterInfo>)new SmartList(), (List<GoParameterInfo>)new SmartList(), existingNames);
    }

    @Nullable
    protected List<GoParameterInfo> buildParameters(@NotNull List<TypeOwnerHolder> expressions, @NotNull List<GoParameterInfo> parameters, @NotNull HtmlBuilder preview, @NotNull List<GoParameterInfo> newParameters, @NotNull List<GoParameterInfo> removedParameters, @NotNull List<GoParameterInfo> changeParameters, @NotNull Set<String> existingNames) {
        if (expressions == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(15);
        }
        if (parameters == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(16);
        }
        if (preview == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(17);
        }
        if (newParameters == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(18);
        }
        if (removedParameters == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(19);
        }
        if (changeParameters == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(20);
        }
        if (existingNames == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(21);
        }
        if (ContainerUtil.exists(expressions, expression -> expression.getTypeOwner().getGoType(null) instanceof GoTypeList)) {
            return null;
        }
        SmartList result = new SmartList();
        boolean strictVariadic = this.variadicParameterAcceptsOnlyVariadicExpression(expressions);
        if (expressions.size() < parameters.size()) {
            GoParameterInfo parameter;
            int ei = 0;
            for (int pi = 0; ei < expressions.size() && pi < parameters.size(); ++pi) {
                GoType parameterType;
                TypeOwnerHolder expression2 = expressions.get(ei);
                if (!preview.isEmpty()) {
                    preview.append(", ");
                }
                if ((parameterType = (parameter = parameters.get(pi)).getType()) == null) {
                    return null;
                }
                if (this.isAssignable(parameterType, parameter, expression2, strictVariadic)) {
                    result.add(parameter);
                    preview.append(this.getTypeText(parameter));
                    ++ei;
                    continue;
                }
                removedParameters.add(parameter);
                preview.append((HtmlChunk)this.getTypeText(parameter).strikethrough());
            }
            if (result.size() != expressions.size()) {
                return null;
            }
            for (int i = pi; i < parameters.size(); ++i) {
                if (!preview.isEmpty()) {
                    preview.append(", ");
                }
                parameter = parameters.get(i);
                removedParameters.add(parameter);
                preview.append((HtmlChunk)this.getTypeText(parameter).strikethrough());
            }
            if (removedParameters.isEmpty()) {
                return null;
            }
        } else if (expressions.size() > parameters.size()) {
            boolean namedParameters = StreamEx.of(parameters).map(GoParameterInfo::getName).anyMatch(StringUtil::isNotEmpty);
            int ei = 0;
            int pi = 0;
            GoParameterInfo lastParameter = (GoParameterInfo)ContainerUtil.getLastItem(parameters);
            GoParameterInfo variadicParameter = lastParameter != null && lastParameter.isVariadic() ? lastParameter : null;
            GoType variadicType = (GoType)ObjectUtils.doIfNotNull((Object)variadicParameter, GoParameterInfo::getType);
            int fuse = 0;
            while (ei < expressions.size() || pi < parameters.size()) {
                if (!preview.isEmpty()) {
                    preview.append(", ");
                }
                TypeOwnerHolder expression3 = (TypeOwnerHolder)ContainerUtil.getOrElse(expressions, (int)ei, null);
                GoParameterInfo parameter = (GoParameterInfo)ContainerUtil.getOrElse(parameters, (int)pi, null);
                GoType parameterType = (GoType)ObjectUtils.doIfNotNull((Object)parameter, GoParameterInfo::getType);
                if (parameter != null && parameterType == null) {
                    return null;
                }
                if (parameterType != null && (expression3 == null || this.isAssignable(parameterType, parameter, expression3, strictVariadic))) {
                    result.add(parameter);
                    preview.append(this.getTypeText(parameter));
                    ++pi;
                    ++ei;
                } else if (variadicType != null && !strictVariadic && pi >= parameters.size() && (expression3 == null || this.isAssignable(variadicType, variadicParameter, expression3, false))) {
                    ++pi;
                    ++ei;
                } else if (expression3 != null) {
                    if (variadicType != null && !strictVariadic && pi >= parameters.size()) {
                        return null;
                    }
                    GoType expressionType = expression3.getTypeOwner().getGoType(null);
                    if (expressionType == null || expressionType instanceof GoLightType.LightVoidType || GoTypeUtil.isDocOnlyAnyType(expressionType, null)) {
                        return null;
                    }
                    String name = namedParameters ? GoChangeSignatureQuickFixBase.suggestName(expression3, existingNames) : "";
                    boolean variadic = expression3.isVariadic();
                    GoParameterInfo newParameter = new GoParameterInfo(-1, name, expressionType, variadic);
                    result.add(newParameter);
                    newParameters.add(newParameter);
                    preview.append((HtmlChunk)this.getTypeText(newParameter).bold());
                    ++ei;
                }
                assert (fuse <= expressions.size() + parameters.size()) : "Potentially infinite loop";
                ++fuse;
            }
            if ((variadicType == null || strictVariadic) && result.size() != expressions.size()) {
                return null;
            }
            if (newParameters.isEmpty()) {
                return null;
            }
        } else {
            for (int i = 0; i < parameters.size(); ++i) {
                if (!preview.isEmpty()) {
                    preview.append(", ");
                }
                TypeOwnerHolder expression4 = expressions.get(i);
                GoParameterInfo parameter = parameters.get(i);
                GoType parameterType = parameter.getType();
                if (parameterType == null) {
                    return null;
                }
                if (this.isAssignable(parameterType, parameter, expression4, strictVariadic)) {
                    result.add(parameter);
                    preview.append(this.getTypeText(parameter));
                    continue;
                }
                GoType expressionType = expression4.getTypeOwner().getGoType(null);
                if (expressionType == null || expressionType instanceof GoLightType.LightVoidType || GoTypeUtil.isDocOnlyAnyType(expressionType, null)) {
                    return null;
                }
                boolean variadic = strictVariadic ? expression4.isVariadic() : parameter.isVariadic();
                GoParameterInfo changedParameter = new GoParameterInfo(parameter, expressionType, variadic, null);
                result.add(changedParameter);
                changeParameters.add(changedParameter);
                preview.append((HtmlChunk)this.getTypeText(parameter).strikethrough()).append(" ").append((HtmlChunk)this.getTypeText(changedParameter).bold());
            }
            if (changeParameters.isEmpty()) {
                return null;
            }
        }
        return result;
    }

    @NotNull
    protected HtmlChunk getTypeText(@NotNull GoParameterInfo parameter) {
        GoFile file;
        if (parameter == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(22);
        }
        PsiElement element = this.getStartElement();
        GoType type = parameter.getType();
        if (element != null && type != null && (file = (GoFile)((Object)ObjectUtils.tryCast((Object)element.getContainingFile(), GoFile.class))) != null) {
            HtmlChunk htmlChunk = HtmlChunk.text((String)((parameter.isVariadic() ? "..." : "") + GoRefactoringUtil.getTypeTextWithImports((GoFile)file, (GoType)type).typeText));
            if (htmlChunk == null) {
                GoChangeSignatureQuickFixBase.$$$reportNull$$$0(23);
            }
            return htmlChunk;
        }
        HtmlChunk htmlChunk = HtmlChunk.text((String)parameter.getTypeText());
        if (htmlChunk == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(24);
        }
        return htmlChunk;
    }

    private boolean isAssignable(@NotNull GoType leftType, @NotNull GoParameterInfo parameter, @NotNull TypeOwnerHolder expression, boolean variadicParameterAcceptsOnlyVariadicExpression) {
        if (leftType == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(25);
        }
        if (parameter == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(26);
        }
        if (expression == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(27);
        }
        if (expression.isVariadic() && !parameter.isVariadic()) {
            return false;
        }
        if (variadicParameterAcceptsOnlyVariadicExpression && parameter.isVariadic() && !expression.isVariadic()) {
            return false;
        }
        GoType rightType = expression.getTypeOwner().getGoType(null);
        if (this.myCheckIdentical ? GoTypeUtil.identical(leftType, rightType, expression.getTypeOwner()) : GoTypeUtil.isAssignable(leftType, null, rightType, expression.getTypeOwner(), true)) {
            return true;
        }
        return GoExpressionUtil.isNil(expression.getTypeOwner()) && GoTypeUtil.isAllowedComparingToNil(leftType, expression.getTypeOwner());
    }

    protected boolean variadicParameterAcceptsOnlyVariadicExpression(@NotNull List<TypeOwnerHolder> expressions) {
        if (expressions == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(28);
        }
        return ContainerUtil.or(expressions, TypeOwnerHolder::isVariadic);
    }

    @NotNull
    private static String suggestName(@NotNull TypeOwnerHolder expression, @NotNull Set<String> existingNames) {
        if (expression == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(29);
        }
        if (existingNames == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(30);
        }
        GoNameSuggestionProvider.Settings settings = new GoNameSuggestionProvider.Settings(existingNames);
        settings.options.add(GoNameSuggestionProvider.Option.DO_NOT_SUGGEST_NAMES_BASED_ON_FUNC_PARAM_NAME);
        LinkedHashSet<String> suggestedNames = GoNameSuggestionProvider.getSuggestedNames(expression.getTypeOwner(), null, settings);
        String name = (String)ContainerUtil.getFirstItem(suggestedNames, (Object)"");
        settings.excludedNames.add(name);
        String string = name;
        if (string == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    protected static List<TypeOwnerHolder> getExpressionsFromParameters(@NotNull GoParameters parameters) {
        if (parameters == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(32);
        }
        SmartList expressions = new SmartList();
        for (GoParameterDeclaration declaration : parameters.getParameterDeclarationList()) {
            List<GoParamDefinition> definitions = declaration.getParamDefinitionList();
            if (definitions.isEmpty()) {
                GoType type = Objects.requireNonNull(declaration.getType());
                GoFakeTypeOwner typeOwner = new GoFakeTypeOwner(declaration.getManager(), type, declaration.getContainingFile());
                expressions.add(new TypeOwnerHolder(typeOwner, declaration.isVariadic()));
                continue;
            }
            for (GoParamDefinition definition : definitions) {
                expressions.add(new TypeOwnerHolder(definition, definition.isVariadic()));
            }
        }
        SmartList smartList = expressions;
        if (smartList == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(33);
        }
        return smartList;
    }

    @NotNull
    protected static List<TypeOwnerHolder> getExpressionsFromResultParameters(@Nullable GoResult result) {
        if (result == null) {
            List<TypeOwnerHolder> list = Collections.emptyList();
            if (list == null) {
                GoChangeSignatureQuickFixBase.$$$reportNull$$$0(34);
            }
            return list;
        }
        GoType type = result.getType();
        if (type != null) {
            GoFakeTypeOwner typeOwner = new GoFakeTypeOwner(result.getManager(), type, result.getContainingFile());
            List<TypeOwnerHolder> list = Collections.singletonList(new TypeOwnerHolder(typeOwner));
            if (list == null) {
                GoChangeSignatureQuickFixBase.$$$reportNull$$$0(35);
            }
            return list;
        }
        return GoChangeSignatureQuickFixBase.getExpressionsFromParameters(Objects.requireNonNull(result.getParameters()));
    }

    @NotNull
    public String getText() {
        String string = this.myText.wrapWith("html").toString();
        if (string == null) {
            GoChangeSignatureQuickFixBase.$$$reportNull$$$0(36);
        }
        return string;
    }

    private static /* synthetic */ void lambda$shouldRunImmediately$1(GoNamedSignatureOwner method, List usages2) {
        GoReferencesSearch.search(method, (SearchScope)ReadAction.compute(() -> ((GoNamedSignatureOwner)method).getUseScope())).forEach(reference -> {
            usages2.add(reference);
            return usages2.size() < 2;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 23, 24, 31, 33, 34, 35, 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refactoring";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: 
            case 15: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 12: 
            case 16: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preview";
                break;
            }
            case 14: 
            case 21: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingNames";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParameters";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removedParameters";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeParameters";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 23: 
            case 24: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/quickfix/GoChangeSignatureQuickFixBase";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftType";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/quickfix/GoChangeSignatureQuickFixBase";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestName";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionsFromParameters";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionsFromResultParameters";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addIfAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "refactorImplementations";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doRefactoring";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "shouldRunImmediately";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "buildParameters";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTypeText";
                break;
            }
            case 23: 
            case 24: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isAssignable";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "variadicParameterAcceptsOnlyVariadicExpression";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "suggestName";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionsFromParameters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 23, 24, 31, 33, 34, 35, 36 -> new IllegalStateException(string);
        };
    }

    protected static class TypeOwnerHolder {
        private final GoTypeOwner myTypeOwner;
        private final boolean myVariadic;

        protected TypeOwnerHolder(@NotNull GoTypeOwner typeOwner) {
            if (typeOwner == null) {
                TypeOwnerHolder.$$$reportNull$$$0(0);
            }
            this(typeOwner, false);
        }

        protected TypeOwnerHolder(@NotNull GoTypeOwner typeOwner, boolean variadic) {
            if (typeOwner == null) {
                TypeOwnerHolder.$$$reportNull$$$0(1);
            }
            this.myTypeOwner = typeOwner;
            this.myVariadic = variadic;
        }

        @NotNull
        protected GoTypeOwner getTypeOwner() {
            GoTypeOwner goTypeOwner = this.myTypeOwner;
            if (goTypeOwner == null) {
                TypeOwnerHolder.$$$reportNull$$$0(2);
            }
            return goTypeOwner;
        }

        protected boolean isVariadic() {
            return this.myVariadic;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeOwner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/quickfix/GoChangeSignatureQuickFixBase$TypeOwnerHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/quickfix/GoChangeSignatureQuickFixBase$TypeOwnerHolder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeOwner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

