/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi.properties;

import com.goide.psi.properties.GoFileProperties;
import com.goide.psi.properties.GoFilePropertiesParser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Service
public final class GoFilePropertiesGist {
    private static final GoFileProperties EMPTY_PROPERTIES = new GoFileProperties(null, null, null, false, false);
    @VisibleForTesting
    public static final int READ_FILE_LIMIT = 4096;
    public static final int VERSION = 8;
    private final VirtualFileGist<GoFileProperties> gist = GistManager.getInstance().newVirtualFileGist("GO_FILE_PROPERTIES", 8, (DataExternalizer)new DataExternalizer<GoFileProperties>(){

        public void save(@NotNull DataOutput out, GoFileProperties value2) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            IOUtil.writeUTF((DataOutput)out, (String)StringUtil.notNullize((String)value2.packageName));
            IOUtil.writeUTF((DataOutput)out, (String)StringUtil.notNullize((String)value2.buildFlags));
            IOUtil.writeUTF((DataOutput)out, (String)StringUtil.notNullize((String)value2.goBuildConstraint));
            out.writeBoolean(value2.hasCImport);
            out.writeBoolean(value2.isGenerated);
        }

        public GoFileProperties read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            return new GoFileProperties(StringUtil.nullize((String)IOUtil.readUTF((DataInput)in)), StringUtil.nullize((String)IOUtil.readUTF((DataInput)in)), StringUtil.nullize((String)IOUtil.readUTF((DataInput)in)), in.readBoolean(), in.readBoolean());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/goide/psi/properties/GoFilePropertiesGist$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }, (project, file) -> {
        GoFilePropertiesParser propertiesParser = new GoFilePropertiesParser();
        if (file instanceof LightVirtualFile) {
            return propertiesParser.parse(((LightVirtualFile)file).getContent());
        }
        byte[] buf = new byte[4096];
        try (InputStream stream = file.getInputStream();){
            while (!propertiesParser.isFinished()) {
                int nread = stream.read(buf);
                if (nread == -1) {
                    break;
                }
                propertiesParser.partialParse(String.valueOf(propertiesParser.getPrefixForNextIteration()) + new String(buf, 0, nread, StandardCharsets.UTF_8));
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable ignore) {
            return EMPTY_PROPERTIES;
        }
        return propertiesParser.getFileProperties();
    });

    @NotNull
    public static GoFilePropertiesGist getInstance() {
        GoFilePropertiesGist goFilePropertiesGist = (GoFilePropertiesGist)ApplicationManager.getApplication().getService(GoFilePropertiesGist.class);
        if (goFilePropertiesGist == null) {
            GoFilePropertiesGist.$$$reportNull$$$0(0);
        }
        return goFilePropertiesGist;
    }

    @NotNull
    public VirtualFileGist<GoFileProperties> getGist() {
        VirtualFileGist<GoFileProperties> virtualFileGist = this.gist;
        if (virtualFileGist == null) {
            GoFilePropertiesGist.$$$reportNull$$$0(1);
        }
        return virtualFileGist;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/goide/psi/properties/GoFilePropertiesGist";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGist";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

