/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi.properties;

import com.goide.GoFileType;
import com.goide.execution.testing.GoTestFinder;
import com.goide.psi.GoFile;
import com.goide.psi.properties.GoFilePropertiesGist;
import com.goide.psi.properties.GoFilePropertiesParser;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoFileProperties {
    @Nullable
    public final String packageName;
    @Nullable
    public final String buildFlags;
    @Nullable
    public final String goBuildConstraint;
    public final boolean hasCImport;
    public final boolean isGenerated;

    public GoFileProperties(@Nullable String packageName, @Nullable String buildFlags, @Nullable String goBuildConstraint, boolean hasCImport, boolean isGenerated) {
        this.packageName = packageName;
        this.buildFlags = buildFlags;
        this.goBuildConstraint = goBuildConstraint;
        this.hasCImport = hasCImport;
        this.isGenerated = isGenerated;
    }

    @Deprecated
    public String getCanonicalPackageName(@NotNull VirtualFile file) {
        if (file == null) {
            GoFileProperties.$$$reportNull$$$0(0);
        }
        if (StringUtil.isNotEmpty((String)this.packageName) && GoTestFinder.isTestFile(file)) {
            return StringUtil.trimEnd((String)this.packageName, (String)"_test");
        }
        return this.packageName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GoFileProperties that = (GoFileProperties)o;
        return this.hasCImport == that.hasCImport && this.isGenerated == that.isGenerated && Objects.equals(this.packageName, that.packageName) && Objects.equals(this.buildFlags, that.buildFlags) && Objects.equals(this.goBuildConstraint, that.goBuildConstraint);
    }

    public int hashCode() {
        return Objects.hash(this.packageName, this.buildFlags, this.goBuildConstraint, this.hasCImport, this.isGenerated);
    }

    @Nullable
    public static GoFileProperties of(@Nullable PsiFile file) {
        return file instanceof GoFile ? ((GoFile)file).getFileProperties() : GoFileProperties.calcFileProperties(file);
    }

    @Nullable
    private static GoFileProperties calcFileProperties(@Nullable PsiFile file) {
        if (file == null || file.getFileType() != GoFileType.INSTANCE) {
            return null;
        }
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        if (FileDocumentManager.getInstance().isFileModified(virtualFile)) {
            return (GoFileProperties)CachedValuesManager.getCachedValue((PsiElement)file, () -> new CachedValueProvider.Result((Object)new GoFilePropertiesParser().parse(file.getText()), new Object[]{file}));
        }
        return (GoFileProperties)GoFilePropertiesGist.getInstance().getGist().getFileData(file.getProject(), virtualFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/goide/psi/properties/GoFileProperties", "getCanonicalPackageName"));
    }
}

