/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi.presentation;

import com.goide.codeInsight.imports.GoImport;
import com.goide.index.GoImportPathToAliasIndexKt;
import com.goide.psi.GoFile;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.psi.presentation.GoPsiPresentationFunction;
import com.goide.refactor.GoNameSuggestionProvider;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoUtil;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoContextAwarePresentationFunction
implements GoPsiPresentationFunction {
    private final Map<String, GoImport> myPathsToImport;
    private final GoFile myFile;
    private final boolean myVendoringEnabled;
    private final boolean myExposePrivateTypes;
    @Nullable
    private final Module myModule;
    private final MultiMap<String, GoImportSpec> myImportMap;
    private final Map<String, GoImportSpec> myImportPackagesMap;

    public GoContextAwarePresentationFunction(@NotNull GoFile file) {
        if (file == null) {
            GoContextAwarePresentationFunction.$$$reportNull$$$0(0);
        }
        this(file, false);
    }

    public GoContextAwarePresentationFunction(@NotNull GoFile file, boolean exposePrivateTypes) {
        if (file == null) {
            GoContextAwarePresentationFunction.$$$reportNull$$$0(1);
        }
        this.myPathsToImport = new HashMap<String, GoImport>();
        this.myFile = GoContextAwarePresentationFunction.contextOrSelf(file);
        this.myImportPackagesMap = this.myFile.getImportedPackagesMap();
        this.myModule = GoUtil.module((PsiElement)file);
        this.myVendoringEnabled = GoVendoringUtil.isVendoringEnabled(this.myModule);
        this.myExposePrivateTypes = exposePrivateTypes;
        this.myImportMap = file.getImportMap();
    }

    @NotNull
    public Map<String, GoImport> getPathsToImport() {
        Map<String, GoImport> map = this.myPathsToImport;
        if (map == null) {
            GoContextAwarePresentationFunction.$$$reportNull$$$0(2);
        }
        return map;
    }

    @Override
    public String apply(PsiElement e) {
        if (e instanceof GoSpecType) {
            boolean isAllowed;
            String name;
            GoSpecType specType = (GoSpecType)e;
            GoTypeSpec spec = specType.getTypeSpec();
            String string = name = spec != null ? spec.getName() : null;
            if (name == null) {
                return "interface{}";
            }
            if (GoPsiImplUtil.builtin(spec)) {
                return name;
            }
            GoFile typeFile = (GoFile)((Object)ObjectUtils.tryCast((Object)spec.getContainingFile().getOriginalFile(), GoFile.class));
            if (typeFile == null) {
                return "interface{}";
            }
            if (GoUtil.isDirectlyAccessible((PsiFile)typeFile, (PsiFile)this.myFile)) {
                return name;
            }
            if (!spec.isPublic() && !this.myExposePrivateTypes) {
                return "interface{}";
            }
            VirtualFile declarationFile = typeFile.getVirtualFile();
            boolean bl = isAllowed = declarationFile != null && this.myModule != null && GoUtil.goPathResolveScope(this.myModule, (PsiElement)this.myFile).contains(declarationFile);
            if (!isAllowed) {
                return "interface{}";
            }
            return GoPsiImplUtil.getFqn(this.getQualifierToUse(typeFile), name);
        }
        if (e instanceof GoNamedElement) {
            return ((GoNamedElement)e).getName();
        }
        return e != null ? e.getText() : "";
    }

    @Nullable
    private String getQualifierToUse(@NotNull GoFile typeFile) {
        String importPath;
        if (typeFile == null) {
            GoContextAwarePresentationFunction.$$$reportNull$$$0(3);
        }
        if ((importPath = typeFile.getImportPath(this.myVendoringEnabled)) == null) {
            return null;
        }
        GoImportSpec importSpec = this.myImportPackagesMap.get(importPath);
        String packageName = typeFile.getPackageName();
        if (importSpec != null) {
            if (importSpec.isDot() || importSpec.getAlias() != null) {
                return (String)ContainerUtil.getFirstItem(GoPsiImplUtil.getImportQualifiersToUseInFile(importSpec), (Object)packageName);
            }
            return packageName;
        }
        GoImport addedImport = this.myPathsToImport.get(importPath);
        if (addedImport != null) {
            return (String)ObjectUtils.chooseNotNull((Object)addedImport.getAlias(), (Object)packageName);
        }
        String alias = this.getPreferredAlias(importPath);
        if (alias != null && !this.myImportMap.containsKey((Object)alias)) {
            this.myPathsToImport.put(importPath, new GoImport(importPath, alias));
            return alias;
        }
        if (packageName != null && !this.myImportMap.containsKey((Object)packageName)) {
            this.myPathsToImport.put(importPath, new GoImport(importPath, null));
            return packageName;
        }
        GoImportSpec newSpec = GoElementFactory.createImportSpec((PsiFile)typeFile, importPath, packageName);
        String result = (String)ContainerUtil.getFirstItem(GoNameSuggestionProvider.getSuggestedNames(newSpec, (PsiElement)this.myFile));
        if (result != null) {
            this.myPathsToImport.put(importPath, new GoImport(importPath, result));
        }
        return result;
    }

    @NotNull
    private static GoFile contextOrSelf(@NotNull GoFile file) {
        PsiElement context;
        if (file == null) {
            GoContextAwarePresentationFunction.$$$reportNull$$$0(4);
        }
        GoFile contextFile = (context = GoReferenceBase.getSubstitutionContext((PsiElement)file)) != null ? (GoFile)((Object)ObjectUtils.tryCast((Object)context.getContainingFile(), GoFile.class)) : null;
        GoFile goFile = (GoFile)CompletionUtil.getOriginalOrSelf((PsiElement)((GoFile)((Object)ObjectUtils.chooseNotNull((Object)((Object)contextFile), (Object)((Object)file)))));
        if (goFile == null) {
            GoContextAwarePresentationFunction.$$$reportNull$$$0(5);
        }
        return goFile;
    }

    @Nullable
    private String getPreferredAlias(@NotNull String importPath) {
        if (importPath == null) {
            GoContextAwarePresentationFunction.$$$reportNull$$$0(6);
        }
        GlobalSearchScope projectNoLibs = GoSdkUtil.getGoModules(this.myFile.getProject()).stream().map(module -> GoUtil.moduleScopeWithoutLibraries(this.myFile.getProject(), module)).reduce(GlobalSearchScope::uniteWith).orElse(GlobalSearchScope.EMPTY_SCOPE);
        IntRef totalUsageCount = new IntRef();
        HashMap aliasUsageCount = new HashMap();
        GoImportPathToAliasIndexKt.processAliasesByImportPath(projectNoLibs, importPath, (FileBasedIndex.ValueProcessor<? super String>)((FileBasedIndex.ValueProcessor)(file, alias) -> {
            totalUsageCount.inc();
            aliasUsageCount.merge(alias, 1, (count1, count2) -> count1 + count2);
            return true;
        }));
        int total = totalUsageCount.get();
        String mostPopularAlias = null;
        double mostPopularUsagePercents = 0.0;
        for (Map.Entry entry : aliasUsageCount.entrySet()) {
            double usage = (double)((Integer)entry.getValue()).intValue() * 100.0 / (double)total;
            if (!(usage > mostPopularUsagePercents)) continue;
            mostPopularAlias = (String)entry.getKey();
            mostPopularUsagePercents = usage;
        }
        return mostPopularUsagePercents > 50.0 ? mostPopularAlias : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/psi/presentation/GoContextAwarePresentationFunction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/psi/presentation/GoContextAwarePresentationFunction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsToImport";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "contextOrSelf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierToUse";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "contextOrSelf";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredAlias";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }
}

