/*
 * Decompiled with CFR 0.152.
 */
package com.goide.project;

import com.goide.project.GoLibrariesService;
import com.goide.project.GoLibrariesState;
import com.goide.sdk.GoSdkUtil;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="GoLibraries", storages={@Storage(value="goLibraries.xml", deprecated=true), @Storage(value="$PROJECT_FILE$", deprecated=true), @Storage(value="$WORKSPACE_FILE$")})
@Service(value={Service.Level.PROJECT})
public final class GoProjectLibrariesService
extends GoLibrariesService<GoProjectLibrariesState> {
    @Nullable
    private final Project myProject;

    public GoProjectLibrariesService(@Nullable Project project) {
        super(new GoProjectLibrariesState());
        this.myProject = project;
    }

    public static GoProjectLibrariesService getInstance(@NotNull Project project) {
        if (project == null) {
            GoProjectLibrariesService.$$$reportNull$$$0(0);
        }
        return (GoProjectLibrariesService)((Object)project.getService(GoProjectLibrariesService.class));
    }

    @Override
    protected Project @NotNull [] getProjectsToNotify() {
        Project[] projectArray = new Project[]{this.myProject};
        if (projectArray == null) {
            GoProjectLibrariesService.$$$reportNull$$$0(1);
        }
        return projectArray;
    }

    @Override
    public void loadState(@NotNull GoProjectLibrariesState state) {
        if (state == null) {
            GoProjectLibrariesService.$$$reportNull$$$0(2);
        }
        super.loadState(state);
    }

    public boolean isUseGoPathFromSystemEnvironment() {
        return ((GoProjectLibrariesState)this.myState).isUseGoPathFromSystemEnvironment();
    }

    public void setUseGoPathFromSystemEnvironment(boolean useGoPathFromSystemEnvironment) {
        if (((GoProjectLibrariesState)this.myState).isUseGoPathFromSystemEnvironment() != useGoPathFromSystemEnvironment) {
            if (this.myProject != null && !GoSdkUtil.getGoPathsRootsFromEnvironment(this.myProject, null).isEmpty()) {
                this.notifyProjectsAboutChangedRoots(RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED, () -> {
                    this.incModificationCount();
                    ((GoProjectLibrariesState)this.myState).setUseGoPathFromSystemEnvironment(useGoPathFromSystemEnvironment);
                }, () -> ((GoLibrariesService.LibrariesListener)this.myProject.getMessageBus().syncPublisher(LIBRARIES_TOPIC)).librariesChanged(this.getLibraryRootUrls()));
            } else {
                this.incModificationCount();
                ((GoProjectLibrariesState)this.myState).setUseGoPathFromSystemEnvironment(useGoPathFromSystemEnvironment);
            }
        }
    }

    public boolean isIndexEntireGopath() {
        return ((GoProjectLibrariesState)this.myState).isIndexEntireGoPath();
    }

    public void setIndexEntireGopath(boolean indexEntireGoPath) {
        if (((GoProjectLibrariesState)this.myState).isIndexEntireGoPath() != indexEntireGoPath) {
            if (this.myProject != null) {
                this.notifyProjectsAboutChangedRoots(RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED, () -> {
                    this.incModificationCount();
                    ((GoProjectLibrariesState)this.myState).setIndexEntireGoPath(indexEntireGoPath);
                }, () -> ((GoLibrariesService.LibrariesListener)this.myProject.getMessageBus().syncPublisher(LIBRARIES_TOPIC)).librariesChanged(this.getLibraryRootUrls()));
            } else {
                this.incModificationCount();
                ((GoProjectLibrariesState)this.myState).setIndexEntireGoPath(indexEntireGoPath);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/project/GoProjectLibrariesService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/project/GoProjectLibrariesService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectsToNotify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static class GoProjectLibrariesState
    extends GoLibrariesState {
        private boolean myUseGoPathFromSystemEnvironment = true;
        private boolean myIndexEntireGoPath = false;

        public boolean isUseGoPathFromSystemEnvironment() {
            return this.myUseGoPathFromSystemEnvironment;
        }

        public void setUseGoPathFromSystemEnvironment(boolean useGoPathFromSystemEnvironment) {
            this.myUseGoPathFromSystemEnvironment = useGoPathFromSystemEnvironment;
        }

        public boolean isIndexEntireGoPath() {
            return this.myIndexEntireGoPath;
        }

        public void setIndexEntireGoPath(boolean indexEntireGoPath) {
            this.myIndexEntireGoPath = indexEntireGoPath;
        }
    }
}

