/*
 * Decompiled with CFR 0.152.
 */
package com.goide.project;

import com.goide.GoLibrariesUtil;
import com.goide.project.GoModuleSettings;
import com.goide.project.GoProjectLibrariesService;
import com.goide.sdk.GoSdkService;
import com.goide.tree.GoExportabilitySorter;
import com.goide.util.GoUtil;
import com.goide.vendor.GoVendorDirectoriesCollector;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.RunOnceUtil;
import com.intellij.ide.util.treeView.smartTree.TreeStructureUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.project.ProjectKt;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

final class GoPluginUrgentConfigurator
implements StartupActivity.DumbAware {
    private static final String MIGRATED_GO_MODULES_SETTINGS = "go.migrated.go.modules.settings";
    private static final String ENABLED_EXPORTABILITY_SORTER = "go.enabled.exportability.sorter";

    GoPluginUrgentConfigurator() {
    }

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            GoPluginUrgentConfigurator.$$$reportNull$$$0(0);
        }
        if (project.isDisposed()) {
            return;
        }
        RunOnceUtil.runOnceForProject((Project)project, (String)MIGRATED_GO_MODULES_SETTINGS, () -> GoPluginUrgentConfigurator.migrateGoModulesSettings(project));
        DumbService.getInstance((Project)project).runWhenSmart(() -> GoVendorDirectoriesCollector.getInstance(project).requestVendorDirectoriesRecalculation());
        project.getMessageBus().simpleConnect().subscribe(GoModuleSettings.GO_SUPPORT_TOPIC, (m, batchUpdate) -> {
            if (!batchUpdate && !project.isDisposed()) {
                GoSdkService.getInstance(project).incModificationCount();
                if (!m.isDisposed()) {
                    GoLibrariesUtil.updateLibraries(project, RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED, EmptyRunnable.getInstance(), null);
                }
                GoUtil.cleanResolveCache(project);
            }
        });
        RunOnceUtil.runOnceForApp((String)ENABLED_EXPORTABILITY_SORTER, () -> PropertiesComponent.getInstance().setValue(TreeStructureUtil.getPropertyName((String)GoExportabilitySorter.INSTANCE.getName()), true));
    }

    private static void migrateGoModulesSettings(@NotNull Project project) {
        VgoProjectSettings settings;
        if (project == null) {
            GoPluginUrgentConfigurator.$$$reportNull$$$0(1);
        }
        if (!(settings = VgoProjectSettings.getInstance(project)).isSettingsMigrated()) {
            settings.setSettingsMigrated(true);
            boolean[] previousValues = new boolean[]{false, true};
            Path workspaceFile = ProjectKt.getStateStore((Project)project).getWorkspacePath();
            if (!Files.exists(workspaceFile, new LinkOption[0])) {
                return;
            }
            try (Stream<String> lines = Files.lines(workspaceFile);){
                lines.forEach(line -> {
                    String trimmed = line.trim();
                    if ("<integration-enabled>true</integration-enabled>".equals(trimmed)) {
                        previousValues[0] = true;
                    } else if ("<option name=\"indexEntireGoPath\" value=\"false\" />".equals(trimmed)) {
                        previousValues[1] = false;
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
            settings.setIntegrationEnabled(previousValues[0]);
            GoProjectLibrariesService.getInstance(project).setIndexEntireGopath(previousValues[1]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/goide/project/GoPluginUrgentConfigurator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "migrateGoModulesSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

