/*
 * Decompiled with CFR 0.152.
 */
package com.goide.playground.actions;

import com.goide.i18n.GoBundle;
import com.goide.playground.managers.GoPlaygroundEditorManager;
import com.goide.vgo.imports.VgoScratchFileService;
import com.goide.vgo.project.VgoDependency;
import com.goide.vgo.project.VgoModule;
import com.goide.vgo.project.VgoModulesRegistry;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.committed.LabeledComboBoxAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoScratchFileNotificationAction
extends LabeledComboBoxAction
implements DumbAware {
    GoPlaygroundEditorManager myManager;

    public GoScratchFileNotificationAction(@NotNull GoPlaygroundEditorManager manager) {
        if (manager == null) {
            GoScratchFileNotificationAction.$$$reportNull$$$0(0);
        }
        super(GoBundle.message((String)"go.modules.scratch.file.notification.text", (Object[])new Object[0]));
        this.myManager = manager;
        final Project project = this.myManager.getEditor().getProject();
        if (project == null) {
            return;
        }
        if (this.selectContextIfAvailable(project, null)) {
            return;
        }
        final MessageBusConnection connection = project.getMessageBus().connect((Disposable)manager);
        connection.subscribe(ModuleRootListener.TOPIC, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                GoScratchFileNotificationAction.this.selectContextIfAvailable(project, connection);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/goide/playground/actions/GoScratchFileNotificationAction$1", "rootsChanged"));
            }
        });
        connection.subscribe(WorkspaceModelTopics.CHANGED, (Object)new WorkspaceModelChangeListener(){

            public void changed(@NotNull VersionedStorageChange event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                GoScratchFileNotificationAction.this.selectContextIfAvailable(project, connection);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/goide/playground/actions/GoScratchFileNotificationAction$2", "changed"));
            }
        });
    }

    private boolean selectContextIfAvailable(@NotNull Project project, @Nullable MessageBusConnection connection) {
        String[] availableContexts;
        if (project == null) {
            GoScratchFileNotificationAction.$$$reportNull$$$0(1);
        }
        if ((availableContexts = GoScratchFileNotificationAction.getImportPaths(project)).length == 0) {
            return false;
        }
        GoScratchFileNotificationAction.selectContext(project, this.myManager.getFile(), availableContexts[0]);
        if (connection != null) {
            connection.disconnect();
        }
        return true;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GoScratchFileNotificationAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GoScratchFileNotificationAction.$$$reportNull$$$0(3);
        }
        super.update(e);
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        VirtualFile file = this.myManager.getFile();
        @NlsSafe String path = VgoScratchFileService.getInstance(project).getImportPath(file);
        e.getPresentation().setText(path);
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button, @NotNull DataContext context) {
        if (button == null) {
            GoScratchFileNotificationAction.$$$reportNull$$$0(4);
        }
        if (context == null) {
            GoScratchFileNotificationAction.$$$reportNull$$$0(5);
        }
        Project project = this.myManager.getEditor().getProject();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        if (project == null) {
            DefaultActionGroup defaultActionGroup = actionGroup;
            if (defaultActionGroup == null) {
                GoScratchFileNotificationAction.$$$reportNull$$$0(6);
            }
            return defaultActionGroup;
        }
        Object[] paths = GoScratchFileNotificationAction.getImportPaths(project);
        actionGroup.addAll((Collection)ContainerUtil.map((Object[])paths, e -> new SelectContextAction((String)e)));
        DefaultActionGroup defaultActionGroup = actionGroup;
        if (defaultActionGroup == null) {
            GoScratchFileNotificationAction.$$$reportNull$$$0(7);
        }
        return defaultActionGroup;
    }

    @NlsSafe
    private static String[] getImportPaths(@NotNull Project project) {
        if (project == null) {
            GoScratchFileNotificationAction.$$$reportNull$$$0(8);
        }
        Collection<VgoModule> modules = VgoModulesRegistry.getInstance(project).getModules();
        return (String[])ContainerUtil.map2Array(modules, (Object[])ArrayUtil.EMPTY_STRING_ARRAY, VgoDependency::getImportPath);
    }

    private static void selectContext(@NotNull Project project, @NotNull VirtualFile file, @NotNull String context) {
        PsiFile psiFile;
        VgoScratchFileService service;
        if (project == null) {
            GoScratchFileNotificationAction.$$$reportNull$$$0(9);
        }
        if (file == null) {
            GoScratchFileNotificationAction.$$$reportNull$$$0(10);
        }
        if (context == null) {
            GoScratchFileNotificationAction.$$$reportNull$$$0(11);
        }
        if (!StringUtil.equals((CharSequence)context, (CharSequence)(service = VgoScratchFileService.getInstance(project)).getImportPath(file))) {
            service.mapToModule(file, context);
            GoScratchFileNotificationAction.dropCaches(project);
        }
        if ((psiFile = PsiManager.getInstance((Project)project).findFile(file)) != null) {
            DaemonCodeAnalyzer.getInstance((Project)project).restart(psiFile);
        }
    }

    private static void dropCaches(@NotNull Project project) {
        if (project == null) {
            GoScratchFileNotificationAction.$$$reportNull$$$0(12);
        }
        VgoModulesRegistry.getInstance(project).incModificationCount();
        ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> PsiManager.getInstance((Project)project).dropPsiCaches());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/playground/actions/GoScratchFileNotificationAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/playground/actions/GoScratchFileNotificationAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "selectContextIfAvailable";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPopupActionGroup";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getImportPaths";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "selectContext";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "dropCaches";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 7 -> new IllegalStateException(string);
        };
    }

    private class SelectContextAction
    extends DumbAwareAction {
        @NlsSafe
        private final String contextName;

        SelectContextAction(String contextName) {
            super(contextName, GoBundle.message((String)"go.playground.actions.go.context.description.prefix", (Object[])new Object[0]) + " " + contextName, null);
            this.contextName = contextName;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                SelectContextAction.$$$reportNull$$$0(0);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            VirtualFile file = GoScratchFileNotificationAction.this.myManager.getFile();
            GoScratchFileNotificationAction.selectContext(project, file, this.contextName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/goide/playground/actions/GoScratchFileNotificationAction$SelectContextAction", "actionPerformed"));
        }
    }
}

