/*
 * Decompiled with CFR 0.152.
 */
package com.goide.microservices.endpoints;

import com.goide.GoFileType;
import com.goide.microservices.GoLangModificationTracker;
import com.goide.microservices.declarations.GoDeclarationPatternsKt;
import com.goide.microservices.declarations.GoEndpointDeclaration;
import com.goide.microservices.declarations.GoQualifiedName;
import com.goide.microservices.endpoints.GoEndpointData;
import com.goide.microservices.endpoints.GoLocalAuthoritySearcher;
import com.goide.microservices.endpoints.LibraryFunctionCollectProcessor;
import com.goide.microservices.parsing.GoEndpoint;
import com.goide.microservices.parsing.GoEndpointParser;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoReferencesSearch;
import com.goide.psi.GoStringLiteral;
import com.goide.stubs.index.GoAllPublicNamesIndex;
import com.goide.stubs.index.GoNonPackageLevelNamesIndex;
import com.goide.util.GoUtil;
import com.intellij.microservices.url.Authority;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0005H\u0002\u001a(\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\u0006\u0010\u0017\u001a\u00020\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a&\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00192\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u001dH\u0002\u001a\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00032\b\u0010 \u001a\u0004\u0018\u00010!H\u0000\u001a\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00032\u0006\u0010 \u001a\u00020\fH\u0002\"Q\u0010\u0000\u001aE\u0012<\u0012:\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003 \u0007*\u001c\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010%\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"LIBRARY_SERVER_FUNCTIONS_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "", "Lkotlin/Pair;", "Lcom/goide/microservices/declarations/GoEndpointDeclaration;", "Lcom/goide/psi/GoNamedElement;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getOrComputeEndpointsInFile", "Lcom/goide/microservices/endpoints/GoEndpointData;", "goFile", "Lcom/goide/psi/GoFile;", "getOrComputePotentialFilesWithEndpoints", "module", "Lcom/intellij/openapi/module/Module;", "findPotentialFilesWithEndpoints", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "computeEndpoints", "collectLibraryFunctions", "declaration", "toEndpointData", "Lkotlin/sequences/Sequence;", "libraryFunction", "findUrlsByArgumentIndex", "Lcom/goide/psi/GoStringLiteral;", "Lcom/intellij/psi/search/SearchScope;", "getOrComputeAuthorities", "Lcom/intellij/microservices/url/Authority;", "file", "Lcom/intellij/psi/PsiFile;", "computeLocalAuthorities", "fullAuthorityPattern", "Lkotlin/text/Regex;", "portOnlyPattern", "intellij.go.microservices"})
@SourceDebugExtension(value={"SMAP\nGoEndpointUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoEndpointUtils.kt\ncom/goide/microservices/endpoints/GoEndpointUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,202:1\n1563#2:203\n1634#2,3:204\n1869#2,2:207\n808#2,11:209\n1387#2:220\n1475#2,5:221\n1374#2:230\n1460#2,2:231\n1563#2:233\n1634#2,3:234\n1462#2,3:237\n30#3,2:226\n30#3,2:228\n67#4:240\n*S KotlinDebug\n*F\n+ 1 GoEndpointUtils.kt\ncom/goide/microservices/endpoints/GoEndpointUtilsKt\n*L\n64#1:203\n64#1:204,3\n65#1:207,2\n69#1:209,11\n84#1:220\n84#1:221,5\n79#1:230\n79#1:231,2\n79#1:233\n79#1:234,3\n79#1:237,3\n45#1:226,2\n53#1:228,2\n154#1:240\n*E\n"})
public final class GoEndpointUtilsKt {
    @NotNull
    private static final Key<CachedValue<List<Pair<GoEndpointDeclaration, GoNamedElement>>>> LIBRARY_SERVER_FUNCTIONS_KEY;
    @NotNull
    private static final Regex fullAuthorityPattern;
    @NotNull
    private static final Regex portOnlyPattern;

    @NotNull
    public static final List<GoEndpointData> getOrComputeEndpointsInFile(@NotNull GoFile goFile) {
        Intrinsics.checkNotNullParameter((Object)((Object)goFile), (String)"goFile");
        Project project = goFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Object object = CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)goFile, () -> GoEndpointUtilsKt.getOrComputeEndpointsInFile$lambda$0(goFile, project2));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    @NotNull
    public static final List<GoFile> getOrComputePotentialFilesWithEndpoints(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Object object = CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> GoEndpointUtilsKt.getOrComputePotentialFilesWithEndpoints$lambda$1(module));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<GoFile> findPotentialFilesWithEndpoints(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$forEach$iv;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        Set foundCandidates = new LinkedHashSet();
        Processor processor2 = Processors.cancelableCollectProcessor((Collection)foundCandidates);
        Intrinsics.checkNotNullExpressionValue((Object)processor2, (String)"cancelableCollectProcessor(...)");
        Processor processor3 = processor2;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope((Project)project, (Collection)FileTypeIndex.getFiles((FileType)((FileType)GoFileType.INSTANCE), (GlobalSearchScope)searchScope));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"filesScope(...)");
        GlobalSearchScope scope = globalSearchScope;
        Iterable iterable = GoDeclarationPatternsKt.getGoAllEndpointDeclarations();
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            GoEndpointDeclaration goEndpointDeclaration = (GoEndpointDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getQualifiedName().getShortName());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            PsiSearchHelper.getInstance((Project)project).processAllFilesWithWord(it, scope, processor3, true);
        }
        Iterable $this$filterIsInstance$iv = foundCandidates;
        boolean $i$f$filterIsInstance = false;
        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GoFile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<GoEndpointData> computeEndpoints(GoFile goFile) {
        void $this$flatMapTo$iv$iv;
        Project project = goFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        CachedValuesManager manager = CachedValuesManager.getManager((Project)project2);
        List declarationToFunctionPairs = (List)manager.getCachedValue((UserDataHolder)project2, LIBRARY_SERVER_FUNCTIONS_KEY, () -> GoEndpointUtilsKt.computeEndpoints$lambda$6(project2), false);
        Intrinsics.checkNotNull((Object)declarationToFunctionPairs);
        Iterable $this$flatMap$iv = declarationToFunctionPairs;
        boolean $i$f$flatMapSequence = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            Sequence<GoEndpointData> list$iv$iv = GoEndpointUtilsKt.toEndpointData((GoEndpointDeclaration)it.getFirst(), (GoNamedElement)it.getSecond(), goFile);
            CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final List<GoNamedElement> collectLibraryFunctions(Project project, GoEndpointDeclaration declaration) {
        StubIndexKey<String, GoNamedElement> stubIndexKey;
        List foundElements = new ArrayList();
        LibraryFunctionCollectProcessor cancelableCollectProcessor = new LibraryFunctionCollectProcessor(foundElements, declaration);
        GoQualifiedName goQualifiedName = declaration.getQualifiedName();
        if (goQualifiedName instanceof GoQualifiedName.Function) {
            stubIndexKey = GoAllPublicNamesIndex.ALL_PUBLIC_NAMES;
        } else if (goQualifiedName instanceof GoQualifiedName.Method) {
            stubIndexKey = GoNonPackageLevelNamesIndex.KEY;
        } else {
            return CollectionsKt.emptyList();
        }
        StubIndexKey<String, GoNamedElement> indexKey = stubIndexKey;
        StubIndex.getInstance().processElements(indexKey, (Object)declaration.getQualifiedName().getAsInIndex(), project, ProjectScope.getLibrariesScope((Project)project), GoNamedElement.class, (Processor)cancelableCollectProcessor);
        return foundElements;
    }

    private static final Sequence<GoEndpointData> toEndpointData(GoEndpointDeclaration declaration, GoNamedElement libraryFunction, GoFile goFile) {
        if (libraryFunction == null) {
            return SequencesKt.emptySequence();
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)((PsiFile)goFile));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"fileScope(...)");
        return SequencesKt.mapNotNull(GoEndpointUtilsKt.findUrlsByArgumentIndex(declaration, libraryFunction, (SearchScope)globalSearchScope), arg_0 -> GoEndpointUtilsKt.toEndpointData$lambda$8(declaration, arg_0));
    }

    private static final Sequence<GoStringLiteral> findUrlsByArgumentIndex(GoEndpointDeclaration declaration, GoNamedElement libraryFunction, SearchScope searchScope) {
        if (!Intrinsics.areEqual((Object)GoUtil.getImportPath(libraryFunction, libraryFunction.getContext()), (Object)declaration.getQualifiedName().getImportPath())) {
            return SequencesKt.emptySequence();
        }
        Query<PsiReference> query = GoReferencesSearch.search(libraryFunction, searchScope);
        Intrinsics.checkNotNullExpressionValue(query, (String)"search(...)");
        return SequencesKt.filterIsInstance((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)query)), GoEndpointUtilsKt::findUrlsByArgumentIndex$lambda$9), arg_0 -> GoEndpointUtilsKt.findUrlsByArgumentIndex$lambda$10(declaration, arg_0)), GoStringLiteral.class);
    }

    @NotNull
    public static final List<Authority> getOrComputeAuthorities(@Nullable PsiFile file) {
        if (!(file instanceof GoFile)) {
            return CollectionsKt.emptyList();
        }
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file), () -> GoEndpointUtilsKt.getOrComputeAuthorities$lambda$11(file));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    private static final List<Authority> computeLocalAuthorities(GoFile file) {
        GoLocalAuthoritySearcher visitor2 = new GoLocalAuthoritySearcher();
        file.accept(visitor2);
        return visitor2.getAuthorities();
    }

    private static final CachedValueProvider.Result getOrComputeEndpointsInFile$lambda$0(GoFile $goFile, Project $project) {
        Object[] objectArray = new Object[1];
        ComponentManager $this$service$iv = (ComponentManager)$project;
        boolean $i$f$service = false;
        Class<GoLangModificationTracker> serviceClass$iv = GoLangModificationTracker.class;
        if ($this$service$iv.getService(serviceClass$iv) == null) {
            Object cfr_ignored_0 = objectArray[0];
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return new CachedValueProvider.Result(GoEndpointUtilsKt.computeEndpoints($goFile), objectArray);
    }

    private static final CachedValueProvider.Result getOrComputePotentialFilesWithEndpoints$lambda$1(Module $module) {
        Project project = $module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        GlobalSearchScope globalSearchScope = $module.getModuleContentWithDependenciesScope();
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getModuleContentWithDependenciesScope(...)");
        List<GoFile> list = GoEndpointUtilsKt.findPotentialFilesWithEndpoints(project, globalSearchScope);
        Object[] objectArray = new Object[1];
        Project project2 = $module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<GoLangModificationTracker> serviceClass$iv = GoLangModificationTracker.class;
        if ($this$service$iv.getService(serviceClass$iv) == null) {
            Object cfr_ignored_0 = objectArray[0];
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return new CachedValueProvider.Result(list, objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private static final CachedValueProvider.Result computeEndpoints$lambda$6(Project $project) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = GoDeclarationPatternsKt.getGoAllEndpointDeclarations();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            GoEndpointDeclaration declaration = (GoEndpointDeclaration)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = GoEndpointUtilsKt.collectLibraryFunctions($project, declaration);
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GoNamedElement goNamedElement = (GoNamedElement)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(TuplesKt.to((Object)declaration, (Object)it));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Object[] objectArray = new Object[]{ProjectRootManager.getInstance((Project)$project)};
        Object[] objectArray2 = objectArray;
        List list = (List)destination$iv$iv;
        return new CachedValueProvider.Result((Object)list, objectArray2);
    }

    private static final GoEndpointData toEndpointData$lambda$8(GoEndpointDeclaration $declaration, GoStringLiteral it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        GoEndpoint parsedEndpoint = GoEndpointParser.INSTANCE.parse(it, $declaration.getHttpMethod());
        return parsedEndpoint.getUrl() == null ? null : new GoEndpointData(parsedEndpoint.getHttpMethods(), parsedEndpoint.getUrl(), (SmartPsiElementPointer<GoExpression>)SmartPointersKt.createSmartPointer((PsiElement)it));
    }

    /*
     * WARNING - void declaration
     */
    private static final GoCallExpr findUrlsByArgumentIndex$lambda$9(PsiReference reference) {
        void $this$parentOfType$iv;
        PsiElement psiElement = reference.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        PsiElement psiElement2 = psiElement;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        return (GoCallExpr)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, GoCallExpr.class, (boolean)false);
    }

    private static final GoExpression findUrlsByArgumentIndex$lambda$10(GoEndpointDeclaration $declaration, GoCallExpr call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        List<GoExpression> list = call.getArgumentList().getExpressionList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getExpressionList(...)");
        return (GoExpression)CollectionsKt.getOrNull(list, (int)$declaration.getArgumentIndex());
    }

    private static final CachedValueProvider.Result getOrComputeAuthorities$lambda$11(PsiFile $file) {
        List<Authority> authorities = GoEndpointUtilsKt.computeLocalAuthorities((GoFile)$file);
        Object[] objectArray = new Object[1];
        Project project = ((GoFile)$file).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        objectArray[0] = GoLangModificationTracker.Companion.getInstance(project);
        return new CachedValueProvider.Result(authorities, objectArray);
    }

    public static final /* synthetic */ Regex access$getFullAuthorityPattern$p() {
        return fullAuthorityPattern;
    }

    public static final /* synthetic */ Regex access$getPortOnlyPattern$p() {
        return portOnlyPattern;
    }

    static {
        Key key = Key.create((String)"GoLibraryServerFunctions");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        LIBRARY_SERVER_FUNCTIONS_KEY = key;
        fullAuthorityPattern = new Regex("(\\S+):(\\S+)");
        portOnlyPattern = new Regex(":(\\d+)");
    }
}

