/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.time;

import com.goide.inspections.time.GoTimeFile;
import com.goide.inspections.time.GoTimeToken;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.util.ObjectUtils;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoTimeParameterInfoHandler
implements ParameterInfoHandler<GoTimeFile, GoTimeToken>,
DumbAware {
    public static final Map<GoTimeToken, String> DESCRIPTIONS = Map.ofEntries(Map.entry(GoTimeToken.TEXT, "Text fragment"), Map.entry(GoTimeToken.LONG_MONTH, "Month (full)"), Map.entry(GoTimeToken.MONTH, "Month (short)"), Map.entry(GoTimeToken.LONG_WEEK_DAY, "Day of week (full)"), Map.entry(GoTimeToken.WEEK_DAY, "Day of week (short)"), Map.entry(GoTimeToken.TZ, "Time zone"), Map.entry(GoTimeToken.ZERO_MONTH, "Month (zero-padded)"), Map.entry(GoTimeToken.ZERO_DAY, "Day of month (zero-padded)"), Map.entry(GoTimeToken.ZERO_HOUR12, "12-hour (zero-padded)"), Map.entry(GoTimeToken.ZERO_MINUTE, "Minute (zero-padded)"), Map.entry(GoTimeToken.ZERO_SECOND, "Second (zero-padded)"), Map.entry(GoTimeToken.ZERO_YEAR, "Year (two-digit)"), Map.entry(GoTimeToken.ZERO_YEAR_DAY, "Day of year (three-digit zero-padded)"), Map.entry(GoTimeToken.HOUR, "24-hour (zero-padded)"), Map.entry(GoTimeToken.NUM_MONTH, "Month (no padding)"), Map.entry(GoTimeToken.LONG_YEAR, "Year (four-digit)"), Map.entry(GoTimeToken.DAY, "Day of month (no padding)"), Map.entry(GoTimeToken.UNDER_DAY, "Day of month (space-padded)"), Map.entry(GoTimeToken.UNDER_YEAR, "Day of year (three-digit space-padded)"), Map.entry(GoTimeToken.HOUR12, "12-hour (no padding)"), Map.entry(GoTimeToken.MINUTE, "Minute (no padding)"), Map.entry(GoTimeToken.SECOND, "Second (no padding)"), Map.entry(GoTimeToken.PM_BIG, "AM/PM marker"), Map.entry(GoTimeToken.PM_SMALL, "am/pm marker"), Map.entry(GoTimeToken.NUM_SECONDS_TZ, "Time zone offset \u00b1hhmmss"), Map.entry(GoTimeToken.NUM_COLON_SECONDS_TZ, "Time zone offset \u00b1hh:mm:ss"), Map.entry(GoTimeToken.NUM_TZ, "Time zone offset \u00b1hhmm"), Map.entry(GoTimeToken.NUM_COLON_TZ, "Time zone offset \u00b1hh:mm"), Map.entry(GoTimeToken.NUM_SHORT_TZ, "Time zone offset \u00b1hh"), Map.entry(GoTimeToken.ISO_8601_SECONDS_TZ, "Time zone offset \u00b1hhmmss, Z for UTC"), Map.entry(GoTimeToken.ISO_8601_COLON_SECONDS_TZ, "Time zone offset \u00b1hh:mm:ss, Z for UTC"), Map.entry(GoTimeToken.ISO_8601_TZ, "Time zone offset \u00b1hhmm, Z for UTC"), Map.entry(GoTimeToken.ISO_8601_COLON_TZ, "Time zone offset \u00b1hh:mm, Z for UTC"), Map.entry(GoTimeToken.ISO_8601_SHORT_TZ, "Time zone offset \u00b1hh, Z for UTC"), Map.entry(GoTimeToken.FRAC_SECOND0, "Fractional second"), Map.entry(GoTimeToken.FRAC_SECOND9, "Fractional second (no trailing zeros)"));

    @Nullable
    public GoTimeFile findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        GoTimeFile file;
        if (context == null) {
            GoTimeParameterInfoHandler.$$$reportNull$$$0(0);
        }
        if ((file = (GoTimeFile)((Object)ObjectUtils.tryCast((Object)context.getFile(), GoTimeFile.class))) == null) {
            return null;
        }
        GoTimeToken token = GoTimeParameterInfoHandler.getTimeToken(file, context.getOffset());
        if (token != null) {
            context.setItemsToShow(new Object[]{token});
        }
        return file;
    }

    public void showParameterInfo(@NotNull GoTimeFile element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            GoTimeParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if (context == null) {
            GoTimeParameterInfoHandler.$$$reportNull$$$0(2);
        }
        int startOffset = element.getTextRange().getStartOffset();
        context.showHint((PsiElement)element, startOffset, (ParameterInfoHandler)this);
    }

    @Nullable
    public GoTimeFile findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            GoTimeParameterInfoHandler.$$$reportNull$$$0(3);
        }
        GoTimeFile file = (GoTimeFile)((Object)ObjectUtils.tryCast((Object)context.getFile(), GoTimeFile.class));
        Editor editor = context.getEditor();
        if (file != null && editor instanceof EditorWindow) {
            Editor hostEditor = ((EditorWindow)editor).getDelegate();
            int hostOffset = hostEditor.getCaretModel().getOffset();
            PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)context.getProject()).getInjectionHost((PsiElement)file);
            if (host != null && !host.getTextRange().contains(hostOffset)) {
                return null;
            }
        }
        return file;
    }

    public void updateParameterInfo(@NotNull GoTimeFile file, @NotNull UpdateParameterInfoContext context) {
        if (file == null) {
            GoTimeParameterInfoHandler.$$$reportNull$$$0(4);
        }
        if (context == null) {
            GoTimeParameterInfoHandler.$$$reportNull$$$0(5);
        }
        GoTimeToken token = GoTimeParameterInfoHandler.getTimeToken(file, context.getOffset());
        Object[] objectsToView = context.getObjectsToView();
        if (token != null && objectsToView != null && objectsToView.length > 0) {
            objectsToView[0] = token;
        }
    }

    public void updateUI(GoTimeToken token, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            GoTimeParameterInfoHandler.$$$reportNull$$$0(6);
        }
        String description = DESCRIPTIONS.get((Object)token);
        context.setupUIComponentPresentation(description, 0, 0, false, false, false, context.getDefaultParameterColor());
    }

    public boolean isWhitespaceSensitive() {
        return true;
    }

    @Nullable
    private static GoTimeToken getTimeToken(@NotNull GoTimeFile file, int offset) {
        PsiElement element;
        if (file == null) {
            GoTimeParameterInfoHandler.$$$reportNull$$$0(7);
        }
        return (element = file.findElementAt(offset)) != null ? (GoTimeToken)((Object)ObjectUtils.tryCast((Object)element.getNode().getElementType(), GoTimeToken.class)) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/goide/inspections/time/GoTimeParameterInfoHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForParameterInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showParameterInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateParameterInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateUI";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getTimeToken";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

