/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.tag;

import com.goide.completion.GoInvokeIntentionInsertHandler;
import com.goide.i18n.GoBundle;
import com.goide.inspections.tag.GoTagAddKeyIntention;
import com.goide.inspections.tag.GoTagFieldNameStyle;
import com.goide.inspections.tag.GoTagLexer;
import com.goide.inspections.tag.GoTagToken;
import com.goide.inspections.tag.GoTagUtil;
import com.goide.inspections.tag.GoTagValueCompletionContributor;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoFile;
import com.goide.psi.GoStructType;
import com.goide.psi.GoTag;
import com.goide.refactor.template.GoLookupExpression;
import com.goide.refactor.template.GoTemplate;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElementImpl;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoTagKeyCompletionContributor
extends CompletionContributor {
    public GoTagKeyCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)GoTagUtil.RAW_STRING_IN_STRUCT_TAG, new GoTagAddKeyCompletionProvider());
    }

    @Nullable
    private static Ref<IElementType> getTagToken(@NotNull String text, int offset) {
        IElementType token;
        int tagStart;
        if (text == null) {
            GoTagKeyCompletionContributor.$$$reportNull$$$0(0);
        }
        if ((tagStart = StringUtil.lastIndexOf((CharSequence)text, (char)'`', (int)0, (int)offset)) < 0) {
            return null;
        }
        int tagEnd = StringUtil.indexOf((CharSequence)text, (char)'`', (int)offset);
        if (tagEnd < 0) {
            return null;
        }
        GoTagLexer lexer = new GoTagLexer();
        int tagTextStart = tagStart + 1;
        lexer.start(text.substring(tagTextStart, tagEnd), 0, tagEnd - tagTextStart);
        int relativeCaretOffset = offset - tagTextStart;
        while ((token = lexer.getTokenType()) != null) {
            int tokenStart = lexer.getTokenStart();
            int tokenEnd = lexer.getTokenEnd();
            if (tokenStart <= relativeCaretOffset && relativeCaretOffset < tokenEnd) {
                return Ref.create((Object)token);
            }
            lexer.advance();
        }
        return Ref.create(null);
    }

    private static int skipSpacesBackward(@NotNull CharSequence text, int offset) {
        if (text == null) {
            GoTagKeyCompletionContributor.$$$reportNull$$$0(1);
        }
        while (offset >= 0) {
            char c = text.charAt(offset);
            if (c == ' ') {
                --offset;
                continue;
            }
            return c;
        }
        return -1;
    }

    @Nullable
    private static String getTagKeyPrefix(@NotNull String text, int offset) {
        if (text == null) {
            GoTagKeyCompletionContributor.$$$reportNull$$$0(2);
        }
        for (int i = offset - 1; i >= 0; --i) {
            char c = text.charAt(i);
            if (c != ' ' && c != '`' && c != '\"') continue;
            return text.substring(i + 1, offset);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "text";
        objectArray2[1] = "com/goide/inspections/tag/GoTagKeyCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTagToken";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "skipSpacesBackward";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTagKeyPrefix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class GoTagAddKeyCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private GoTagAddKeyCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            String tagKeyPrefix;
            int offset;
            if (parameters == null) {
                GoTagAddKeyCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                GoTagAddKeyCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                GoTagAddKeyCompletionProvider.$$$reportNull$$$0(2);
            }
            if (GoTagAddKeyIntention.isInProgress(parameters.getOriginalFile())) {
                return;
            }
            Editor editor = parameters.getEditor();
            Document document = editor.getDocument();
            String text = document.getText();
            Ref<IElementType> token = GoTagKeyCompletionContributor.getTagToken(text, offset = parameters.getOffset());
            if (token == null || token.get() == GoTagToken.VALUE) {
                return;
            }
            int prevNonSpace = GoTagKeyCompletionContributor.skipSpacesBackward(text, offset - 1);
            if (prevNonSpace == 34 || prevNonSpace == 96) {
                result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)GoBundle.message((String)"go.completion.add.tag.key.to.all.fields", (Object[])new Object[0])).withInsertHandler((InsertHandler)new GoInvokeIntentionInsertHandler(new GoTagAddKeyIntention())).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE), (double)5.0));
            }
            if ((tagKeyPrefix = GoTagKeyCompletionContributor.getTagKeyPrefix(text, offset)) != null) {
                result = result.withPrefixMatcher((PrefixMatcher)new PlainPrefixMatcher(tagKeyPrefix, false));
                for (Map.Entry<String, GoTagValueCompletionContributor.Options> entry : GoTagValueCompletionContributor.OPTIONS.entrySet()) {
                    result.addElement(LookupElementBuilder.create((String)entry.getKey()).withInsertHandler((InsertHandler)new GoTagKeyInsertHandler(entry.getKey(), entry.getValue())).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE));
                }
                if (tagKeyPrefix.isEmpty()) {
                    PsiFile file = parameters.getPosition().getContainingFile();
                    List templates = TemplateManagerImpl.listApplicableTemplates((TemplateActionContext)TemplateActionContext.expanding((PsiFile)file, (Editor)editor));
                    for (TemplateImpl template : templates) {
                        result.addElement((LookupElement)new LiveTemplateLookupElementImpl(template, false));
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/goide/inspections/tag/GoTagKeyCompletionContributor$GoTagAddKeyCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GoTagKeyInsertHandler
    implements InsertHandler<LookupElement> {
        private final String myKey;
        private final GoTagValueCompletionContributor.Options myTagOptions;

        private GoTagKeyInsertHandler(@NotNull String key, @NotNull GoTagValueCompletionContributor.Options options) {
            if (key == null) {
                GoTagKeyInsertHandler.$$$reportNull$$$0(0);
            }
            if (options == null) {
                GoTagKeyInsertHandler.$$$reportNull$$$0(1);
            }
            this.myKey = key;
            this.myTagOptions = options;
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            Document document;
            if (context == null) {
                GoTagKeyInsertHandler.$$$reportNull$$$0(2);
            }
            if (item == null) {
                GoTagKeyInsertHandler.$$$reportNull$$$0(3);
            }
            if ((document = context.getDocument()).getText().charAt(context.getTailOffset()) == ':') {
                return;
            }
            String fieldNameForTag = GoTagKeyInsertHandler.getFieldNameForTag(context);
            if (this.myTagOptions.isStartsWithFieldName() && StringUtil.isNotEmpty((String)fieldNameForTag)) {
                final LinkedHashMap<String, GoTagFieldNameStyle> variants = new LinkedHashMap<String, GoTagFieldNameStyle>();
                for (GoTagFieldNameStyle style : this.getSortedStyles(context)) {
                    variants.putIfAbsent(style.apply(fieldNameForTag), style);
                }
                GoTemplate template = new GoTemplate((GoFile)context.getFile());
                template.addTextSegment(":\"");
                template.addPrimaryVariable("NAME", new GoLookupExpression(variants.keySet(), LookupFocusDegree.FOCUSED){

                    @Override
                    @NotNull
                    protected LookupElement createLookupElement(final @NotNull String name) {
                        if (name == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)name).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                                if (context == null) {
                                    GoTagKeyInsertHandler.1.$$$reportNull$$$0(0);
                                }
                                if (item == null) {
                                    GoTagKeyInsertHandler.1.$$$reportNull$$$0(1);
                                }
                                GoTagFieldNameStyle.setLastUsedStyle((GoTagFieldNameStyle)variants.get(name));
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2 = new Object[3];
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "context";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "item";
                                        break;
                                    }
                                }
                                objectArray[1] = "com/goide/inspections/tag/GoTagKeyCompletionContributor$GoTagKeyInsertHandler$1$1";
                                objectArray[2] = "handleInsert";
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        });
                        if (lookupElementBuilder == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return lookupElementBuilder;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 3;
                            case 1 -> 2;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "name";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/goide/inspections/tag/GoTagKeyCompletionContributor$GoTagKeyInsertHandler$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/goide/inspections/tag/GoTagKeyCompletionContributor$GoTagKeyInsertHandler$1";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "createLookupElement";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "createLookupElement";
                                break;
                            }
                            case 1: {
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalArgumentException(string);
                            case 1 -> new IllegalStateException(string);
                        };
                    }
                });
                template.addEndVariable();
                template.addTextSegment("\"");
                template.startTemplate(context.getEditor(), context.getTailOffset(), "", null);
            } else {
                int caretOffset = context.getTailOffset() + 2;
                document.insertString(context.getTailOffset(), (CharSequence)":\"\"");
                context.getEditor().getCaretModel().moveToOffset(caretOffset);
                AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
            }
        }

        @NotNull
        private List<GoTagFieldNameStyle> getSortedStyles(@NotNull InsertionContext context) {
            if (context == null) {
                GoTagKeyInsertHandler.$$$reportNull$$$0(4);
            }
            HashMap<GoTagFieldNameStyle, Double> styleScore = new HashMap<GoTagFieldNameStyle, Double>();
            styleScore.put(GoTagFieldNameStyle.getLastUsedStyle(), 0.5);
            PsiElement at = context.getFile().findElementAt(context.getTailOffset());
            GoStructType struct = (GoStructType)PsiTreeUtil.getParentOfType((PsiElement)at, GoStructType.class);
            if (struct != null) {
                for (GoFieldDeclaration field : struct.getFieldDeclarationList()) {
                    int comma;
                    String name;
                    GoTagFieldNameStyle style;
                    GoTag tag = field.getTag();
                    String tagValue = tag != null ? tag.getValue(this.myKey) : null;
                    if (!StringUtil.isNotEmpty((String)tagValue) || (style = GoTagFieldNameStyle.guessStyle(name = (comma = tagValue.indexOf(44)) == -1 ? tagValue : tagValue.substring(0, comma))) == null) continue;
                    styleScore.compute(style, (k, v) -> v != null ? v + 1.0 : 1.0);
                }
            }
            List list = ContainerUtil.sorted(GoTagFieldNameStyle.getStyles(), (o1, o2) -> Comparing.compare((Comparable)styleScore.getOrDefault(o2, 0.0), (Comparable)styleScore.getOrDefault(o1, 0.0)));
            if (list == null) {
                GoTagKeyInsertHandler.$$$reportNull$$$0(5);
            }
            return list;
        }

        @NotNull
        private static String getFieldNameForTag(@NotNull InsertionContext context) {
            if (context == null) {
                GoTagKeyInsertHandler.$$$reportNull$$$0(6);
            }
            Document document = context.getDocument();
            PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(document);
            PsiElement at = context.getFile().findElementAt(context.getTailOffset());
            String string = StringUtil.notNullize((String)GoTagUtil.getFieldNameForTag(at));
            if (string == null) {
                GoTagKeyInsertHandler.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/tag/GoTagKeyCompletionContributor$GoTagKeyInsertHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/tag/GoTagKeyCompletionContributor$GoTagKeyInsertHandler";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSortedStyles";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldNameForTag";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleInsert";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getSortedStyles";
                    break;
                }
                case 5: 
                case 7: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getFieldNameForTag";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 7 -> new IllegalStateException(string);
            };
        }
    }
}

