/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.imports;

import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.inspections.imports.GoCyclicImportsResultService;
import com.goide.psi.GoFile;
import com.goide.psi.GoPackageClause;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoPackage;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J+\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f2\u001c\u0010\r\u001a\u0018\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000b0\u000f0\u000ej\u0002`\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/goide/inspections/imports/GoCyclicImportsInspection;", "Lcom/goide/inspections/core/GoInspectionBase;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/goide/inspections/core/GoProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "buildErrorMsg", "", "Lcom/intellij/openapi/util/NlsSafe;", "cycle", "", "Lkotlin/Pair;", "Lcom/goide/psi/impl/GoPackage;", "Lcom/goide/inspections/imports/GoImportCycle;", "getPackageRepr", "Lcom/intellij/openapi/util/text/HtmlChunk;", "pkg", "intellij.go.impl"})
public final class GoCyclicImportsInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(@NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new GoVisitor(this, holder){
            final /* synthetic */ GoCyclicImportsInspection this$0;
            final /* synthetic */ GoProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitPackageClause(GoPackageClause o) {
                T t;
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                PsiFile psiFile = o.getContainingFile();
                GoFile goFile = psiFile instanceof GoFile ? (GoFile)psiFile : null;
                if (goFile == null) {
                    return;
                }
                GoFile file = goFile;
                GoPackage goPackage = GoPackage.of(file);
                if (goPackage == null) {
                    return;
                }
                GoPackage pkg = goPackage;
                Project project = file.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<GoCyclicImportsResultService> serviceClass$iv = GoCyclicImportsResultService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                List<List<Pair<GoPackage, String>>> cycles = ((GoCyclicImportsResultService)object).getImportCycles(pkg);
                if (cycles.isEmpty()) {
                    return;
                }
                Iterable $this$minBy$iv = cycles;
                boolean $i$f$minByOrThrow = false;
                Iterator<T> iterator$iv = $this$minBy$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new NoSuchElementException();
                }
                T minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    t = minElem$iv;
                } else {
                    List it = (List)minElem$iv;
                    boolean bl = false;
                    int minValue$iv = it.size();
                    do {
                        T e$iv = iterator$iv.next();
                        List it2 = (List)e$iv;
                        $i$a$-minByOrThrow-GoCyclicImportsInspection$buildVisitor$1$visitPackageClause$shortestCycle$1 = false;
                        int v$iv = it2.size();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    t = minElem$iv;
                }
                List shortestCycle = (List)t;
                String cycleStringExplanation = GoCyclicImportsInspection.access$buildErrorMsg(this.this$0, shortestCycle);
                Object[] objectArray = new Object[]{cycleStringExplanation};
                this.$holder.registerProblem((PsiElement)o, GoCyclicImportsInspection.access$message$s1115493773("go.inspection.problem.cyclic.imports.not.allowed", objectArray), new LocalQuickFix[0]);
            }
        };
    }

    private final String buildErrorMsg(List<? extends Pair<? extends GoPackage, String>> cycle) {
        HtmlBuilder builder = new HtmlBuilder();
        for (Pair<? extends GoPackage, String> pair : cycle) {
            HtmlChunk.Element fileRepr;
            GoPackage pkg = (GoPackage)pair.component1();
            String representativeFilePath = (String)pair.component2();
            HtmlChunk pkgRepr = this.getPackageRepr(pkg);
            String string = "#navigation/" + representativeFilePath + ":0";
            Path path = Paths.get(representativeFilePath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Intrinsics.checkNotNullExpressionValue((Object)HtmlChunk.link((String)string, (String)PathsKt.getName((Path)path)), (String)"link(...)");
            Object[] objectArray = new Object[]{pkgRepr, fileRepr};
            builder.append(GoBundle.message((String)"go.inspection.problem.cyclic.imports.pkg.in.file.imports", (Object[])objectArray));
            builder.br();
        }
        builder.append(this.getPackageRepr((GoPackage)cycle.get(0).getFirst()));
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final HtmlChunk getPackageRepr(GoPackage pkg) {
        String string = pkg.getImportPath(false);
        if (string == null) {
            String string2 = pkg.getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        }
        String pkgStr = string;
        HtmlChunk htmlChunk = HtmlChunk.text((String)pkgStr);
        Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"text(...)");
        return htmlChunk;
    }

    public static final /* synthetic */ String access$buildErrorMsg(GoCyclicImportsInspection $this, List cycle) {
        return $this.buildErrorMsg(cycle);
    }

    public static final /* synthetic */ GoInspectionMessage access$message$s1115493773(String key, Object ... parameters) {
        return GoInspectionBase.message(key, parameters);
    }
}

