/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.core;

import com.goide.inspections.core.GoCallableDescriptor;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.sdk.GoSdkUtil;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoCallableDescriptorMap<V> {
    protected final Map<GoCallableDescriptor, @Nullable V> myDescriptors;
    protected final Set<String> myNames;

    public GoCallableDescriptorMap(@NotNull Map<GoCallableDescriptor, @Nullable V> descriptors) {
        if (descriptors == null) {
            GoCallableDescriptorMap.$$$reportNull$$$0(0);
        }
        this.myDescriptors = descriptors;
        this.myNames = ContainerUtil.map2Set(this.myDescriptors.keySet(), GoCallableDescriptor::getName);
    }

    public GoCallableDescriptorMap(@NotNull Set<GoCallableDescriptor> descriptors) {
        if (descriptors == null) {
            GoCallableDescriptorMap.$$$reportNull$$$0(1);
        }
        this(descriptors.stream().collect(HashMap::new, (m, e) -> m.put(e, null), HashMap::putAll));
    }

    public GoCallableDescriptorMap() {
        this.myDescriptors = new HashMap<GoCallableDescriptor, V>();
        this.myNames = new HashSet<String>();
    }

    @Nullable
    public GoCallableDescriptor find(@NotNull GoCallExpr call, boolean mustBeStdCall) {
        GoCallableDescriptor descriptor;
        GoReferenceExpression callRef;
        String refName;
        if (call == null) {
            GoCallableDescriptorMap.$$$reportNull$$$0(2);
        }
        String string = refName = (callRef = GoPsiUtil.getCallReference(call)) != null ? callRef.getIdentifier().getText() : null;
        if (refName == null || !this.myNames.contains(refName)) {
            return null;
        }
        GoNamedSignatureOwner declaration = (GoNamedSignatureOwner)ObjectUtils.tryCast((Object)callRef.resolve(), GoNamedSignatureOwner.class);
        GoCallableDescriptor goCallableDescriptor = descriptor = declaration != null ? GoCallableDescriptor.of(declaration, call, true) : null;
        if (descriptor == null || !this.myDescriptors.containsKey(descriptor) || mustBeStdCall && !GoSdkUtil.isInSdk((PsiFileSystemItem)declaration.getContainingFile())) {
            return null;
        }
        return descriptor;
    }

    public boolean contains(@NotNull GoCallExpr call, boolean mustBeStdCall) {
        if (call == null) {
            GoCallableDescriptorMap.$$$reportNull$$$0(3);
        }
        return this.find(call, mustBeStdCall) != null;
    }

    public boolean contains(@NotNull GoCallableDescriptor descriptor) {
        if (descriptor == null) {
            GoCallableDescriptorMap.$$$reportNull$$$0(4);
        }
        return this.myDescriptors.containsKey(descriptor);
    }

    public void add(@NotNull GoCallableDescriptor descriptor, @Nullable V value2) {
        if (descriptor == null) {
            GoCallableDescriptorMap.$$$reportNull$$$0(5);
        }
        this.myDescriptors.put(descriptor, value2);
        this.myNames.add(descriptor.getName());
    }

    public void remove(@NotNull GoCallableDescriptor descriptor) {
        if (descriptor == null) {
            GoCallableDescriptorMap.$$$reportNull$$$0(6);
        }
        this.myDescriptors.remove(descriptor);
        this.myNames.remove(descriptor.getName());
    }

    public void clear() {
        this.myDescriptors.clear();
        this.myNames.clear();
    }

    @Nullable
    public V get(@NotNull GoCallableDescriptor descriptor) {
        if (descriptor == null) {
            GoCallableDescriptorMap.$$$reportNull$$$0(7);
        }
        return this.myDescriptors.get(descriptor);
    }

    @NotNull
    public Set<GoCallableDescriptor> getDescriptors() {
        Set<GoCallableDescriptor> set = this.myDescriptors.keySet();
        if (set == null) {
            GoCallableDescriptorMap.$$$reportNull$$$0(8);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/core/GoCallableDescriptorMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/core/GoCallableDescriptorMap";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

