/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.controlflow.GoControlFlowBuilder;
import com.goide.controlflow.GoControlFlowProvider;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoReturnStatement;
import com.goide.psi.GoVisitor;
import com.goide.util.GoStdlibUtil;
import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class GoUnreachableCodeInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoUnreachableCodeInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoUnreachableCodeInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitFunctionOrMethodDeclaration(@NotNull GoFunctionOrMethodDeclaration o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.reportUnreachable(o);
            }

            @Override
            public void visitFunctionLit(@NotNull GoFunctionLit o) {
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.reportUnreachable(o);
            }

            private void reportUnreachable(@NotNull PsiElement element) {
                ControlFlow controlFlow;
                if (element == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((controlFlow = GoControlFlowProvider.INSTANCE.getControlFlow(element)) == null) {
                    return;
                }
                Instruction[] allInstructions = controlFlow.getInstructions();
                HashSet reachable = new HashSet();
                Ref controlFlowHasTerminatingCalls = Ref.create();
                Ref controlFlowHasTestingSkipCalls = Ref.create();
                ControlFlowUtil.process((Instruction[])allInstructions, (int)0, instruction -> {
                    reachable.add(instruction);
                    GoCallExpr callExpr = (GoCallExpr)ObjectUtils.tryCast((Object)instruction.getElement(), GoCallExpr.class);
                    if (callExpr != null && GoControlFlowBuilder.isTerminatingCall(callExpr)) {
                        controlFlowHasTerminatingCalls.set((Object)Boolean.TRUE);
                        if (GoStdlibUtil.isTestingSkipCall(callExpr)) {
                            controlFlowHasTestingSkipCalls.set((Object)Boolean.TRUE);
                            return false;
                        }
                    }
                    return true;
                });
                if (Boolean.TRUE.equals(controlFlowHasTestingSkipCalls.get())) {
                    return;
                }
                HashSet<PsiElement> allUnreachableElements = new HashSet<PsiElement>();
                for (Instruction instruction2 : allInstructions) {
                    PsiElement instructionElement = instruction2.getElement();
                    if (instructionElement == null || reachable.contains(instruction2)) continue;
                    allUnreachableElements.add(instructionElement);
                }
                for (PsiElement unreachable : allUnreachableElements) {
                    if (allUnreachableElements.contains(unreachable.getParent()) || unreachable instanceof GoReturnStatement && Boolean.TRUE.equals(controlFlowHasTerminatingCalls.get())) continue;
                    holder.registerProblem(unreachable, GoUnreachableCodeInspection.message("go.inspection.problem.unreachable.code"), new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/goide/inspections/GoUnreachableCodeInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFunctionOrMethodDeclaration";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFunctionLit";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "reportUnreachable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/goide/inspections/GoUnreachableCodeInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

