/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.GoConstants;
import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoElementFactory;
import com.intellij.codeInsight.hints.InlayHintsUtils;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/goide/inspections/GoLeadingWhitespaceInDirectiveCommentInspection;", "Lcom/goide/inspections/core/GoInspectionBase;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/goide/inspections/core/GoProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "checkLeadingWhitespaceBeforeGoDirective", "", "comment", "Lcom/intellij/psi/PsiComment;", "directive", "", "isLineDirectiveArgumentValid", "directiveIndex", "", "isExportDirectiveArgumentValid", "getDirectiveArguments", "", "commentText", "index", "RemoveLeadingWhitespaceBeforeGoEmbed", "intellij.go.impl"})
public final class GoLeadingWhitespaceInDirectiveCommentInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(@NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new GoVisitor(this, holder){
            final /* synthetic */ GoLeadingWhitespaceInDirectiveCommentInspection this$0;
            final /* synthetic */ GoProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitComment(PsiComment comment) {
                Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
                super.visitComment(comment);
                String string = comment.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (!StringsKt.startsWith$default((String)string, (String)"//", (boolean)false, (int)2, null)) {
                    return;
                }
                if (!InlayHintsUtils.isFirstInLine((PsiElement)((PsiElement)comment))) {
                    return;
                }
                Iterator iterator = ArrayIteratorKt.iterator((Object[])GoConstants.COMPILER_FLAGS);
                while (iterator.hasNext()) {
                    String directive = (String)iterator.next();
                    Intrinsics.checkNotNull((Object)directive);
                    if (!GoLeadingWhitespaceInDirectiveCommentInspection.access$checkLeadingWhitespaceBeforeGoDirective(this.this$0, this.$holder, comment, directive)) continue;
                    return;
                }
            }
        };
    }

    private final boolean checkLeadingWhitespaceBeforeGoDirective(GoProblemsHolder holder, PsiComment comment, String directive) {
        String commentText = comment.getText();
        Intrinsics.checkNotNull((Object)commentText);
        int directiveIndex = StringsKt.indexOf$default((CharSequence)commentText, (String)directive, (int)0, (boolean)false, (int)6, null);
        if (directiveIndex == -1) {
            return false;
        }
        if (directiveIndex + directive.length() < commentText.length() && !Character.isWhitespace(commentText.charAt(directiveIndex + directive.length()))) {
            return false;
        }
        if (Intrinsics.areEqual((Object)directive, (Object)"line") && !this.isLineDirectiveArgumentValid(comment, directiveIndex)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)directive, (Object)"export") && !this.isExportDirectiveArgumentValid(comment, directiveIndex)) {
            return false;
        }
        int commentStartLength = 2;
        String string = commentText.substring(commentStartLength, directiveIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String beforeGoEmbed = string;
        if (((CharSequence)beforeGoEmbed).length() == 0 || !(((CharSequence)((Object)StringsKt.trim((CharSequence)beforeGoEmbed)).toString()).length() == 0)) {
            return false;
        }
        int leadingWhitespaceLength = directiveIndex - commentStartLength;
        TextRange textRange = TextRange.from((int)commentStartLength, (int)leadingWhitespaceLength);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
        TextRange whitespaceRange = textRange;
        String string2 = commentText.substring(commentStartLength + leadingWhitespaceLength);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String commentWithLeadingSpaceRemoved = "//" + string2;
        GoInspectionMessageWithI18n goInspectionMessageWithI18n = GoInspectionMessageWithI18n.message("go.inspection.problem.leading.whitespace.in.directive.comment");
        Intrinsics.checkNotNullExpressionValue((Object)goInspectionMessageWithI18n, (String)"message(...)");
        GoInspectionMessageWithI18n problemDescription = goInspectionMessageWithI18n;
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RemoveLeadingWhitespaceBeforeGoEmbed(comment, commentWithLeadingSpaceRemoved)};
        holder.registerProblem((PsiElement)comment, whitespaceRange, (GoInspectionMessage)problemDescription, localQuickFixArray);
        return true;
    }

    private final boolean isLineDirectiveArgumentValid(PsiComment comment, int directiveIndex) {
        String string = comment.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        List<String> arguments = this.getDirectiveArguments(string, directiveIndex, "line");
        return arguments.size() == 1 ? StringsKt.contains$default((CharSequence)arguments.get(0), (CharSequence)":", (boolean)false, (int)2, null) : false;
    }

    private final boolean isExportDirectiveArgumentValid(PsiComment comment, int directiveIndex) {
        boolean bl;
        String commentText = comment.getText();
        Intrinsics.checkNotNull((Object)commentText);
        List<String> arguments = this.getDirectiveArguments(commentText, directiveIndex, "export");
        if (arguments.size() == 1) {
            PsiElement psiElement = comment.getNextSibling();
            PsiWhiteSpace psiWhiteSpace = psiElement instanceof PsiWhiteSpace ? (PsiWhiteSpace)psiElement : null;
            Object object = psiWhiteSpace != null ? psiWhiteSpace.getNextSibling() : null;
            GoFunctionDeclaration funcDecl = object instanceof GoFunctionDeclaration ? (GoFunctionDeclaration)object : null;
            GoFunctionDeclaration goFunctionDeclaration = funcDecl;
            bl = Intrinsics.areEqual((Object)(goFunctionDeclaration != null && (goFunctionDeclaration = goFunctionDeclaration.getIdentifier()) != null ? goFunctionDeclaration.getText() : null), (Object)arguments.get(0));
        } else {
            bl = false;
        }
        return bl;
    }

    private final List<String> getDirectiveArguments(String commentText, int index, String directive) {
        String string = commentText.substring(index + directive.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String rest = string;
        CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)rest)).toString();
        Regex regex = new Regex("\\s+");
        int n = 0;
        return regex.split(charSequence, n);
    }

    public static final /* synthetic */ boolean access$checkLeadingWhitespaceBeforeGoDirective(GoLeadingWhitespaceInDirectiveCommentInspection $this, GoProblemsHolder holder, PsiComment comment, String directive) {
        return $this.checkLeadingWhitespaceBeforeGoDirective(holder, comment, directive);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J3\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/goide/inspections/GoLeadingWhitespaceInDirectiveCommentInspection$RemoveLeadingWhitespaceBeforeGoEmbed;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "comment", "Lcom/intellij/psi/PsiComment;", "fixedCommentText", "", "<init>", "(Lcom/intellij/psi/PsiComment;Ljava/lang/String;)V", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "getText", "getFamilyName", "Companion", "intellij.go.impl"})
    public static final class RemoveLeadingWhitespaceBeforeGoEmbed
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String fixedCommentText;

        public RemoveLeadingWhitespaceBeforeGoEmbed(@NotNull PsiComment comment, @NotNull String fixedCommentText) {
            Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
            Intrinsics.checkNotNullParameter((Object)fixedCommentText, (String)"fixedCommentText");
            super((PsiElement)comment);
            this.fixedCommentText = fixedCommentText;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            PsiComment psiComment = GoElementFactory.createComment(project, this.fixedCommentText);
            Intrinsics.checkNotNullExpressionValue((Object)psiComment, (String)"createComment(...)");
            PsiComment newComment = psiComment;
            startElement.replace((PsiElement)newComment);
        }

        @NotNull
        public String getText() {
            return Companion.name();
        }

        @NotNull
        public String getFamilyName() {
            return Companion.name();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/goide/inspections/GoLeadingWhitespaceInDirectiveCommentInspection$RemoveLeadingWhitespaceBeforeGoEmbed$Companion;", "", "<init>", "()V", "name", "", "Lcom/intellij/codeInspection/util/IntentionName;", "intellij.go.impl"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final String name() {
                String string = GoBundle.message((String)"go.fix.remove.leading.whitespace.go.directive", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

