/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.formatter.GoFormatterUtil;
import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoCallableDescriptor;
import com.goide.inspections.core.GoCallableDescriptorSet;
import com.goide.inspections.core.GoFunctionDescriptor;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoAddExpr;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoPsiTreeUtil;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.util.Value;
import com.goide.utils.GoStringUtil;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoErrorStringFormatInspection
extends GoInspectionBase {
    private static final GoCallableDescriptorSet DESCRIPTOR_SET = new GoCallableDescriptorSet(ContainerUtil.newHashSet((Object[])new GoCallableDescriptor[]{GoFunctionDescriptor.of("fmt.Errorf"), GoFunctionDescriptor.of("errors.New")}));
    private static final String PUNCTUATION_MARKS = ".,!?:;-";
    private static final Pattern MATCH_PATTERN = Pattern.compile("(\\S+)( \\S+)*");
    private static final Pattern SPLIT_PATTERN = Pattern.compile("\\s");

    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoErrorStringFormatInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoErrorStringFormatInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitCallExpr(@NotNull GoCallExpr callExpr) {
                if (callExpr == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitCallExpr(callExpr);
                if (DESCRIPTOR_SET.contains(callExpr, true)) {
                    this.checkErrorStringArgument(callExpr);
                }
            }

            private void checkErrorStringArgument(@NotNull GoCallExpr callExpr) {
                String stringValue;
                List<GoExpression> args;
                GoExpression firstArg;
                if (callExpr == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((firstArg = (GoExpression)ContainerUtil.getFirstItem(args = callExpr.getArgumentList().getExpressionList())) == null || !GoTypeUtil.isString(firstArg.getGoType(null), firstArg)) {
                    return;
                }
                Value value2 = firstArg.getValue();
                String string = stringValue = value2 != null ? value2.getString() : null;
                if (stringValue == null || stringValue.isEmpty()) {
                    return;
                }
                if (!MATCH_PATTERN.matcher(stringValue).matches()) {
                    return;
                }
                String firstWord = SPLIT_PATTERN.split(stringValue, 2)[0];
                if (1.isCapitalized(firstWord) || 1.endsWithPunctuation(stringValue)) {
                    GoInspectionMessage message = GoErrorStringFormatInspection.message("go.inspection.problem.bad.error.string");
                    if (GoErrorStringFormatInspection.canFix(firstArg)) {
                        holder.registerProblem((PsiElement)firstArg, message, new GoErrorStringFormatQuickFix());
                    } else {
                        holder.registerProblem((PsiElement)firstArg, message, new LocalQuickFix[0]);
                    }
                }
            }

            private static boolean isCapitalized(@NotNull String word) {
                if (word == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (word.length() < 2) {
                    return false;
                }
                if (!Character.isUpperCase(word.charAt(0))) {
                    return false;
                }
                for (int i = 1; i < word.length(); ++i) {
                    if (!Character.isUpperCase(word.charAt(i))) continue;
                    return false;
                }
                return true;
            }

            private static boolean endsWithPunctuation(@NotNull String text) {
                if (text == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (text.length() < 2) {
                    return false;
                }
                char lastChar = text.charAt(text.length() - 1);
                return StringUtil.containsChar((String)GoErrorStringFormatInspection.PUNCTUATION_MARKS, (char)lastChar);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "callExpr";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "word";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                }
                objectArray2[1] = "com/goide/inspections/GoErrorStringFormatInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCallExpr";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkErrorStringArgument";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isCapitalized";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "endsWithPunctuation";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean canFix(@NotNull GoExpression expr) {
        if (expr == null) {
            GoErrorStringFormatInspection.$$$reportNull$$$0(2);
        }
        return GoErrorStringFormatInspection.areAllStringLiterals(expr);
    }

    private static boolean areAllStringLiterals(@Nullable GoExpression expr) {
        if (expr instanceof GoAddExpr) {
            GoAddExpr addExpr = (GoAddExpr)expr;
            return GoErrorStringFormatInspection.areAllStringLiterals(addExpr.getLeft()) && GoErrorStringFormatInspection.areAllStringLiterals(addExpr.getRight());
        }
        return expr instanceof GoStringLiteral;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        objectArray2[1] = "com/goide/inspections/GoErrorStringFormatInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "canFix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class GoErrorStringFormatQuickFix
    implements LocalQuickFix {
        private GoErrorStringFormatQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.fix.error.string.format", (Object[])new Object[0]);
            if (string == null) {
                GoErrorStringFormatQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                GoErrorStringFormatQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                GoErrorStringFormatQuickFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor.getStartElement()) == null || !element.isValid()) {
                return;
            }
            GoErrorStringFormatQuickFix.applyQuickFix(element);
        }

        private static void applyQuickFix(@NotNull PsiElement element) {
            if (element == null) {
                GoErrorStringFormatQuickFix.$$$reportNull$$$0(3);
            }
            @NotNull List literals = ((SyntaxTraverser)GoPsiTreeUtil.goTraverser().withRoot((Object)element)).filter(GoStringLiteral.class).toList();
            GoErrorStringFormatQuickFix.decapitalize(GoErrorStringFormatQuickFix.removePunctuation(literals));
        }

        private static void decapitalize(@NotNull List<GoStringLiteral> literals) {
            if (literals == null) {
                GoErrorStringFormatQuickFix.$$$reportNull$$$0(4);
            }
            for (GoStringLiteral literal : literals) {
                String text = GoErrorStringFormatQuickFix.getText(literal);
                if (text.isEmpty()) continue;
                String result = GoErrorStringFormatQuickFix.decapitalize(text, GoErrorStringFormatQuickFix.isOneSymbolText(literals));
                GoErrorStringFormatQuickFix.replace(literal, result);
                break;
            }
        }

        @NotNull
        private static String decapitalize(@NotNull String text, boolean oneSymbolText) {
            if (text == null) {
                GoErrorStringFormatQuickFix.$$$reportNull$$$0(5);
            }
            String string = oneSymbolText ? text : StringUtil.decapitalize((String)text);
            if (string == null) {
                GoErrorStringFormatQuickFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static List<GoStringLiteral> removePunctuation(@NotNull List<GoStringLiteral> literals) {
            if (literals == null) {
                GoErrorStringFormatQuickFix.$$$reportNull$$$0(7);
            }
            ArrayList<GoStringLiteral> result = new ArrayList<GoStringLiteral>(literals.size());
            boolean fixed = false;
            for (GoStringLiteral literal : ContainerUtil.reverse(literals)) {
                if (fixed) {
                    result.add(literal);
                    continue;
                }
                GoStringLiteral processedLiteral = GoErrorStringFormatQuickFix.removePunctuation(literal);
                result.add(processedLiteral);
                if (GoErrorStringFormatQuickFix.getText(processedLiteral).isEmpty()) continue;
                fixed = true;
            }
            return ContainerUtil.reverse(result);
        }

        @NotNull
        private static GoStringLiteral removePunctuation(@NotNull GoStringLiteral literal) {
            String text;
            if (literal == null) {
                GoErrorStringFormatQuickFix.$$$reportNull$$$0(8);
            }
            if ((text = GoErrorStringFormatQuickFix.getText(literal)).isEmpty()) {
                GoStringLiteral goStringLiteral = literal;
                if (goStringLiteral == null) {
                    GoErrorStringFormatQuickFix.$$$reportNull$$$0(9);
                }
                return goStringLiteral;
            }
            String fixedText = GoErrorStringFormatQuickFix.removePunctuation(text);
            GoStringLiteral goStringLiteral = fixedText.length() != text.length() ? GoErrorStringFormatQuickFix.replace(literal, fixedText) : literal;
            if (goStringLiteral == null) {
                GoErrorStringFormatQuickFix.$$$reportNull$$$0(10);
            }
            return goStringLiteral;
        }

        @NotNull
        private static String removePunctuation(@NotNull String text) {
            int end;
            if (text == null) {
                GoErrorStringFormatQuickFix.$$$reportNull$$$0(11);
            }
            for (end = text.length() - 1; end >= 0 && StringUtil.containsChar((String)GoErrorStringFormatInspection.PUNCTUATION_MARKS, (char)text.charAt(end)); --end) {
            }
            String string = text.substring(0, end + 1);
            if (string == null) {
                GoErrorStringFormatQuickFix.$$$reportNull$$$0(12);
            }
            return string;
        }

        @NotNull
        private static GoStringLiteral replace(@NotNull GoStringLiteral literal, @NotNull String text) {
            if (literal == null) {
                GoErrorStringFormatQuickFix.$$$reportNull$$$0(13);
            }
            if (text == null) {
                GoErrorStringFormatQuickFix.$$$reportNull$$$0(14);
            }
            GoStringLiteral newElement = GoElementFactory.createStringLiteral(literal.getProject(), GoErrorStringFormatQuickFix.quote(text, GoErrorStringFormatQuickFix.isRawString(literal)));
            PsiElement result = literal.replace(newElement);
            GoFormatterUtil.reformat(result);
            GoStringLiteral goStringLiteral = (GoStringLiteral)result;
            if (goStringLiteral == null) {
                GoErrorStringFormatQuickFix.$$$reportNull$$$0(15);
            }
            return goStringLiteral;
        }

        private static boolean isRawString(@NotNull GoStringLiteral literal) {
            if (literal == null) {
                GoErrorStringFormatQuickFix.$$$reportNull$$$0(16);
            }
            return literal.getRawString() != null;
        }

        private static boolean isOneSymbolText(@NotNull List<GoStringLiteral> literals) {
            if (literals == null) {
                GoErrorStringFormatQuickFix.$$$reportNull$$$0(17);
            }
            int length = 0;
            for (GoStringLiteral literal : literals) {
                if ((length += GoErrorStringFormatQuickFix.getText(literal).length()) <= 1) continue;
                return false;
            }
            return true;
        }

        @NotNull
        private static String quote(@NotNull String text, boolean isRawString) {
            if (text == null) {
                GoErrorStringFormatQuickFix.$$$reportNull$$$0(18);
            }
            String string = isRawString ? "`" + text + "`" : "\"" + GoStringUtil.escapeString(text) + "\"";
            if (string == null) {
                GoErrorStringFormatQuickFix.$$$reportNull$$$0(19);
            }
            return string;
        }

        @NotNull
        private static String getText(@NotNull GoExpression o) {
            if (o == null) {
                GoErrorStringFormatQuickFix.$$$reportNull$$$0(20);
            }
            String result = o.getValue() != null ? o.getValue().getString() : null;
            String string = StringUtil.notNullize((String)result);
            if (string == null) {
                GoErrorStringFormatQuickFix.$$$reportNull$$$0(21);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 7, 8, 11, 13, 14, 16, 17, 18, 20 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/GoErrorStringFormatInspection$GoErrorStringFormatQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: 
                case 7: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "literals";
                    break;
                }
                case 5: 
                case 11: 
                case 14: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 8: 
                case 13: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "literal";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 11: 
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/GoErrorStringFormatInspection$GoErrorStringFormatQuickFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "decapitalize";
                    break;
                }
                case 9: 
                case 10: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "removePunctuation";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "replace";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "quote";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyQuickFix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "decapitalize";
                    break;
                }
                case 7: 
                case 8: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "removePunctuation";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "replace";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "isRawString";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "isOneSymbolText";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "quote";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 7, 8, 11, 13, 14, 16, 17, 18, 20 -> new IllegalArgumentException(string);
            };
        }
    }
}

