/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.legacyErrorInspections;

import com.goide.i18n.GoBundle;
import com.goide.inspections.GoInspectionUtil;
import com.goide.inspections.core.GoInspectionProblemUtil;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoIfStatement;
import com.goide.psi.GoShortVarDeclaration;
import com.goide.psi.GoSimpleStatement;
import com.goide.psi.GoStatement;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.presentation.GoPresentationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GoUsedAsValueInCondition
extends GoVisitor {
    @NotNull
    private final GoProblemsHolder myHolder;

    public GoUsedAsValueInCondition(@NotNull GoProblemsHolder holder) {
        if (holder == null) {
            GoUsedAsValueInCondition.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    @Override
    public void visitAssignmentStatement(@NotNull GoAssignmentStatement o) {
        GoIfStatement ifStatement;
        PsiElement psiElement;
        if (o == null) {
            GoUsedAsValueInCondition.$$$reportNull$$$0(1);
        }
        if (GoPsiUtil.isInsideTypeSwitchAssertion(o)) {
            this.registerProblem(o, new GoAssignmentToComparisonQuickFix[0]);
        }
        if (o.getParent() != null && (psiElement = o.getParent()) instanceof GoIfStatement && (ifStatement = (GoIfStatement)psiElement).getExpression() == null) {
            this.registerProblem(o, new GoAssignmentToComparisonQuickFix());
        }
    }

    private void registerProblem(@NotNull GoAssignmentStatement o, GoAssignmentToComparisonQuickFix ... fixes) {
        if (o == null) {
            GoUsedAsValueInCondition.$$$reportNull$$$0(2);
        }
        if (fixes == null) {
            GoUsedAsValueInCondition.$$$reportNull$$$0(3);
        }
        String left = GoPresentationUtil.joinPsiElementText(o.getLeftHandExprList().getExpressionList());
        String right = GoPresentationUtil.joinPsiElementText(o.getExpressionList());
        String text = left + " = " + right;
        this.myHolder.registerProblem((PsiElement)o, GoInspectionProblemUtil.message("go.inspection.problem.assignment.used.as.value", text), fixes);
    }

    @Override
    public void visitShortVarDeclaration(@NotNull GoShortVarDeclaration o) {
        PsiElement parent;
        if (o == null) {
            GoUsedAsValueInCondition.$$$reportNull$$$0(4);
        }
        if ((parent = o.getParent()) != null) {
            GoIfStatement ifStatement;
            GoSimpleStatement simpleStatement;
            PsiElement grandParent = parent.getParent();
            if (parent instanceof GoSimpleStatement && GoPsiUtil.isInsideTypeSwitchAssertion(simpleStatement = (GoSimpleStatement)parent)) {
                this.registerProblem(o, new LocalQuickFix[0]);
            } else if (grandParent instanceof GoIfStatement && (ifStatement = (GoIfStatement)grandParent).getExpression() == null) {
                this.registerProblem(o, new GoAssignmentToComparisonQuickFix());
            }
        }
    }

    private void registerProblem(@NotNull GoShortVarDeclaration o, LocalQuickFix ... fixes) {
        if (o == null) {
            GoUsedAsValueInCondition.$$$reportNull$$$0(5);
        }
        if (fixes == null) {
            GoUsedAsValueInCondition.$$$reportNull$$$0(6);
        }
        String left = GoPresentationUtil.joinPsiElementText(o.getVarDefinitionList());
        String right = GoPresentationUtil.joinPsiElementText(o.getRightExpressionsList());
        String text = left + " := " + right;
        this.myHolder.registerProblem((PsiElement)o, GoInspectionProblemUtil.message("go.inspection.problem.assignment.used.as.value", text), fixes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoUsedAsValueInCondition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAssignmentStatement";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "registerProblem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitShortVarDeclaration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class GoAssignmentToComparisonQuickFix
    implements LocalQuickFix {
        private static final Logger LOG = Logger.getInstance(GoAssignmentToComparisonQuickFix.class);

        private GoAssignmentToComparisonQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.fix.convert.to.is.equal.name", (Object[])new Object[0]);
            if (string == null) {
                GoAssignmentToComparisonQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                GoAssignmentToComparisonQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                GoAssignmentToComparisonQuickFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor.getPsiElement()) == null || !element.isValid()) {
                return;
            }
            if (element instanceof GoAssignmentStatement) {
                GoAssignmentStatement assignmentStatement = (GoAssignmentStatement)element;
                String left = GoPresentationUtil.joinPsiElementText(assignmentStatement.getLeftHandExprList().getExpressionList());
                String right = GoPresentationUtil.joinPsiElementText(assignmentStatement.getExpressionList());
                element.replace((PsiElement)GoElementFactory.createComparison(project, left + " == " + right));
            } else if (element instanceof GoShortVarDeclaration) {
                GoShortVarDeclaration shortVarDeclaration = (GoShortVarDeclaration)element;
                String left = GoPresentationUtil.joinPsiElementText(shortVarDeclaration.getVarDefinitionList());
                String right = GoPresentationUtil.joinPsiElementText(shortVarDeclaration.getRightExpressionsList());
                PsiElement statement = element.getParent();
                if (!(statement instanceof GoStatement)) {
                    LOG.error("Cannot properly replace ShortVarDeclaration (" + element.getText() + ") with comparison. Parent is " + statement.getClass().getSimpleName(), new Attachment[]{GoInspectionUtil.createAttachment(element)});
                }
                statement.replace((PsiElement)GoElementFactory.createComparison(project, left + " == " + right));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/highlighting/legacyErrorInspections/GoUsedAsValueInCondition$GoAssignmentToComparisonQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoUsedAsValueInCondition$GoAssignmentToComparisonQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

