/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.legacyErrorInspections;

import com.goide.highlighting.legacyErrorInspections.GoUnusedImportInspection;
import com.goide.i18n.GoBundle;
import com.goide.inspections.GoDuplicatesSearch;
import com.goide.inspections.GoInspectionUtil;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionProblemUtil;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.inspections.core.GoUniqueIdentifier;
import com.goide.psi.GoBlock;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoFunctionType;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoLabelDefinition;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoRangeClause;
import com.goide.psi.GoRecvStatement;
import com.goide.psi.GoShortVarDeclaration;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoStatement;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeParamDefinition;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.quickfix.GoDeleteImportQuickFix;
import com.goide.quickfix.GoNavigateToQuickFix;
import com.goide.quickfix.GoRenameQuickFix;
import com.goide.quickfix.GoViewAllDuplicatesQuickFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoDuplicateInspection
extends GoVisitor {
    @NotNull
    private final GoProblemsHolder myHolder;

    public GoDuplicateInspection(@NotNull GoProblemsHolder holder) {
        if (holder == null) {
            GoDuplicateInspection.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    @Override
    public void visitGoFile(@NotNull GoFile file) {
        if (file == null) {
            GoDuplicateInspection.$$$reportNull$$$0(1);
        }
        super.visitGoFile(file);
        if (!ScratchUtil.isScratch((VirtualFile)file.getOriginalFile().getVirtualFile())) {
            PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf((PsiElement)file);
            GoDuplicateInspection.processDuplicates(file, new GoDuplicatesSearch.TopLevelScopeSearch(), this.myHolder, context);
        }
        for (GoTypeSpec goTypeSpec : file.getTypes()) {
            PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(goTypeSpec);
            GoDuplicateInspection.processDuplicates(goTypeSpec, new GoDuplicatesSearch.TypeSpecScopeSearch(), this.myHolder, context);
        }
        HashSet<GoTypeSpec> processedSpecs = new HashSet<GoTypeSpec>();
        for (GoMethodDeclaration method : file.getMethods()) {
            GoTypeSpec spec = GoPsiImplUtil.getTypeSpecFromReceiver(method.getReceiver());
            if (spec == null || ((Object)((Object)file)).equals((Object)spec.getContainingFile()) || !processedSpecs.add(spec)) continue;
            PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(spec);
            GoDuplicateInspection.processDuplicates(spec, new GoDuplicatesSearch.TypeSpecScopeSearch(), this.myHolder, context);
        }
    }

    @Override
    public void visitStructType(@NotNull GoStructType o) {
        block5: {
            block4: {
                if (o == null) {
                    GoDuplicateInspection.$$$reportNull$$$0(2);
                }
                super.visitStructType(o);
                PsiElement parent = o.getParent();
                if (!(parent instanceof GoSpecType)) break block4;
                if (!Optional.of(parent).map(p -> (GoTypeDeclaration)PsiTreeUtil.getParentOfType((PsiElement)p, GoTypeDeclaration.class, (boolean)true, (Class[])new Class[]{GoStatement.class})).map(PsiElement::getParent).map(GoStatement.class::isInstance).orElse(Boolean.FALSE).booleanValue()) break block5;
            }
            GoDuplicateInspection.processDuplicates(o, new GoDuplicatesSearch.StructScopeSearch(), this.myHolder, GoReferenceBase.getSubstitutionContextOrSelf(o));
        }
    }

    @Override
    public void visitSpecType(@NotNull GoSpecType o) {
        if (o == null) {
            GoDuplicateInspection.$$$reportNull$$$0(3);
        }
        super.visitSpecType(o);
        PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(o);
        GoDuplicateInspection.processDuplicates(o.getTypeParameters(), new GoDuplicatesSearch.TypeSpecTypeParametersScopeSearch(), this.myHolder, context);
    }

    @Override
    public void visitFunctionLit(@NotNull GoFunctionLit o) {
        if (o == null) {
            GoDuplicateInspection.$$$reportNull$$$0(4);
        }
        super.visitFunctionLit(o);
        PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(o);
        GoDuplicateInspection.processDuplicates(o, new GoDuplicatesSearch.SignatureOwnerScopeSearch(), this.myHolder, context);
        GoDuplicateInspection.processDuplicates(o, new GoDuplicatesSearch.LabelScopeSearch(), this.myHolder, context);
    }

    @Override
    public void visitFunctionType(@NotNull GoFunctionType o) {
        if (o == null) {
            GoDuplicateInspection.$$$reportNull$$$0(5);
        }
        super.visitFunctionType(o);
        PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(o);
        GoDuplicateInspection.processDuplicates(o, new GoDuplicatesSearch.SignatureScopeSearch(), this.myHolder, context);
    }

    @Override
    public void visitNamedSignatureOwner(@NotNull GoNamedSignatureOwner o) {
        if (o == null) {
            GoDuplicateInspection.$$$reportNull$$$0(6);
        }
        super.visitNamedSignatureOwner(o);
        PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(o);
        GoDuplicateInspection.processDuplicates(o, new GoDuplicatesSearch.SignatureOwnerScopeSearch(), this.myHolder, context);
        GoDuplicateInspection.processDuplicates(o, new GoDuplicatesSearch.LabelScopeSearch(), this.myHolder, context);
    }

    @Override
    public void visitBlock(@NotNull GoBlock o) {
        if (o == null) {
            GoDuplicateInspection.$$$reportNull$$$0(7);
        }
        super.visitBlock(o);
        if (!(o.getParent() instanceof GoSignatureOwner)) {
            PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(o);
            GoDuplicateInspection.processDuplicates(o, new GoDuplicatesSearch.StatementsHolderScopeSearch(), this.myHolder, context);
        }
    }

    @Override
    public void visitShortVarDeclaration(@NotNull GoShortVarDeclaration o) {
        if (o == null) {
            GoDuplicateInspection.$$$reportNull$$$0(8);
        }
        super.visitShortVarDeclaration(o);
        this.checkVarAssign(o.getVarDefinitionList(), true);
    }

    @Override
    public void visitRecvStatement(@NotNull GoRecvStatement o) {
        if (o == null) {
            GoDuplicateInspection.$$$reportNull$$$0(9);
        }
        super.visitRecvStatement(o);
        this.checkVarAssign(o.getVarDefinitionList(), false);
    }

    @Override
    public void visitRangeClause(@NotNull GoRangeClause o) {
        if (o == null) {
            GoDuplicateInspection.$$$reportNull$$$0(10);
        }
        super.visitRangeClause(o);
        this.checkVarAssign(o.getVarDefinitionList(), false);
    }

    private void checkVarAssign(@NotNull List<GoVarDefinition> list, boolean ignoreFirstDefinition) {
        if (list == null) {
            GoDuplicateInspection.$$$reportNull$$$0(11);
        }
        MultiMap namesMap = MultiMap.create();
        for (GoVarDefinition def : list) {
            if (def.isBlank() || ignoreFirstDefinition && GoInspectionUtil.isPrimaryDefinition(def)) continue;
            namesMap.putValue((Object)def.getName(), (Object)def);
        }
        for (Map.Entry entry : namesMap.entrySet()) {
            String name = (String)entry.getKey();
            Collection defs = (Collection)entry.getValue();
            if (name == null || defs.size() < 2) continue;
            for (GoVarDefinition def : defs) {
                this.myHolder.registerProblem((PsiElement)def, GoInspectionProblemUtil.message("go.inspection.problem.variable.repeated.on.left.side", GoInspectionProblemUtil.REF), new LocalQuickFix[]{new GoRenameQuickFix(def)});
            }
        }
    }

    public static <T extends PsiElement> void processDuplicates(@Nullable T container, @NotNull GoDuplicatesSearch<T> search, @NotNull GoProblemsHolder holder, @NotNull PsiElement context) {
        if (search == null) {
            GoDuplicateInspection.$$$reportNull$$$0(12);
        }
        if (holder == null) {
            GoDuplicateInspection.$$$reportNull$$$0(13);
        }
        if (context == null) {
            GoDuplicateInspection.$$$reportNull$$$0(14);
        }
        if (container == null) {
            return;
        }
        MultiMap nameBasedDuplicates = MultiMap.createSet();
        search.processAllElements(container, (PairProcessor<String, GoDuplicatesSearch.Duplicate>)((PairProcessor)(name, duplicate) -> {
            ProgressIndicatorProvider.checkCanceled();
            nameBasedDuplicates.putValue(name, duplicate);
            return true;
        }));
        MultiMap identifierBasedDuplicates = MultiMap.createSet();
        for (Map.Entry entry : nameBasedDuplicates.entrySet()) {
            Collection duplicates = (Collection)entry.getValue();
            if (GoDuplicateInspection.areElementOfSameKind(duplicates) && GoDuplicateInspection.isImportable((GoDuplicatesSearch.Duplicate)ContainerUtil.getFirstItem((Collection)duplicates))) {
                for (GoDuplicatesSearch.Duplicate duplicate2 : duplicates) {
                    GoUniqueIdentifier identifier = GoUniqueIdentifier.Companion.of(duplicate2.duplicatedElement, context);
                    if (identifier == null) continue;
                    identifierBasedDuplicates.putValue((Object)identifier, (Object)duplicate2);
                }
                continue;
            }
            identifierBasedDuplicates.put((Object)new GoUniqueIdentifier((String)entry.getKey(), null, null), duplicates);
        }
        for (Map.Entry entry : identifierBasedDuplicates.entrySet()) {
            String typeText;
            String name2 = ((GoUniqueIdentifier)entry.getKey()).getName();
            Collection duplicates = (Collection)entry.getValue();
            if (duplicates.size() <= 1 || container instanceof GoInterfaceType && GoPsiUtil.allowedDuplicateMethodsFromOverlappingInterfaces(ContainerUtil.map((Collection)duplicates, d -> d.getSubstElement()), context)) continue;
            boolean elementsOfSameKind = GoDuplicateInspection.areElementOfSameKind(duplicates);
            GoMethodDeclaration methodDeclaration = duplicates.stream().map(duplicate -> duplicate.duplicatedElement).filter(GoMethodDeclaration.class::isInstance).map(GoMethodDeclaration.class::cast).findFirst().orElse(null);
            GoType receiverType = methodDeclaration != null ? methodDeclaration.getReceiverType() : null;
            String string = typeText = receiverType != null ? receiverType.getPresentationText() : null;
            if (duplicates.size() == 2) {
                Iterator iterator = duplicates.iterator();
                GoDuplicatesSearch.Duplicate firstItem = (GoDuplicatesSearch.Duplicate)iterator.next();
                GoDuplicatesSearch.Duplicate secondItem = (GoDuplicatesSearch.Duplicate)iterator.next();
                GoDuplicateInspection.registerProblem(holder, name2, firstItem, elementsOfSameKind, typeText, GoDuplicateInspection.createNavigateQuickFixes(secondItem));
                GoDuplicateInspection.registerProblem(holder, name2, secondItem, elementsOfSameKind, typeText, GoDuplicateInspection.createNavigateQuickFixes(firstItem));
                continue;
            }
            GoViewAllDuplicatesQuickFix<T> defaultQuickFix = new GoViewAllDuplicatesQuickFix<T>(name2, container, search);
            for (GoDuplicatesSearch.Duplicate duplicate3 : duplicates) {
                GoDuplicateInspection.registerProblem(holder, name2, duplicate3, elementsOfSameKind, typeText, defaultQuickFix);
            }
        }
    }

    @Nullable
    private static LocalQuickFix createNavigateQuickFixes(@NotNull GoDuplicatesSearch.Duplicate secondItem) {
        if (secondItem == null) {
            GoDuplicateInspection.$$$reportNull$$$0(15);
        }
        return secondItem.sourceElement.isValid() ? new GoNavigateToQuickFix(secondItem.sourceElement, GoBundle.message((String)"go.terms.duplicate", (Object[])new Object[0])) : null;
    }

    private static boolean areElementOfSameKind(@NotNull Collection<GoDuplicatesSearch.Duplicate> duplicates) {
        if (duplicates == null) {
            GoDuplicateInspection.$$$reportNull$$$0(16);
        }
        Object prevElement = null;
        for (GoDuplicatesSearch.Duplicate duplicate : duplicates) {
            GoNamedElement element = duplicate.duplicatedElement;
            if (!(prevElement == null || prevElement.getClass().isInstance(element) || GoPsiImplUtil.isFieldDefinition(element) && GoPsiImplUtil.isFieldDefinition((PsiElement)prevElement))) {
                return false;
            }
            prevElement = element;
        }
        return true;
    }

    private static boolean isImportable(@Nullable GoDuplicatesSearch.Duplicate duplicate) {
        GoNamedElement element = duplicate != null ? duplicate.duplicatedElement : null;
        return element instanceof GoVarOrConstDefinition || element instanceof GoNamedSignatureOwner || element instanceof GoTypeSpec;
    }

    private static void registerProblem(@NotNull GoProblemsHolder holder, @NotNull String name, @NotNull GoDuplicatesSearch.Duplicate duplicate, boolean sameKindElements, @Nullable String typeName, @Nullable LocalQuickFix defaultFix) {
        PsiElement sourceElement;
        if (holder == null) {
            GoDuplicateInspection.$$$reportNull$$$0(17);
        }
        if (name == null) {
            GoDuplicateInspection.$$$reportNull$$$0(18);
        }
        if (duplicate == null) {
            GoDuplicateInspection.$$$reportNull$$$0(19);
        }
        if (!(sourceElement = duplicate.sourceElement).getContainingFile().equals(holder.getFile())) {
            return;
        }
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        if (sameKindElements && sourceElement instanceof GoImportSpec) {
            fixes.add(GoUnusedImportInspection.OPTIMIZE_QUICK_FIX);
            fixes.add(new GoDeleteImportQuickFix());
        }
        ContainerUtil.addIfNotNull(fixes, (Object)defaultFix);
        PsiElement identifier = sourceElement instanceof GoNamedElement ? ((GoNamedElement)sourceElement).getIdentifier() : null;
        GoInspectionMessage errorMessage = GoDuplicateInspection.getErrorMessage(name, duplicate, sameKindElements, typeName);
        holder.registerProblem(identifier != null ? identifier : sourceElement, errorMessage, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    @NotNull
    private static GoInspectionMessage getErrorMessage(@NotNull String name, @NotNull GoDuplicatesSearch.Duplicate duplicate, boolean sameKindElements, @Nullable String type) {
        GoNamedElement e;
        if (name == null) {
            GoDuplicateInspection.$$$reportNull$$$0(20);
        }
        if (duplicate == null) {
            GoDuplicateInspection.$$$reportNull$$$0(21);
        }
        if ((e = duplicate.duplicatedElement) instanceof GoImportSpec) {
            GoInspectionMessage goInspectionMessage = sameKindElements ? GoInspectionProblemUtil.message("go.inspection.problem.name.redeclared.as.imported.package", GoInspectionProblemUtil.code(name)) : GoInspectionProblemUtil.message("go.inspection.problem.name.collides.with.name.declared.in.this.package", GoInspectionProblemUtil.code(name));
            if (goInspectionMessage == null) {
                GoDuplicateInspection.$$$reportNull$$$0(22);
            }
            return goInspectionMessage;
        }
        if (e instanceof GoLabelDefinition) {
            GoInspectionMessage goInspectionMessage = GoInspectionProblemUtil.message("go.inspection.problem.label.already.defined", GoInspectionProblemUtil.REF);
            if (goInspectionMessage == null) {
                GoDuplicateInspection.$$$reportNull$$$0(23);
            }
            return goInspectionMessage;
        }
        if (e instanceof GoTypeParamDefinition) {
            GoInspectionMessage goInspectionMessage = sameKindElements ? GoInspectionProblemUtil.message("go.inspection.problem.duplicate.type.param", GoInspectionProblemUtil.REF) : GoInspectionProblemUtil.message("go.inspection.problem.name.redeclared.in.this.function", GoInspectionProblemUtil.REF);
            if (goInspectionMessage == null) {
                GoDuplicateInspection.$$$reportNull$$$0(24);
            }
            return goInspectionMessage;
        }
        if (e instanceof GoParamDefinition) {
            GoInspectionMessage goInspectionMessage = sameKindElements ? GoInspectionProblemUtil.message("go.inspection.problem.duplicate.argument", GoInspectionProblemUtil.REF) : GoInspectionProblemUtil.message("go.inspection.problem.name.redeclared.in.this.function", GoInspectionProblemUtil.REF);
            if (goInspectionMessage == null) {
                GoDuplicateInspection.$$$reportNull$$$0(25);
            }
            return goInspectionMessage;
        }
        if (GoPsiImplUtil.isFieldDefinition(e)) {
            GoInspectionMessage goInspectionMessage = sameKindElements || type == null ? GoInspectionProblemUtil.message("go.inspection.problem.duplicate.field", GoInspectionProblemUtil.REF) : GoInspectionProblemUtil.message("go.inspection.problem.type.has.same.named.field.and.method", GoInspectionProblemUtil.code(type), GoInspectionProblemUtil.REF);
            if (goInspectionMessage == null) {
                GoDuplicateInspection.$$$reportNull$$$0(26);
            }
            return goInspectionMessage;
        }
        if (e instanceof GoMethodDeclaration && type != null) {
            GoInspectionMessage goInspectionMessage = sameKindElements ? GoInspectionProblemUtil.message("go.inspection.problem.method.redeclared", GoInspectionProblemUtil.code(type + "." + name)) : GoInspectionProblemUtil.message("go.inspection.problem.type.has.both.field.and.method.with.name", GoInspectionProblemUtil.code(type), GoInspectionProblemUtil.code(name));
            if (goInspectionMessage == null) {
                GoDuplicateInspection.$$$reportNull$$$0(27);
            }
            return goInspectionMessage;
        }
        if (e instanceof GoMethodSpec) {
            GoInspectionMessage goInspectionMessage = GoInspectionProblemUtil.message("go.inspection.problem.duplicate.method", GoInspectionProblemUtil.code(name));
            if (goInspectionMessage == null) {
                GoDuplicateInspection.$$$reportNull$$$0(28);
            }
            return goInspectionMessage;
        }
        String description = GoDuplicateInspection.getProblemElementDescription(duplicate.sourceElement, e, name);
        GoInspectionMessage goInspectionMessage = e.getContainingFile() != duplicate.sourceElement.getContainingFile() || PsiTreeUtil.getParentOfType((PsiElement)e, GoBlock.class) == null ? GoInspectionProblemUtil.message("go.inspection.problem.name.redeclared.in.this.package", description) : GoInspectionProblemUtil.message("go.inspection.problem.name.redeclared.in.this.block", description);
        if (goInspectionMessage == null) {
            GoDuplicateInspection.$$$reportNull$$$0(29);
        }
        return goInspectionMessage;
    }

    @NotNull
    @NonNls
    private static String getProblemElementDescription(@NotNull PsiElement sourceElement, @NotNull GoNamedElement duplicateElement, @NotNull String name) {
        if (sourceElement == null) {
            GoDuplicateInspection.$$$reportNull$$$0(30);
        }
        if (duplicateElement == null) {
            GoDuplicateInspection.$$$reportNull$$$0(31);
        }
        if (name == null) {
            GoDuplicateInspection.$$$reportNull$$$0(32);
        }
        if (sourceElement instanceof GoNamedElement && ((GoNamedElement)sourceElement).getIdentifier() != null) {
            String string = GoInspectionProblemUtil.REF;
            if (string == null) {
                GoDuplicateInspection.$$$reportNull$$$0(33);
            }
            return string;
        }
        String description = UsageViewUtil.getType((PsiElement)duplicateElement);
        Object object = StringUtil.isNotEmpty((String)description) ? StringUtil.capitalize((String)description) + " " + GoInspectionProblemUtil.code(name) : GoInspectionProblemUtil.code(name);
        if (object == null) {
            GoDuplicateInspection.$$$reportNull$$$0(34);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 22, 23, 24, 25, 26, 27, 28, 29, 33, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "search";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondItem";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicates";
                break;
            }
            case 18: 
            case 20: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicate";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/highlighting/legacyErrorInspections/GoDuplicateInspection";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicateElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoDuplicateInspection";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemElementDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitGoFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitStructType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitSpecType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitFunctionLit";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitFunctionType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitNamedSignatureOwner";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitBlock";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitShortVarDeclaration";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitRecvStatement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitRangeClause";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkVarAssign";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processDuplicates";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createNavigateQuickFixes";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "areElementOfSameKind";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: {
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getProblemElementDescription";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 22, 23, 24, 25, 26, 27, 28, 29, 33, 34 -> new IllegalStateException(string);
        };
    }
}

