/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.legacyErrorInspections;

import com.goide.GoTypes;
import com.goide.highlighting.legacyErrorInspections.GoInvalidExpressionConversionInspection;
import com.goide.highlighting.legacyErrorInspections.GoTypeCheckingUtil;
import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionProblemUtil;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoBinaryExpr;
import com.goide.psi.GoChannelType;
import com.goide.psi.GoExpression;
import com.goide.psi.GoIncDecStatement;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoSendStatement;
import com.goide.psi.GoShortVarDeclaration;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeOwner;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.GoVarOrConstSpec;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoCType;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoLightType;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.impl.typesCompatibility.GoTypeCheckResult;
import com.goide.psi.impl.typesCompatibility.GoTypesCompatible;
import com.goide.psi.impl.typesCompatibility.GoTypesNotCompatible;
import com.goide.sdk.GoSdkUtil;
import com.goide.sdk.GoSdkVersion;
import com.goide.util.Complex;
import com.goide.util.Value;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoBinaryAndUnaryExpressionTypesCompatibilityInspection
extends GoVisitor {
    private static final TokenSet MUL_OP = TokenSet.create((IElementType[])new IElementType[]{GoTypes.MUL, GoTypes.MUL_ASSIGN, GoTypes.QUOTIENT, GoTypes.QUOTIENT_ASSIGN});
    private static final TokenSet SHIFT_OP = TokenSet.create((IElementType[])new IElementType[]{GoTypes.SHIFT_LEFT, GoTypes.SHIFT_LEFT_ASSIGN, GoTypes.SHIFT_RIGHT, GoTypes.SHIFT_RIGHT_ASSIGN});
    private static final TokenSet BOOL_OP = TokenSet.create((IElementType[])new IElementType[]{GoTypes.COND_OR, GoTypes.COND_AND});
    private static final TokenSet PLUS_OP = TokenSet.create((IElementType[])new IElementType[]{GoTypes.PLUS, GoTypes.PLUS_ASSIGN});
    private static final TokenSet MINUS_OP = TokenSet.create((IElementType[])new IElementType[]{GoTypes.MINUS, GoTypes.MINUS_ASSIGN});
    private static final TokenSet COMPARE_OP = TokenSet.create((IElementType[])new IElementType[]{GoTypes.EQ, GoTypes.NOT_EQ});
    private static final TokenSet ORDERED_COMPARE_OP = TokenSet.create((IElementType[])new IElementType[]{GoTypes.LESS, GoTypes.LESS_OR_EQUAL, GoTypes.GREATER, GoTypes.GREATER_OR_EQUAL});
    private static final TokenSet INTEGER_OP = TokenSet.create((IElementType[])new IElementType[]{GoTypes.BIT_OR, GoTypes.BIT_OR_ASSIGN, GoTypes.BIT_XOR, GoTypes.BIT_XOR_ASSIGN, GoTypes.BIT_CLEAR, GoTypes.BIT_CLEAR_ASSIGN, GoTypes.REMAINDER, GoTypes.REMAINDER_ASSIGN, GoTypes.BIT_AND, GoTypes.BIT_AND_ASSIGN});
    @NotNull
    private final GoProblemsHolder myHolder;

    public GoBinaryAndUnaryExpressionTypesCompatibilityInspection(@NotNull GoProblemsHolder holder) {
        if (holder == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    @Override
    public void visitUnaryExpr(@NotNull GoUnaryExpr o) {
        GoType coreType;
        PsiElement operator;
        if (o == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(1);
        }
        if ((operator = o.getOperator()) == null) {
            return;
        }
        GoExpression expression = o.getExpression();
        GoType type = expression != null ? expression.getGoType(null) : null;
        PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(o);
        GoType goType = coreType = type != null ? GoTypeUtil.getCoreType(type, context) : null;
        if (type == null || coreType instanceof GoCType) {
            return;
        }
        IElementType operatorType = operator.getNode().getElementType();
        if (coreType != null && !GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isOperatorApplicableToUnaryExpressionType(operatorType, coreType, context)) {
            this.myHolder.registerProblem((PsiElement)o, GoInspectionProblemUtil.message("go.inspection.problem.invalid.unary.operation", operator.getText() + " " + type.getPresentationText()), new LocalQuickFix[0]);
        } else if (operatorType == GoTypes.ARROW) {
            if (coreType instanceof GoChannelType) {
                GoChannelType channelType = (GoChannelType)coreType;
                if (channelType.getDirection() == GoPsiImplUtil.ChannelDirection.SEND) {
                    this.myHolder.registerProblem((PsiElement)o, GoInspectionProblemUtil.message("go.inspection.problem.receive.from.send.only.type", o.getText(), type.getPresentationText()), new LocalQuickFix[0]);
                }
            } else if (coreType != null) {
                this.myHolder.registerProblem((PsiElement)o, GoInspectionProblemUtil.message("go.inspection.problem.receive.from.non.chan.type", o.getText(), type.getPresentationText()), new LocalQuickFix[0]);
            } else {
                this.myHolder.registerProblem((PsiElement)o, GoInspectionProblemUtil.message("go.inspection.problem.receive.no.core.type", o.getText(), expression.getText(), type.getText()), new LocalQuickFix[0]);
            }
        }
    }

    @Override
    public void visitBinaryExpr(@NotNull GoBinaryExpr o) {
        PsiElement operator;
        if (o == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(2);
        }
        if ((operator = o.getOperator()) != null) {
            this.checkTypesCompatibility(o.getLeft(), o.getRight(), operator, o, GoReferenceBase.getSubstitutionContextOrSelf(o));
        }
    }

    @Override
    public void visitVarOrConstSpec(@NotNull GoVarOrConstSpec o) {
        if (o == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(3);
        }
        if (o.getType() == null) {
            return;
        }
        PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(o);
        GoVarOrConstSpec spec = o;
        this.checkTypesCompatibility(spec.getDefinitionList(), spec.getExpressionList(), true, context);
    }

    @Override
    public void visitShortVarDeclaration(@NotNull GoShortVarDeclaration o) {
        if (o == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(4);
        }
        PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(o);
        this.checkTypesCompatibility(o.getVarDefinitionList(), o.getExpressionList(), false, context);
    }

    @Override
    public void visitAssignmentStatement(@NotNull GoAssignmentStatement o) {
        PsiElement operator;
        if (o == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(5);
        }
        if ((operator = o.getAssignOp().getOperator()) == null) {
            return;
        }
        PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(o);
        if (operator.getNode().getElementType() == GoTypes.ASSIGN) {
            this.checkTypesCompatibility(o.getLeftHandExprList().getExpressionList(), o.getExpressionList(), false, context);
        } else {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.processAssignments(o.getLeftHandExprList().getExpressionList(), o.getExpressionList(), assignmentInfo -> this.checkTypesCompatibility(assignmentInfo.left, assignmentInfo.right, operator, o, context), false, context);
        }
    }

    @Override
    public void visitSendStatement(@NotNull GoSendStatement o) {
        GoType underlyingType;
        if (o == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(6);
        }
        GoExpression channelExpression = o.getChannelExpression();
        GoType type = channelExpression.getGoType(null);
        PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(o);
        GoType goType = underlyingType = type != null ? GoTypeUtil.getCoreType(type, context) : null;
        if (underlyingType instanceof GoChannelType) {
            GoChannelType channelType = (GoChannelType)underlyingType;
            this.checkSendExpressionType(o, channelType);
        } else if (type != null) {
            this.myHolder.registerProblem((PsiElement)o, GoInspectionProblemUtil.message("go.inspection.problem.send.to.non.chan.type", o.getText(), type.getPresentationText()), new LocalQuickFix[0]);
        }
    }

    private void checkSendExpressionType(@NotNull GoSendStatement sendStatement, @NotNull GoChannelType channelType) {
        GoTypeCheckResult result;
        if (sendStatement == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(7);
        }
        if (channelType == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(8);
        }
        if (channelType.getDirection() == GoPsiImplUtil.ChannelDirection.RECEIVE) {
            this.myHolder.registerProblem((PsiElement)sendStatement, GoInspectionProblemUtil.message("go.inspection.problem.send.to.receive.only.type", sendStatement.getText(), channelType.getPresentationText()), new LocalQuickFix[0]);
            return;
        }
        GoType expectedType = channelType.getType();
        GoExpression sendExpression = sendStatement.getSendExpression();
        if (sendExpression == null) {
            return;
        }
        GoTypeCheckResult goTypeCheckResult = result = expectedType != null ? GoTypeUtil.checkAssignable(expectedType, sendExpression, false) : null;
        if (result instanceof GoTypesNotCompatible) {
            GoInspectionMessage message = GoTypeCheckingUtil.commonErrorDescription(sendExpression, expectedType, result);
            GoTypeCheckingUtil.registerProblem(this.myHolder, sendExpression, message, expectedType, result);
        }
    }

    @Override
    public void visitIncDecStatement(@NotNull GoIncDecStatement o) {
        GoType underlyingType;
        if (o == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(9);
        }
        GoExpression expression = o.getExpression();
        GoType type = expression.getGoType(null);
        PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(o);
        GoType goType = underlyingType = type != null ? type.getUnderlyingType(context) : null;
        if (underlyingType != null && !(underlyingType instanceof GoCType) && !GoTypeUtil.isNumericType(underlyingType, context)) {
            this.myHolder.registerProblem((PsiElement)expression, GoInspectionProblemUtil.message("go.inspection.problem.invalid.inc.dec.operation", o.getText(), type.getPresentationText()), new LocalQuickFix[0]);
        }
    }

    private void checkTypesCompatibility(@NotNull List<? extends GoTypeOwner> leftElements, @NotNull List<GoExpression> rightElements, boolean skipBlank, @Nullable PsiElement context) {
        if (leftElements == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(10);
        }
        if (rightElements == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(11);
        }
        GoBinaryAndUnaryExpressionTypesCompatibilityInspection.processAssignments(leftElements, rightElements, assignmentInfo -> {
            GoType leftType = assignmentInfo.left.getGoType(null);
            GoType rightType = assignmentInfo.rightType;
            if (leftType == null || rightType == null) {
                return;
            }
            GoTypeCheckResult result = GoTypeUtil.checkAssignable(leftType, assignmentInfo.right, rightType, context, false);
            if (result instanceof GoTypesCompatible) {
                return;
            }
            if (assignmentInfo.multipleAssignment) {
                String leftText = GoBundle.message((String)"go.inspection.problem.expression.with.type", (Object[])new Object[]{assignmentInfo.left.getText(), leftType.getPresentationText()});
                GoInspectionMessage message = GoInspectionProblemUtil.message("go.inspection.problem.cannot.assign.in.multiple.assignment", rightType.getPresentationText(), leftText);
                GoTypeCheckingUtil.registerProblem(this.myHolder, assignmentInfo.right, message, leftType, result);
            } else {
                GoInspectionMessage message = GoTypeCheckingUtil.commonErrorDescription(assignmentInfo.right, rightType, leftType, result);
                GoTypeCheckingUtil.registerProblem(this.myHolder, assignmentInfo.right, message, leftType, result);
            }
        }, skipBlank, context);
    }

    private void checkTypesCompatibility(@NotNull GoTypeOwner left, @Nullable GoExpression right, @NotNull PsiElement operator, @NotNull PsiElement elementToReport, @Nullable PsiElement context) {
        GoExpression leftExpr;
        GoType rightUnderlyingType;
        GoType leftType;
        GoType leftUnderlyingType;
        if (left == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(12);
        }
        if (operator == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(13);
        }
        if (elementToReport == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(14);
        }
        GoType goType = leftUnderlyingType = (leftType = left.getGoType(null)) != null ? leftType.getUnderlyingType(context) : null;
        if (leftUnderlyingType instanceof GoCType) {
            return;
        }
        GoType rightType = right != null ? right.getGoType(null) : null;
        GoType goType2 = rightUnderlyingType = rightType != null ? rightType.getUnderlyingType(context) : null;
        if (rightUnderlyingType instanceof GoCType) {
            return;
        }
        if (!this.processNil(left, right, operator, context)) {
            return;
        }
        IElementType operatorType = operator.getNode().getElementType();
        if (GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isTypesMismatch(leftType, leftUnderlyingType, rightType, rightUnderlyingType, operatorType, left)) {
            this.myHolder.registerProblem(elementToReport, GoInspectionProblemUtil.message("go.inspection.problem.invalid.operation.mismatched.types", elementToReport.getText(), leftType.getPresentationText(), rightType.getPresentationText()), new LocalQuickFix[0]);
            return;
        }
        if (rightUnderlyingType != null && leftUnderlyingType != null && !SHIFT_OP.contains(operatorType)) {
            if (GoTypeUtil.isUntypedNumericType(leftUnderlyingType) && GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isTypedNumericType(rightUnderlyingType, context) && left instanceof GoExpression) {
                leftExpr = (GoExpression)left;
                if (GoBinaryAndUnaryExpressionTypesCompatibilityInspection.canBeConverted(leftExpr, leftUnderlyingType, rightUnderlyingType, context)) {
                    leftUnderlyingType = rightUnderlyingType;
                } else {
                    this.registerConstantConvertProblem(elementToReport, left, rightUnderlyingType);
                    return;
                }
            }
            if (GoTypeUtil.isUntypedNumericType(rightUnderlyingType) && GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isTypedNumericType(leftUnderlyingType, context)) {
                if (GoBinaryAndUnaryExpressionTypesCompatibilityInspection.canBeConverted(right, rightUnderlyingType, leftUnderlyingType, context)) {
                    rightUnderlyingType = leftUnderlyingType;
                } else {
                    this.registerConstantConvertProblem(elementToReport, right, leftUnderlyingType);
                    return;
                }
            }
        }
        if (rightType != null) {
            if (SHIFT_OP.contains(operatorType)) {
                GoInspectionMessage message = GoBinaryAndUnaryExpressionTypesCompatibilityInspection.getInvalidShiftCountError(rightType, rightUnderlyingType, right, elementToReport, context);
                if (message != null) {
                    this.myHolder.registerProblem(elementToReport, message, new LocalQuickFix[0]);
                    return;
                }
            } else if (!GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isOperatorApplicableToType(operatorType, rightType, rightUnderlyingType, context)) {
                @NlsSafe String presentationText = rightType.getPresentationText();
                this.registerOperatorNotDefined(elementToReport, operator, presentationText);
                return;
            }
        }
        if (leftType != null && left instanceof GoExpression && !GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isOperatorApplicableToLeftOperand(operatorType, leftType, leftUnderlyingType, leftExpr = (GoExpression)left, context)) {
            @NlsSafe String presentationText = leftType.getPresentationText();
            this.registerOperatorNotDefined(elementToReport, operator, presentationText);
        }
    }

    private boolean processNil(@NotNull GoTypeOwner left, @Nullable GoExpression right, @NotNull PsiElement operator, @Nullable PsiElement context) {
        boolean bothNil;
        GoType type;
        if (left == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(15);
        }
        if (operator == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(16);
        }
        GoExpression l = left instanceof GoExpression ? ((GoExpression)left).unwrapParentheses() : null;
        GoExpression r = GoPsiImplUtil.unwrapParentheses(right);
        boolean leftNil = GoExpressionUtil.isNil(l);
        boolean rightNil = GoExpressionUtil.isNil(r);
        if (!leftNil && !rightNil) {
            return true;
        }
        GoExpression typeOwner = leftNil ? r : l;
        GoExpression nil = leftNil ? l : r;
        GoType goType = type = typeOwner != null ? typeOwner.getGoType(null) : null;
        if (type == null) {
            return false;
        }
        ASTNode operatorNode = operator.getNode();
        IElementType operatorType = operatorNode != null ? operatorNode.getElementType() : null;
        boolean bl = bothNil = leftNil && rightNil;
        if (GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isCompareOp(operatorType)) {
            if (!bothNil && !GoTypeUtil.isAllowedComparingToNil(type, context)) {
                this.registerCannotConvertNilToType(nil, type);
            } else if (ORDERED_COMPARE_OP.contains(operatorType)) {
                @NlsSafe String presentationText = type.getPresentationText();
                this.registerOperatorNotDefined(typeOwner, operator, presentationText);
            }
        } else if (!bothNil) {
            this.registerCannotConvertNilToType(nil, type);
        } else {
            this.registerOperatorNotDefined(l, operator, "nil");
        }
        return false;
    }

    private void registerCannotConvertNilToType(@NotNull GoTypeOwner typeOwner, @NotNull GoType type) {
        if (typeOwner == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(17);
        }
        if (type == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(18);
        }
        this.myHolder.registerProblem((PsiElement)typeOwner, GoInspectionProblemUtil.message("go.inspection.problem.cannot.convert.nil.to.type", GoInspectionProblemUtil.code("nil"), GoInspectionProblemUtil.code(type.getPresentationText())), new LocalQuickFix[0]);
    }

    private void registerOperatorNotDefined(@NotNull PsiElement element, @NotNull PsiElement operator, @Nls @NotNull String typeText) {
        if (element == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(19);
        }
        if (operator == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(20);
        }
        if (typeText == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(21);
        }
        this.myHolder.registerProblem(element, GoInspectionProblemUtil.message("go.inspection.problem.operator.not.defined", element.getText(), operator.getText(), typeText), new LocalQuickFix[0]);
    }

    private static boolean isTypesMismatch(@Nullable GoType leftType, @Nullable GoType leftUnderlyingType, @Nullable GoType rightType, @Nullable GoType rightUnderlyingType, @NotNull IElementType operatorType, @Nullable PsiElement context) {
        if (operatorType == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(22);
        }
        return leftType != null && rightType != null && leftUnderlyingType != null && rightUnderlyingType != null && !SHIFT_OP.contains(operatorType) && !GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isUntypedNumericAndNumeric(leftUnderlyingType, rightUnderlyingType, context) && !GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isUntypedStringAndString(leftUnderlyingType, rightUnderlyingType, context) && !GoTypeUtil.identical(leftType, rightType, false, context) && (!GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isCompareOp(operatorType) && !BOOL_OP.contains(operatorType) || !GoTypeUtil.isAssignable(leftType, null, rightType, context, false) && !GoTypeUtil.isAssignable(rightType, null, leftType, context, false));
    }

    private static boolean isUntypedStringAndString(@NotNull GoType left, @NotNull GoType right, @Nullable PsiElement context) {
        if (left == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(23);
        }
        if (right == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(24);
        }
        return left instanceof GoLightType.LightUntypedStringType && GoTypeUtil.isString(right, context) || right instanceof GoLightType.LightUntypedStringType && GoTypeUtil.isString(left, context);
    }

    private static boolean isUntypedNumericAndNumeric(@NotNull GoType left, @NotNull GoType right, @Nullable PsiElement context) {
        if (left == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(25);
        }
        if (right == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(26);
        }
        return left instanceof GoLightType.LightUntypedNumericType && GoTypeUtil.isNumericType(right, context) || right instanceof GoLightType.LightUntypedNumericType && GoTypeUtil.isNumericType(left, context);
    }

    private static boolean isCompareOp(IElementType operatorType) {
        return COMPARE_OP.contains(operatorType) || ORDERED_COMPARE_OP.contains(operatorType);
    }

    private static void processAssignments(@NotNull List<? extends GoTypeOwner> leftElements, @NotNull List<GoExpression> rightExpressions, @NotNull Consumer<? super AssignmentInfo> consumer, boolean skipBlank, @Nullable PsiElement context) {
        if (leftElements == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(27);
        }
        if (rightExpressions == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(28);
        }
        if (consumer == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(29);
        }
        GoExpression firstExpression = (GoExpression)ContainerUtil.getFirstItem(rightExpressions);
        ResolveState state = GoPsiImplUtil.createContextOnElement(context);
        List<GoType> rightTypes = firstExpression != null && rightExpressions.size() == 1 && GoExpressionUtil.hasSecondBoolValueWhichCanBeOmitted(firstExpression, state) ? Arrays.asList(firstExpression.getGoType(null), GoLightType.getBoolType(firstExpression)) : GoTypeUtil.getTypesOfExpressions(rightExpressions, state);
        boolean isMultipleAssignment = rightExpressions.size() != rightTypes.size();
        int count2 = Math.min(leftElements.size(), rightTypes.size());
        for (int i = 0; i < count2; ++i) {
            GoNamedElement namedElement;
            GoTypeOwner left = leftElements.get(i);
            if (!skipBlank && left instanceof GoNamedElement && (namedElement = (GoNamedElement)left).isBlank()) continue;
            GoExpression right = rightExpressions.get(isMultipleAssignment ? 0 : i);
            consumer.accept(new AssignmentInfo(left, right, rightTypes.get(i), isMultipleAssignment));
        }
    }

    private static boolean isOperatorApplicableToUnaryExpressionType(@NotNull IElementType operatorType, @NotNull GoType unaryExpressionType, @Nullable PsiElement context) {
        if (operatorType == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(30);
        }
        if (unaryExpressionType == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(31);
        }
        if (operatorType == GoTypes.MINUS || operatorType == GoTypes.PLUS) {
            return GoTypeUtil.isNumericType(unaryExpressionType, context);
        }
        if (operatorType == GoTypes.NOT) {
            return GoTypeUtil.isBoolean(unaryExpressionType, context);
        }
        if (operatorType == GoTypes.BIT_XOR) {
            return GoTypeUtil.isIntegerType(unaryExpressionType, context) || GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isUntypedIntegerOrCType(unaryExpressionType, context);
        }
        return true;
    }

    private static boolean isOperatorApplicableToLeftOperand(@NotNull IElementType operatorType, @NotNull GoType leftOperandType, @NotNull GoType leftOperandUnderlyingType, @NotNull GoExpression leftExpression, @Nullable PsiElement context) {
        if (operatorType == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(32);
        }
        if (leftOperandType == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(33);
        }
        if (leftOperandUnderlyingType == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(34);
        }
        if (leftExpression == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(35);
        }
        if (SHIFT_OP.contains(operatorType)) {
            return GoTypeUtil.isIntegerType(leftOperandUnderlyingType, context) || GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isUntypedIntegerOrCType(leftOperandUnderlyingType, context) || GoBinaryAndUnaryExpressionTypesCompatibilityInspection.hasUntypedIntegerValue(leftExpression, leftOperandUnderlyingType, true, context);
        }
        return GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isOperatorApplicableToType(operatorType, leftOperandType, leftOperandUnderlyingType, context);
    }

    @Nullable
    private static GoInspectionMessage getInvalidShiftCountError(@NotNull GoType type, @NotNull GoType underlyingType, @NotNull GoExpression expression, @NotNull PsiElement elementToReport, @Nullable PsiElement context) {
        if (type == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(36);
        }
        if (underlyingType == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(37);
        }
        if (expression == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(38);
        }
        if (elementToReport == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(39);
        }
        if (underlyingType instanceof GoCType) {
            return null;
        }
        boolean isConstant = GoTypeUtil.isUntypedNumericType(underlyingType);
        if (isConstant) {
            if (GoBinaryAndUnaryExpressionTypesCompatibilityInspection.hasUntypedIntegerValue(expression, underlyingType, false, context)) {
                return null;
            }
            if (!GoBinaryAndUnaryExpressionTypesCompatibilityInspection.supportsSignedShift(expression)) {
                return GoInspectionProblemUtil.message("go.inspection.problem.shift.count.must.be.unsigned.integer", elementToReport.getText(), type.getPresentationText());
            }
            return !GoTypeUtil.isIntegerType(underlyingType, context) ? GoInspectionProblemUtil.message("go.inspection.problem.shift.count.must.be.integer", elementToReport.getText(), type.getPresentationText()) : GoInspectionProblemUtil.message("go.inspection.problem.negative.shift.count", elementToReport.getText());
        }
        if (!GoBinaryAndUnaryExpressionTypesCompatibilityInspection.supportsSignedShift(expression)) {
            return !GoTypeUtil.isUintType(underlyingType, context) ? GoInspectionProblemUtil.message("go.inspection.problem.shift.count.must.be.unsigned.integer", elementToReport.getText(), type.getPresentationText()) : null;
        }
        return !GoTypeUtil.isIntegerType(underlyingType, context) ? GoInspectionProblemUtil.message("go.inspection.problem.shift.count.must.be.integer", elementToReport.getText(), type.getPresentationText()) : null;
    }

    private static boolean supportsSignedShift(@NotNull GoExpression expression) {
        if (expression == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(40);
        }
        return GoSdkUtil.featureSupported(expression, false, GoSdkVersion::supportsSignedShift) == GoSdkUtil.FeatureSupported.YES;
    }

    private static boolean isOperatorApplicableToType(@NotNull IElementType operatorType, @NotNull GoType operandType, @NotNull GoType operandUnderlyingType, @Nullable PsiElement context) {
        if (operatorType == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(41);
        }
        if (operandType == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(42);
        }
        if (operandUnderlyingType == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(43);
        }
        if (MINUS_OP.contains(operatorType) || MUL_OP.contains(operatorType)) {
            return GoTypeUtil.isNumericType(operandUnderlyingType, context);
        }
        if (BOOL_OP.contains(operatorType)) {
            return GoTypeUtil.isBoolean(operandUnderlyingType, context);
        }
        if (INTEGER_OP.contains(operatorType)) {
            return GoTypeUtil.isIntegerType(operandUnderlyingType, context) || GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isUntypedIntegerOrCType(operandUnderlyingType, context);
        }
        if (PLUS_OP.contains(operatorType)) {
            return GoTypeUtil.isPlusable(operandUnderlyingType, context);
        }
        if (COMPARE_OP.contains(operatorType)) {
            return GoTypeUtil.isComparable(operandType, context, false);
        }
        if (ORDERED_COMPARE_OP.contains(operatorType)) {
            return GoTypeUtil.isOrderedComparable(operandUnderlyingType, context);
        }
        return true;
    }

    private void registerConstantConvertProblem(@NotNull PsiElement element, @NotNull PsiElement constant, @NotNull GoType type) {
        if (element == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(44);
        }
        if (constant == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(45);
        }
        if (type == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(46);
        }
        this.myHolder.registerProblem(element, GoInspectionProblemUtil.message("go.inspection.problem.cannot.convert.constant", element.getText(), constant.getText(), type.getText()), new LocalQuickFix[0]);
    }

    private static boolean hasUntypedIntegerValue(@NotNull GoExpression expression, @NotNull GoType type, boolean signed, @Nullable PsiElement context) {
        if (expression == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(47);
        }
        if (type == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(48);
        }
        if (!GoTypeUtil.isUntypedNumericType(type)) {
            return false;
        }
        Value value2 = expression.getValue();
        if (value2 == null) {
            return true;
        }
        if (GoTypeUtil.isIntegerType(type, context)) {
            Long intValue = value2.getInteger();
            return intValue != null && (signed || intValue >= 0L);
        }
        if (GoTypeUtil.isComplexType(type, context)) {
            Complex complex = value2.getComplex();
            return complex != null && complex.im() == 0.0 && complex.re() == Math.floor(complex.re()) && (signed || complex.re() >= 0.0);
        }
        if (GoTypeUtil.isFloatType(type, context)) {
            Double doubleValue = value2.getDouble();
            return doubleValue != null && doubleValue == Math.floor(doubleValue) && (signed || doubleValue >= 0.0);
        }
        return false;
    }

    private static boolean canBeConverted(@NotNull GoExpression expression, @NotNull GoType constExprType, @NotNull GoType targetType, @Nullable PsiElement context) {
        if (expression == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(49);
        }
        if (constExprType == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(50);
        }
        if (targetType == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(51);
        }
        return ThreeState.NO != GoInvalidExpressionConversionInspection.isValidConstExpressionConversion(expression, constExprType, targetType, false, context);
    }

    private static boolean isUntypedIntegerOrCType(@Nullable GoType type, @Nullable PsiElement context) {
        return GoTypeUtil.isUntypedIntegerType(type) || GoTypeUtil.isCType(type, context);
    }

    private static boolean isTypedNumericType(@NotNull GoType type, @Nullable PsiElement context) {
        if (type == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(52);
        }
        return GoTypeUtil.isNumericType(type, context) && !GoTypeUtil.isUntypedNumericType(type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sendStatement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channelType";
                break;
            }
            case 10: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftElements";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightElements";
                break;
            }
            case 12: 
            case 15: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 13: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
            case 14: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToReport";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeOwner";
                break;
            }
            case 18: 
            case 36: 
            case 46: 
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeText";
                break;
            }
            case 22: 
            case 30: 
            case 32: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operatorType";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightExpressions";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unaryExpressionType";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftOperandType";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftOperandUnderlyingType";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftExpression";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "underlyingType";
                break;
            }
            case 38: 
            case 40: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operandType";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operandUnderlyingType";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constExprType";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoBinaryAndUnaryExpressionTypesCompatibilityInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitUnaryExpr";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBinaryExpr";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitVarOrConstSpec";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitShortVarDeclaration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAssignmentStatement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSendStatement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSendExpressionType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitIncDecStatement";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTypesCompatibility";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "processNil";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "registerCannotConvertNilToType";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "registerOperatorNotDefined";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "isTypesMismatch";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "isUntypedStringAndString";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "isUntypedNumericAndNumeric";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "processAssignments";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "isOperatorApplicableToUnaryExpressionType";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "isOperatorApplicableToLeftOperand";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "getInvalidShiftCountError";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[2] = "supportsSignedShift";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[2] = "isOperatorApplicableToType";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[2] = "registerConstantConvertProblem";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[2] = "hasUntypedIntegerValue";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeConverted";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[2] = "isTypedNumericType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class AssignmentInfo {
        final boolean multipleAssignment;
        final GoTypeOwner left;
        final GoExpression right;
        final GoType rightType;

        AssignmentInfo(@NotNull GoTypeOwner left, @NotNull GoExpression right, @Nullable GoType rightType, boolean multipleAssignment) {
            if (left == null) {
                AssignmentInfo.$$$reportNull$$$0(0);
            }
            if (right == null) {
                AssignmentInfo.$$$reportNull$$$0(1);
            }
            this.multipleAssignment = multipleAssignment;
            this.left = left;
            this.right = right;
            this.rightType = rightType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "left";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "right";
                    break;
                }
            }
            objectArray[1] = "com/goide/highlighting/legacyErrorInspections/GoBinaryAndUnaryExpressionTypesCompatibilityInspection$AssignmentInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

