/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.errors.GoSpecCheckerBase;
import com.goide.inspections.GoInspectionUtil;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoIndexOrSliceExpr;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoSignature;
import com.goide.psi.GoTypeParamDefinition;
import com.goide.psi.GoTypeParameters;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.psi.impl.generics.GoReverseTypeInferenceContext;
import com.goide.psi.impl.generics.GoTypeInferenceKt;
import com.goide.psi.impl.generics.GoTypeInferenceResult;
import com.goide.psi.impl.generics.GoTypeInferenceSpecificationBuilder;
import com.goide.psi.impl.generics.GoTypeInstantiationKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/goide/highlighting/errors/GoTypeInferenceSpecChecker;", "Lcom/goide/highlighting/errors/GoSpecCheckerBase;", "holder", "Lcom/goide/highlighting/GoAnnotationHolder;", "<init>", "(Lcom/goide/highlighting/GoAnnotationHolder;)V", "visitCallExpr", "", "callExpr", "Lcom/goide/psi/GoCallExpr;", "visitIndexOrSliceExpr", "indexOrSliceExpr", "Lcom/goide/psi/GoIndexOrSliceExpr;", "getCannotInferErrorMessage", "Lcom/goide/inspections/core/GoInspectionMessageWithI18n;", "typeParameters", "Lcom/goide/psi/GoTypeParameters;", "inferenceResult", "Lcom/goide/psi/impl/generics/GoTypeInferenceResult;", "resolveSignature", "Lcom/goide/psi/GoSignature;", "Lcom/goide/psi/GoExpression;", "intellij.go.impl"})
@SourceDebugExtension(value={"SMAP\nGoTypeInferenceSpecChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoTypeInferenceSpecChecker.kt\ncom/goide/highlighting/errors/GoTypeInferenceSpecChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,69:1\n295#2,2:70\n19#3:72\n*S KotlinDebug\n*F\n+ 1 GoTypeInferenceSpecChecker.kt\ncom/goide/highlighting/errors/GoTypeInferenceSpecChecker\n*L\n61#1:70,2\n68#1:72\n*E\n"})
public final class GoTypeInferenceSpecChecker
extends GoSpecCheckerBase {
    public GoTypeInferenceSpecChecker(@NotNull GoAnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super(holder);
    }

    @Override
    public void visitCallExpr(@NotNull GoCallExpr callExpr) {
        Intrinsics.checkNotNullParameter((Object)callExpr, (String)"callExpr");
        super.visitCallExpr(callExpr);
        GoSignature goSignature = GoPsiImplUtil.getSignature(callExpr);
        if (goSignature == null) {
            return;
        }
        GoSignature signature = goSignature;
        GoTypeParameters goTypeParameters = signature.getTypeParameters();
        if (goTypeParameters == null) {
            return;
        }
        GoTypeParameters typeParameters = goTypeParameters;
        if (!GoInspectionUtil.areAllArgumentsSpecified(callExpr, signature, true)) {
            return;
        }
        PsiElement psiElement = GoReferenceBase.getSubstitutionContextOrSelf(callExpr);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getSubstitutionContextOrSelf(...)");
        PsiElement context = psiElement;
        ResolveState resolveState = GoPsiImplUtil.createContextOnElement(context);
        Intrinsics.checkNotNullExpressionValue((Object)resolveState, (String)"createContextOnElement(...)");
        ResolveState state = resolveState;
        GoTypeInferenceResult goTypeInferenceResult = GoTypeInferenceSpecificationBuilder.Companion.fromCall(callExpr, signature).build(state).infer();
        if (goTypeInferenceResult == null) {
            return;
        }
        GoTypeInferenceResult inferenceResult2 = goTypeInferenceResult;
        if (inferenceResult2.getOk()) {
            return;
        }
        GoInspectionMessageWithI18n goInspectionMessageWithI18n = this.getCannotInferErrorMessage(typeParameters, inferenceResult2);
        if (goInspectionMessageWithI18n == null) {
            return;
        }
        GoInspectionMessageWithI18n message = goInspectionMessageWithI18n;
        this.myHolder.newErrorAnnotation(callExpr, (GoInspectionMessage)message).create();
    }

    @Override
    public void visitIndexOrSliceExpr(@NotNull GoIndexOrSliceExpr indexOrSliceExpr) {
        GoTypeInferenceResult inferenceResult2;
        Intrinsics.checkNotNullParameter((Object)indexOrSliceExpr, (String)"indexOrSliceExpr");
        super.visitIndexOrSliceExpr(indexOrSliceExpr);
        if (indexOrSliceExpr.getParent() instanceof GoCallExpr) {
            return;
        }
        if (!GoPsiUtil.isCallOrConversionWithTypeInstantiation(indexOrSliceExpr)) {
            return;
        }
        GoCompositeElement goCompositeElement = indexOrSliceExpr.getExpression();
        if (goCompositeElement == null || (goCompositeElement = this.resolveSignature((GoExpression)goCompositeElement)) == null) {
            return;
        }
        GoCompositeElement signature = goCompositeElement;
        GoTypeParameters goTypeParameters = signature.getTypeParameters();
        if (goTypeParameters == null) {
            return;
        }
        GoTypeParameters typeParameters = goTypeParameters;
        PsiElement psiElement = GoReferenceBase.getSubstitutionContextOrSelf(indexOrSliceExpr);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getSubstitutionContextOrSelf(...)");
        PsiElement context = psiElement;
        ResolveState resolveState = GoPsiImplUtil.createContextOnElement(context);
        Intrinsics.checkNotNullExpressionValue((Object)resolveState, (String)"createContextOnElement(...)");
        ResolveState state = resolveState;
        GoReverseTypeInferenceContext typeInferenceContext = GoTypeInferenceKt.isReverseTypeInferenceEnabled(indexOrSliceExpr) ? GoTypeInstantiationKt.getReverseTypeInferenceContext(indexOrSliceExpr) : null;
        GoTypeInferenceResult goTypeInferenceResult = inferenceResult2 = typeInferenceContext != null ? GoTypeInstantiationKt.inferTypeArguments(indexOrSliceExpr, typeInferenceContext, state) : GoTypeInferenceSpecificationBuilder.Companion.fromIndexExpr(indexOrSliceExpr, (GoSignature)signature).build(state).infer();
        if (inferenceResult2 == null) {
            return;
        }
        if (inferenceResult2.getOk()) {
            return;
        }
        GoInspectionMessageWithI18n goInspectionMessageWithI18n = this.getCannotInferErrorMessage(typeParameters, inferenceResult2);
        if (goInspectionMessageWithI18n == null) {
            return;
        }
        GoInspectionMessageWithI18n message = goInspectionMessageWithI18n;
        this.myHolder.newErrorAnnotation(indexOrSliceExpr, (GoInspectionMessage)message).create();
    }

    private final GoInspectionMessageWithI18n getCannotInferErrorMessage(GoTypeParameters typeParameters, GoTypeInferenceResult inferenceResult2) {
        GoTypeParamDefinition firstNotInferred;
        Object v1;
        block2: {
            List<GoTypeParamDefinition> list = GoPsiImplUtil.getTypeParamDefinitions(typeParameters);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getTypeParamDefinitions(...)");
            List<GoTypeParamDefinition> typeParamDefinitions = list;
            Iterable $this$firstOrNull$iv = typeParamDefinitions;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GoTypeParamDefinition it = (GoTypeParamDefinition)element$iv;
                boolean bl = false;
                if (!(!inferenceResult2.getSubstitution().containsKey(it))) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        if ((firstNotInferred = (GoTypeParamDefinition)v1) == null) {
            return null;
        }
        Object[] objectArray = new Object[]{firstNotInferred.getName()};
        return GoInspectionMessageWithI18n.message("go.error.annotator.cannot.infer.types", objectArray);
    }

    private final GoSignature resolveSignature(GoExpression $this$resolveSignature) {
        GoExpression $this$asSafely$iv = $this$resolveSignature;
        boolean $i$f$asSafely = false;
        GoExpression goExpression = $this$asSafely$iv;
        if (!(goExpression instanceof GoReferenceExpression)) {
            goExpression = null;
        }
        GoReferenceExpression goReferenceExpression = (GoReferenceExpression)goExpression;
        PsiElement $this$asSafely$iv2 = goReferenceExpression != null ? goReferenceExpression.resolve() : null;
        boolean $i$f$asSafely2 = false;
        PsiElement psiElement = $this$asSafely$iv2;
        if (!(psiElement instanceof GoNamedSignatureOwner)) {
            psiElement = null;
        }
        GoNamedSignatureOwner goNamedSignatureOwner = (GoNamedSignatureOwner)psiElement;
        return goNamedSignatureOwner != null ? goNamedSignatureOwner.getSignature() : null;
    }
}

