/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.errors.GoSpecCheckerBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.project.GoModuleSettings;
import com.goide.psi.GoFile;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeSpec;
import com.goide.quickfix.GoEnableGoExperimentQuickFix;
import com.goide.quickfix.GoShowSdkConfigurableFix;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkUtil;
import com.goide.sdk.GoSdkVersion;
import com.goide.util.GoTargetSystem;
import com.goide.util.GoUtil;
import com.goide.vgo.mod.quickfix.VgoAddOrUpdateGoVersionFix;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/goide/highlighting/errors/GoTypeAliasesSpecChecker;", "Lcom/goide/highlighting/errors/GoSpecCheckerBase;", "holder", "Lcom/goide/highlighting/GoAnnotationHolder;", "<init>", "(Lcom/goide/highlighting/GoAnnotationHolder;)V", "genericTypeAliasesExperimentEnabled", "", "getGenericTypeAliasesExperimentEnabled", "()Z", "visitTypeDeclaration", "", "o", "Lcom/goide/psi/GoTypeDeclaration;", "checkNameForInit", "spec", "Lcom/goide/psi/GoTypeSpec;", "checkTypeAliases", "module", "Lcom/intellij/openapi/module/Module;", "checkGenericTypeAlias", "intellij.go.impl"})
@SourceDebugExtension(value={"SMAP\nGoTypeAliasesSpecChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoTypeAliasesSpecChecker.kt\ncom/goide/highlighting/errors/GoTypeAliasesSpecChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public final class GoTypeAliasesSpecChecker
extends GoSpecCheckerBase {
    @NotNull
    private final GoAnnotationHolder holder;
    private final boolean genericTypeAliasesExperimentEnabled;

    /*
     * WARNING - void declaration
     */
    public GoTypeAliasesSpecChecker(@NotNull GoAnnotationHolder holder) {
        GoModuleSettings settings;
        Object object;
        GoModuleSettings goModuleSettings;
        void $this$genericTypeAliasesExperimentEnabled_u24lambda_u241;
        Module module;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super(holder);
        this.holder = holder;
        GoTypeAliasesSpecChecker goTypeAliasesSpecChecker = this;
        GoTypeAliasesSpecChecker goTypeAliasesSpecChecker2 = this;
        boolean bl = false;
        Module module2 = module = GoUtil.module((PsiElement)$this$genericTypeAliasesExperimentEnabled_u24lambda_u241.holder.getFile());
        if (module2 != null) {
            Module it = module2;
            boolean bl2 = false;
            goModuleSettings = GoModuleSettings.getInstance(it);
        } else {
            goModuleSettings = null;
        }
        boolean bl3 = (object = (settings = goModuleSettings)) != null && (object = ((GoModuleSettings)object).getTargetSystem()) != null ? ((GoTargetSystem)object).supportsExperiment("aliastypeparams") : false;
        goTypeAliasesSpecChecker2.genericTypeAliasesExperimentEnabled = bl3;
    }

    public final boolean getGenericTypeAliasesExperimentEnabled() {
        return this.genericTypeAliasesExperimentEnabled;
    }

    @Override
    public void visitTypeDeclaration(@NotNull GoTypeDeclaration o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        super.visitTypeDeclaration(o);
        if (!(o.getParent() instanceof GoFile)) {
            return;
        }
        Module module = GoUtil.module((PsiElement)this.holder.getFile());
        for (GoTypeSpec spec : o.getTypeSpecList()) {
            Intrinsics.checkNotNull((Object)spec);
            this.checkNameForInit(spec);
            if (module == null || !spec.isTypeAlias()) continue;
            this.checkTypeAliases(module, spec);
            if (spec.getSpecType().getTypeParameters() == null) continue;
            this.checkGenericTypeAlias(spec);
        }
    }

    private final void checkNameForInit(GoTypeSpec spec) {
        if (Intrinsics.areEqual((Object)spec.getName(), (Object)"init")) {
            this.myHolder.newErrorAnnotation(spec, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.cannot.declare.init.must.be.a.function")).create();
        }
    }

    private final void checkTypeAliases(Module module, GoTypeSpec spec) {
        if (!GoSdkService.getInstance(module.getProject()).getSdk(module).supportsTypeAliases()) {
            this.myHolder.newErrorAnnotation(spec.getSpecType(), (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.type.aliases.are.available.since.go.1.9")).create();
        }
    }

    private final void checkGenericTypeAlias(GoTypeSpec spec) {
        GoSdkUtil.FeatureSupported featureSupported = GoSdkUtil.featureSupported(spec, false, GoSdkVersion::supportsGenericTypeAliases);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)featureSupported), (String)"featureSupported(...)");
        GoSdkUtil.FeatureSupported featureSupported2 = featureSupported;
        if (featureSupported2 == GoSdkUtil.FeatureSupported.NO) {
            GoInspectionMessageWithI18n goInspectionMessageWithI18n = GoInspectionMessageWithI18n.message("go.error.annotator.needs.update.for.generic.type.aliases");
            Intrinsics.checkNotNullExpressionValue((Object)goInspectionMessageWithI18n, (String)"message(...)");
            GoInspectionMessageWithI18n message = goInspectionMessageWithI18n;
            GoSpecCheckerBase.withQuickFix(this.myHolder.newErrorAnnotation(spec, (GoInspectionMessage)message), new GoShowSdkConfigurableFix(), spec, message).create();
            return;
        }
        if (featureSupported2 == GoSdkUtil.FeatureSupported.NEED_VERSION_UPDATE) {
            GoInspectionMessageWithI18n goInspectionMessageWithI18n = GoInspectionMessageWithI18n.message("go.error.annotator.needs.update.for.generic.type.aliases");
            Intrinsics.checkNotNullExpressionValue((Object)goInspectionMessageWithI18n, (String)"message(...)");
            GoInspectionMessageWithI18n message = goInspectionMessageWithI18n;
            GoSpecCheckerBase.withQuickFix(this.myHolder.newErrorAnnotation(spec, (GoInspectionMessage)message), new VgoAddOrUpdateGoVersionFix(GoSdkVersion.GO_1_23), spec, message).create();
            return;
        }
        if (this.genericTypeAliasesExperimentEnabled) {
            return;
        }
        GoSdkUtil.FeatureSupported featureSupported3 = GoSdkUtil.featureSupported(spec, false, GoSdkVersion::requiresExperimentForGenericTypeAliases);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)featureSupported3), (String)"featureSupported(...)");
        GoSdkUtil.FeatureSupported experimentRequired = featureSupported3;
        if (experimentRequired == GoSdkUtil.FeatureSupported.YES) {
            GoInspectionMessageWithI18n goInspectionMessageWithI18n = GoInspectionMessageWithI18n.message("go.error.annotator.needs.experiment.for.generic.type.aliases");
            Intrinsics.checkNotNullExpressionValue((Object)goInspectionMessageWithI18n, (String)"message(...)");
            GoInspectionMessageWithI18n message = goInspectionMessageWithI18n;
            AnnotationBuilder annotationBuilder = this.myHolder.newErrorAnnotation(spec, (GoInspectionMessage)message);
            Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder, (String)"newErrorAnnotation(...)");
            AnnotationBuilder annotationBuilder2 = annotationBuilder;
            GoEnableGoExperimentQuickFix fix = new GoEnableGoExperimentQuickFix("aliastypeparams");
            GoSpecCheckerBase.withQuickFix(annotationBuilder2, fix, spec, message).create();
        }
    }
}

