/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.errors.AnnotationBuilderExtKt;
import com.goide.i18n.GoBundle;
import com.goide.inspections.GoInspectionUtil;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoCaseClause;
import com.goide.psi.GoExpression;
import com.goide.psi.GoVarSpec;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.quickfix.GoChangeResultParametersInAssignmentQuickFix;
import com.goide.quickfix.GoChangeResultParametersInVarSpecQuickFix;
import com.goide.quickfix.GoDeleteExtraExpressionsQuickFix;
import com.goide.quickfix.GoInsertBlankIdentifiersQuickFix;
import com.goide.quickfix.GoNavigateToQuickFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoSpecCheckerUtil {
    public static void checkAssignmentCountMismatch(@NotNull PsiElement assignmentLikeElement, @NotNull List<? extends PsiElement> left, @NotNull List<GoExpression> right, @NotNull GoAnnotationHolder holder, @Nullable ResolveState state) {
        int exprsCount;
        if (assignmentLikeElement == null) {
            GoSpecCheckerUtil.$$$reportNull$$$0(0);
        }
        if (left == null) {
            GoSpecCheckerUtil.$$$reportNull$$$0(1);
        }
        if (right == null) {
            GoSpecCheckerUtil.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            GoSpecCheckerUtil.$$$reportNull$$$0(3);
        }
        if ((exprsCount = right.size()) == 0) {
            return;
        }
        int targetsCount = left.size();
        if (exprsCount == 1) {
            GoExpression singleExpr = right.get(0);
            if (targetsCount == 2 && GoExpressionUtil.hasSecondBoolValueWhichCanBeOmitted(singleExpr, state)) {
                return;
            }
            exprsCount = GoInspectionUtil.getExpressionResultCount(singleExpr);
            if (exprsCount == -1 || exprsCount == 0 || targetsCount == exprsCount) {
                return;
            }
            GoSpecCheckerUtil.createErrorAnnotation(holder, assignmentLikeElement, targetsCount, exprsCount, false);
            return;
        }
        if (targetsCount != exprsCount) {
            GoSpecCheckerUtil.createErrorAnnotation(holder, assignmentLikeElement, targetsCount, exprsCount, true);
        }
    }

    private static void createErrorAnnotation(@NotNull GoAnnotationHolder holder, @NotNull PsiElement assignmentLikeElement, int targetsCount, int expressionsCount, boolean deleteExtraExpressions) {
        if (holder == null) {
            GoSpecCheckerUtil.$$$reportNull$$$0(4);
        }
        if (assignmentLikeElement == null) {
            GoSpecCheckerUtil.$$$reportNull$$$0(5);
        }
        GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.error.annotator.assignment.count.mismatch", targetsCount, expressionsCount);
        AnnotationBuilder annotation = holder.newErrorAnnotation(assignmentLikeElement, (GoInspectionMessage)message);
        List<LocalQuickFix> fixes = GoSpecCheckerUtil.createFixes(assignmentLikeElement, targetsCount < expressionsCount, deleteExtraExpressions, expressionsCount - targetsCount);
        for (LocalQuickFix fix : fixes) {
            annotation = GoSpecCheckerUtil.withQuickFix(annotation, fix, assignmentLikeElement, message);
        }
        annotation.create();
    }

    @NotNull
    private static @NotNull List<@NotNull LocalQuickFix> createFixes(@NotNull PsiElement assignmentLikeElement, boolean needAssignmentCountMismatchFixes, boolean deleteExtraExpressions, int count2) {
        GoVarSpec varSpec;
        if (assignmentLikeElement == null) {
            GoSpecCheckerUtil.$$$reportNull$$$0(6);
        }
        SmartList fixes = new SmartList();
        GoAssignmentStatement assignment = (GoAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)assignmentLikeElement, GoAssignmentStatement.class, (boolean)false);
        if (assignment != null) {
            new GoChangeResultParametersInAssignmentQuickFix(assignment).addIfAvailable((List<? super LocalQuickFix>)fixes);
        }
        if ((varSpec = (GoVarSpec)PsiTreeUtil.getParentOfType((PsiElement)assignmentLikeElement, GoVarSpec.class, (boolean)false)) != null) {
            new GoChangeResultParametersInVarSpecQuickFix(varSpec).addIfAvailable((List<? super LocalQuickFix>)fixes);
        }
        if (needAssignmentCountMismatchFixes) {
            fixes.add(new GoInsertBlankIdentifiersQuickFix(count2));
            if (deleteExtraExpressions) {
                fixes.add(new GoDeleteExtraExpressionsQuickFix(count2));
            }
        }
        SmartList smartList = fixes;
        if (smartList == null) {
            GoSpecCheckerUtil.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    public static boolean checkLeftHandSideOfAssignment(@NotNull List<GoExpression> leftHandSide, @NotNull GoAnnotationHolder holder, @NotNull PsiElement context) {
        if (leftHandSide == null) {
            GoSpecCheckerUtil.$$$reportNull$$$0(8);
        }
        if (holder == null) {
            GoSpecCheckerUtil.$$$reportNull$$$0(9);
        }
        if (context == null) {
            GoSpecCheckerUtil.$$$reportNull$$$0(10);
        }
        boolean noProblems = true;
        for (GoExpression expression : leftHandSide) {
            if (GoSpecCheckerUtil.canBeOnLeftHandSide(expression, context)) continue;
            holder.newErrorAnnotation(expression, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.cannot.assign.to.expression", expression.getText())).create();
            noProblems = false;
        }
        return noProblems;
    }

    private static boolean canBeOnLeftHandSide(@NotNull GoExpression expression, @NotNull PsiElement context) {
        GoExpression unwrapped;
        if (expression == null) {
            GoSpecCheckerUtil.$$$reportNull$$$0(11);
        }
        if (context == null) {
            GoSpecCheckerUtil.$$$reportNull$$$0(12);
        }
        return (unwrapped = expression.unwrapParentheses()) == null || GoExpressionUtil.isBlankGoReferenceExpression(unwrapped) || GoPsiImplUtil.isMapIndexExpr(unwrapped, GoPsiImplUtil.createContextOnElement(context)) || GoExpressionUtil.isAddressable(unwrapped, context);
    }

    public static void reportMultipleDefaults(@NotNull String statementName, @NotNull List<GoCaseClause> defaultCases, @NotNull GoAnnotationHolder holder) {
        if (statementName == null) {
            GoSpecCheckerUtil.$$$reportNull$$$0(13);
        }
        if (defaultCases == null) {
            GoSpecCheckerUtil.$$$reportNull$$$0(14);
        }
        if (holder == null) {
            GoSpecCheckerUtil.$$$reportNull$$$0(15);
        }
        GoCaseClause firstClause = defaultCases.get(0);
        GoNavigateToQuickFix navigateToQuickFix = new GoNavigateToQuickFix(firstClause, GoBundle.message((String)"go.terms.duplicated.default", (Object[])new Object[0]));
        for (int i = 1; i < defaultCases.size(); ++i) {
            ProgressManager.checkCanceled();
            PsiElement aDefault = defaultCases.get(i).getDefault();
            assert (aDefault != null);
            GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.error.annotator.multiple.defaults", statementName);
            GoSpecCheckerUtil.withQuickFix(holder.newErrorAnnotation(aDefault, (GoInspectionMessage)message), navigateToQuickFix, aDefault, message).create();
        }
    }

    @NotNull
    public static AnnotationBuilder withQuickFix(@NotNull AnnotationBuilder annotation, @NotNull LocalQuickFix fix, @NotNull PsiElement element, @NotNull GoInspectionMessage message) {
        if (annotation == null) {
            GoSpecCheckerUtil.$$$reportNull$$$0(16);
        }
        if (fix == null) {
            GoSpecCheckerUtil.$$$reportNull$$$0(17);
        }
        if (element == null) {
            GoSpecCheckerUtil.$$$reportNull$$$0(18);
        }
        if (message == null) {
            GoSpecCheckerUtil.$$$reportNull$$$0(19);
        }
        AnnotationBuilder annotationBuilder = AnnotationBuilderExtKt.withLocalQuickFix(annotation, fix, element, message);
        if (annotationBuilder == null) {
            GoSpecCheckerUtil.$$$reportNull$$$0(20);
        }
        return annotationBuilder;
    }

    @NotNull
    public static AnnotationBuilder withQuickFix(@NotNull AnnotationBuilder annotation, @NotNull LocalQuickFix fix, @NotNull PsiElement element, @NotNull TextRange range, @NotNull GoInspectionMessage message) {
        if (annotation == null) {
            GoSpecCheckerUtil.$$$reportNull$$$0(21);
        }
        if (fix == null) {
            GoSpecCheckerUtil.$$$reportNull$$$0(22);
        }
        if (element == null) {
            GoSpecCheckerUtil.$$$reportNull$$$0(23);
        }
        if (range == null) {
            GoSpecCheckerUtil.$$$reportNull$$$0(24);
        }
        if (message == null) {
            GoSpecCheckerUtil.$$$reportNull$$$0(25);
        }
        AnnotationBuilder annotationBuilder = AnnotationBuilderExtKt.withLocalQuickFix(annotation, fix, element, range, message);
        if (annotationBuilder == null) {
            GoSpecCheckerUtil.$$$reportNull$$$0(26);
        }
        return annotationBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 20, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentLikeElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 7: 
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/highlighting/errors/GoSpecCheckerUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftHandSide";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultCases";
                break;
            }
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/highlighting/errors/GoSpecCheckerUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createFixes";
                break;
            }
            case 20: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "withQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkAssignmentCountMismatch";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createErrorAnnotation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFixes";
                break;
            }
            case 7: 
            case 20: 
            case 26: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkLeftHandSideOfAssignment";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "canBeOnLeftHandSide";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "reportMultipleDefaults";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "withQuickFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 20, 26 -> new IllegalStateException(string);
        };
    }
}

