/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.errors.GoSpecCheckerBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.psi.GoLiteral;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkVersion;
import com.goide.sdk.GoTargetSdkVersionProvider;
import com.goide.util.GoUtil;
import com.goide.vgo.mod.quickfix.VgoAddOrUpdateGoVersionFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.module.Module;
import org.jetbrains.annotations.NotNull;

public class GoNumericLiteralSpecChecker
extends GoSpecCheckerBase {
    public GoNumericLiteralSpecChecker(@NotNull GoAnnotationHolder holder) {
        if (holder == null) {
            GoNumericLiteralSpecChecker.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    @Override
    public void visitLiteral(@NotNull GoLiteral element) {
        Module module;
        if (element == null) {
            GoNumericLiteralSpecChecker.$$$reportNull$$$0(1);
        }
        if ((module = GoUtil.module(element)) == null) {
            return;
        }
        if (element.getChar() != null) {
            return;
        }
        GoSdk sdk = GoSdkService.getInstance(module.getProject()).getSdk(module);
        GoSdkVersion targetGoSdkVersion = GoTargetSdkVersionProvider.getTargetGoSdkVersion(element);
        if (sdk.getMajorVersion().isAtLeast(GoSdkVersion.GO_1_13) && (targetGoSdkVersion == null || targetGoSdkVersion.isAtLeast(GoSdkVersion.GO_1_13))) {
            return;
        }
        if (element.textContains('_')) {
            if (!sdk.supportsDigitSeparator()) {
                this.myHolder.newErrorAnnotation(element, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.digit.separator.is.not.supported")).create();
            } else if (targetGoSdkVersion != null && !targetGoSdkVersion.supportsDigitSeparator()) {
                this.myHolder.newErrorAnnotation(element, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.digit.separator.is.not.supported")).withFix((IntentionAction)new VgoAddOrUpdateGoVersionFix(GoSdk.DIGIT_SEPARATOR_VERSION)).create();
            }
        }
        if (element.getBin() != null) {
            if (!sdk.supportsBinaryDigits()) {
                this.myHolder.newErrorAnnotation(element, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.binary.digits.are.not.supported")).create();
            } else if (targetGoSdkVersion != null && !targetGoSdkVersion.supportsBinaryDigits()) {
                this.myHolder.newErrorAnnotation(element, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.binary.digits.are.not.supported")).withFix((IntentionAction)new VgoAddOrUpdateGoVersionFix(GoSdk.BINARY_DIGITS_VERSION)).create();
            }
        }
        if (element.textContains('o') || element.textContains('O')) {
            if (!sdk.supportsOctalPrefix()) {
                this.myHolder.newErrorAnnotation(element, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.octal.prefix.is.not.supported")).create();
            } else if (targetGoSdkVersion != null && !targetGoSdkVersion.supportsOctalPrefix()) {
                this.myHolder.newErrorAnnotation(element, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.octal.prefix.is.not.supported")).withFix((IntentionAction)new VgoAddOrUpdateGoVersionFix(GoSdk.OCTAL_PREFIX_VERSION)).create();
            }
        }
        if ((element.getFloat() != null || element.getFloati() != null) && (element.textContains('x') || element.textContains('X'))) {
            if (!sdk.supportsHexFloats()) {
                this.myHolder.newErrorAnnotation(element, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.hex.floats.are.not.supported")).create();
            } else if (targetGoSdkVersion != null && !targetGoSdkVersion.supportsHexFloats()) {
                this.myHolder.newErrorAnnotation(element, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.hex.floats.are.not.supported")).withFix((IntentionAction)new VgoAddOrUpdateGoVersionFix(GoSdk.HEX_FLOATS_VERSION)).create();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/errors/GoNumericLiteralSpecChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitLiteral";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

