/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.errors.GoAddSquareBracketsQuickFix;
import com.goide.highlighting.errors.GoSpecCheckerBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoExpression;
import com.goide.psi.GoIndexOrSliceExpr;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoResolvable;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeArguments;
import com.goide.psi.GoTypeParamDefinition;
import com.goide.psi.GoTypeParameterDeclaration;
import com.goide.psi.GoTypeParameters;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.quickfix.GoDeleteQuickFix;
import com.goide.quickfix.GoReplaceExpressionQuickFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\b\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/goide/highlighting/errors/GoInstantiationSpecChecker;", "Lcom/goide/highlighting/errors/GoSpecCheckerBase;", "holder", "Lcom/goide/highlighting/GoAnnotationHolder;", "<init>", "(Lcom/goide/highlighting/GoAnnotationHolder;)V", "visitTypeReferenceExpression", "", "o", "Lcom/goide/psi/GoTypeReferenceExpression;", "visitCallExpr", "callExpr", "Lcom/goide/psi/GoCallExpr;", "visitTypeArguments", "typeArguments", "Lcom/goide/psi/GoTypeArguments;", "checkTypeArgumentsCount", "elementToHighlight", "Lcom/intellij/psi/PsiElement;", "getTypeParameters", "Lcom/goide/psi/GoTypeParameters;", "getTypeArguments", "getGoResolvable", "Lcom/goide/psi/GoResolvable;", "getTypeParametersCount", "", "typeParameters", "intellij.go.impl"})
@SourceDebugExtension(value={"SMAP\nGoInstantiationSpecChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoInstantiationSpecChecker.kt\ncom/goide/highlighting/errors/GoInstantiationSpecChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n1#2:130\n*E\n"})
public final class GoInstantiationSpecChecker
extends GoSpecCheckerBase {
    public GoInstantiationSpecChecker(@NotNull GoAnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super(holder);
    }

    @Override
    public void visitTypeReferenceExpression(@NotNull GoTypeReferenceExpression o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        super.visitTypeReferenceExpression(o);
        if (this.getTypeParameters(o) != null && this.getTypeArguments(o) == null) {
            this.myHolder.newErrorAnnotation(o, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.use.of.generic.type.without.instantiation")).withFix((IntentionAction)new GoAddSquareBracketsQuickFix(o)).create();
            return;
        }
        if (GoPsiImplUtil.isReceiverTypeReferenceExpression(o) && o.resolve() instanceof GoTypeParamDefinition) {
            Object[] objectArray = new Object[]{o.getText()};
            GoInspectionMessageWithI18n goInspectionMessageWithI18n = GoInspectionMessageWithI18n.message("go.error.annotator.shadowed.receiver.is.not.a.generic.type", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)goInspectionMessageWithI18n, (String)"message(...)");
            GoInspectionMessageWithI18n message = goInspectionMessageWithI18n;
            this.myHolder.newErrorAnnotation(o, (GoInspectionMessage)message).create();
            return;
        }
    }

    @Override
    public void visitCallExpr(@NotNull GoCallExpr callExpr) {
        Intrinsics.checkNotNullParameter((Object)callExpr, (String)"callExpr");
        super.visitCallExpr(callExpr);
        GoType goType = callExpr.getGoType(null);
        GoTypeArguments goTypeArguments = goType != null ? goType.getTypeArguments() : null;
        GoExpression goExpression = callExpr.getExpression();
        Intrinsics.checkNotNullExpressionValue((Object)goExpression, (String)"getExpression(...)");
        this.checkTypeArgumentsCount(goTypeArguments, goExpression);
    }

    @Override
    public void visitTypeArguments(@NotNull GoTypeArguments typeArguments) {
        Intrinsics.checkNotNullParameter((Object)typeArguments, (String)"typeArguments");
        super.visitTypeArguments(typeArguments);
        this.checkTypeArgumentsCount(typeArguments, typeArguments);
    }

    private final void checkTypeArgumentsCount(GoTypeArguments typeArguments, PsiElement elementToHighlight) {
        int typeArgumentsCount;
        GoTypeParameters typeParameters;
        GoResolvable goResolvable = this.getGoResolvable(typeArguments, elementToHighlight);
        if (goResolvable == null) {
            return;
        }
        GoResolvable resolvable = goResolvable;
        PsiElement psiElement = resolvable.resolve();
        GoTypeSpec goTypeSpec = psiElement instanceof GoTypeSpec ? (GoTypeSpec)psiElement : null;
        if (goTypeSpec == null) {
            return;
        }
        GoTypeSpec typeSpec = goTypeSpec;
        GoTypeParameters goTypeParameters = typeParameters = typeSpec.getSpecType().getTypeParameters();
        int typeParametersCount = goTypeParameters != null ? this.getTypeParametersCount(goTypeParameters) : 0;
        Object object = typeArguments;
        int n = object != null && (object = object.getTypes()) != null ? object.size() : (typeArgumentsCount = 0);
        if (typeArgumentsCount == 0 && typeParametersCount > 0) {
            this.myHolder.newErrorAnnotation(elementToHighlight, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.list.of.type.arguments.must.not.be.empty")).create();
        } else if (typeArguments != null && typeParametersCount == 0) {
            Object[] objectArray = new Object[]{resolvable.getText()};
            GoInspectionMessageWithI18n goInspectionMessageWithI18n = GoInspectionMessageWithI18n.message("go.error.annotator.is.not.a.generic.type", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)goInspectionMessageWithI18n, (String)"message(...)");
            GoInspectionMessageWithI18n message = goInspectionMessageWithI18n;
            GoSpecCheckerBase.withQuickFix(this.myHolder.newErrorAnnotation(elementToHighlight, (GoInspectionMessage)message), elementToHighlight instanceof GoIndexOrSliceExpr ? (LocalQuickFix)GoReplaceExpressionQuickFix.getDeleteTypeArgumentsInGoIndexOrSliceExpr((GoIndexOrSliceExpr)elementToHighlight) : (LocalQuickFix)GoDeleteQuickFix.Fixes.DELETE_TYPE_ARGUMENTS_FIX, elementToHighlight, message).create();
        } else if (typeArgumentsCount != typeParametersCount) {
            Object[] objectArray = new Object[]{typeArgumentsCount, typeParametersCount};
            this.myHolder.newErrorAnnotation(elementToHighlight, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.got.n.arguments.but.m.type.parameters", objectArray)).create();
        }
    }

    private final GoTypeParameters getTypeParameters(GoTypeReferenceExpression o) {
        PsiElement resolve = o.resolve();
        GoTypeSpec goTypeSpec = resolve instanceof GoTypeSpec ? (GoTypeSpec)resolve : null;
        if (goTypeSpec == null) {
            return null;
        }
        GoTypeSpec typeSpec = goTypeSpec;
        return typeSpec.getSpecType().getTypeParameters();
    }

    private final GoTypeArguments getTypeArguments(GoTypeReferenceExpression o) {
        PsiElement parent = o.getParent();
        return parent instanceof GoType ? ((GoType)parent).getTypeArguments() : (parent instanceof GoCompositeLit ? ((GoCompositeLit)parent).getTypeArguments() : (parent instanceof GoMethodSpec ? ((GoMethodSpec)parent).getTypeArguments() : null));
    }

    private final GoResolvable getGoResolvable(GoTypeArguments o, PsiElement elementToHighlight) {
        PsiElement parent;
        GoTypeArguments goTypeArguments = o;
        Object object = parent = goTypeArguments != null ? goTypeArguments.getParent() : null;
        if (parent instanceof GoType) {
            return ((GoType)parent).getTypeReferenceExpression();
        }
        if (parent instanceof GoCompositeLit) {
            return ((GoCompositeLit)parent).getTypeReferenceExpression();
        }
        if (parent instanceof GoMethodSpec) {
            return ((GoMethodSpec)parent).getTypeReferenceExpression();
        }
        if (elementToHighlight instanceof GoIndexOrSliceExpr) {
            PsiElement psiElement = ((GoIndexOrSliceExpr)elementToHighlight).getFirstChild();
            return psiElement instanceof GoResolvable ? (GoResolvable)psiElement : null;
        }
        return elementToHighlight instanceof GoResolvable ? (GoResolvable)elementToHighlight : null;
    }

    /*
     * WARNING - void declaration
     */
    private final int getTypeParametersCount(GoTypeParameters typeParameters) {
        List<GoTypeParameterDeclaration> list = typeParameters.getTypeParameterDeclarationList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getTypeParameterDeclarationList(...)");
        Iterable iterable = list;
        int n = 0;
        for (Object t : iterable) {
            void it;
            GoTypeParameterDeclaration goTypeParameterDeclaration = (GoTypeParameterDeclaration)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getTypeParamDefinitionList().size();
            n = n2 + n3;
        }
        return n;
    }
}

