/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.errors.GoSpecCheckerBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoFunctionType;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoParameterDeclaration;
import com.goide.psi.GoParameters;
import com.goide.psi.GoResult;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoTypeParameters;
import com.goide.quickfix.GoDeleteQuickFix;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageViewUtil;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public final class GoFunctionTypeSpecChecker
extends GoSpecCheckerBase {
    @PropertyKey(resourceBundle="messages.GoBundle")
    private static final @PropertyKey(resourceBundle="messages.GoBundle") String NAMED_AND_UNNAMED_RETURN_PARAMETERS = "go.error.annotator.named.and.unnamed.return.parameters";
    @PropertyKey(resourceBundle="messages.GoBundle")
    private static final @PropertyKey(resourceBundle="messages.GoBundle") String NAMED_AND_UNNAMED_PARAMETERS = "go.error.annotator.named.and.unnamed.parameters";

    public GoFunctionTypeSpecChecker(@NotNull GoAnnotationHolder holder) {
        if (holder == null) {
            GoFunctionTypeSpecChecker.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    @Override
    public void visitNamedSignatureOwner(@NotNull GoNamedSignatureOwner o) {
        if (o == null) {
            GoFunctionTypeSpecChecker.$$$reportNull$$$0(1);
        }
        this.check(o);
    }

    @Override
    public void visitFunctionLit(@NotNull GoFunctionLit o) {
        if (o == null) {
            GoFunctionTypeSpecChecker.$$$reportNull$$$0(2);
        }
        this.check(o);
    }

    @Override
    public void visitFunctionType(@NotNull GoFunctionType o) {
        if (o == null) {
            GoFunctionTypeSpecChecker.$$$reportNull$$$0(3);
        }
        this.check(o);
        GoSignature signature = o.getSignature();
        if (signature == null) {
            return;
        }
        this.checkHasNoTypeParameters(signature);
    }

    private void check(@NotNull GoSignatureOwner signatureOwner) {
        GoSignature signature;
        if (signatureOwner == null) {
            GoFunctionTypeSpecChecker.$$$reportNull$$$0(4);
        }
        if ((signature = signatureOwner.getSignature()) == null) {
            return;
        }
        GoParameters parameters = signature.getParameters();
        GoParameters resultParameters = Optional.ofNullable(signature.getResult()).map(GoResult::getParameters).orElse(null);
        String signatureOwnerType = UsageViewUtil.getType((PsiElement)signatureOwner);
        this.checkNamedAndUnnamedParameters(parameters, signatureOwnerType, false);
        this.checkNamedAndUnnamedParameters(resultParameters, signatureOwnerType, true);
        this.checkVariadicInParameters(parameters);
        this.checkVariadicInResultParameters(resultParameters);
    }

    private void checkNamedAndUnnamedParameters(@Nullable GoParameters parameters, @NotNull String signatureOwnerType, boolean isReturnParameters) {
        if (signatureOwnerType == null) {
            GoFunctionTypeSpecChecker.$$$reportNull$$$0(5);
        }
        if (parameters == null || parameters.getParameterDeclarationList().isEmpty()) {
            return;
        }
        boolean hasNamed = false;
        boolean hasUnnamed = false;
        for (GoParameterDeclaration parameterDeclaration : parameters.getParameterDeclarationList()) {
            ProgressManager.checkCanceled();
            if (parameterDeclaration.getParamDefinitionList().isEmpty()) {
                hasUnnamed = true;
            } else {
                hasNamed = true;
            }
            if (!hasNamed || !hasUnnamed) continue;
            String key = isReturnParameters ? NAMED_AND_UNNAMED_RETURN_PARAMETERS : NAMED_AND_UNNAMED_PARAMETERS;
            this.myHolder.newErrorAnnotation(parameters, (GoInspectionMessage)GoInspectionMessageWithI18n.message(key, StringUtil.capitalize((String)signatureOwnerType), parameters.getText())).create();
            return;
        }
    }

    private void checkVariadicInParameters(@NotNull GoParameters parameters) {
        if (parameters == null) {
            GoFunctionTypeSpecChecker.$$$reportNull$$$0(6);
        }
        List<GoParameterDeclaration> list = parameters.getParameterDeclarationList();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            GoParameterDeclaration declaration = list.get(i);
            PsiElement dot = declaration.getTripleDot();
            if (dot == null || declaration.getParamDefinitionList().size() <= 1 && i == size - 1) continue;
            GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.error.annotator.can.only.use.triple.dot.as.final.argument");
            GoFunctionTypeSpecChecker.withQuickFix(this.myHolder.newErrorAnnotation(dot, (GoInspectionMessage)message), GoDeleteQuickFix.Fixes.DELETE_TRIPLE_DOT_FIX, dot, message).create();
        }
    }

    private void checkVariadicInResultParameters(@Nullable GoParameters parameters) {
        if (parameters == null) {
            return;
        }
        for (GoParameterDeclaration declaration : parameters.getParameterDeclarationList()) {
            PsiElement dot = declaration.getTripleDot();
            if (dot == null) continue;
            GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.error.annotator.cannot.use.triple.dot.for.output.arguments");
            GoFunctionTypeSpecChecker.withQuickFix(this.myHolder.newErrorAnnotation(dot, (GoInspectionMessage)message), GoDeleteQuickFix.Fixes.DELETE_TRIPLE_DOT_FIX, dot, message).create();
        }
    }

    private void checkHasNoTypeParameters(GoSignature signature) {
        GoTypeParameters typeParameters = signature.getTypeParameters();
        if (typeParameters != null) {
            GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.error.annotator.function.type.cannot.have.type.parameters");
            GoFunctionTypeSpecChecker.withQuickFix(this.myHolder.newErrorAnnotation(typeParameters, (GoInspectionMessage)message), GoDeleteQuickFix.Fixes.DELETE_TYPE_PARAMETERS_FIX, typeParameters, message).create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatureOwner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatureOwnerType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/errors/GoFunctionTypeSpecChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNamedSignatureOwner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitFunctionLit";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitFunctionType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "check";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkNamedAndUnnamedParameters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkVariadicInParameters";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

