/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.errors.GoSpecCheckerBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoCompositeType;
import com.goide.psi.GoConstraintElem;
import com.goide.psi.GoConstraintTerm;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeParamDefinition;
import com.goide.psi.GoTypeParameterDeclaration;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.psi.impl.GoTypeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoConstraintTermSpecChecker
extends GoSpecCheckerBase {
    public GoConstraintTermSpecChecker(@NotNull GoAnnotationHolder holder) {
        if (holder == null) {
            GoConstraintTermSpecChecker.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    @Override
    public void visitConstraintTerm(@NotNull GoConstraintTerm o) {
        if (o == null) {
            GoConstraintTermSpecChecker.$$$reportNull$$$0(1);
        }
        super.visitConstraintTerm(o);
        PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(o);
        if (o.hasTilde()) {
            this.checkApproximationConstraint(o, context);
        } else {
            PsiElement resolve;
            GoType type = o.getType();
            GoTypeReferenceExpression typeRef = type.getTypeReferenceExpression();
            PsiElement psiElement = resolve = typeRef != null ? typeRef.resolve() : null;
            if (resolve instanceof GoTypeParamDefinition) {
                if (GoConstraintTermSpecChecker.isConstraintInTypeParametersDeclaration(o)) {
                    this.myHolder.newErrorAnnotation(typeRef, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.cannot.use.type.parameter.as.constraint")).create();
                } else {
                    this.myHolder.newErrorAnnotation(typeRef, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.cannot.embed.type.parameter")).create();
                }
                return;
            }
            if (GoConstraintTermSpecChecker.isTermInUnion(o)) {
                GoCompositeElement errorElement;
                GoType typeToCheck = GoPsiImplUtil.getUnderlyingType(type, context);
                GoCompositeElement goCompositeElement = errorElement = typeRef != null ? typeRef : type;
                if (GoConstraintTermSpecChecker.isInterfaceWithMethods(typeToCheck)) {
                    this.myHolder.newErrorAnnotation(errorElement, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.cannot.use.interface.with.methods.in.union")).create();
                } else if (GoConstraintTermSpecChecker.isInterfaceWithEmbeddedComparable(typeToCheck, context)) {
                    if (GoPsiImplUtil.builtin(typeToCheck)) {
                        this.myHolder.newErrorAnnotation(type, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.cannot.use.comparable.in.union")).create();
                    } else {
                        this.myHolder.newErrorAnnotation(type, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.cannot.use.type.embedding.comparable.in.union", errorElement.getText())).create();
                    }
                }
            }
        }
    }

    private static boolean isConstraintInTypeParametersDeclaration(@NotNull GoConstraintTerm o) {
        if (o == null) {
            GoConstraintTermSpecChecker.$$$reportNull$$$0(2);
        }
        return o.getParent() != null && o.getParent().getParent() instanceof GoTypeParameterDeclaration;
    }

    private void checkApproximationConstraint(@NotNull GoConstraintTerm o, @NotNull PsiElement context) {
        GoType type;
        if (o == null) {
            GoConstraintTermSpecChecker.$$$reportNull$$$0(3);
        }
        if (context == null) {
            GoConstraintTermSpecChecker.$$$reportNull$$$0(4);
        }
        if ((type = GoPsiImplUtil.unwrapGoParType(o.getType())) instanceof GoInterfaceType) {
            this.myHolder.newErrorAnnotation(type, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.constraint.term.on.interface", type.getText())).create();
            return;
        }
        if (type instanceof GoCompositeType) {
            return;
        }
        PsiElement resolve = type.resolve(context);
        if (resolve instanceof GoTypeParamDefinition) {
            this.myHolder.newErrorAnnotation(type, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.cannot.embed.type.parameter")).create();
            return;
        }
        GoTypeSpec resolveTypeSpec = (GoTypeSpec)ObjectUtils.tryCast((Object)resolve, GoTypeSpec.class);
        if (resolveTypeSpec != null) {
            ResolveState state = GoPsiImplUtil.createContextOnElement(context);
            GoType underlyingType = resolveTypeSpec.getGoUnderlyingType(state);
            if (!(underlyingType instanceof GoInterfaceType) && GoTypeUtil.identical(type, underlyingType, true, context)) {
                return;
            }
            if (underlyingType instanceof GoInterfaceType) {
                this.myHolder.newErrorAnnotation(type, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.constraint.term.on.interface", type.getText())).create();
            } else {
                this.myHolder.newErrorAnnotation(type, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.constraint.term.underlying.type.is.not.self", type.getText())).create();
            }
        }
    }

    private static boolean isInterfaceWithMethods(@Nullable GoType type) {
        return type instanceof GoInterfaceType && !((GoInterfaceType)type).getMethods().isEmpty();
    }

    private static boolean isTermInUnion(@NotNull GoConstraintTerm o) {
        GoConstraintElem constraintElem;
        if (o == null) {
            GoConstraintTermSpecChecker.$$$reportNull$$$0(5);
        }
        return (constraintElem = (GoConstraintElem)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)o, GoConstraintElem.class)) != null && constraintElem.getConstraintTermList().size() > 1;
    }

    @Contract(value="null, _ -> false")
    private static boolean isInterfaceWithEmbeddedComparable(@Nullable GoType type, @NotNull PsiElement context) {
        if (context == null) {
            GoConstraintTermSpecChecker.$$$reportNull$$$0(6);
        }
        return GoTypeUtil.findFirstMatchedInterfaceDfs(type, iface -> GoTypeUtil.isBuiltinComparable(iface, context)) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/errors/GoConstraintTermSpecChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitConstraintTerm";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isConstraintInTypeParametersDeclaration";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkApproximationConstraint";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isTermInUnion";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isInterfaceWithEmbeddedComparable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

