/*
 * Decompiled with CFR 0.152.
 */
package com.goide.hierarchy;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import java.util.Comparator;

public final class GoHierarchyUtil {
    private static final Comparator<NodeDescriptor<?>> NODE_DESCRIPTOR_COMPARATOR = Comparator.comparingInt(NodeDescriptor::getIndex);

    public static Comparator<NodeDescriptor<?>> getComparator(Project project) {
        HierarchyBrowserManager.State state = HierarchyBrowserManager.getInstance((Project)project).getState();
        return state != null && state.SORT_ALPHABETICALLY ? AlphaComparator.getInstance() : NODE_DESCRIPTOR_COMPARATOR;
    }

    public static void setInvalidHighlightingText(CompositeAppearance highlightedText, TextAttributes invalidPrefixAttributes) {
        String invalidPrefix = IdeBundle.message((String)"node.hierarchy.invalid", (Object[])new Object[0]);
        if (!highlightedText.getText().startsWith(invalidPrefix)) {
            highlightedText.getBeginning().addText(invalidPrefix, invalidPrefixAttributes);
        }
    }
}

