/*
 * Decompiled with CFR 0.152.
 */
package com.goide.hierarchy;

import com.goide.hierarchy.GoCallHierarchyNodeDescriptor;
import com.goide.hierarchy.GoCalleeHierarchyTreeStructure;
import com.goide.hierarchy.GoCallerHierarchyTreeStructure;
import com.goide.hierarchy.GoChangeScopeAction;
import com.goide.hierarchy.GoHierarchyUtil;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoNamedSignatureOwner;
import com.intellij.icons.AllIcons;
import com.intellij.ide.hierarchy.CallHierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyBrowserBaseEx;
import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.LanguageCallHierarchy;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.PopupHandler;
import java.util.Comparator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoCallHierarchyBrowser
extends CallHierarchyBrowserBase {
    private static final String RECURSIVE_KEY = "go.call.hierarchy.browser.recursive";
    private static final Logger LOG = Logger.getInstance(GoCallHierarchyBrowser.class);
    private String myScope;

    public GoCallHierarchyBrowser(Project project, GoNamedSignatureOwner target) {
        super(project, (PsiElement)target);
        HierarchyBrowserManager.State state = HierarchyBrowserManager.getSettings((Project)project);
        this.myScope = state.SCOPE != null ? state.SCOPE : "All";
    }

    protected String getCurrentScopeType() {
        String currentViewType = this.getCurrentViewType();
        return currentViewType == null ? null : this.myScope;
    }

    @Nullable
    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            GoCallHierarchyBrowser.$$$reportNull$$$0(0);
        }
        return descriptor instanceof GoCallHierarchyNodeDescriptor ? descriptor.getPsiElement() : null;
    }

    protected void createTrees(@NotNull Map<? super @Nls String, ? super JTree> trees) {
        if (trees == null) {
            GoCallHierarchyBrowser.$$$reportNull$$$0(1);
        }
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("GoCallHierarchyPopupMenu");
        trees.put(CallHierarchyBrowserBase.getCalleeType(), this.createTree(group));
        trees.put(CallHierarchyBrowserBase.getCallerType(), this.createTree(group));
    }

    private JTree createTree(ActionGroup group) {
        JTree tree = this.createTree(false);
        PopupHandler.installPopupMenu((JComponent)tree, (ActionGroup)group, (String)"CallHierarchyViewPopup");
        BaseOnThisDeclarationAction action = new BaseOnThisDeclarationAction();
        action.registerCustomShortcutSet(ActionManager.getInstance().getAction("CallHierarchy").getShortcutSet(), tree);
        return tree;
    }

    protected void prependActions(@NotNull DefaultActionGroup actionGroup) {
        if (actionGroup == null) {
            GoCallHierarchyBrowser.$$$reportNull$$$0(2);
        }
        actionGroup.add((AnAction)new WithInterfaceCallsAction());
        super.prependActions(actionGroup);
        for (AnAction stub : actionGroup.getChildActionsOrStubs()) {
            if (!(stub instanceof HierarchyBrowserBaseEx.ChangeScopeAction)) continue;
            actionGroup.replaceAction(stub, (AnAction)new GoChangeScopeAction(this.myProject, this::getCurrentScopeType, it -> {
                this.myScope = it;
            }, () -> this.doRefresh(true)));
            break;
        }
    }

    protected boolean isApplicableElement(@NotNull PsiElement e) {
        if (e == null) {
            GoCallHierarchyBrowser.$$$reportNull$$$0(3);
        }
        return e instanceof GoNamedSignatureOwner;
    }

    @Nullable
    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String type, @NotNull PsiElement e) {
        if (type == null) {
            GoCallHierarchyBrowser.$$$reportNull$$$0(4);
        }
        if (e == null) {
            GoCallHierarchyBrowser.$$$reportNull$$$0(5);
        }
        if (GoCallHierarchyBrowser.getCallerType().equals(type)) {
            return new GoCallerHierarchyTreeStructure((GoNamedSignatureOwner)e, this.getCurrentScopeType(), PropertiesComponent.getInstance().getBoolean(RECURSIVE_KEY, false));
        }
        if (GoCallHierarchyBrowser.getCalleeType().equals(type)) {
            return new GoCalleeHierarchyTreeStructure((GoNamedSignatureOwner)e, this.getCurrentScopeType(), PropertiesComponent.getInstance().getBoolean(RECURSIVE_KEY, false));
        }
        LOG.error("unexpected type: " + type);
        return null;
    }

    @Nullable
    protected Comparator<NodeDescriptor<?>> getComparator() {
        return GoHierarchyUtil.getComparator(this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trees";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/goide/hierarchy/GoCallHierarchyBrowser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementFromDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createTrees";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "prependActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createHierarchyTreeStructure";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class BaseOnThisDeclarationAction
    extends HierarchyBrowserBaseEx.BaseOnThisElementAction {
        public BaseOnThisDeclarationAction() {
            super((LanguageExtension)LanguageCallHierarchy.INSTANCE);
        }
    }

    private final class WithInterfaceCallsAction
    extends ToggleAction {
        private WithInterfaceCallsAction() {
            super(() -> GoBundle.message((String)"go.call.hierarchy.respect.interface.calls.action.name", (Object[])new Object[0]), () -> GoBundle.message((String)"go.call.hierarchy.respect.interface.calls.description", (Object[])new Object[0]), AllIcons.Gutter.ImplementingMethod);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                WithInterfaceCallsAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                WithInterfaceCallsAction.$$$reportNull$$$0(1);
            }
            return PropertiesComponent.getInstance().getBoolean(GoCallHierarchyBrowser.RECURSIVE_KEY, false);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                WithInterfaceCallsAction.$$$reportNull$$$0(2);
            }
            PropertiesComponent.getInstance().setValue(GoCallHierarchyBrowser.RECURSIVE_KEY, state);
            GoCallHierarchyBrowser.this.doRefresh(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/hierarchy/GoCallHierarchyBrowser$WithInterfaceCallsAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/hierarchy/GoCallHierarchyBrowser$WithInterfaceCallsAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

