/*
 * Decompiled with CFR 0.152.
 */
package com.goide.formatter;

import com.goide.formatter.GoChildrenAlignment;
import com.goide.formatter.GoFormattingBlock;
import com.goide.psi.GoImportList;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GoMultilineCommentBlock
extends GoFormattingBlock {
    private static final String CLOSING = "*/";
    private List<Block> mySubBlocks;

    public GoMultilineCommentBlock(@NotNull GoFormattingBlock parent, @NotNull ASTNode node2, @Nullable Alignment alignment, @Nullable Indent indent, @Nullable GoChildrenAlignment childrenAlignment) {
        if (parent == null) {
            GoMultilineCommentBlock.$$$reportNull$$$0(0);
        }
        if (node2 == null) {
            GoMultilineCommentBlock.$$$reportNull$$$0(1);
        }
        super(parent, node2, alignment, indent, null, childrenAlignment);
    }

    @Override
    @Nullable
    public Indent getIndent() {
        Indent indent = super.getIndent();
        return indent == Indent.getNormalIndent() ? Indent.getIndent((Indent.Type)Indent.Type.NORMAL, (boolean)false, (boolean)true) : indent;
    }

    @Override
    @NotNull
    public List<Block> getSubBlocks() {
        if (this.mySubBlocks == null) {
            this.mySubBlocks = this.buildSubBlocks();
        }
        List<Block> list = this.mySubBlocks;
        if (list == null) {
            GoMultilineCommentBlock.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    private List<Block> buildSubBlocks() {
        boolean lineOfStars;
        String prefix;
        boolean shouldIndent;
        ASTNode node2 = this.getNode();
        String text = node2.getText();
        String[] originalLines = StringUtil.splitByLinesKeepSeparators((String)text);
        if (originalLines.length <= 1) {
            List<Block> list = Collections.emptyList();
            if (list == null) {
                GoMultilineCommentBlock.$$$reportNull$$$0(3);
            }
            return list;
        }
        Object[] lines = (String[])originalLines.clone();
        PsiElement parent = node2.getPsi().getParent();
        boolean bl = shouldIndent = !(parent instanceof PsiFile) && !(parent instanceof GoImportList);
        if (GoMultilineCommentBlock.getColumn(node2) == 1 && shouldIndent) {
            for (int i = 1; i < lines.length; ++i) {
                lines[i] = "   " + (String)lines[i];
            }
        }
        if ((prefix = GoMultilineCommentBlock.getCommonPrefix(ContainerUtil.subArrayAsList((Object[])lines, (int)1, (int)(lines.length - 1)))) == null) {
            prefix = GoMultilineCommentBlock.getPrefix((String)lines[lines.length - 1]);
        }
        if (lineOfStars = prefix.contains("*")) {
            int starIndex = prefix.indexOf(42);
            if (starIndex > 0 && prefix.charAt(starIndex - 1) == ' ') {
                --starIndex;
            }
            prefix = prefix.substring(0, starIndex);
        } else {
            Object firstLine = lines[0];
            String firstLineText = ((String)firstLine).substring(2);
            if (firstLineText.trim().isEmpty()) {
                int i = prefix.length();
                for (int n = 0; n < 3 && i > 0 && prefix.charAt(i - 1) == ' '; --i, ++n) {
                }
                if (i == prefix.length() && i > 0 && prefix.charAt(i - 1) == '\t') {
                    --i;
                }
                prefix = prefix.substring(0, i);
            } else {
                StringBuilder suffix = new StringBuilder("  ");
                int whiteSpaceEnd = StringUtil.findFirst((CharSequence)firstLineText, it -> !Character.isWhitespace(it));
                if (whiteSpaceEnd > 0) {
                    suffix.append(firstLineText, 0, whiteSpaceEnd);
                }
                int suffixStart = suffix.length() > 2 && suffix.charAt(2) == '\t' ? 2 : 0;
                prefix = StringUtil.trimEnd((String)prefix, (String)suffix.substring(suffixStart));
            }
        }
        Object lastLine = lines[lines.length - 1];
        Indent lastLineIndent = Indent.getNoneIndent();
        if (CLOSING.equals(((String)lastLine).trim())) {
            if (lineOfStars) {
                lastLineIndent = Indent.getSpaceIndent((int)1);
            }
            lines[lines.length - 1] = prefix + CLOSING;
        } else {
            prefix = StringUtil.commonPrefix((String)prefix, (String)lastLine);
        }
        SmartList subBlocks = new SmartList();
        int lineStartOffset = node2.getStartOffset();
        for (int i = 0; i < lines.length; ++i) {
            Object line = lines[i];
            String originalLine = originalLines[i];
            if (!((String)line).trim().isEmpty()) {
                int blockStart = lineStartOffset;
                int blockLength = StringUtil.trimTrailing((String)originalLine).length();
                Indent indent = Indent.getNoneIndent();
                if (i > 0) {
                    String lineNoPrefix = StringUtil.trimStart((String)line, (String)prefix);
                    if (lineNoPrefix.length() > originalLine.length()) {
                        indent = Indent.getSpaceIndent((int)(lineNoPrefix.length() - originalLine.length()));
                    } else {
                        if (i == lines.length - 1) {
                            indent = lastLineIndent;
                        }
                        int blockStartInLine = originalLine.indexOf(lineNoPrefix);
                        blockStart = lineStartOffset + blockStartInLine;
                        blockLength -= blockStartInLine;
                    }
                }
                subBlocks.add(new GoMultilineCommentLineBlock(this.getNode(), TextRange.from((int)blockStart, (int)blockLength), indent));
            }
            lineStartOffset += originalLine.length();
        }
        SmartList smartList = subBlocks;
        if (smartList == null) {
            GoMultilineCommentBlock.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    private static int getColumn(@NotNull ASTNode node2) {
        if (node2 == null) {
            GoMultilineCommentBlock.$$$reportNull$$$0(5);
        }
        String fileText = node2.getPsi().getContainingFile().getText();
        int column = 1;
        for (int i = node2.getStartOffset(); i > 0 && fileText.charAt(i - 1) != '\n'; --i) {
            ++column;
        }
        return column;
    }

    @Nullable
    private static String getCommonPrefix(@NotNull List<String> lines) {
        if (lines == null) {
            GoMultilineCommentBlock.$$$reportNull$$$0(6);
        }
        String commonPrefix = null;
        for (String line : lines) {
            if (!StringUtil.isNotEmpty((String)line.trim())) continue;
            commonPrefix = commonPrefix == null ? GoMultilineCommentBlock.getPrefix(line) : StringUtil.commonPrefix(commonPrefix, (String)line);
        }
        return commonPrefix;
    }

    @NotNull
    private static String getPrefix(@NotNull String commentLine) {
        int prefixEnd;
        if (commentLine == null) {
            GoMultilineCommentBlock.$$$reportNull$$$0(7);
        }
        String string = (prefixEnd = StringUtil.findFirst((CharSequence)commentLine, c -> !Character.isWhitespace(c) && c != '*')) != -1 ? commentLine.substring(0, prefixEnd) : commentLine;
        if (string == null) {
            GoMultilineCommentBlock.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            GoMultilineCommentBlock.$$$reportNull$$$0(9);
        }
        if (child1 instanceof GoMultilineCommentLineBlock && child2 instanceof GoMultilineCommentLineBlock) {
            return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)1, (boolean)true, (int)0x7FFFFFFE);
        }
        return super.getSpacing(child1, child2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/formatter/GoMultilineCommentBlock";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentLine";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/formatter/GoMultilineCommentBlock";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlocks";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSubBlocks";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getColumn";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCommonPrefix";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPrefix";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 8 -> new IllegalStateException(string);
        };
    }

    private static final class GoMultilineCommentLineBlock
    extends AbstractBlock {
        private final TextRange myRange;
        private final Indent myIndent;

        private GoMultilineCommentLineBlock(@NotNull ASTNode node2, @NotNull TextRange range, @NotNull Indent indent) {
            if (node2 == null) {
                GoMultilineCommentLineBlock.$$$reportNull$$$0(0);
            }
            if (range == null) {
                GoMultilineCommentLineBlock.$$$reportNull$$$0(1);
            }
            if (indent == null) {
                GoMultilineCommentLineBlock.$$$reportNull$$$0(2);
            }
            super(node2, null, null);
            this.myRange = range;
            this.myIndent = indent;
        }

        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = this.myRange;
            if (textRange == null) {
                GoMultilineCommentLineBlock.$$$reportNull$$$0(3);
            }
            return textRange;
        }

        protected List<Block> buildChildren() {
            return Collections.emptyList();
        }

        public Indent getIndent() {
            return this.myIndent;
        }

        @Nullable
        public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
            if (child2 == null) {
                GoMultilineCommentLineBlock.$$$reportNull$$$0(4);
            }
            return null;
        }

        public boolean isLeaf() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/formatter/GoMultilineCommentBlock$GoMultilineCommentLineBlock";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/formatter/GoMultilineCommentBlock$GoMultilineCommentLineBlock";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getSpacing";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

