/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing.ui;

import com.goide.execution.GoBuildingRunConfiguration;
import com.goide.execution.GoRunUtil;
import com.goide.execution.testing.GoTestFramework;
import com.goide.execution.testing.GoTestRunConfiguration;
import com.goide.execution.testing.frameworks.gotest.GotestFramework;
import com.goide.execution.testing.ui.GoPackageFieldCompletionProvider;
import com.goide.execution.ui.GoCommonSettingsPanel;
import com.intellij.DynamicBundle;
import com.intellij.execution.impl.SingleConfigurationConfigurable;
import com.intellij.execution.process.ElevationService;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.intellij.lang.regexp.RegExpLanguage;
import org.jetbrains.annotations.NotNull;

public class GoTestRunConfigurationEditorForm
extends SettingsEditor<GoTestRunConfiguration> {
    @NotNull
    private final Project myProject;
    private JPanel myComponent;
    private EditorTextField myPatternEditor;
    private ComboBox<GoBuildingRunConfiguration.Kind> myTestKindComboBox;
    private ComboBox<GoTestFramework> myTestFrameworkComboBox;
    private JLabel myFileLabel;
    private TextFieldWithBrowseButton myFileField;
    private JLabel myPackageLabel;
    private EditorTextField myPackageField;
    private JLabel myDirectoryLabel;
    private TextFieldWithBrowseButton myDirectoryField;
    private JLabel myPatternLabel;
    private GoCommonSettingsPanel myCommonSettingsPanel;
    private JLabel myOutputFilePathLabel;
    private TextFieldWithBrowseButton myOutputFilePathField;
    private JBCheckBox myBuildOnRemoteTargetCheckBox;

    public GoTestRunConfigurationEditorForm(@NotNull Project project) {
        if (project == null) {
            GoTestRunConfigurationEditorForm.$$$reportNull$$$0(0);
        }
        super(null);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myCommonSettingsPanel.init(project);
        this.installTestKindComboBox();
        this.installFileChoosers(project);
        this.installTestFrameworksComboBox();
    }

    private void onTestKindChanged() {
        GoBuildingRunConfiguration.Kind selectedKind = (GoBuildingRunConfiguration.Kind)((Object)this.myTestKindComboBox.getSelectedItem());
        if (selectedKind == null) {
            selectedKind = GoBuildingRunConfiguration.Kind.DIRECTORY;
        }
        boolean allInPackage = selectedKind == GoBuildingRunConfiguration.Kind.PACKAGE;
        boolean allInDirectory = selectedKind == GoBuildingRunConfiguration.Kind.DIRECTORY;
        boolean file = selectedKind == GoBuildingRunConfiguration.Kind.FILE;
        this.myPackageField.setVisible(allInPackage);
        this.myPackageLabel.setVisible(allInPackage);
        this.myDirectoryField.setVisible(allInDirectory);
        this.myDirectoryLabel.setVisible(allInDirectory);
        this.myFileField.setVisible(file);
        this.myFileLabel.setVisible(file);
        this.myPatternEditor.setVisible(!file);
        this.myPatternLabel.setVisible(!file);
        this.myOutputFilePathLabel.setVisible(!allInDirectory);
        this.myOutputFilePathField.setVisible(!allInDirectory);
    }

    protected void resetEditorFrom(@NotNull GoTestRunConfiguration configuration) {
        if (configuration == null) {
            GoTestRunConfigurationEditorForm.$$$reportNull$$$0(1);
        }
        this.myTestFrameworkComboBox.setSelectedItem((Object)configuration.getTestFramework());
        this.myTestKindComboBox.setSelectedItem((Object)configuration.getKind());
        this.myOutputFilePathField.setText(StringUtil.notNullize((String)configuration.getOutputDirectory()));
        this.myBuildOnRemoteTargetCheckBox.setSelected(configuration.isBuildOnRemoteTarget());
        this.myPackageField.setText(configuration.getPackage());
        this.myDirectoryField.setText(configuration.getDirectoryPath());
        this.myFileField.setText(configuration.getFilePathsString());
        this.myPatternEditor.setText(configuration.getPattern());
        this.myCommonSettingsPanel.resetEditorFrom(configuration);
    }

    @NotNull
    private GoTestFramework getSelectedTestFramework() {
        GoTestFramework framework = (GoTestFramework)ObjectUtils.tryCast((Object)this.myTestFrameworkComboBox.getSelectedItem(), GoTestFramework.class);
        GoTestFramework goTestFramework = (GoTestFramework)ObjectUtils.notNull((Object)framework, (Object)GotestFramework.INSTANCE);
        if (goTestFramework == null) {
            GoTestRunConfigurationEditorForm.$$$reportNull$$$0(2);
        }
        return goTestFramework;
    }

    protected void applyEditorTo(@NotNull GoTestRunConfiguration configuration) {
        if (configuration == null) {
            GoTestRunConfigurationEditorForm.$$$reportNull$$$0(3);
        }
        configuration.setTestFramework(this.getSelectedTestFramework());
        configuration.setKind((GoBuildingRunConfiguration.Kind)((Object)this.myTestKindComboBox.getSelectedItem()));
        configuration.setOutputDirectory(this.myOutputFilePathField.getText());
        configuration.setBuildOnRemoteTarget(this.myBuildOnRemoteTargetCheckBox.isSelected());
        configuration.setPackage(this.myPackageField.getText());
        configuration.setDirectoryPath(this.myDirectoryField.getText());
        configuration.setFilePathsString(this.myFileField.getText());
        configuration.setPattern(this.myPatternEditor.getText());
        this.myCommonSettingsPanel.applyEditorTo(configuration);
        this.hideUnsupportedFieldsIfNeeded();
    }

    private void hideUnsupportedFieldsIfNeeded() {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return;
        }
        boolean localTarget = DataManager.getInstance().getDataContext((Component)this.myComponent).getData(SingleConfigurationConfigurable.RUN_ON_TARGET_NAME_KEY) == null;
        boolean isElevationServiceAvailable = ElevationService.getInstance().isAvailable();
        this.myBuildOnRemoteTargetCheckBox.setVisible(!localTarget);
        boolean showOutputField = localTarget || !this.myBuildOnRemoteTargetCheckBox.isSelected();
        this.myOutputFilePathField.setVisible(showOutputField);
        this.myOutputFilePathLabel.setVisible(showOutputField);
        this.myCommonSettingsPanel.hideUnsupportedFieldsIfNeeded(localTarget, isElevationServiceAvailable);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            GoTestRunConfigurationEditorForm.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    protected void disposeEditor() {
        this.myComponent.setVisible(false);
        Disposer.dispose((Disposable)this.myCommonSettingsPanel);
        Disposer.dispose((Disposable)this.myFileField);
    }

    private void createUIComponents() {
        this.myPatternEditor = new EditorTextField("", null, (FileType)RegExpLanguage.INSTANCE.getAssociatedFileType());
        this.myPackageField = new GoPackageFieldCompletionProvider((NotNullProducer<? extends Collection<Module>>)((NotNullProducer)() -> ContainerUtil.createMaybeSingletonList(this.myCommonSettingsPanel != null ? this.myCommonSettingsPanel.getSelectedModule() : null)), true, false).createEditor(this.myProject);
        this.myFileField = GoRunUtil.createMultipleFileField(this.myProject);
    }

    private void installFileChoosers(@NotNull Project project) {
        if (project == null) {
            GoTestRunConfigurationEditorForm.$$$reportNull$$$0(5);
        }
        GoRunUtil.installDirectoryChooser(project, this.myDirectoryField);
        GoRunUtil.installDirectoryChooser(this.myProject, this.myOutputFilePathField);
    }

    private void installTestKindComboBox() {
        this.myTestKindComboBox.removeAllItems();
        this.myTestKindComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", value2 -> value2.getUiName()));
        for (GoBuildingRunConfiguration.Kind kind : GoBuildingRunConfiguration.Kind.values()) {
            this.myTestKindComboBox.addItem((Object)kind);
        }
        this.myTestKindComboBox.addActionListener(e -> this.onTestKindChanged());
    }

    private void installTestFrameworksComboBox() {
        this.myTestFrameworkComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", GoTestFramework::getName));
        for (GoTestFramework framework : GoTestFramework.all()) {
            this.myTestFrameworkComboBox.addItem((Object)framework);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel;
        GoCommonSettingsPanel goCommonSettingsPanel;
        ComboBox comboBox;
        ComboBox comboBox2;
        JLabel jLabel2;
        JLabel jLabel3;
        JLabel jLabel4;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JLabel jLabel5;
        JPanel jPanel;
        this.createUIComponents();
        this.myComponent = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(10, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, DynamicBundle.getBundle((String)"messages/GoBundle", GoTestRunConfigurationEditorForm.class).getString("go.run.configuration.test.kind.label"));
        jPanel.add((Component)jLabel6, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(163, 16), null));
        this.myDirectoryLabel = jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/GoBundle", GoTestRunConfigurationEditorForm.class).getString("go.run.configuration.target.directory.label"));
        ((Component)jLabel5).setVisible(true);
        jPanel.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(163, 16), null));
        this.myDirectoryField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton2.setVisible(true);
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myPackageLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/GoBundle", GoTestRunConfigurationEditorForm.class).getString("go.run.configuration.target.package.label"));
        ((Component)jLabel4).setVisible(true);
        jPanel.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(163, 16), null));
        EditorTextField editorTextField = this.myPackageField;
        editorTextField.setVisible(true);
        jPanel.add((Component)editorTextField, new GridConstraints(3, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myFileLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/GoBundle", GoTestRunConfigurationEditorForm.class).getString("go.run.configuration.target.files.label"));
        ((Component)jLabel3).setVisible(true);
        jPanel.add((Component)jLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(163, 16), null));
        TextFieldWithBrowseButton textFieldWithBrowseButton3 = this.myFileField;
        textFieldWithBrowseButton3.setVisible(true);
        jPanel.add((Component)textFieldWithBrowseButton3, new GridConstraints(4, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        EditorTextField editorTextField2 = this.myPatternEditor;
        jPanel.add((Component)editorTextField2, new GridConstraints(5, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myPatternLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/GoBundle", GoTestRunConfigurationEditorForm.class).getString("go.run.configuration.test.pattern.label"));
        jPanel.add((Component)jLabel2, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(163, 15), null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, DynamicBundle.getBundle((String)"messages/GoBundle", GoTestRunConfigurationEditorForm.class).getString("go.run.configuration.test.framework"));
        jPanel.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myTestFrameworkComboBox = comboBox2 = new ComboBox();
        jPanel2.add((Component)comboBox2, new GridConstraints(0, 0, 1, 1, 0, 0, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myTestKindComboBox = comboBox = new ComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        comboBox.setModel(defaultComboBoxModel);
        jPanel3.add((Component)comboBox, new GridConstraints(0, 0, 1, 1, 0, 0, 2, 0, null, null, null));
        this.myCommonSettingsPanel = goCommonSettingsPanel = new GoCommonSettingsPanel();
        JComponent jComponent = goCommonSettingsPanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(8, 0, 1, 2, 1, 1, 3, 3, null, null, null, 0, true));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(9, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myOutputFilePathLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/GoBundle", GoTestRunConfigurationEditorForm.class).getString("go.run.configuration.output.directory.label"));
        jPanel.add((Component)jLabel, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOutputFilePathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(6, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myBuildOnRemoteTargetCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/GoBundle", GoTestRunConfigurationEditorForm.class).getString("go.run.configuration.build.on.remote.target.checkbox"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(7, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        jLabel6.setLabelFor((Component)comboBox);
        jLabel5.setLabelFor((Component)textFieldWithBrowseButton2);
        jLabel4.setLabelFor((Component)editorTextField);
        jLabel3.setLabelFor((Component)textFieldWithBrowseButton3);
        jLabel2.setLabelFor((Component)editorTextField2);
        jLabel7.setLabelFor((Component)comboBox2);
        jLabel.setLabelFor((Component)textFieldWithBrowseButton);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myComponent;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/testing/ui/GoTestRunConfigurationEditorForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/testing/ui/GoTestRunConfigurationEditorForm";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedTestFramework";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "installFileChoosers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

