/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing.frameworks.testify;

import com.goide.execution.GoBuildingRunConfiguration;
import com.goide.execution.testing.GoTestFinder;
import com.goide.execution.testing.GoTestFunctionType;
import com.goide.execution.testing.GoTestRunConfiguration;
import com.goide.execution.testing.GoTestRunConfigurationProducerBase;
import com.goide.execution.testing.GoTestRunningState;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoAnonymousFieldDefinition;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoReferencesSearch;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.util.GoCacheUtilKt;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoTestifySupport {
    private static final Key<Map<String, Pair<Long, Set<String>>>> GO_TESTIFY_SUITE_USAGES_KEY = Key.create((String)"GO_TESTIFY_SUITE_USAGES");
    @NonNls
    public static final String TESTIFY_SUITE_PACKAGE = "github.com/stretchr/testify/suite";
    @NotNull
    private final PsiElement myContext;

    public GoTestifySupport(@NotNull PsiElement context) {
        if (context == null) {
            GoTestifySupport.$$$reportNull$$$0(0);
        }
        this.myContext = context;
    }

    public boolean setupConfigurationFromContext(@NotNull GoTestRunConfiguration configuration) {
        if (configuration == null) {
            GoTestifySupport.$$$reportNull$$$0(1);
        }
        PsiFile file = this.myContext.getContainingFile();
        GoTestifyRunConfigInfo info = this.getRunConfigInfoFromContext();
        if (info != null) {
            GoTestifySupport.setupConfiguration(configuration, file, info.myUiName, info.myMethodPattern, info.myRunPattern);
            return true;
        }
        return false;
    }

    public boolean isConfigurationFromContext(@NotNull GoTestRunConfiguration configuration) {
        GoTestifyRunConfigInfo info;
        if (configuration == null) {
            GoTestifySupport.$$$reportNull$$$0(2);
        }
        if ((info = this.getRunConfigInfoFromContext()) == null || !configuration.getPattern().equals(info.myRunPattern)) {
            return false;
        }
        if (info.myMethodPattern.isEmpty()) {
            return GoTestifySupport.findTestifyPattern(configuration.getParams()) == null;
        }
        return configuration.getParams().contains(info.myMethodPattern);
    }

    @Contract(value="null -> false")
    public static boolean isTestifySuite(@Nullable GoSpecType specType) {
        GoType contextType = specType != null ? specType.getContextlessUnderlyingType() : null;
        return GoTestifySupport.isSuiteType(contextType, new HashSet<GoType>(), GoVendoringUtil.isVendoringEnabled(specType));
    }

    @Nullable
    public static String findTestifyPattern(@NotNull String parametersString) {
        if (parametersString == null) {
            GoTestifySupport.$$$reportNull$$$0(3);
        }
        ParametersList parametersList = new ParametersList();
        parametersList.addParametersString(parametersString);
        List parameters = parametersList.getList();
        int indexOf = parameters.indexOf("-" + GoTestifySupport.testifyMatchMethodFlag());
        return indexOf >= 0 && parameters.size() > indexOf + 1 ? (String)parameters.get(indexOf + 1) : null;
    }

    @Nullable
    private GoTypeSpec findTypeSpecInContext() {
        List<GoTypeSpec> list;
        PsiElement e = PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.myContext, (Class[])new Class[]{GoTypeSpec.class, GoTypeDeclaration.class});
        if (e instanceof GoTypeSpec) {
            return (GoTypeSpec)e;
        }
        if (e instanceof GoTypeDeclaration && (list = ((GoTypeDeclaration)e).getTypeSpecList()).size() == 1) {
            return list.get(0);
        }
        return null;
    }

    @NotNull
    public static String testifyMatchMethodFlag() {
        String string = Registry.get((String)"go.testify.method.match.flag").asString();
        if (string == null) {
            GoTestifySupport.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static void setupConfiguration(@NotNull GoTestRunConfiguration configuration, @NotNull PsiFile contextFile, @Nullable String targetName, @NotNull String methodPattern, @NotNull String runPattern) {
        if (configuration == null) {
            GoTestifySupport.$$$reportNull$$$0(5);
        }
        if (contextFile == null) {
            GoTestifySupport.$$$reportNull$$$0(6);
        }
        if (methodPattern == null) {
            GoTestifySupport.$$$reportNull$$$0(7);
        }
        if (runPattern == null) {
            GoTestifySupport.$$$reportNull$$$0(8);
        }
        configuration.setGeneratedName();
        configuration.setPattern(runPattern);
        if (!methodPattern.isEmpty()) {
            configuration.setParams(configuration.getParams() + " " + GoTestifySupport.createTestifyMethodParameter(methodPattern));
        }
        String importPath = contextFile instanceof GoFile ? ((GoFile)contextFile).getImportPath(false) : null;
        String targetUiName = StringUtil.notNullize((String)targetName, (String)GoBundle.message((String)"go.test.testify.unknown.target.name", (Object[])new Object[0]));
        if (StringUtil.isNotEmpty((String)importPath)) {
            configuration.setKind(GoBuildingRunConfiguration.Kind.PACKAGE);
            configuration.setPackage(importPath);
            configuration.setName(GoBundle.message((String)"go.test.testify.run.configuration.name", (Object[])new Object[]{targetUiName, importPath}));
        } else {
            String filePath = contextFile.getVirtualFile().getPath();
            configuration.setKind(GoBuildingRunConfiguration.Kind.FILE);
            configuration.setFilePaths(Collections.singletonList(filePath));
            configuration.setName(GoBundle.message((String)"go.test.testify.run.configuration.name", (Object[])new Object[]{targetUiName, filePath}));
        }
    }

    @NotNull
    private static String createMethodsPattern(@NotNull GoTypeSpec typeSpec) {
        if (typeSpec == null) {
            GoTestifySupport.$$$reportNull$$$0(9);
        }
        String string = ((StreamEx)StreamEx.of(typeSpec.getMethods()).map(NavigationItem::getName).filter(name -> GoTestFunctionType.fromName(name) == GoTestFunctionType.TEST)).map(StringUtil::escapeToRegexp).joining((CharSequence)"|");
        if (string == null) {
            GoTestifySupport.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    private static String createTestifyMethodParameter(@NotNull String pattern) {
        if (pattern == null) {
            GoTestifySupport.$$$reportNull$$$0(11);
        }
        String string = "-" + GoTestifySupport.testifyMatchMethodFlag() + " ^" + pattern + "$";
        if (string == null) {
            GoTestifySupport.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static boolean isSuiteType(@Nullable GoType type, @NotNull Set<GoType> visitedTypes, boolean vendoringEnabled) {
        if (visitedTypes == null) {
            GoTestifySupport.$$$reportNull$$$0(13);
        }
        if (!(type instanceof GoStructType) || !visitedTypes.add(type)) {
            return false;
        }
        for (GoNamedElement definition : ((GoStructType)type).getFieldDefinitions()) {
            GoTypeReferenceExpression reference;
            GoTypeSpec resolve;
            if (!(definition instanceof GoAnonymousFieldDefinition) || (resolve = (GoTypeSpec)ObjectUtils.tryCast((Object)((reference = ((GoAnonymousFieldDefinition)definition).getTypeReferenceExpression()) != null ? reference.resolve() : null), GoTypeSpec.class)) == null) continue;
            if ("Suite".equals(resolve.getName()) && TESTIFY_SUITE_PACKAGE.equals(resolve.getContainingFile().getImportPath(vendoringEnabled))) {
                return true;
            }
            GoType underlyingType = resolve.getSpecType().getUnderlyingType(reference);
            if (!GoTestifySupport.isSuiteType(underlyingType, visitedTypes, vendoringEnabled)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private GoTestifyRunConfigInfo getRunConfigInfoFromContext() {
        GoSpecType specType;
        GoTypeSpec typeSpec = this.findTypeSpecInContext();
        GoSpecType goSpecType = specType = typeSpec != null ? typeSpec.getSpecType() : null;
        if (GoTestifySupport.isTestifySuite(specType)) {
            String suiteRunPattern = GoTestifySupport.getSuiteRunPattern(typeSpec);
            if (suiteRunPattern == null) {
                return null;
            }
            return new GoTestifyRunConfigInfo(typeSpec.getName(), suiteRunPattern, GoTestifySupport.createMethodsPattern(typeSpec));
        }
        GoFunctionOrMethodDeclaration function = GoTestFinder.findTestFunctionInContext(this.myContext);
        String functionName = function != null ? function.getName() : null;
        GoTypeSpec suiteTypeSpec = GoTestifySupport.getTestifySuiteTypeSpec((GoMethodDeclaration)ObjectUtils.tryCast((Object)function, GoMethodDeclaration.class));
        if (functionName != null && suiteTypeSpec != null) {
            String suiteRunPattern = GoTestifySupport.getSuiteRunPattern(suiteTypeSpec);
            if (suiteRunPattern == null) {
                return null;
            }
            String subTestName = GoTestRunConfigurationProducerBase.findSubTestInContext(this.myContext, function);
            String testName = subTestName != null ? subTestName : functionName;
            String runPattern = suiteRunPattern + "/" + GoTestRunConfigurationProducerBase.createPatternFromFullTestName(testName);
            return new GoTestifyRunConfigInfo(functionName, runPattern, StringUtil.escapeToRegexp((String)functionName));
        }
        return null;
    }

    @Contract(value="null->null")
    @Nullable
    public static GoTypeSpec getTestifySuiteTypeSpec(@Nullable GoMethodDeclaration method) {
        if (method == null) {
            return null;
        }
        if (GoTestFunctionType.fromName(method.getName()) != GoTestFunctionType.TEST) {
            return null;
        }
        boolean vendoringEnabled = GoVendoringUtil.isVendoringEnabled(method);
        GoType receiverType = GoPsiImplUtil.unwrapPointerIfNeeded(method.getReceiverType());
        if (receiverType != null && GoTestifySupport.isSuiteType(receiverType.getContextlessUnderlyingType(), new HashSet<GoType>(), vendoringEnabled)) {
            return (GoTypeSpec)ObjectUtils.tryCast((Object)receiverType.resolve(method), GoTypeSpec.class);
        }
        return null;
    }

    @Nullable
    private static String getSuiteRunPattern(@Nullable GoTypeSpec suiteType) {
        ArrayList<String> suiteTestFunctionNames = new ArrayList<String>(GoTestifySupport.getTestFunctionNamesForSuite(suiteType));
        if (suiteTestFunctionNames.isEmpty()) {
            return null;
        }
        Collections.sort(suiteTestFunctionNames);
        List quotedNames = ContainerUtil.map(suiteTestFunctionNames, GoTestRunningState::escapePattern);
        return "^" + StringUtil.join((Collection)quotedNames, (String)"|") + "$";
    }

    public static boolean isUsesTestifySuite(@NotNull GoFunctionDeclaration function, @NotNull GoTypeSpec suiteType) {
        if (function == null) {
            GoTestifySupport.$$$reportNull$$$0(14);
        }
        if (suiteType == null) {
            GoTestifySupport.$$$reportNull$$$0(15);
        }
        GoFile file = function.getContainingFile();
        String suiteTypeFullName = GoTestifySupport.getTestifySuiteFullName(suiteType);
        if (suiteTypeFullName == null) {
            return false;
        }
        Set<String> usages2 = GoTestifySupport.getSuiteTypeUsages(file, suiteTypeFullName, suiteType);
        return usages2.contains(function.getName());
    }

    @NotNull
    private static Set<String> getTestFunctionNamesForSuite(@Nullable GoTypeSpec suiteType) {
        GoPackage pkg;
        GoPackage goPackage = pkg = suiteType != null ? GoPackage.of(suiteType.getContainingFile()) : null;
        if (pkg == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                GoTestifySupport.$$$reportNull$$$0(16);
            }
            return set;
        }
        String suiteTypeFullName = GoTestifySupport.getTestifySuiteFullName(suiteType);
        if (suiteTypeFullName == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                GoTestifySupport.$$$reportNull$$$0(17);
            }
            return set;
        }
        HashSet<String> result = new HashSet<String>();
        pkg.processFiles((Processor<? super PsiFile>)((Processor)it -> {
            if (GoTestFinder.isTestFile(it)) {
                result.addAll(GoTestifySupport.getSuiteTypeUsages((GoFile)((Object)it), suiteTypeFullName, suiteType));
            }
            return true;
        }));
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            GoTestifySupport.$$$reportNull$$$0(18);
        }
        return hashSet;
    }

    public static boolean isRunnableTestifyMethod(@Nullable GoMethodDeclaration method) {
        if (method == null) {
            return false;
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)method, () -> GoCacheUtilKt.createResolveDependentResult(method.getProject(), (Boolean)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> GoTestifySupport.hasTestFunctionUsages(GoTestifySupport.getTestifySuiteTypeSpec(method))), method));
    }

    public static boolean hasTestFunctionUsages(@Nullable GoTypeSpec suiteType) {
        if (suiteType == null) {
            return false;
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)suiteType, () -> GoCacheUtilKt.createResolveDependentResult(suiteType.getProject(), (Boolean)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> GoTestifySupport.hasTestFunctionUsagesInner(suiteType)), suiteType));
    }

    private static boolean hasTestFunctionUsagesInner(@NotNull GoTypeSpec suiteType) {
        GoFile suiteFile;
        GoPackage pkg;
        if (suiteType == null) {
            GoTestifySupport.$$$reportNull$$$0(19);
        }
        if ((pkg = GoPackage.of(suiteFile = suiteType.getContainingFile())) == null) {
            return false;
        }
        String suiteTypeFullName = GoTestifySupport.getTestifySuiteFullName(suiteType);
        if (suiteTypeFullName == null) {
            return false;
        }
        if (!GoTestifySupport.getSuiteTypeUsages(suiteFile, suiteTypeFullName, suiteType).isEmpty()) {
            return true;
        }
        boolean[] result = new boolean[]{false};
        pkg.processFiles((Processor<? super PsiFile>)((Processor)it -> {
            if (it != suiteFile && GoTestFinder.isTestFile(it) && !GoTestifySupport.getSuiteTypeUsages((GoFile)((Object)it), suiteTypeFullName, suiteType).isEmpty()) {
                result[0] = true;
                return false;
            }
            return true;
        }));
        return result[0];
    }

    @NotNull
    private static Set<String> getSuiteTypeUsages(@NotNull GoFile file, @NotNull String suiteTypeFullName, @NotNull GoTypeSpec suiteType) {
        if (file == null) {
            GoTestifySupport.$$$reportNull$$$0(20);
        }
        if (suiteTypeFullName == null) {
            GoTestifySupport.$$$reportNull$$$0(21);
        }
        if (suiteType == null) {
            GoTestifySupport.$$$reportNull$$$0(22);
        }
        long modStamp = file.getModificationStamp();
        Map usages2 = (Map)file.putUserDataIfAbsent(GO_TESTIFY_SUITE_USAGES_KEY, new ConcurrentHashMap());
        Pair suiteUsages = (Pair)usages2.get(suiteTypeFullName);
        if (suiteUsages == null || (Long)suiteUsages.first != modStamp) {
            HashSet<String> testFuncNames = new HashSet<String>();
            for (GoFunctionDeclaration goFunctionDeclaration : file.getFunctions()) {
                LocalSearchScope funcScope;
                String funcName = goFunctionDeclaration != null ? goFunctionDeclaration.getName() : null;
                if (GoTestFunctionType.fromName(funcName) != GoTestFunctionType.TEST || GoReferencesSearch.search(suiteType, (SearchScope)(funcScope = new LocalSearchScope((PsiElement)goFunctionDeclaration))).findFirst() == null) continue;
                testFuncNames.add(funcName);
            }
            suiteUsages = Pair.create((Object)modStamp, testFuncNames);
            usages2.put(suiteTypeFullName, suiteUsages);
        }
        Set set = (Set)suiteUsages.second;
        if (set == null) {
            GoTestifySupport.$$$reportNull$$$0(23);
        }
        return set;
    }

    private static String getTestifySuiteFullName(@NotNull GoTypeSpec suiteType) {
        if (suiteType == null) {
            GoTestifySupport.$$$reportNull$$$0(24);
        }
        String suiteTypePackageName = suiteType.getContainingFile().getPackageName();
        String suiteTypeName = suiteType.getName();
        return suiteTypePackageName != null && suiteTypeName != null ? suiteTypePackageName + "." + suiteTypeName : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 10, 12, 16, 17, 18, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersString";
                break;
            }
            case 4: 
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/testing/frameworks/testify/GoTestifySupport";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodPattern";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runPattern";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSpec";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedTypes";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 15: 
            case 19: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteTypeFullName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/testing/frameworks/testify/GoTestifySupport";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "testifyMatchMethodFlag";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodsPattern";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestifyMethodParameter";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFunctionNamesForSuite";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuiteTypeUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findTestifyPattern";
                break;
            }
            case 4: 
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 23: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setupConfiguration";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createMethodsPattern";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createTestifyMethodParameter";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isSuiteType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isUsesTestifySuite";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "hasTestFunctionUsagesInner";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getSuiteTypeUsages";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTestifySuiteFullName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 10, 12, 16, 17, 18, 23 -> new IllegalStateException(string);
        };
    }

    private static class GoTestifyRunConfigInfo {
        private final String myUiName;
        private final String myRunPattern;
        private final String myMethodPattern;

        private GoTestifyRunConfigInfo(@Nullable String uiName, @NotNull String runPattern, @NotNull String methodPattern) {
            if (runPattern == null) {
                GoTestifyRunConfigInfo.$$$reportNull$$$0(0);
            }
            if (methodPattern == null) {
                GoTestifyRunConfigInfo.$$$reportNull$$$0(1);
            }
            this.myUiName = uiName;
            this.myRunPattern = runPattern;
            this.myMethodPattern = methodPattern;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "runPattern";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "methodPattern";
                    break;
                }
            }
            objectArray[1] = "com/goide/execution/testing/frameworks/testify/GoTestifySupport$GoTestifyRunConfigInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

