/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing.coverage;

import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.Processor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class GoCoverageProjectData
extends ProjectData {
    @NotNull
    private final Map<String, FileData> myFilesData = new HashMap<String, FileData>();

    public void processFiles(@NotNull Processor<? super FileData> processor2) {
        if (processor2 == null) {
            GoCoverageProjectData.$$$reportNull$$$0(0);
        }
        for (FileData fileData2 : this.myFilesData.values()) {
            if (processor2.process((Object)fileData2)) continue;
            return;
        }
    }

    public void processFile(@NotNull String filePath, @NotNull Processor<? super RangeData> processor2) {
        FileData fileData2;
        if (filePath == null) {
            GoCoverageProjectData.$$$reportNull$$$0(1);
        }
        if (processor2 == null) {
            GoCoverageProjectData.$$$reportNull$$$0(2);
        }
        if ((fileData2 = this.myFilesData.get(filePath)) != null) {
            for (RangeData rangeData : fileData2.myRangesData.values()) {
                if (processor2.process((Object)rangeData)) continue;
                return;
            }
        }
    }

    public void addData(String filePath, int startLine, int startColumn, int endLine, int endColumn, int statements, long hits) {
        FileData fileData2 = this.myFilesData.computeIfAbsent(filePath, __ -> new FileData(filePath));
        fileData2.add(startLine, startColumn, endLine, endColumn, statements, hits);
    }

    public void merge(CoverageData data) {
        super.merge(data);
        if (data instanceof GoCoverageProjectData) {
            for (Map.Entry<String, FileData> entry : ((GoCoverageProjectData)data).myFilesData.entrySet()) {
                String filePath = entry.getKey();
                FileData fileData2 = this.myFilesData.get(filePath);
                FileData fileDataToMerge = entry.getValue();
                if (fileData2 != null) {
                    for (Map.Entry<String, RangeData> dataEntry : fileDataToMerge.myRangesData.entrySet()) {
                        fileData2.myRangesData.merge(dataEntry.getKey(), dataEntry.getValue(), (a, b) -> new RangeData(a.startLine, a.startColumn, a.endLine, a.endColumn, a.statements, a.hits + b.hits));
                    }
                    continue;
                }
                this.myFilesData.put(filePath, fileDataToMerge);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GoCoverageProjectData)) {
            return false;
        }
        GoCoverageProjectData data = (GoCoverageProjectData)((Object)o);
        return this.myFilesData.equals(data.myFilesData);
    }

    public int hashCode() {
        return this.myFilesData.hashCode();
    }

    private static String rangeKey(int startLine, int startColumn, int endLine, int endColumn) {
        return startLine + ":" + startColumn + "-" + endLine + ":" + endColumn;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        objectArray2[1] = "com/goide/execution/testing/coverage/GoCoverageProjectData";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processFiles";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class FileData {
        @NotNull
        public final String myFilePath;
        @NotNull
        public final Map<String, RangeData> myRangesData;

        public FileData(@NotNull String filePath) {
            if (filePath == null) {
                FileData.$$$reportNull$$$0(0);
            }
            this.myRangesData = new HashMap<String, RangeData>();
            this.myFilePath = filePath;
        }

        public void add(int startLine, int startColumn, int endLine, int endColumn, int statements, long hits) {
            String key = GoCoverageProjectData.rangeKey(startLine, startColumn, endLine, endColumn);
            RangeData oldData = this.myRangesData.get(key);
            long mergedHits = oldData != null ? oldData.hits + hits : hits;
            this.myRangesData.put(key, new RangeData(startLine, startColumn, endLine, endColumn, statements, mergedHits));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileData)) {
                return false;
            }
            FileData fileData2 = (FileData)o;
            if (!this.myFilePath.equals(fileData2.myFilePath)) {
                return false;
            }
            return this.myRangesData.equals(fileData2.myRangesData);
        }

        public int hashCode() {
            int result = this.myFilePath.hashCode();
            result = 31 * result + this.myRangesData.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/goide/execution/testing/coverage/GoCoverageProjectData$FileData", "<init>"));
        }
    }

    public static class RangeData {
        public final int startLine;
        public final int startColumn;
        public final int endLine;
        public final int endColumn;
        public final long hits;
        public final int statements;

        public RangeData(int startLine, int startColumn, int endLine, int endColumn, int statements, long hits) {
            this.startLine = startLine;
            this.startColumn = startColumn;
            this.endLine = endLine;
            this.endColumn = endColumn;
            this.hits = hits;
            this.statements = statements;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RangeData data = (RangeData)o;
            return this.startLine == data.startLine && this.startColumn == data.startColumn && this.endLine == data.endLine && this.endColumn == data.endColumn && this.hits == data.hits && this.statements == data.statements;
        }

        public int hashCode() {
            return Objects.hash(this.startLine, this.startColumn, this.endLine, this.endColumn, this.hits, this.statements);
        }

        public String toString() {
            return GoCoverageProjectData.rangeKey(this.startLine, this.startColumn, this.endLine, this.endColumn) + "; hits: " + this.hits + "; statements: " + this.statements;
        }
    }
}

