/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing.coverage;

import com.goide.execution.testing.coverage.GoCoverageEngine;
import com.goide.execution.testing.coverage.GoCoverageProjectData;
import com.goide.i18n.GoBundle;
import com.intellij.DynamicBundle;
import com.intellij.coverage.BaseCoverageAnnotator;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.Processor;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GoCoverageAnnotator
extends BaseCoverageAnnotator {
    private final Map<String, BaseCoverageAnnotator.FileCoverageInfo> myFileCoverageInfos;
    private final Map<String, BaseCoverageAnnotator.DirCoverageInfo> myDirCoverageInfos;

    public GoCoverageAnnotator(@NotNull Project project) {
        if (project == null) {
            GoCoverageAnnotator.$$$reportNull$$$0(0);
        }
        super(project);
        this.myFileCoverageInfos = new HashMap<String, BaseCoverageAnnotator.FileCoverageInfo>();
        this.myDirCoverageInfos = new HashMap<String, BaseCoverageAnnotator.DirCoverageInfo>();
    }

    public static GoCoverageAnnotator getInstance(Project project) {
        return (GoCoverageAnnotator)((Object)project.getService(GoCoverageAnnotator.class));
    }

    @Nullable
    public String getDirCoverageInformationString(@NotNull Project project, @NotNull VirtualFile directory, @NotNull CoverageSuitesBundle bundle, @NotNull CoverageDataManager manager) {
        BaseCoverageAnnotator.DirCoverageInfo dirCoverageInfo;
        if (project == null) {
            GoCoverageAnnotator.$$$reportNull$$$0(1);
        }
        if (directory == null) {
            GoCoverageAnnotator.$$$reportNull$$$0(2);
        }
        if (bundle == null) {
            GoCoverageAnnotator.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            GoCoverageAnnotator.$$$reportNull$$$0(4);
        }
        if ((dirCoverageInfo = this.myDirCoverageInfos.get(directory.getPath())) == null) {
            return null;
        }
        if (manager.isSubCoverageActive()) {
            return dirCoverageInfo.coveredLineCount > 0 ? GoBundle.message((String)"go.execution.coverage.covered", (Object[])new Object[0]) : null;
        }
        return GoCoverageAnnotator.getDirCoverageString(dirCoverageInfo);
    }

    @Nullable
    @Nls
    private static String getDirCoverageString(@NotNull BaseCoverageAnnotator.DirCoverageInfo dirCoverageInfo) {
        String filesCoverageInfo;
        if (dirCoverageInfo == null) {
            GoCoverageAnnotator.$$$reportNull$$$0(5);
        }
        if ((filesCoverageInfo = GoCoverageAnnotator.getFilesCoverageString(dirCoverageInfo)) != null) {
            @Nls StringBuilder builder = new StringBuilder();
            builder.append(filesCoverageInfo);
            String statementsCoverageInfo = GoCoverageAnnotator.getStatementsCoverageString((BaseCoverageAnnotator.FileCoverageInfo)dirCoverageInfo);
            if (statementsCoverageInfo != null) {
                builder.append(", ").append(statementsCoverageInfo);
            }
            return builder.toString();
        }
        return null;
    }

    @TestOnly
    @Nullable
    public String getDirCoverageInformationString(@NotNull VirtualFile file) {
        BaseCoverageAnnotator.DirCoverageInfo coverageInfo;
        if (file == null) {
            GoCoverageAnnotator.$$$reportNull$$$0(6);
        }
        return (coverageInfo = this.myDirCoverageInfos.get(file.getPath())) != null ? GoCoverageAnnotator.getDirCoverageString(coverageInfo) : null;
    }

    @Nullable
    public String getFileCoverageInformationString(@NotNull Project project, @NotNull VirtualFile file, @NotNull CoverageSuitesBundle bundle, @NotNull CoverageDataManager manager) {
        BaseCoverageAnnotator.FileCoverageInfo coverageInfo;
        if (project == null) {
            GoCoverageAnnotator.$$$reportNull$$$0(7);
        }
        if (file == null) {
            GoCoverageAnnotator.$$$reportNull$$$0(8);
        }
        if (bundle == null) {
            GoCoverageAnnotator.$$$reportNull$$$0(9);
        }
        if (manager == null) {
            GoCoverageAnnotator.$$$reportNull$$$0(10);
        }
        if ((coverageInfo = this.myFileCoverageInfos.get(file.getPath())) == null) {
            return null;
        }
        if (manager.isSubCoverageActive()) {
            return coverageInfo.coveredLineCount > 0 ? GoBundle.message((String)"go.execution.coverage.covered", (Object[])new Object[0]) : null;
        }
        return GoCoverageAnnotator.getStatementsCoverageString(coverageInfo);
    }

    @TestOnly
    @Nullable
    public String getFileCoverageInformationString(@NotNull VirtualFile file) {
        BaseCoverageAnnotator.FileCoverageInfo coverageInfo;
        if (file == null) {
            GoCoverageAnnotator.$$$reportNull$$$0(11);
        }
        return (coverageInfo = this.myFileCoverageInfos.get(file.getPath())) != null ? GoCoverageAnnotator.getStatementsCoverageString(coverageInfo) : null;
    }

    public void onSuiteChosen(CoverageSuitesBundle newSuite) {
        super.onSuiteChosen(newSuite);
        this.myFileCoverageInfos.clear();
        this.myDirCoverageInfos.clear();
    }

    @Nullable
    protected Runnable createRenewRequest(@NotNull CoverageSuitesBundle bundle, @NotNull CoverageDataManager manager) {
        if (bundle == null) {
            GoCoverageAnnotator.$$$reportNull$$$0(12);
        }
        if (manager == null) {
            GoCoverageAnnotator.$$$reportNull$$$0(13);
        }
        GoCoverageProjectData data = new GoCoverageProjectData();
        for (CoverageSuite suite : bundle.getSuites()) {
            ProjectData toMerge = suite.getCoverageData(manager);
            if (toMerge == null) continue;
            data.merge((CoverageData)toMerge);
        }
        return () -> {
            this.annotateAllFiles(data, (VirtualFile[])manager.doInReadActionIfProjectOpen(() -> ProjectRootManager.getInstance((Project)this.getProject()).getContentRoots()));
            manager.triggerPresentationUpdate();
        };
    }

    @NotNull
    private BaseCoverageAnnotator.DirCoverageInfo getOrCreateDirectoryInfo(VirtualFile file) {
        BaseCoverageAnnotator.DirCoverageInfo dirCoverageInfo = this.myDirCoverageInfos.computeIfAbsent(file.getPath(), __ -> new BaseCoverageAnnotator.DirCoverageInfo());
        if (dirCoverageInfo == null) {
            GoCoverageAnnotator.$$$reportNull$$$0(14);
        }
        return dirCoverageInfo;
    }

    @NotNull
    private BaseCoverageAnnotator.FileCoverageInfo getOrCreateFileInfo(VirtualFile file) {
        BaseCoverageAnnotator.FileCoverageInfo fileCoverageInfo = this.myFileCoverageInfos.computeIfAbsent(file.getPath(), __ -> new BaseCoverageAnnotator.FileCoverageInfo());
        if (fileCoverageInfo == null) {
            GoCoverageAnnotator.$$$reportNull$$$0(15);
        }
        return fileCoverageInfo;
    }

    @Nullable
    @Nls
    private static String getStatementsCoverageString(@NotNull BaseCoverageAnnotator.FileCoverageInfo info) {
        if (info == null) {
            GoCoverageAnnotator.$$$reportNull$$$0(16);
        }
        double percent = GoCoverageAnnotator.calcPercent(info.coveredLineCount, info.totalLineCount);
        return info.totalLineCount > 0 ? new DecimalFormat("##.#" + GoBundle.message((String)"go.execution.coverage.percent.statements", (Object[])new Object[0]), DecimalFormatSymbols.getInstance(DynamicBundle.getLocale())).format(percent) : null;
    }

    @Nullable
    @Nls
    private static String getFilesCoverageString(@NotNull BaseCoverageAnnotator.DirCoverageInfo info) {
        if (info == null) {
            GoCoverageAnnotator.$$$reportNull$$$0(17);
        }
        double percent = GoCoverageAnnotator.calcPercent(info.coveredFilesCount, info.totalFilesCount);
        return info.totalFilesCount > 0 ? new DecimalFormat("##.#" + GoBundle.message((String)"go.execution.coverage.percent.files", (Object[])new Object[0]), DecimalFormatSymbols.getInstance(DynamicBundle.getLocale())).format(percent) : null;
    }

    private static double calcPercent(int covered, int total) {
        return total != 0 ? (double)covered / (double)total : 0.0;
    }

    public void annotateAllFiles(final @NotNull GoCoverageProjectData data, VirtualFile ... contentRoots) {
        if (data == null) {
            GoCoverageAnnotator.$$$reportNull$$$0(18);
        }
        if (contentRoots != null) {
            for (VirtualFile root : contentRoots) {
                VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor<Object>(new VirtualFileVisitor.Option[0]){

                    @NotNull
                    public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                        if (file == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ProgressIndicatorProvider.checkCanceled();
                        if (file.isDirectory() && ((Boolean)ReadAction.compute(() -> !FileIndexFacade.getInstance((Project)GoCoverageAnnotator.this.getProject()).isInContent(file))).booleanValue()) {
                            VirtualFileVisitor.Result result = VirtualFileVisitor.SKIP_CHILDREN;
                            if (result == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return result;
                        }
                        if (!file.isDirectory() && GoCoverageEngine.INSTANCE.coverageProjectViewStatisticsApplicableTo(file)) {
                            BaseCoverageAnnotator.DirCoverageInfo dirCoverageInfo = GoCoverageAnnotator.this.getOrCreateDirectoryInfo(file.getParent());
                            BaseCoverageAnnotator.FileCoverageInfo fileCoverageInfo = GoCoverageAnnotator.this.getOrCreateFileInfo(file);
                            data.processFile(file.getPath(), (Processor<? super GoCoverageProjectData.RangeData>)((Processor)rangeData -> {
                                if (rangeData.hits > 0L) {
                                    fileCoverageInfo.coveredLineCount += Math.max(rangeData.statements, 1);
                                }
                                fileCoverageInfo.totalLineCount += Math.max(rangeData.statements, 1);
                                return true;
                            }));
                            if (fileCoverageInfo.totalLineCount > 0) {
                                dirCoverageInfo.totalLineCount += fileCoverageInfo.totalLineCount;
                                ++dirCoverageInfo.totalFilesCount;
                            }
                            if (fileCoverageInfo.coveredLineCount > 0) {
                                dirCoverageInfo.coveredLineCount += fileCoverageInfo.coveredLineCount;
                                ++dirCoverageInfo.coveredFilesCount;
                            }
                        }
                        VirtualFileVisitor.Result result = VirtualFileVisitor.CONTINUE;
                        if (result == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return result;
                    }

                    public void afterChildrenVisited(@NotNull VirtualFile file) {
                        if (file == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        if (file.isDirectory()) {
                            BaseCoverageAnnotator.DirCoverageInfo currentCoverageInfo = GoCoverageAnnotator.this.getOrCreateDirectoryInfo(file);
                            BaseCoverageAnnotator.DirCoverageInfo parentCoverageInfo = GoCoverageAnnotator.this.getOrCreateDirectoryInfo(file.getParent());
                            parentCoverageInfo.totalFilesCount += currentCoverageInfo.totalFilesCount;
                            parentCoverageInfo.coveredFilesCount += currentCoverageInfo.coveredFilesCount;
                            parentCoverageInfo.totalLineCount += currentCoverageInfo.totalLineCount;
                            parentCoverageInfo.coveredLineCount += currentCoverageInfo.coveredLineCount;
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 3;
                            case 1, 2 -> 2;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "file";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/goide/execution/testing/coverage/GoCoverageAnnotator$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/goide/execution/testing/coverage/GoCoverageAnnotator$1";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "visitFileEx";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "visitFileEx";
                                break;
                            }
                            case 1: 
                            case 2: {
                                break;
                            }
                            case 3: {
                                objectArray = objectArray;
                                objectArray[2] = "afterChildrenVisited";
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalArgumentException(string);
                            case 1, 2 -> new IllegalStateException(string);
                        };
                    }
                });
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 3: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 4: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirCoverageInfo";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/testing/coverage/GoCoverageAnnotator";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/testing/coverage/GoCoverageAnnotator";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateDirectoryInfo";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateFileInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDirCoverageInformationString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDirCoverageString";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFileCoverageInformationString";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createRenewRequest";
                break;
            }
            case 14: 
            case 15: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getStatementsCoverageString";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getFilesCoverageString";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "annotateAllFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 15 -> new IllegalStateException(string);
        };
    }
}

