/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing;

import com.goide.execution.testing.GoTestRunConfiguration;
import com.goide.execution.testing.GoTestRunningState;
import com.goide.execution.testing.frameworks.gobench.GobenchFramework;
import com.goide.execution.testing.frameworks.gocheck.GocheckFramework;
import com.goide.execution.testing.frameworks.gofuzz.GoFuzzFramework;
import com.goide.execution.testing.frameworks.gotest.GotestFramework;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoTestFramework {
    public static List<GoTestFramework> all() {
        return Lazy.ALL_FRAMEWORKS;
    }

    public boolean supportsJsonTestsOutput() {
        return false;
    }

    public Collection<? extends AnAction> getGenerateMethodActions() {
        return Collections.emptyList();
    }

    @NotNull
    public static GoTestFramework fromName(@Nullable String name) {
        for (GoTestFramework framework : GoTestFramework.all()) {
            if (!framework.getName().equals(name)) continue;
            GoTestFramework goTestFramework = framework;
            if (goTestFramework == null) {
                GoTestFramework.$$$reportNull$$$0(0);
            }
            return goTestFramework;
        }
        GotestFramework gotestFramework = GotestFramework.INSTANCE;
        if (gotestFramework == null) {
            GoTestFramework.$$$reportNull$$$0(1);
        }
        return gotestFramework;
    }

    @NotNull
    public abstract String getName();

    @NotNull
    @NlsSafe
    public String getPackageConfigurationName(@NotNull String packageName) {
        if (packageName == null) {
            GoTestFramework.$$$reportNull$$$0(2);
        }
        String string = this.getName() + " " + packageName;
        if (string == null) {
            GoTestFramework.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getFileConfigurationName(@NotNull String fileName) {
        if (fileName == null) {
            GoTestFramework.$$$reportNull$$$0(4);
        }
        String string = this.getName() + " " + fileName;
        if (string == null) {
            GoTestFramework.$$$reportNull$$$0(5);
        }
        return string;
    }

    public abstract boolean isAvailable(@Nullable Module var1);

    public abstract boolean isAvailableOnFile(@Nullable PsiFile var1);

    public abstract boolean isAvailableOnFunction(@Nullable GoFunctionOrMethodDeclaration var1);

    @NotNull
    protected abstract GoTestRunningState newRunningState(@NotNull ExecutionEnvironment var1, @NotNull Module var2, @NotNull GoTestRunConfiguration var3);

    @NotNull
    public abstract OutputToGeneralTestEventsConverter createTestEventsConverter(@NotNull String var1, @NotNull TestConsoleProperties var2, @Nullable Module var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/testing/GoTestFramework";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "fromName";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/testing/GoTestFramework";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageConfigurationName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileConfigurationName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPackageConfigurationName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFileConfigurationName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4 -> new IllegalArgumentException(string);
        };
    }

    private static class Lazy {
        private static final ArrayList<GoTestFramework> ALL_FRAMEWORKS = ContainerUtil.newArrayList((Object[])new GoTestFramework[]{GotestFramework.INSTANCE, GocheckFramework.INSTANCE, GobenchFramework.INSTANCE, GoFuzzFramework.INSTANCE});

        private Lazy() {
        }
    }
}

