/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing;

import com.goide.GoFileType;
import com.goide.execution.testing.GoTestFramework;
import com.goide.execution.testing.GoTestFunctionType;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.sdk.GoPackageUtil;
import com.goide.stubs.index.GoFunctionIndex;
import com.goide.stubs.index.GoMethodIndex;
import com.goide.util.GoUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFinder;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoTestFinder
implements TestFinder {
    private static final String EXTENSION = "." + GoFileType.INSTANCE.getDefaultExtension();

    public static boolean isTestFile(@Nullable PsiFile file) {
        return file instanceof GoFile && GoTestFinder.isTestFile(file.getViewProvider().getVirtualFile());
    }

    public static boolean isTestFile(@NotNull VirtualFile file) {
        if (file == null) {
            GoTestFinder.$$$reportNull$$$0(0);
        }
        VirtualFile fileToCheck = VirtualFileUtil.originalFileOrSelf((VirtualFile)file);
        return GoTestFinder.isTestFileName(fileToCheck.getNameSequence());
    }

    public static boolean isTestFileName(@NotNull CharSequence fileName) {
        if (fileName == null) {
            GoTestFinder.$$$reportNull$$$0(1);
        }
        return StringUtil.endsWith((CharSequence)fileName, (CharSequence)"_test.go");
    }

    public static boolean isTestFunction(@NotNull GoFunctionOrMethodDeclaration function) {
        if (function == null) {
            GoTestFinder.$$$reportNull$$$0(2);
        }
        return GoTestFunctionType.fromName(function.getName()) != null;
    }

    public static boolean isExampleFunction(@NotNull GoFunctionOrMethodDeclaration declaration) {
        if (declaration == null) {
            GoTestFinder.$$$reportNull$$$0(3);
        }
        return GoTestFunctionType.fromName(declaration.getName()) == GoTestFunctionType.EXAMPLE && GoTestFinder.isTestFile((PsiFile)declaration.getContainingFile());
    }

    public static boolean isTestOrExampleFunction(@NotNull GoFunctionOrMethodDeclaration function) {
        GoTestFunctionType type;
        if (function == null) {
            GoTestFinder.$$$reportNull$$$0(4);
        }
        return (type = GoTestFunctionType.fromName(function.getName())) == GoTestFunctionType.EXAMPLE || type == GoTestFunctionType.TEST || type == GoTestFunctionType.FUZZ;
    }

    public static boolean isBenchmarkFunction(@NotNull GoFunctionOrMethodDeclaration function) {
        GoTestFunctionType type;
        if (function == null) {
            GoTestFinder.$$$reportNull$$$0(5);
        }
        return (type = GoTestFunctionType.fromName(function.getName())) == GoTestFunctionType.BENCHMARK;
    }

    public static boolean isFuzzingFunction(@NotNull GoFunctionOrMethodDeclaration function) {
        GoTestFunctionType type;
        if (function == null) {
            GoTestFinder.$$$reportNull$$$0(6);
        }
        return (type = GoTestFunctionType.fromName(function.getName())) == GoTestFunctionType.FUZZ;
    }

    @Contract(value="null -> false")
    public static boolean isTestFileWithTestPackage(@Nullable PsiFile file) {
        return GoTestFinder.getTestTargetPackage(file) != null;
    }

    @Nullable
    public static String getTestTargetPackage(@Nullable PsiFile file) {
        String packageName;
        if (GoTestFinder.isTestFile(file) && (packageName = ((GoFile)file).getPackageName()) != null && packageName.endsWith("_test")) {
            return StringUtil.nullize((String)StringUtil.trimEnd((String)packageName, (String)"_test"));
        }
        return null;
    }

    @Nullable
    public PsiElement findSourceElement(@NotNull PsiElement from2) {
        GoFunctionOrMethodDeclaration function;
        if (from2 == null) {
            GoTestFinder.$$$reportNull$$$0(7);
        }
        if ((function = (GoFunctionOrMethodDeclaration)PsiTreeUtil.getNonStrictParentOfType((PsiElement)from2, (Class[])new Class[]{GoFunctionOrMethodDeclaration.class})) != null && (!GoTestFinder.isTestFile((PsiFile)function.getContainingFile()) || GoTestFinder.isRealTestFunction(function))) {
            return function;
        }
        return (PsiElement)ObjectUtils.tryCast((Object)InjectedLanguageManager.getInstance((Project)from2.getProject()).getTopLevelFile(from2), GoFile.class);
    }

    @NotNull
    public Collection<PsiElement> findTestsForClass(@NotNull PsiElement element) {
        PsiFile file;
        PsiDirectory directory;
        if (element == null) {
            GoTestFinder.$$$reportNull$$$0(8);
        }
        PsiDirectory psiDirectory = directory = (file = InjectedLanguageManager.getInstance((Project)element.getProject()).getTopLevelFile(element)) != null ? file.getContainingDirectory() : null;
        if (!(file instanceof GoFile) || directory == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                GoTestFinder.$$$reportNull$$$0(9);
            }
            return list;
        }
        GoFunctionOrMethodDeclaration function = (GoFunctionOrMethodDeclaration)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{GoFunctionOrMethodDeclaration.class});
        if (function != null && !DumbService.getInstance((Project)element.getProject()).isDumb()) {
            Project project = file.getProject();
            GlobalSearchScope scope = GoPackageUtil.packageScope((GoFile)file);
            SmartList result = new SmartList();
            String functionName = function.getName();
            SmartList prefixesToCheck = new SmartList((Object)GoTestFinder.addUnderscoreIfNeeded(functionName));
            if (function instanceof GoMethodDeclaration) {
                String receiverTypeName = GoTypeUtil.getReceiverTypeName(((GoMethodDeclaration)function).getReceiverType());
                prefixesToCheck.add(GoTestFinder.addUnderscoreIfNeeded(receiverTypeName) + "_" + functionName);
            }
            for (String name : StubIndex.getInstance().getAllKeys(GoFunctionIndex.KEY, project)) {
                if (!GoTestFinder.isTestFunctionWithPrefix(name, (List<String>)prefixesToCheck)) continue;
                GoFunctionIndex.process(name, project, scope, null, (Processor<? super GoFunctionDeclaration>)((Processor)arg_0 -> GoTestFinder.lambda$findTestsForClass$0((List)result, arg_0)));
            }
            if (!result.isEmpty()) {
                SmartList smartList = result;
                if (smartList == null) {
                    GoTestFinder.$$$reportNull$$$0(10);
                }
                return smartList;
            }
        }
        PsiFile testFile = directory.findFile(FileUtil.getNameWithoutExtension((String)file.getName()) + "_test.go");
        List list = ContainerUtil.createMaybeSingletonList((Object)testFile);
        if (list == null) {
            GoTestFinder.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public List<GoFunctionDeclaration> findExampleFunctions(@NotNull PsiElement element) {
        if (element == null) {
            GoTestFinder.$$$reportNull$$$0(12);
        }
        SmartList result = new SmartList();
        String examplePrefix = GoTestFinder.getExamplePrefix(element);
        if (examplePrefix == null) {
            SmartList smartList = result;
            if (smartList == null) {
                GoTestFinder.$$$reportNull$$$0(13);
            }
            return smartList;
        }
        for (PsiElement test : this.findTestsForClass(element)) {
            String name;
            GoFunctionDeclaration declaration = (GoFunctionDeclaration)ObjectUtils.tryCast((Object)test, GoFunctionDeclaration.class);
            String string = name = declaration != null ? declaration.getName() : null;
            if (declaration == null || !GoTestFinder.isExampleFunction(declaration) || name == null || !name.equals(examplePrefix) && !name.startsWith(examplePrefix + "_")) continue;
            result.add(declaration);
        }
        SmartList smartList = result;
        if (smartList == null) {
            GoTestFinder.$$$reportNull$$$0(14);
        }
        return smartList;
    }

    @Nullable
    public static String getExamplePrefix(@NotNull PsiElement element) {
        String name;
        if (element == null) {
            GoTestFinder.$$$reportNull$$$0(15);
        }
        String string = name = element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : null;
        if (!StringUtil.isCapitalized((String)name)) {
            return null;
        }
        if (element instanceof GoFunctionDeclaration) {
            return "Example" + name;
        }
        if (element instanceof GoMethodDeclaration) {
            String receiverTypeName = GoTypeUtil.getReceiverTypeName(((GoMethodDeclaration)element).getReceiverType());
            return StringUtil.isCapitalized((String)receiverTypeName) ? "Example" + receiverTypeName + "_" + name : null;
        }
        return null;
    }

    private static boolean isTestFunctionWithPrefix(@NotNull String functionName, @NotNull List<String> prefixesToCheck) {
        if (functionName == null) {
            GoTestFinder.$$$reportNull$$$0(16);
        }
        if (prefixesToCheck == null) {
            GoTestFinder.$$$reportNull$$$0(17);
        }
        for (GoTestFunctionType testFunctionType : GoTestFunctionType.values()) {
            for (String prefix : prefixesToCheck) {
                if (!GoUtil.checkPrefix(functionName, testFunctionType.getPrefix() + prefix)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public Collection<PsiElement> findClassesForTest(@NotNull PsiElement element) {
        PsiFile file;
        PsiDirectory directory;
        if (element == null) {
            GoTestFinder.$$$reportNull$$$0(18);
        }
        PsiDirectory psiDirectory = directory = (file = InjectedLanguageManager.getInstance((Project)element.getProject()).getTopLevelFile(element)) != null ? file.getContainingDirectory() : null;
        if (!(file instanceof GoFile) || directory == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                GoTestFinder.$$$reportNull$$$0(19);
            }
            return list;
        }
        GoFunctionOrMethodDeclaration function = GoTestFinder.findTestFunctionInContext(element);
        String testName = function != null ? function.getName() : null;
        GoTestFunctionType testFunctionType = GoTestFunctionType.fromName(testName);
        if (testName != null && testFunctionType != null && GoTestFinder.isRealTestFunction(function)) {
            Project project = file.getProject();
            GlobalSearchScope scope = GoPackageUtil.packageScope((GoFile)file);
            SmartList result = new SmartList();
            for (String name : StubIndex.getInstance().getAllKeys(GoFunctionIndex.KEY, project)) {
                if (!GoUtil.checkPrefix(testName, testFunctionType.getPrefix() + GoTestFinder.addUnderscoreIfNeeded(name))) continue;
                GoFunctionIndex.process(name, project, scope, null, (Processor<? super GoFunctionDeclaration>)((Processor)arg_0 -> GoTestFinder.lambda$findClassesForTest$1((List)result, arg_0)));
            }
            for (String name : StubIndex.getInstance().getAllKeys(GoMethodIndex.KEY, project)) {
                GoMethodIndex.process(name, project, scope, null, (Processor<? super GoMethodDeclaration>)((Processor)arg_0 -> GoTestFinder.lambda$findClassesForTest$2(testName, testFunctionType, (List)result, arg_0)));
            }
            if (!result.isEmpty()) {
                SmartList smartList = result;
                if (smartList == null) {
                    GoTestFinder.$$$reportNull$$$0(20);
                }
                return smartList;
            }
        }
        PsiFile sourceFile = directory.findFile(StringUtil.trimEnd((String)file.getName(), (String)"_test.go") + EXTENSION);
        List list = ContainerUtil.createMaybeSingletonList((Object)sourceFile);
        if (list == null) {
            GoTestFinder.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    private static String addUnderscoreIfNeeded(@Nullable String s) {
        Object object = StringUtil.isCapitalized((String)s) ? s : "_" + StringUtil.notNullize((String)s);
        if (object == null) {
            GoTestFinder.$$$reportNull$$$0(22);
        }
        return object;
    }

    private static boolean isRealTestFunction(@Nullable GoFunctionOrMethodDeclaration functionInContext) {
        for (GoTestFramework framework : GoTestFramework.all()) {
            if (!framework.isAvailableOnFunction(functionInContext)) continue;
            return true;
        }
        return false;
    }

    public boolean isTest(@NotNull PsiElement element) {
        if (element == null) {
            GoTestFinder.$$$reportNull$$$0(23);
        }
        return GoTestFinder.isTestFile(InjectedLanguageManager.getInstance((Project)element.getProject()).getTopLevelFile(element));
    }

    @Nullable
    public static GoFunctionOrMethodDeclaration findTestFunctionInContext(@NotNull PsiElement contextElement) {
        GoFunctionOrMethodDeclaration function;
        if (contextElement == null) {
            GoTestFinder.$$$reportNull$$$0(24);
        }
        return (function = (GoFunctionOrMethodDeclaration)PsiTreeUtil.getNonStrictParentOfType((PsiElement)contextElement, (Class[])new Class[]{GoFunctionOrMethodDeclaration.class})) != null && GoTestFinder.isTestFunction(function) ? function : null;
    }

    private static boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            GoTestFinder.$$$reportNull$$$0(25);
        }
        return InjectedLanguageManager.getInstance((Project)element.getProject()).getTopLevelFile(element) instanceof GoFile;
    }

    @Nullable
    public String getSearchingForTestsForClassProgressTitle(@NotNull PsiElement element) {
        if (element == null) {
            GoTestFinder.$$$reportNull$$$0(26);
        }
        return GoTestFinder.isApplicable(element) ? GoBundle.message((String)"go.test.creator.progress.title.searching.for.functions.for.test", (Object[])new Object[0]) : null;
    }

    @Nullable
    public String getSearchingForClassesForTestProgressTitle(@NotNull PsiElement element) {
        if (element == null) {
            GoTestFinder.$$$reportNull$$$0(27);
        }
        return GoTestFinder.isApplicable(element) ? GoBundle.message((String)"go.test.creator.progress.title.searching.for.tests.for.function", (Object[])new Object[0]) : null;
    }

    private static /* synthetic */ boolean lambda$findClassesForTest$2(String testName, GoTestFunctionType testFunctionType, List result, GoMethodDeclaration method) {
        ProgressManager.checkCanceled();
        String methodName = method.getName();
        if (GoUtil.checkPrefix(testName, testFunctionType.getPrefix() + GoTestFinder.addUnderscoreIfNeeded(methodName))) {
            result.add(method);
            return true;
        }
        String typeName = GoTypeUtil.getReceiverTypeName(method.getReceiverType());
        if (GoUtil.checkPrefix(testName, testFunctionType.getPrefix() + GoTestFinder.addUnderscoreIfNeeded(typeName) + "_" + methodName)) {
            result.add(method);
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$findClassesForTest$1(List result, GoFunctionDeclaration declaration) {
        ProgressManager.checkCanceled();
        result.add(declaration);
        return true;
    }

    private static /* synthetic */ boolean lambda$findTestsForClass$0(List result, GoFunctionDeclaration declaration) {
        ProgressManager.checkCanceled();
        result.add(declaration);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 11, 13, 14, 19, 20, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 8: 
            case 12: 
            case 15: 
            case 18: 
            case 23: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/testing/GoTestFinder";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixesToCheck";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/testing/GoTestFinder";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestsForClass";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findExampleFunctions";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesForTest";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "addUnderscoreIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isTestFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isTestFileName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isTestFunction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isExampleFunction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isTestOrExampleFunction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isBenchmarkFunction";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isFuzzingFunction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findSourceElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findTestsForClass";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findExampleFunctions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getExamplePrefix";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isTestFunctionWithPrefix";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findClassesForTest";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isTest";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findTestFunctionInContext";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getSearchingForTestsForClassProgressTitle";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getSearchingForClassesForTestProgressTitle";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 11, 13, 14, 19, 20, 21, 22 -> new IllegalStateException(string);
        };
    }
}

