/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing;

import com.goide.GoOsManager;
import com.goide.execution.testing.GoTestEventsConverterBase;
import com.goide.testing.GoTestJsonEventsProcessor;
import com.goide.testing.OutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsAdapter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.messages.MessageBusConnection;
import java.text.ParseException;
import java.util.concurrent.atomic.AtomicBoolean;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoTestEventsJsonConverter
extends OutputToGeneralTestEventsConverter
implements GoTestEventsConverterBase {
    private final GoTestJsonEventsProcessor myEventsProcessor;

    public GoTestEventsJsonConverter(@NotNull String frameworkName, @NotNull String defaultImportPath, @NotNull TestConsoleProperties consoleProperties) {
        if (frameworkName == null) {
            GoTestEventsJsonConverter.$$$reportNull$$$0(0);
        }
        if (defaultImportPath == null) {
            GoTestEventsJsonConverter.$$$reportNull$$$0(1);
        }
        if (consoleProperties == null) {
            GoTestEventsJsonConverter.$$$reportNull$$$0(2);
        }
        super(frameworkName, consoleProperties);
        boolean restoreTrimmedSpaces = GoOsManager.isWindows() && Registry.is((String)"go.run.processes.with.pty");
        AtomicBoolean durationStrategySet = new AtomicBoolean(false);
        this.myEventsProcessor = new GoTestJsonEventsProcessor(defaultImportPath, (message, outputType, visitor2) -> {
            try {
                if (!durationStrategySet.getAndSet(true)) {
                    super.processServiceMessages("##teamcity[enteredTheMatrix durationStrategy='manual']", ProcessOutputTypes.STDOUT, visitor2);
                }
                return super.processServiceMessages(message.asString(), GoTestEventsJsonConverter.convert(outputType), visitor2);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }, Registry.is((String)"go.testing.handle.split.lines"), restoreTrimmedSpaces);
        final MessageBusConnection connection = consoleProperties.getProject().getMessageBus().connect((Disposable)consoleProperties);
        connection.subscribe(SMTRunnerEventsListener.TEST_STATUS, (Object)new SMTRunnerEventsAdapter(){

            public void onBeforeTestingFinished(// Could not load outer class - annotation placement on inner may be incorrect
             @NotNull SMTestProxy.SMRootTestProxy testsRoot) {
                Double totalTimeSeconds;
                if (testsRoot == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((totalTimeSeconds = GoTestEventsJsonConverter.this.myEventsProcessor.getTotalTimeSeconds()) != null) {
                    testsRoot.setDuration((long)(1000.0 * totalTimeSeconds));
                }
                connection.disconnect();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testsRoot", "com/goide/execution/testing/GoTestEventsJsonConverter$1", "onBeforeTestingFinished"));
            }
        });
    }

    @Override
    public boolean processServiceMessages(@NotNull String text, @NotNull Key<?> outputType, @NotNull ServiceMessageVisitor visitor2) {
        if (text == null) {
            GoTestEventsJsonConverter.$$$reportNull$$$0(3);
        }
        if (outputType == null) {
            GoTestEventsJsonConverter.$$$reportNull$$$0(4);
        }
        if (visitor2 == null) {
            GoTestEventsJsonConverter.$$$reportNull$$$0(5);
        }
        return this.myEventsProcessor.processLine(text, GoTestEventsJsonConverter.convert(outputType), visitor2);
    }

    public synchronized void finishTesting() {
        this.myEventsProcessor.clearState();
        super.finishTesting();
    }

    private static Key<?> convert(@Nullable OutputType type) {
        if (type == OutputType.STDERR) {
            return ProcessOutputTypes.STDERR;
        }
        if (type == OutputType.SYSTEM) {
            return ProcessOutputTypes.SYSTEM;
        }
        return ProcessOutputTypes.STDOUT;
    }

    private static OutputType convert(@Nullable Key<?> type) {
        if (type == ProcessOutputTypes.STDERR) {
            return OutputType.STDERR;
        }
        if (type == ProcessOutputTypes.SYSTEM) {
            return OutputType.SYSTEM;
        }
        return OutputType.STDOUT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultImportPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        objectArray2[1] = "com/goide/execution/testing/GoTestEventsJsonConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processServiceMessages";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

