/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.scratch;

import com.goide.GoNotifications;
import com.goide.execution.GoBuildingRunConfiguration;
import com.goide.execution.scratch.TargetErrorKind;
import com.goide.i18n.GoBundle;
import com.goide.psi.impl.GoPackage;
import com.goide.sdk.GoPackageUtil;
import com.goide.vgo.VgoUtil;
import com.goide.vgo.project.VgoDependency;
import com.goide.vgo.project.VgoModule;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunDialog;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ResolveState;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0002\u001a\u001c\u0010\u0004\u001a\u00020\u00052\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0002\u00a8\u0006\u0010"}, d2={"checkRunConfiguration", "", "configuration", "Lcom/goide/execution/GoBuildingRunConfiguration;", "notifyInvalidConfiguration", "", "kind", "Lcom/goide/execution/scratch/TargetErrorKind;", "findScratchByPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "", "findOutputFileIndex", "", "parameters", "", "intellij.go.impl"})
@SourceDebugExtension(value={"SMAP\nGoScratchRunConfigurationExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoScratchRunConfigurationExtension.kt\ncom/goide/execution/scratch/GoScratchRunConfigurationExtensionKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1617#2,9:134\n1869#2:143\n1870#2:145\n1626#2:146\n1617#2,9:147\n1869#2:156\n1870#2:158\n1626#2:159\n2746#2,2:160\n1761#2,3:162\n2748#2:165\n1#3:144\n1#3:157\n1#3:166\n*S KotlinDebug\n*F\n+ 1 GoScratchRunConfigurationExtension.kt\ncom/goide/execution/scratch/GoScratchRunConfigurationExtensionKt\n*L\n62#1:134,9\n62#1:143\n62#1:145\n62#1:146\n63#1:147,9\n63#1:156\n63#1:158\n63#1:159\n88#1:160,2\n89#1:162,3\n88#1:165\n62#1:144\n63#1:157\n*E\n"})
public final class GoScratchRunConfigurationExtensionKt {
    /*
     * WARNING - void declaration
     */
    private static final boolean checkRunConfiguration(GoBuildingRunConfiguration<?> configuration) {
        if (configuration.getKind() == GoBuildingRunConfiguration.Kind.FILE) {
            void $this$mapNotNullTo$iv$iv;
            Object element$iv$iv$iv2;
            void $this$mapNotNullTo$iv$iv2;
            List<String> list = configuration.getFilePaths();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getFilePaths(...)");
            Iterable $this$mapNotNull$iv = list;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Iterable<VirtualFile> destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
                VirtualFile it$iv$iv;
                Object element$iv$iv = element$iv$iv$iv2;
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (GoScratchRunConfigurationExtensionKt.findScratchByPath(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List scratchTargets = (List)destination$iv$iv;
            Iterable $this$mapNotNull$iv2 = scratchTargets;
            boolean $i$f$mapNotNull2 = false;
            destination$iv$iv = $this$mapNotNull$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
            while (element$iv$iv$iv2.hasNext()) {
                VgoModule it$iv$iv;
                Object element$iv$iv$iv3;
                Object element$iv$iv = element$iv$iv$iv3 = element$iv$iv$iv2.next();
                boolean bl = false;
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl4 = false;
                Pair.NonNull<VgoModule, VgoDependency> nonNull = VgoUtil.findModuleAndDependencyOfFile(configuration.getProject(), it);
                if ((nonNull != null ? (VgoModule)nonNull.first : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            HashSet vgoModulesOfTargets = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv2));
            return switch (vgoModulesOfTargets.size()) {
                case 0 -> false;
                case 1 -> true;
                default -> {
                    GoScratchRunConfigurationExtensionKt.notifyInvalidConfiguration(configuration, TargetErrorKind.DifferentScratchContexts);
                    yield false;
                }
            };
        }
        File scratchesRoot = new File(ScratchFileService.getInstance().getRootPath((RootType)ScratchRootType.getInstance()));
        if (configuration.getKind() == GoBuildingRunConfiguration.Kind.DIRECTORY && !Intrinsics.areEqual((Object)scratchesRoot, (Object)new File(configuration.getDirectoryPath()))) {
            return false;
        }
        if (configuration.getKind() == GoBuildingRunConfiguration.Kind.PACKAGE) {
            boolean noDirectoriesInScratchRoot;
            block18: {
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)scratchesRoot, (boolean)false);
                if (virtualFile == null) {
                    return false;
                }
                VirtualFile scratchesRootVfs = virtualFile;
                Object object = ActionsKt.runReadAction(() -> GoScratchRunConfigurationExtensionKt.checkRunConfiguration$lambda$2(configuration));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
                Collection packages = (Collection)object;
                Iterable $this$none$iv = packages;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    v5 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        boolean bl;
                        block17: {
                            GoPackage pkg = (GoPackage)element$iv;
                            boolean bl6 = false;
                            Set<VirtualFile> set = pkg.getDirectories();
                            Intrinsics.checkNotNullExpressionValue(set, (String)"getDirectories(...)");
                            Iterable $this$any$iv = set;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv) {
                                    VirtualFile it = (VirtualFile)element$iv2;
                                    boolean bl7 = false;
                                    if (!VfsUtil.isAncestor((VirtualFile)scratchesRootVfs, (VirtualFile)it, (boolean)false)) continue;
                                    bl = true;
                                    break block17;
                                }
                                bl = false;
                            }
                        }
                        if (!bl) continue;
                        v5 = false;
                        break block18;
                    }
                    v5 = noDirectoriesInScratchRoot = true;
                }
            }
            if (noDirectoriesInScratchRoot) {
                return false;
            }
        }
        GoScratchRunConfigurationExtensionKt.notifyInvalidConfiguration(configuration, TargetErrorKind.WrongTargetKind);
        return false;
    }

    private static final void notifyInvalidConfiguration(GoBuildingRunConfiguration<?> configuration, TargetErrorKind kind) {
        NotificationGroup notificationGroup = GoNotifications.getGeneralGroup();
        String string = GoBundle.message((String)"go.execution.scratch.runconfig.extension.edit.notification.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = kind.getKey();
        Object[] objectArray = new Object[2];
        objectArray[0] = configuration.getName();
        String string3 = configuration.getKind().getUiName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getUiName(...)");
        Intrinsics.checkNotNullExpressionValue((Object)string3.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
        String string4 = GoBundle.message((String)string2, (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        Notification notification = notificationGroup.createNotification(string, string4, NotificationType.ERROR);
        String string5 = GoBundle.message((String)"go.execution.scratch.runconfig.extension.edit.notification.action", (Object[])new Object[0]);
        notification.addAction((AnAction)new NotificationAction(configuration, string5){
            final /* synthetic */ GoBuildingRunConfiguration<?> $configuration;
            {
                this.$configuration = $configuration;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e, Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                Project project = this.$configuration.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.Companion.getInstance(project).findSettings((RunConfiguration)this.$configuration);
                if (runnerAndConfigurationSettings == null) {
                    return;
                }
                RunnerAndConfigurationSettings runnerAndConfigurationSettings2 = runnerAndConfigurationSettings;
                Object[] objectArray = new Object[]{this.$configuration.getName()};
                RunDialog.editConfiguration((Project)this.$configuration.getProject(), (RunnerAndConfigurationSettings)runnerAndConfigurationSettings2, (String)ExecutionBundle.message((String)"edit.run.configuration.for.item.dialog.title", (Object[])objectArray));
            }
        });
        notification.notify(configuration.getProject());
    }

    private static final VirtualFile findScratchByPath(String path) {
        VirtualFile scratchFile;
        VirtualFile virtualFile;
        VirtualFile it = virtualFile = (scratchFile = VfsUtil.findFileByIoFile((File)new File(path), (boolean)false));
        boolean bl = false;
        return ScratchUtil.isScratch((VirtualFile)it) ? virtualFile : null;
    }

    private static final int findOutputFileIndex(List<String> parameters) {
        return Math.max(0, Math.max(parameters.indexOf("build"), parameters.indexOf("test")));
    }

    private static final Collection checkRunConfiguration$lambda$2(GoBuildingRunConfiguration $configuration) {
        return GoPackageUtil.findByImportPath($configuration.getPackage(), $configuration.getProject(), null, ResolveState.initial());
    }

    public static final /* synthetic */ boolean access$checkRunConfiguration(GoBuildingRunConfiguration configuration) {
        return GoScratchRunConfigurationExtensionKt.checkRunConfiguration(configuration);
    }

    public static final /* synthetic */ int access$findOutputFileIndex(List parameters) {
        return GoScratchRunConfigurationExtensionKt.findOutputFileIndex(parameters);
    }

    public static final /* synthetic */ VirtualFile access$findScratchByPath(String path) {
        return GoScratchRunConfigurationExtensionKt.findScratchByPath(path);
    }
}

