/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.extension;

import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoExecutorExtension {
    public static final ExtensionPointName<GoExecutorExtension> EP_NAME = new ExtensionPointName("com.goide.executorExtension");

    public Map<String, String> getExtraEnvironment(@NotNull Project project, @Nullable Module module, @NotNull Map<String, String> currentEnvironment) {
        if (project == null) {
            GoExecutorExtension.$$$reportNull$$$0(0);
        }
        if (currentEnvironment == null) {
            GoExecutorExtension.$$$reportNull$$$0(1);
        }
        return Collections.emptyMap();
    }

    @NotNull
    public static Map<String, String> getGoSpecificEnvironment(@NotNull Project project, @Nullable Module module, @NotNull Map<String, String> currentEnvironment) {
        Collection<VirtualFile> goPath;
        if (project == null) {
            GoExecutorExtension.$$$reportNull$$$0(2);
        }
        if (currentEnvironment == null) {
            GoExecutorExtension.$$$reportNull$$$0(3);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        GoSdk sdk = GoSdkService.getInstance(project).getSdk(module);
        if (sdk.isValid()) {
            result.put("GOROOT", VfsUtilCore.urlToPath((String)sdk.getHomeUrl()));
        }
        if (!(goPath = GoSdkUtil.getGoPathRoots(project, module)).isEmpty()) {
            result.put("GOPATH", StringUtil.join((Collection)ContainerUtil.map(goPath, f -> PathUtil.toSystemDependentName((String)f.getPath())), (String)File.pathSeparator));
        }
        for (GoExecutorExtension extension : EP_NAME.getExtensionList()) {
            result.putAll(extension.getExtraEnvironment(project, module, currentEnvironment));
        }
        HashMap<String, String> hashMap = result;
        if (hashMap == null) {
            GoExecutorExtension.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    public static String getGoSpecificPathVariable(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            GoExecutorExtension.$$$reportNull$$$0(5);
        }
        return StringUtil.join(GoSdkUtil.getGoPathBins(project, module, false), f -> PathUtil.toSystemDependentName((String)f.getPath()), (String)File.pathSeparator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentEnvironment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/extension/GoExecutorExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/extension/GoExecutorExtension";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoSpecificEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExtraEnvironment";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getGoSpecificEnvironment";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getGoSpecificPathVariable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

