/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution;

import com.goide.execution.GoLazyDelegatingSearchScope;
import com.goide.execution.GoModuleBasedConfiguration;
import com.goide.execution.GoRunningState;
import com.goide.execution.GoWslUtil;
import com.goide.execution.extension.GoRunConfigurationExtensionsManager;
import com.goide.execution.target.GoLanguageRuntimeType;
import com.goide.i18n.GoBundle;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkUtil;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunConfigurationWithSuppressedDefaultDebugAction;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoRunConfigurationBase<RunningState extends GoRunningState<? extends GoRunConfigurationBase<RunningState>>>
extends ModuleBasedConfiguration<GoModuleBasedConfiguration, Element>
implements RunConfigurationWithSuppressedDefaultRunAction,
RunConfigurationWithSuppressedDefaultDebugAction,
TargetEnvironmentAwareRunProfile {
    @NonNls
    private static final String WORKING_DIRECTORY_NAME = "working_directory";
    @NonNls
    private static final String GO_PARAMETERS_NAME = "go_parameters";
    @NonNls
    private static final String USE_CUSTOM_BUILD_TAGS = "useCustomBuildTags";
    @NonNls
    private static final String PARAMETERS_NAME = "parameters";
    @NonNls
    private static final String PASS_PARENT_ENV = "pass_parent_env";
    @NonNls
    private static final String RUN_WITH_SUDO = "sudo";
    @NotNull
    private String myWorkingDirectory;
    @NotNull
    private String myGoToolsParams = "";
    private boolean myUseCustomBuildTags;
    @NotNull
    private String myParams = "";
    @NotNull
    private final Map<String, String> myCustomEnvironment = new LinkedHashMap<String, String>();
    private boolean myPassParentEnvironment = true;
    private boolean myRunWithSudo;
    @NotNull
    private GlobalSearchScope myConsoleScope;

    protected GoRunConfigurationBase(String name, GoModuleBasedConfiguration configurationModule, ConfigurationFactory factory) {
        super(name, (RunConfigurationModule)configurationModule, factory);
        Collection modules;
        Module module = configurationModule.getModule();
        if (module == null && (modules = this.getAllModules()).size() == 1) {
            module = (Module)ContainerUtil.getFirstItem((Collection)modules);
            ((GoModuleBasedConfiguration)this.getConfigurationModule()).setModule(module);
        }
        this.myWorkingDirectory = GoRunConfigurationBase.suggestWorkingDirectory(configurationModule.getProject(), module);
        this.myConsoleScope = new GoLazyDelegatingSearchScope(this.getProject(), () -> ((GoRunConfigurationBase)this).getSearchScope());
    }

    @NotNull
    private static String suggestWorkingDirectory(@NotNull Project project, @Nullable Module module) {
        VirtualFile contentRoot;
        if (project == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(0);
        }
        if (module != null && (contentRoot = (VirtualFile)ArrayUtil.getFirstElement((Object[])ModuleRootManager.getInstance((Module)module).getContentRoots())) != null) {
            String string = contentRoot.getPath();
            if (string == null) {
                GoRunConfigurationBase.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = StringUtil.notNullize((String)project.getBasePath());
        if (string == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isRunnable() {
        return true;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(3);
        }
        if (environment == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(4);
        }
        return this.createRunningState(environment);
    }

    @NotNull
    public Collection<Module> getValidModules() {
        Collection<Module> collection = GoSdkUtil.getGoModules(this.getProject());
        if (collection == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup<GoRunConfigurationBase<RunningState>> group = this.createSettingsEditorGroup();
        GoRunConfigurationExtensionsManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup<GoRunConfigurationBase<RunningState>> settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(6);
        }
        return settingsEditorGroup;
    }

    @Nullable
    public String getOverriddenOutputFileParameter() {
        List params = ParametersListUtil.parse((String)ProgramParametersConfigurator.expandMacros((String)this.myGoToolsParams), (boolean)false, (boolean)true);
        Iterator iterator = params.iterator();
        while (iterator.hasNext()) {
            String parameter = (String)iterator.next();
            if (!"-o".equals(parameter)) continue;
            return iterator.hasNext() ? StringUtil.nullize((String)((String)iterator.next())) : null;
        }
        return null;
    }

    public abstract SettingsEditorGroup<? extends GoRunConfigurationBase<RunningState>> createSettingsEditorGroup();

    public void checkConfiguration() throws RuntimeConfigurationException {
        GoModuleBasedConfiguration configurationModule = (GoModuleBasedConfiguration)this.getConfigurationModule();
        Module module = configurationModule.getModule();
        if (module != null) {
            if (GoSdkService.getInstance(module.getProject()).getSdk(module) == GoSdk.NULL) {
                throw new RuntimeConfigurationWarning(GoBundle.message((String)"go.execution.sdk.is.not.specified.error", (Object[])new Object[]{module.getName()}));
            }
        } else {
            String moduleName = configurationModule.getModuleName();
            throw new RuntimeConfigurationError(GoBundle.message((String)"go.execution.module.does.not.exist.error", (Object[])new Object[]{moduleName}));
        }
        if (StringUtil.isEmptyOrSpaces((String)this.myWorkingDirectory)) {
            throw new RuntimeConfigurationError(GoBundle.message((String)"go.execution.working.directory.is.not.specified.error", (Object[])new Object[0]));
        }
        VirtualFile workingDirectory = LocalFileSystem.getInstance().findFileByPath(this.myWorkingDirectory);
        if (workingDirectory == null || !workingDirectory.isDirectory()) {
            throw new RuntimeConfigurationError(GoBundle.message((String)"go.execution.cannot.find.working.directory.error", (Object[])new Object[]{this.myWorkingDirectory}));
        }
        this.checkExtensions();
    }

    private void checkExtensions() throws RuntimeConfigurationException {
        try {
            GoRunConfigurationExtensionsManager.getInstance().validateConfiguration((RunConfigurationBase)this, false);
        }
        catch (RuntimeConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeConfigurationException(e.getMessage());
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(7);
        }
        super.writeExternal(element);
        GoRunConfigurationBase.writeNonEmptyPathField(element, WORKING_DIRECTORY_NAME, this.myWorkingDirectory);
        GoRunConfigurationBase.writeNonEmptyField(element, GO_PARAMETERS_NAME, this.myGoToolsParams);
        if (this.myUseCustomBuildTags) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)USE_CUSTOM_BUILD_TAGS, (String)"true");
        }
        GoRunConfigurationBase.writeNonEmptyField(element, PARAMETERS_NAME, this.myParams);
        if (!this.myCustomEnvironment.isEmpty()) {
            EnvironmentVariablesComponent.writeExternal((Element)element, this.myCustomEnvironment);
        }
        if (!this.myPassParentEnvironment) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)PASS_PARENT_ENV, (String)"false");
        }
        if (this.myRunWithSudo) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)RUN_WITH_SUDO, (String)"true");
        }
        GoRunConfigurationExtensionsManager.getInstance().writeExternal((RunConfigurationBase)this, element);
    }

    protected static void writeNonEmptyField(@NotNull Element element, @NotNull String attributeName, @Nullable String value2) {
        if (element == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(8);
        }
        if (attributeName == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(9);
        }
        if (StringUtil.isNotEmpty((String)value2)) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)attributeName, (String)value2);
        }
    }

    protected static void writeNonEmptyPathField(@NotNull Element element, @NotNull String attributeName, @Nullable String value2) {
        if (element == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(10);
        }
        if (attributeName == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(11);
        }
        if (StringUtil.isNotEmpty((String)value2)) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)attributeName, (String)FileUtil.toSystemIndependentName((String)value2));
        }
    }

    @Nullable
    protected static String readPathField(@NotNull Element element, @NotNull String attributeName) {
        String value2;
        if (element == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(12);
        }
        if (attributeName == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(13);
        }
        return (value2 = JDOMExternalizerUtil.readCustomField((Element)element, (String)attributeName)) != null ? FileUtil.toSystemDependentName((String)value2) : null;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(14);
        }
        super.readExternal(element);
        this.readModule(element);
        this.myGoToolsParams = StringUtil.notNullize((String)JDOMExternalizerUtil.readCustomField((Element)element, (String)GO_PARAMETERS_NAME));
        this.myUseCustomBuildTags = Boolean.parseBoolean(JDOMExternalizerUtil.readCustomField((Element)element, (String)USE_CUSTOM_BUILD_TAGS));
        this.myRunWithSudo = Boolean.parseBoolean(JDOMExternalizerUtil.readCustomField((Element)element, (String)RUN_WITH_SUDO));
        this.myParams = StringUtil.notNullize((String)JDOMExternalizerUtil.readCustomField((Element)element, (String)PARAMETERS_NAME));
        String workingDirectoryValue = GoRunConfigurationBase.readPathField(element, WORKING_DIRECTORY_NAME);
        if (workingDirectoryValue != null) {
            this.myWorkingDirectory = workingDirectoryValue;
        }
        EnvironmentVariablesComponent.readExternal((Element)element, this.myCustomEnvironment);
        String passEnvValue = JDOMExternalizerUtil.readCustomField((Element)element, (String)PASS_PARENT_ENV);
        this.myPassParentEnvironment = passEnvValue == null || Boolean.parseBoolean(passEnvValue);
        GoRunConfigurationExtensionsManager.getInstance().readExternal((RunConfigurationBase)this, element);
    }

    @NotNull
    private RunningState createRunningState(ExecutionEnvironment env) throws ExecutionException {
        GoModuleBasedConfiguration configuration = (GoModuleBasedConfiguration)this.getConfigurationModule();
        Module module = configuration.getModule();
        if (module == null) {
            throw new ExecutionException(GoBundle.message((String)"go.execution.go.is.not.configured.error", (Object[])new Object[]{this.getName()}));
        }
        RunningState RunningState = this.newRunningState(env, module);
        if (RunningState == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(15);
        }
        return RunningState;
    }

    @Nullable
    protected VirtualFile findFile(@NotNull String filePath) {
        VirtualFile virtualFile;
        if (filePath == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(16);
        }
        if ((virtualFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)filePath))) == null) {
            String path = FileUtil.join((String[])new String[]{this.getWorkingDirectory(), filePath});
            virtualFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)path));
        }
        return virtualFile;
    }

    public boolean canRunOn(@NotNull TargetEnvironmentConfiguration target) {
        if (target == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(17);
        }
        return false;
    }

    @Nullable
    public LanguageRuntimeType<?> getDefaultLanguageRuntimeType() {
        GoModuleBasedConfiguration configuration = (GoModuleBasedConfiguration)this.getConfigurationModule();
        if (configuration != null && GoWslUtil.getWsl(configuration.getProject()) != null) {
            return null;
        }
        return (LanguageRuntimeType)LanguageRuntimeType.EXTENSION_NAME.findExtension(GoLanguageRuntimeType.class);
    }

    @Nullable
    public String getDefaultTargetName() {
        return this.getOptions().getRemoteTarget();
    }

    public void setDefaultTargetName(@Nullable String targetName) {
        this.getOptions().setRemoteTarget(targetName);
    }

    @NotNull
    protected abstract RunningState newRunningState(ExecutionEnvironment var1, Module var2);

    @NotNull
    public String getGoToolParams() {
        String string = this.myGoToolsParams;
        if (string == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public String getParams() {
        String string = this.myParams;
        if (string == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(19);
        }
        return string;
    }

    public void setGoToolParams(@NotNull @NonNls String params) {
        if (params == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(20);
        }
        this.myGoToolsParams = params;
    }

    public void setParams(@NotNull @NonNls String params) {
        if (params == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(21);
        }
        this.myParams = params;
    }

    @NotNull
    public Map<String, String> getCustomEnvironment() {
        Map<String, String> map = this.myCustomEnvironment;
        if (map == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(22);
        }
        return map;
    }

    public void setCustomEnvironment(@NotNull Map<String, String> customEnvironment) {
        if (customEnvironment == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(23);
        }
        this.myCustomEnvironment.clear();
        this.myCustomEnvironment.putAll(customEnvironment);
    }

    public void setPassParentEnvironment(boolean passParentEnvironment) {
        this.myPassParentEnvironment = passParentEnvironment;
    }

    public boolean isPassParentEnvironment() {
        return this.myPassParentEnvironment;
    }

    @NotNull
    public String getWorkingDirectory() {
        String string = this.myWorkingDirectory;
        if (string == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public String getWorkingDirectoryUrl() {
        String string = VfsUtilCore.pathToUrl((String)this.myWorkingDirectory);
        if (string == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(25);
        }
        return string;
    }

    public void setWorkingDirectory(@NotNull String workingDirectory) {
        if (workingDirectory == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(26);
        }
        this.myWorkingDirectory = workingDirectory;
    }

    public boolean isUseCustomBuildTags() {
        return this.myUseCustomBuildTags;
    }

    public void setUseCustomBuildTags(boolean useCustomBuildTags) {
        this.myUseCustomBuildTags = useCustomBuildTags;
    }

    public boolean isRunWithSudo() {
        return this.myRunWithSudo;
    }

    public void setRunWithSudo(boolean runWithSudo) {
        this.myRunWithSudo = runWithSudo;
    }

    public boolean supportsDelve() {
        return true;
    }

    @NotNull
    public GlobalSearchScope getConsoleScope() {
        GlobalSearchScope globalSearchScope = this.myConsoleScope;
        if (globalSearchScope == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(27);
        }
        return globalSearchScope;
    }

    public void setConsoleScope(@NotNull GlobalSearchScope consoleScope) {
        if (consoleScope == null) {
            GoRunConfigurationBase.$$$reportNull$$$0(28);
        }
        this.myConsoleScope = consoleScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 6, 15, 18, 19, 22, 24, 25, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 15: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/GoRunConfigurationBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customEnvironment";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/GoRunConfigurationBase";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestWorkingDirectory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidModules";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createRunningState";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoToolParams";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getParams";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomEnvironment";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectoryUrl";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestWorkingDirectory";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 15: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 27: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeNonEmptyField";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writeNonEmptyPathField";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readPathField";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "canRunOn";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setGoToolParams";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setParams";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setCustomEnvironment";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setWorkingDirectory";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setConsoleScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5, 6, 15, 18, 19, 22, 24, 25, 27 -> new IllegalStateException(string);
        };
    }
}

