/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution;

import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.sdk.GoPackageUtil;
import com.goide.util.GoGetPackageUtil;
import com.goide.util.GoPathResolveScope;
import com.goide.util.GoUtil;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoConsoleFilter
implements Filter,
DumbAware {
    private static final Pattern MESSAGE_PATTERN = Pattern.compile("(?:^|\\s)(?<slog>source=)?(?<filename>\\S+\\.\\w+):(?<line>\\d+)(:(?<col>\\d+))?(?=[:\\s]|$).*");
    private static final Pattern GO_GET_OR_INSTALL_CALL_PATTERN = Pattern.compile("^[ \t]*(?<call>go (?<cmd>get|install) (?<pkg>.*))\n?$");
    private static final Pattern APP_ENGINE_PATH_PATTERN = Pattern.compile("/tmp[A-z0-9]+appengine-go-bin/");
    private static final Pattern GO_FILE_PATTERN = Pattern.compile("\\((\\w+\\.go)\\)");
    @NotNull
    private final Project myProject;
    @Nullable
    private final Module myModule;
    @Nullable
    private final String myWorkingDirectoryUrl;
    @NotNull
    private Collection<GoPackage> myCurrentPackages;

    public GoConsoleFilter(@NotNull Project project) {
        if (project == null) {
            GoConsoleFilter.$$$reportNull$$$0(0);
        }
        this(project, null, null);
    }

    public GoConsoleFilter(@NotNull Project project, @Nullable Module module, @Nullable String workingDirectoryUrl) {
        if (project == null) {
            GoConsoleFilter.$$$reportNull$$$0(1);
        }
        this.myCurrentPackages = Collections.emptyList();
        this.myProject = project;
        this.myModule = module;
        this.myWorkingDirectoryUrl = (String)ObjectUtils.chooseNotNull((Object)workingDirectoryUrl, (Object)VfsUtilCore.pathToUrl((String)System.getProperty("user.dir")));
    }

    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Matcher goCmdMatcher;
        if (line == null) {
            GoConsoleFilter.$$$reportNull$$$0(2);
        }
        if ((goCmdMatcher = GO_GET_OR_INSTALL_CALL_PATTERN.matcher(line)).find() && this.myModule != null) {
            String packageName = goCmdMatcher.group("pkg").trim();
            String workingDirectory = this.myWorkingDirectoryUrl != null ? VfsUtilCore.urlToPath((String)this.myWorkingDirectoryUrl) : null;
            GoCommandHyperlinkInfo hyperlinkInfo = "install".equals(goCmdMatcher.group("cmd")) ? new GoInstallHyperlinkInfo(packageName, this.myModule, workingDirectory) : new GoGetHyperlinkInfo(packageName, this.myModule, workingDirectory);
            int lineStart = entireLength - line.length();
            return new Filter.Result(lineStart + goCmdMatcher.start("call"), lineStart + goCmdMatcher.end("call"), (HyperlinkInfo)hyperlinkInfo);
        }
        Matcher matcher = MESSAGE_PATTERN.matcher(line);
        if (!matcher.find()) {
            Matcher fileMatcher = GO_FILE_PATTERN.matcher(line);
            ArrayList<Filter.Result> resultItems = new ArrayList<Filter.Result>();
            while (fileMatcher.find()) {
                VirtualFile file = this.findSingleFile(fileMatcher.group(1));
                if (file == null) continue;
                resultItems.add(this.createResult(line, entireLength, fileMatcher.start(1), fileMatcher.end(1), 0, 0, file));
            }
            if (!resultItems.isEmpty()) {
                return new Filter.Result(resultItems);
            }
            if (line.startsWith("# ")) {
                ResolveState resolveState = GoPsiImplUtil.createContextOnElement((PsiElement)GoPsiUtil.findPsiDirectoryByUrl(this.myProject, this.myWorkingDirectoryUrl));
                Collection<GoPackage> packages = GoPackageUtil.findByImportPath(StringUtil.trimStart((String)line, (String)"# ").trim(), this.myProject, this.myModule, resolveState);
                if (!packages.isEmpty()) {
                    this.myCurrentPackages = packages;
                }
            }
            return null;
        }
        int startOffset = matcher.start("filename");
        int endOffset = Math.max(matcher.end("line"), matcher.end("col"));
        @NonNls String fileName = matcher.group("filename");
        int lineNumber = StringUtil.parseInt((String)matcher.group("line"), (int)1) - 1;
        if (lineNumber < 0) {
            return null;
        }
        int columnNumber = StringUtil.parseInt((String)matcher.group("col"), (int)1) - 1;
        Matcher appEnginePathMatcher = APP_ENGINE_PATH_PATTERN.matcher(fileName);
        if (appEnginePathMatcher.find()) {
            fileName = fileName.substring(appEnginePathMatcher.end());
        }
        VirtualFile virtualFile = null;
        if (OSAgnosticPathUtil.isAbsolute((String)fileName)) {
            virtualFile = ApplicationManager.getApplication().isUnitTestMode() ? TempFileSystem.getInstance().refreshAndFindFileByPath(fileName) : VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)fileName));
        } else {
            if (this.myWorkingDirectoryUrl != null) {
                virtualFile = VirtualFileManager.getInstance().findFileByUrl(this.myWorkingDirectoryUrl + "/" + fileName);
            }
            if (virtualFile == null) {
                for (GoPackage aPackage : this.myCurrentPackages) {
                    for (VirtualFile directory : aPackage.getDirectories()) {
                        virtualFile = directory.isValid() ? directory.findFileByRelativePath(fileName) : directory;
                        if (virtualFile == null) continue;
                        return this.createResult(line, entireLength, startOffset, endOffset, lineNumber, columnNumber, virtualFile);
                    }
                }
            }
            if (virtualFile == null && this.myModule != null && (virtualFile = this.findInGoPath(fileName)) == null && fileName.startsWith("src/")) {
                virtualFile = this.findInGoPath(StringUtil.trimStart((String)fileName, (String)"src/"));
            }
            if (virtualFile == null) {
                VirtualFile baseDir;
                VirtualFile virtualFile2 = baseDir = this.myProject.isDisposed() ? null : ProjectUtil.guessProjectDir((Project)this.myProject);
                if (baseDir != null && (virtualFile = baseDir.findFileByRelativePath(fileName)) == null && fileName.startsWith("src/")) {
                    virtualFile = baseDir.findFileByRelativePath(StringUtil.trimStart((String)fileName, (String)"src/"));
                }
            }
        }
        if (virtualFile == null) {
            virtualFile = this.findSingleFile(fileName);
        }
        if (virtualFile == null) {
            return null;
        }
        return this.createResult(line, entireLength, startOffset, endOffset, lineNumber, columnNumber, virtualFile);
    }

    @NotNull
    private Filter.Result createResult(@NotNull String line, int entireLength, int startOffset, int endOffset, int lineNumber, int columnNumber, @NotNull VirtualFile virtualFile) {
        if (line == null) {
            GoConsoleFilter.$$$reportNull$$$0(3);
        }
        if (virtualFile == null) {
            GoConsoleFilter.$$$reportNull$$$0(4);
        }
        OpenFileHyperlinkInfo hyperlinkInfo = new OpenFileHyperlinkInfo(this.myProject, virtualFile, lineNumber, columnNumber);
        int lineStart = entireLength - line.length();
        return new Filter.Result(lineStart + startOffset, lineStart + endOffset, (HyperlinkInfo)hyperlinkInfo);
    }

    @Nullable
    private VirtualFile findSingleFile(@NotNull String fileName) {
        if (fileName == null) {
            GoConsoleFilter.$$$reportNull$$$0(5);
        }
        if (PathUtil.isValidFileName((String)fileName)) {
            Collection files = FilenameIndex.getVirtualFilesByName((String)fileName, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
            if (files.size() == 1) {
                return (VirtualFile)ContainerUtil.getFirstItem((Collection)files);
            }
            if (!files.isEmpty()) {
                GlobalSearchScope goPathScope = GoPathResolveScope.create(this.myProject, this.myModule, null);
                if ((files = ContainerUtil.filter((Collection)files, arg_0 -> ((GlobalSearchScope)goPathScope).accept(arg_0))).size() == 1) {
                    return (VirtualFile)ContainerUtil.getFirstItem((Collection)files);
                }
            }
            if (!files.isEmpty()) {
                GlobalSearchScope smallerScope = GoUtil.moduleScopeWithoutLibraries(this.myProject, this.myModule);
                if ((files = ContainerUtil.filter((Collection)files, arg_0 -> ((GlobalSearchScope)smallerScope).accept(arg_0))).size() == 1) {
                    return (VirtualFile)ContainerUtil.getFirstItem((Collection)files);
                }
            }
        }
        return null;
    }

    @Nullable
    private VirtualFile findInGoPath(@NotNull String fileName) {
        if (fileName == null) {
            GoConsoleFilter.$$$reportNull$$$0(6);
        }
        return GoPackageUtil.findFileByImportPath(fileName, this.myProject, this.myModule);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        objectArray2[1] = "com/goide/execution/GoConsoleFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFilter";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createResult";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findSingleFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findInGoPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class GoInstallHyperlinkInfo
    extends GoCommandHyperlinkInfo {
        public GoInstallHyperlinkInfo(@NotNull String toolImportPath, @NotNull Module module, @Nullable String workingDirectory) {
            if (toolImportPath == null) {
                GoInstallHyperlinkInfo.$$$reportNull$$$0(0);
            }
            if (module == null) {
                GoInstallHyperlinkInfo.$$$reportNull$$$0(1);
            }
            super(toolImportPath, module, workingDirectory);
        }

        public void navigate(@NotNull Project project) {
            if (project == null) {
                GoInstallHyperlinkInfo.$$$reportNull$$$0(2);
            }
            GoGetPackageUtil.installTool(project, this.myModule, this.myWorkingDirectory, this.myToolImportPath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolImportPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/goide/execution/GoConsoleFilter$GoInstallHyperlinkInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "navigate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class GoGetHyperlinkInfo
    extends GoCommandHyperlinkInfo {
        public GoGetHyperlinkInfo(@NotNull String toolImportPath, @NotNull Module module, @Nullable String workingDirectory) {
            if (toolImportPath == null) {
                GoGetHyperlinkInfo.$$$reportNull$$$0(0);
            }
            if (module == null) {
                GoGetHyperlinkInfo.$$$reportNull$$$0(1);
            }
            super(toolImportPath, module, workingDirectory);
        }

        public void navigate(@NotNull Project project) {
            if (project == null) {
                GoGetHyperlinkInfo.$$$reportNull$$$0(2);
            }
            GoGetPackageUtil.installTool(project, this.myModule, this.myWorkingDirectory, this.myToolImportPath, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolImportPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/goide/execution/GoConsoleFilter$GoGetHyperlinkInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "navigate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    public static abstract class GoCommandHyperlinkInfo
    implements HyperlinkInfo {
        protected final String myToolImportPath;
        protected final Module myModule;
        protected final String myWorkingDirectory;

        protected GoCommandHyperlinkInfo(@NotNull String toolImportPath, @NotNull Module module, @Nullable String workingDirectory) {
            if (toolImportPath == null) {
                GoCommandHyperlinkInfo.$$$reportNull$$$0(0);
            }
            if (module == null) {
                GoCommandHyperlinkInfo.$$$reportNull$$$0(1);
            }
            this.myToolImportPath = toolImportPath;
            this.myModule = module;
            this.myWorkingDirectory = workingDirectory;
        }

        @NotNull
        public String getToolImportPath() {
            String string = this.myToolImportPath;
            if (string == null) {
                GoCommandHyperlinkInfo.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolImportPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/execution/GoConsoleFilter$GoCommandHyperlinkInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/execution/GoConsoleFilter$GoCommandHyperlinkInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolImportPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

