/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution;

import com.goide.GoNotifications;
import com.goide.dlv.DlvSettings;
import com.goide.dlv.DlvVm;
import com.goide.execution.GoBuildResultKey;
import com.goide.execution.GoBuildingRunConfiguration;
import com.goide.execution.GoBuildingRunner;
import com.goide.execution.GoConsoleFilter;
import com.goide.execution.GoPathProximityComparator;
import com.goide.execution.GoRunUtil;
import com.goide.execution.GoRunningState;
import com.goide.execution.GoWslUtil;
import com.goide.execution.application.GoNopProcessHandler;
import com.goide.execution.target.GoLanguageRuntimeType;
import com.goide.i18n.GoBundle;
import com.goide.project.GoModuleSettings;
import com.goide.psi.impl.GoPackage;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.util.GoCommandLineParameter;
import com.goide.util.GoExecutor;
import com.goide.util.GoHistoryProcessListener;
import com.google.common.base.Suppliers;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ElevationService;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.execution.wsl.target.WslTargetEnvironmentRequest;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.net.NetUtils;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public abstract class GoBuildingRunningState<T extends GoBuildingRunConfiguration<? extends GoBuildingRunningState<T>>>
extends GoRunningState<T> {
    @NonNls
    private static final String SUPPRESS_CGO_CFLAGS_DEBUG_WARNING = "go.suppress.cgo_cflags.debug.warning";
    private static final Logger LOG = Logger.getInstance(GoBuildingRunningState.class);
    protected int myCompilationExitCode;
    protected @NotNull Supplier<@Nullable String> myOutputFilePath;
    protected String myCoverageLocation;
    protected GoCommandLineParameter myCoverageLocationParameter;
    @Nullable
    private GoHistoryProcessListener myHistoryProcessHandler;
    @Nullable
    private InetSocketAddress myDebugAddress;

    public GoBuildingRunningState(@NotNull ExecutionEnvironment env, @NotNull Module module, @NotNull T configuration) {
        if (env == null) {
            GoBuildingRunningState.$$$reportNull$$$0(0);
        }
        if (module == null) {
            GoBuildingRunningState.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            GoBuildingRunningState.$$$reportNull$$$0(2);
        }
        super(env, module, configuration);
        this.myOutputFilePath = Suppliers.ofInstance(null);
    }

    @Nullable
    public abstract List<GoCommandLineParameter> getBuildingTarget();

    @Nullable
    public GoBuildResultKey getBuildResultKey() {
        List<GoCommandLineParameter> buildingTarget = this.getBuildingTarget();
        if (buildingTarget == null || this.isBuildOnRemoteTarget()) {
            return null;
        }
        ArrayList<String> parameters = new ArrayList<String>(ContainerUtil.map(buildingTarget, p -> p.toPresentableString()));
        parameters.add(this.getGoBuildParams());
        Collections.addAll(parameters, this.getAdditionalBuildParams());
        return new GoBuildResultKey(this.getClass().getSimpleName(), ((GoBuildingRunConfiguration)this.myConfiguration).getName(), parameters, this.getGoBuildEnvironment(), ((GoBuildingRunConfiguration)this.myConfiguration).isPassParentEnvironment(), this.getBuildingWorkingDirectory());
    }

    private Map<String, String> getGoBuildEnvironment() {
        if (this.myModule == null) {
            return ((GoBuildingRunConfiguration)this.myConfiguration).getCustomEnvironment();
        }
        String[] buildTargetExperiments = GoModuleSettings.getInstance((Module)this.myModule).getBuildTargetSettings().experiments;
        if (buildTargetExperiments.length == 0) {
            return ((GoBuildingRunConfiguration)this.myConfiguration).getCustomEnvironment();
        }
        LinkedHashMap<String, String> env = new LinkedHashMap<String, String>(((GoBuildingRunConfiguration)this.myConfiguration).getCustomEnvironment());
        String newGoExperimentValue = GoExecutor.mergeGoExperiments(env.getOrDefault("GOEXPERIMENT", ""), buildTargetExperiments);
        env.put("GOEXPERIMENT", newGoExperimentValue);
        return env;
    }

    public GoExecutor createBuildExecutor() throws ExecutionException {
        String buildingWorkingDirectory = this.getBuildingWorkingDirectory();
        GoExecutor result = this.patchCommandLine(this.createBuildExecutorInner().withWorkDirectory(buildingWorkingDirectory), GoRunningState.CommandLineType.BUILD);
        if (!this.isBuildOnRemoteTarget()) {
            result.withTargetEnvironmentRequest(null);
        } else {
            String configuredRoot = ((GoBuildingRunConfiguration)this.myConfiguration).getRootDirectory();
            if (configuredRoot != null) {
                result.withRootDirectory(() -> {
                    VirtualFile contentRoot = this.getContentRoot();
                    VirtualFile configuredRootFile = LocalFileSystem.getInstance().findFileByPath(configuredRoot);
                    if (contentRoot == null && configuredRootFile == null) {
                        return null;
                    }
                    String root = contentRoot == null || configuredRootFile != null && VfsUtilCore.isAncestor((VirtualFile)configuredRootFile, (VirtualFile)contentRoot, (boolean)true) ? configuredRoot : contentRoot.getPath();
                    return GoCommandLineParameter.path(root).withVolumeDescriptor(GoLanguageRuntimeType.PROJECT_SOURCES_VOLUME);
                });
            }
        }
        if (this.isDebug()) {
            final String customCgoCflags = this.getCgoCflags();
            if (customCgoCflags == null) {
                result.withExtraEnvironment(Map.of("CGO_CFLAGS", "-O0 -g"));
            } else {
                DlvVm.LOG.debug(String.format("Executable was built with CGO_CFLAGS=%s, cgo code could be optimized.", customCgoCflags));
                if (this.shouldShowCgoCflagsWarning()) {
                    result.withProcessListener(new ProcessListener(){

                        public void processTerminated(@NotNull ProcessEvent event) {
                            if (event == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (!(event.getExitCode() != 0 || GoBuildingRunningState.containsOption(customCgoCflags, "-g") && GoBuildingRunningState.containsOption(customCgoCflags, "-O0"))) {
                                Project project = GoBuildingRunningState.this.myEnvironment.getProject();
                                GoNotifications.getGeneralGroup().createNotification(GoBundle.message((String)"go.notification.cgo.optimizations.are.not.disabled", (Object[])new Object[0]), MessageType.WARNING).addAction((AnAction)new GoBuildingRunner.GoDoNotShowNotificationAction(project, GoBuildingRunningState.SUPPRESS_CGO_CFLAGS_DEBUG_WARNING)).notify(project);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/goide/execution/GoBuildingRunningState$1", "processTerminated"));
                        }
                    });
                }
            }
        }
        return result.withParameterString(this.getGoBuildParams());
    }

    @Override
    @NotNull
    protected GoExecutor createCommonExecutor() throws ExecutionException {
        Supplier<GoCommandLineParameter> rootDirectory = () -> (GoCommandLineParameter)ObjectUtils.doIfNotNull((Object)this.getContentRoot(), root -> GoCommandLineParameter.path(root.getPath()).withVolumeDescriptor(GoLanguageRuntimeType.PROJECT_SOURCES_VOLUME));
        GoExecutor goExecutor = super.createCommonExecutor().withRootDirectory(rootDirectory);
        if (goExecutor == null) {
            GoBuildingRunningState.$$$reportNull$$$0(3);
        }
        return goExecutor;
    }

    @Nullable
    protected VirtualFile getContentRoot() {
        return (VirtualFile)ReadAction.compute(() -> (VirtualFile)ObjectUtils.doIfNotNull((Object)LocalFileSystem.getInstance().findFileByPath(this.getBuildingWorkingDirectory()), buildDir -> ProjectFileIndex.getInstance((Project)((GoBuildingRunConfiguration)this.myConfiguration).getProject()).getContentRootForFile(buildDir)));
    }

    private boolean isBuildOnRemoteTarget() {
        return ((GoBuildingRunConfiguration)this.myConfiguration).isBuildOnRemoteTarget() || GoWslUtil.isInWsl(GoSdkService.getInstance(this.myEnvironment.getProject()).getSdk(this.myModule));
    }

    private boolean shouldShowCgoCflagsWarning() {
        return !PropertiesComponent.getInstance((Project)this.myEnvironment.getProject()).getBoolean(SUPPRESS_CGO_CFLAGS_DEBUG_WARNING);
    }

    public void setCoverageLocation(@Nullable String coverageFile) {
        this.myCoverageLocation = coverageFile;
    }

    private static boolean containsOption(@NotNull String flags, @NotNull String option) {
        if (flags == null) {
            GoBuildingRunningState.$$$reportNull$$$0(4);
        }
        if (option == null) {
            GoBuildingRunningState.$$$reportNull$$$0(5);
        }
        return flags.contains(option + " ") || flags.endsWith(option);
    }

    @Nullable
    private String getCgoCflags() {
        String cgoCflagsInParentEnvironment = ((GoBuildingRunConfiguration)this.myConfiguration).isPassParentEnvironment() ? (String)EnvironmentUtil.getEnvironmentMap().get("CGO_CFLAGS") : null;
        return ((GoBuildingRunConfiguration)this.myConfiguration).getCustomEnvironment().getOrDefault("CGO_CFLAGS", cgoCflagsInParentEnvironment);
    }

    @NotNull
    protected GoCommandLineParameter getCoverageFilePathParameter(@NotNull GoExecutor executor) {
        GoBuildingRunner.DownloadFromTargetParameter coverageFilePathParameter;
        if (executor == null) {
            GoBuildingRunningState.$$$reportNull$$$0(6);
        }
        if (this.myCoverageLocationParameter != null) {
            GoCommandLineParameter goCommandLineParameter = this.myCoverageLocationParameter;
            if (goCommandLineParameter == null) {
                GoBuildingRunningState.$$$reportNull$$$0(7);
            }
            return goCommandLineParameter;
        }
        Path localPath = Path.of(this.myCoverageLocation, new String[0]);
        if (GoBuildingRunner.isLocalExecutor(executor)) {
            coverageFilePathParameter = GoBuildingRunner.DownloadFromTargetParameter.forFullPath(localPath);
        } else {
            String fileName = localPath.getFileName().toString();
            coverageFilePathParameter = GoBuildingRunner.DownloadFromTargetParameter.forLanguageRuntime(fileName, null, localPath.getParent());
        }
        this.myCoverageLocationParameter = coverageFilePathParameter;
        if (this.myCoverageLocationParameter == null) {
            GoBuildingRunningState.$$$reportNull$$$0(8);
        }
        return this.myCoverageLocationParameter;
    }

    public void processReport(@NotNull Runnable afterConversion) {
        if (afterConversion == null) {
            GoBuildingRunningState.$$$reportNull$$$0(9);
        }
        this.downloadReport(afterConversion);
    }

    private void downloadReport(@NotNull Runnable afterConversion) {
        TargetValue value2;
        if (afterConversion == null) {
            GoBuildingRunningState.$$$reportNull$$$0(10);
        }
        if ((value2 = (TargetValue)ObjectUtils.doIfNotNull((Object)this.myCoverageLocationParameter, GoCommandLineParameter::toValue)) != null) {
            Promise localValue = value2.getLocalValue();
            localValue.onError(e -> LOG.error("Couldn't download coverage report", e));
            localValue.onProcessed(result -> afterConversion.run());
        } else {
            afterConversion.run();
        }
    }

    protected abstract GoExecutor createBuildExecutorInner() throws ExecutionException;

    public boolean isBuildable() {
        return ((GoBuildingRunConfiguration)((Object)this.getConfiguration())).isBuildable();
    }

    @NotNull
    protected String getCoverPkgString(@NotNull String workingDirectory) {
        if (workingDirectory == null) {
            GoBuildingRunningState.$$$reportNull$$$0(11);
        }
        if (this.myModule == null) {
            return "";
        }
        String basePath = FileUtil.toSystemDependentName((String)FileUtil.toCanonicalPath((String)workingDirectory));
        List paths = ContainerUtil.mapNotNull((Object[])ModuleRootManager.getInstance((Module)this.myModule).getContentRoots(), root -> {
            String relativePath = FileUtil.getRelativePath((String)basePath, (String)FileUtil.toSystemDependentName((String)FileUtil.toCanonicalPath((String)root.getPath())), (char)File.separatorChar);
            return relativePath != null ? FileUtil.toSystemIndependentName((String)(relativePath + "/...")) : null;
        });
        String string = StringUtil.join((Collection)paths, (String)",").trim();
        if (string == null) {
            GoBuildingRunningState.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public String getGoBuildParams() {
        String buildTags;
        @NotNull List params = ParametersListUtil.parse((String)ProgramParametersConfigurator.expandMacros((String)((GoBuildingRunConfiguration)this.myConfiguration).getGoToolParams()), (boolean)false, (boolean)true);
        if (this.myModule != null && ((GoBuildingRunConfiguration)this.myConfiguration).isUseCustomBuildTags() && !GoRunUtil.hasTagsParameter(params) && !(buildTags = StringUtil.join((String[])GoModuleSettings.getInstance((Module)this.myModule).getBuildTargetSettings().customFlags, (String)" ")).isEmpty()) {
            params.add("-tags");
            params.add(buildTags);
        }
        if (this.isDebug() && DlvSettings.getInstance().getRebuildTransitivePackages() && GoSdkService.getInstance(this.myEnvironment.getProject()).getSdk(this.myModule).requiredTransitivePackagesRebuildOnDebug()) {
            String string = GoRunUtil.filterOutInstallParameter(params);
            if (string == null) {
                GoBuildingRunningState.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = ParametersListUtil.join((List)params);
        if (string == null) {
            GoBuildingRunningState.$$$reportNull$$$0(14);
        }
        return string;
    }

    public @NonNls String @NotNull [] getAdditionalBuildParams() {
        if (this.isDebug()) {
            GoSdk sdk = GoSdkService.getInstance(this.myEnvironment.getProject()).getSdk(this.myModule);
            if (sdk.supportsPatternBasedCachingStrategy()) {
                String[] stringArray = new String[]{"-gcflags", "all=-N -l"};
                if (stringArray == null) {
                    GoBuildingRunningState.$$$reportNull$$$0(15);
                }
                return stringArray;
            }
            if (DlvSettings.getInstance().getRebuildTransitivePackages() && sdk.requiredTransitivePackagesRebuildOnDebug()) {
                String[] stringArray = new String[]{"-gcflags", "-N -l", "-a"};
                if (stringArray == null) {
                    GoBuildingRunningState.$$$reportNull$$$0(16);
                }
                return stringArray;
            }
            String[] stringArray = new String[]{"-gcflags", "-N -l"};
            if (stringArray == null) {
                GoBuildingRunningState.$$$reportNull$$$0(17);
            }
            return stringArray;
        }
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            GoBuildingRunningState.$$$reportNull$$$0(18);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public void setOutputFilePath(@NotNull Supplier<String> outputFilePath) {
        if (outputFilePath == null) {
            GoBuildingRunningState.$$$reportNull$$$0(19);
        }
        this.myOutputFilePath = Suppliers.memoize(outputFilePath::get);
    }

    public void setOutputFilePath(@Nullable String outputFilePath) {
        this.setOutputFilePath((Supplier<String>)Suppliers.ofInstance((Object)outputFilePath));
    }

    public void setHistoryProcessHandler(@Nullable GoHistoryProcessListener historyProcessHandler) {
        this.myHistoryProcessHandler = historyProcessHandler;
    }

    @Override
    @NotNull
    public InetSocketAddress getDebugServerAddress() throws ExecutionException {
        if (this.myDebugAddress == null) {
            try {
                InetAddress localhost = this.resolveLocalAddress();
                this.myDebugAddress = new InetSocketAddress(localhost, NetUtils.findAvailableSocketPort());
            }
            catch (UnknownHostException e) {
                DlvVm.LOG.warn("Cannot resolve localhost", (Throwable)e);
                throw new ExecutionException(GoBundle.message((String)"go.debugger.cannot.resolve.localhost", (Object[])new Object[0]), (Throwable)e);
            }
            catch (IOException e) {
                DlvVm.LOG.warn("Cannot find free port", (Throwable)e);
                throw new ExecutionException(GoBundle.message((String)"go.debugger.cannot.find.free.port", (Object[])new Object[0]), (Throwable)e);
            }
        }
        InetSocketAddress inetSocketAddress = this.myDebugAddress;
        if (inetSocketAddress == null) {
            GoBuildingRunningState.$$$reportNull$$$0(20);
        }
        return inetSocketAddress;
    }

    private InetAddress resolveLocalAddress() throws UnknownHostException {
        TargetEnvironmentRequest runner;
        try {
            runner = this.getTargetEnvironmentRequest();
        }
        catch (ExecutionException ignored) {
            runner = null;
        }
        boolean preferIpv6 = runner instanceof WslTargetEnvironmentRequest && Registry.is((String)"go.debugger.prefer.ipv6.for.wsl.run.target");
        return GoRunUtil.resolveLocalAddress(preferIpv6);
    }

    public void setCompilationExitCode(int compilationExitCode) {
        this.myCompilationExitCode = compilationExitCode;
    }

    @Override
    @Nullable
    protected ConsoleView createConsole(@NotNull Executor executor, @NotNull ProcessHandler processHandler) throws ExecutionException {
        if (executor == null) {
            GoBuildingRunningState.$$$reportNull$$$0(21);
        }
        if (processHandler == null) {
            GoBuildingRunningState.$$$reportNull$$$0(22);
        }
        ConsoleView console = this.createConsoleInner(executor, processHandler);
        if (this.myHistoryProcessHandler != null && console != null) {
            UIUtil.invokeLaterIfNeeded(() -> {
                String buildingWorkingDirectory = this.getBuildingWorkingDirectory();
                if (!buildingWorkingDirectory.equals(((GoBuildingRunConfiguration)this.myConfiguration).getWorkingDirectory())) {
                    String url = VfsUtilCore.pathToUrl((String)buildingWorkingDirectory);
                    console.addMessageFilter((Filter)new GoConsoleFilter(((GoBuildingRunConfiguration)this.myConfiguration).getProject(), this.myModule, url));
                }
                this.myHistoryProcessHandler.apply(console);
            });
        }
        return console;
    }

    protected GoExecutor addCommonCoverageFlags(GoExecutor executor) {
        String workingDirectory;
        String packages;
        if (GoSdkService.getInstance(this.myEnvironment.getProject()).getSdk(this.myModule).supportsMultiPackageCoverage() && !(packages = this.getCoverPkgString(workingDirectory = this.getBuildingWorkingDirectory())).isEmpty()) {
            executor.withParameters("-coverpkg=" + packages);
        }
        return executor.withParameters("-covermode=atomic");
    }

    @NotNull
    public String getBuildingWorkingDirectory() {
        String string = switch (((GoBuildingRunConfiguration)this.myConfiguration).getKind()) {
            default -> throw new IncompatibleClassChangeError();
            case GoBuildingRunConfiguration.Kind.DIRECTORY -> ((GoBuildingRunConfiguration)this.myConfiguration).getDirectoryPath();
            case GoBuildingRunConfiguration.Kind.PACKAGE -> {
                Optional firstDirectory = StreamEx.of(((GoBuildingRunConfiguration)this.myConfiguration).getContextPackages()).flatCollection(GoPackage::getDirectories).min((Comparator)new GoPathProximityComparator(((GoBuildingRunConfiguration)this.myConfiguration).getWorkingDirectory()));
                if (firstDirectory.isPresent()) {
                    yield ((VirtualFile)firstDirectory.get()).getPath();
                }
                yield ((GoBuildingRunConfiguration)this.myConfiguration).getWorkingDirectory();
            }
            case GoBuildingRunConfiguration.Kind.FILE -> {
                VirtualFile file;
                String firstFilePath = (String)ContainerUtil.getFirstItem(((GoBuildingRunConfiguration)this.myConfiguration).getFilePaths());
                VirtualFile v1 = file = firstFilePath != null ? LocalFileSystem.getInstance().findFileByPath(firstFilePath) : null;
                if (file != null && file.getParent() != null) {
                    yield file.getParent().getPath();
                }
                yield ((GoBuildingRunConfiguration)this.myConfiguration).getWorkingDirectory();
            }
        };
        if (string == null) {
            GoBuildingRunningState.$$$reportNull$$$0(23);
        }
        return string;
    }

    @Nullable
    protected ConsoleView createConsoleInner(@NotNull Executor executor, @NotNull ProcessHandler processHandler) throws ExecutionException {
        if (executor == null) {
            GoBuildingRunningState.$$$reportNull$$$0(24);
        }
        if (processHandler == null) {
            GoBuildingRunningState.$$$reportNull$$$0(25);
        }
        return super.createConsole(executor, processHandler);
    }

    @Override
    @NotNull
    public ProcessHandler startProcess() throws ExecutionException {
        ProcessHandler processHandler;
        if (!(!this.isBuildable() || this.myCompilationExitCode == 0 && ((GoBuildingRunConfiguration)this.myConfiguration).isRunnable() && this.myOutputFilePath.get() != null && new File(Objects.requireNonNull(this.myOutputFilePath.get())).canExecute())) {
            processHandler = new GoNopProcessHandler(this.myCompilationExitCode);
            String message = "\n" + GoBundle.message((String)"go.execution.compilation.finished.with.exit.code", (Object[])new Object[0]) + "\n";
            if (this.myCompilationExitCode == 0 && ((GoBuildingRunConfiguration)this.myConfiguration).isRunnable() && this.myOutputFilePath.get() != null) {
                message = message + "\n" + GoBundle.message((String)"go.execution.compiled.binary.cannot.be.executed", (Object[])new Object[0]) + "\n";
            }
            if (this.myCompilationExitCode == 0 && ((GoBuildingRunConfiguration)this.myConfiguration).isRunnable()) {
                LOG.debug("Build result had not been downloaded from target: ");
            }
            ProcessTerminatedListener.attach((ProcessHandler)processHandler, (Project)((GoBuildingRunConfiguration)this.myConfiguration).getProject(), (String)message);
        } else {
            processHandler = super.startProcess();
        }
        processHandler.addProcessListener(new ProcessListener(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                String text;
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((text = event.getText()) == null) {
                    return;
                }
                if (outputType == ProcessOutputTypes.STDERR && text.startsWith("could not launch process") && text.contains("\"lldb-server\"")) {
                    GoBuildingRunningState.this.show();
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (GoBuildingRunningState.this.myCompilationExitCode != 0) {
                    GoBuildingRunningState.this.showBuildFailedNotification();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/goide/execution/GoBuildingRunningState$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 == null) {
            GoBuildingRunningState.$$$reportNull$$$0(26);
        }
        return processHandler2;
    }

    private void showBuildFailedNotification() {
        ApplicationManager.getApplication().invokeLater(() -> {
            Project project = this.myEnvironment.getProject();
            if (!project.isDisposed()) {
                NotificationGroup notificationGroup = this.isDebug() ? GoNotifications.getDebugGroup() : GoNotifications.getExecutionGroup();
                GoRunUtil.showNotification(GoBundle.message((String)"go.execution.compilation.failed.notification.title", (Object[])new Object[0]), "", NotificationType.ERROR, notificationGroup, project);
            }
        });
    }

    private void show() {
        ApplicationManager.getApplication().invokeLater(() -> {
            Project project = this.myEnvironment.getProject();
            if (!project.isDisposed()) {
                GoRunUtil.showNotification("", GoBundle.message((String)"go.execution.install.lldb.notification.text", (Object[])new Object[0]), NotificationType.ERROR, GoNotifications.getDebugGroup(), project);
            }
        });
    }

    @Override
    protected GoExecutor createRunExecutor() throws ExecutionException {
        GoCommandLineParameter builtExePath = (GoCommandLineParameter)ObjectUtils.doIfNotNull((Object)this.myOutputFilePath.get(), p -> GoCommandLineParameter.path(p).withVolumeDescriptor(GoLanguageRuntimeType.COMPILED_EXECUTABLES_VOLUME));
        GoExecutor executor = this.isDebug() && builtExePath != null ? this.createDelveExecutor().withParameters(GoCommandLineParameter.string("exec"), builtExePath, GoCommandLineParameter.string("--")) : super.createRunExecutor().showGoEnvVariables(false).withExePath(builtExePath);
        boolean isElevationServiceAvailable = ElevationService.getInstance().isAvailable();
        return ((GoBuildingRunConfiguration)this.myConfiguration).isRunWithSudo() && isElevationServiceAvailable ? executor.withSudo() : executor;
    }

    @Override
    @NotNull
    public Module getModule() {
        Module module = Objects.requireNonNull(super.getModule());
        if (module == null) {
            GoBuildingRunningState.$$$reportNull$$$0(27);
        }
        return module;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 8, 12, 13, 14, 15, 16, 17, 18, 20, 23, 26, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 23: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/GoBuildingRunningState";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flags";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 6: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterConversion";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFilePath";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/GoBuildingRunningState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommonExecutor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageFilePathParameter";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverPkgString";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoBuildParams";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalBuildParams";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugServerAddress";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildingWorkingDirectory";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 23: 
            case 26: 
            case 27: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "containsOption";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCoverageFilePathParameter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processReport";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "downloadReport";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCoverPkgString";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setOutputFilePath";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleInner";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 8, 12, 13, 14, 15, 16, 17, 18, 20, 23, 26, 27 -> new IllegalStateException(string);
        };
    }
}

