/*
 * Decompiled with CFR 0.152.
 */
package com.goide.editor;

import com.goide.GoParserDefinition;
import com.goide.GoTypes;
import com.goide.completion.GoCompletionUtil;
import com.goide.completion.GoPackageInsertHandler;
import com.goide.directiveComment.GoEmbedComment;
import com.goide.editor.GoEditorUtil;
import com.goide.psi.GoCaseClause;
import com.goide.psi.GoFile;
import com.goide.psi.GoImportDeclaration;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoResult;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarOrConstDeclaration;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.GoVarOrConstSpec;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.TypedActionImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.formatter.IndentRangesCalculator;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoTypedHandlers {
    private static void beginUndoablePostProcessing() {
        ((TypedActionImpl)TypedAction.getInstance()).getDefaultRawTypedHandler().beginUndoablePostProcessing();
    }

    private static boolean hasRParenAfter(@NotNull PsiElement element) {
        if (element == null) {
            GoTypedHandlers.$$$reportNull$$$0(0);
        }
        element = PsiTreeUtil.nextLeaf((PsiElement)element);
        while (element != null) {
            if (element instanceof PsiWhiteSpace || element instanceof PsiComment) {
                element = PsiTreeUtil.nextLeaf((PsiElement)element);
                continue;
            }
            return element.getNode().getElementType() == GoTypes.RPAREN;
        }
        return false;
    }

    @NotNull
    private static PsiElement getLastElementToIncludeIntoParens(@NotNull PsiElement spec) {
        if (spec == null) {
            GoTypedHandlers.$$$reportNull$$$0(1);
        }
        PsiElement result = null;
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)spec);
        while (nextLeaf != null) {
            if (nextLeaf instanceof PsiComment) {
                result = nextLeaf;
                if (nextLeaf.textContains('\n')) break;
                nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)nextLeaf);
                continue;
            }
            if (!(nextLeaf instanceof PsiWhiteSpace) || nextLeaf.textContains('\n')) break;
            result = nextLeaf;
            nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)nextLeaf);
        }
        PsiElement psiElement = result != null ? result : spec;
        if (psiElement == null) {
            GoTypedHandlers.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @Nullable
    private static CharSequence getIndent(@NotNull Document document, @Nullable PsiElement element) {
        if (document == null) {
            GoTypedHandlers.$$$reportNull$$$0(3);
        }
        if (element == null) {
            return null;
        }
        int startOffset = element.getTextRange().getStartOffset();
        List indentRanges = new IndentRangesCalculator(document, TextRange.from((int)startOffset, (int)0)).calcIndentRanges();
        TextRange indentRange = (TextRange)ContainerUtil.getOnlyItem((Collection)indentRanges);
        return indentRange != null && indentRange.getEndOffset() == startOffset ? document.getText(indentRange) : null;
    }

    @Nullable
    private static PsiElement getSpecAfter(@NotNull PsiFile file, int offset) {
        PsiElement result;
        if (file == null) {
            GoTypedHandlers.$$$reportNull$$$0(4);
        }
        return (result = GoTypedHandlers.getSpecAt(file, offset)) != null && offset <= result.getTextRange().getStartOffset() ? result : null;
    }

    @Nullable
    private static PsiElement getSpecAt(@NotNull PsiFile file, int offset) {
        PsiElement at;
        if (file == null) {
            GoTypedHandlers.$$$reportNull$$$0(5);
        }
        if ((at = file.findElementAt(offset)) == null) {
            return null;
        }
        PsiElement parent = at.getParent();
        if (parent instanceof GoVarOrConstDefinition) {
            GoVarOrConstSpec spec = (GoVarOrConstSpec)ObjectUtils.tryCast((Object)parent.getParent(), GoVarOrConstSpec.class);
            return GoTypedHandlers.isLastElementOnLine(spec) ? spec : null;
        }
        if (parent instanceof GoSpecType) {
            GoTypeSpec spec = (GoTypeSpec)ObjectUtils.tryCast((Object)parent.getParent(), GoTypeSpec.class);
            return GoTypedHandlers.isLastElementOnLine(spec) ? spec : null;
        }
        if (parent instanceof GoImportSpec || parent instanceof GoStringLiteral && parent.getParent() instanceof GoImportSpec) {
            return PsiTreeUtil.getParentOfType((PsiElement)at, GoImportSpec.class);
        }
        if (at instanceof PsiWhiteSpace) {
            if (parent instanceof GoVarOrConstDeclaration) {
                PsiElement next = !at.textContains('\n') ? GoTypedHandlers.skipSpacesForwardOnSameLine(at) : null;
                GoVarOrConstSpec spec = (GoVarOrConstSpec)ObjectUtils.tryCast((Object)next, GoVarOrConstSpec.class);
                return GoTypedHandlers.isLastElementOnLine(spec) ? spec : null;
            }
            if (parent instanceof GoTypeDeclaration) {
                PsiElement next = !at.textContains('\n') ? GoTypedHandlers.skipSpacesForwardOnSameLine(at) : null;
                GoTypeSpec spec = (GoTypeSpec)ObjectUtils.tryCast((Object)next, GoTypeSpec.class);
                return GoTypedHandlers.isLastElementOnLine(spec) ? spec : null;
            }
            if (parent instanceof GoImportDeclaration) {
                PsiElement next = PsiTreeUtil.skipWhitespacesForward((PsiElement)at);
                return (PsiElement)ObjectUtils.tryCast((Object)next, GoImportSpec.class);
            }
        }
        return null;
    }

    private static boolean isLastElementOnLine(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement result = PsiTreeUtil.nextLeaf((PsiElement)element);
        while (result != null) {
            if (result instanceof PsiWhiteSpace || result instanceof PsiComment) {
                if (result.textContains('\n')) {
                    return true;
                }
            } else {
                return false;
            }
            result = PsiTreeUtil.nextLeaf((PsiElement)result);
        }
        return true;
    }

    @Nullable
    private static PsiElement skipSpacesForwardOnSameLine(@Nullable PsiElement element) {
        PsiElement result;
        PsiElement psiElement = result = element != null ? element.getNextSibling() : null;
        while (result != null && result instanceof PsiWhiteSpace) {
            if (result.textContains('\n')) {
                return null;
            }
            result = result.getNextSibling();
        }
        return result;
    }

    private static boolean isBracket(char c) {
        return c == '{' || c == '(' || c == '[';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/editor/GoTypedHandlers";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/editor/GoTypedHandlers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastElementToIncludeIntoParens";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasRParenAfter";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLastElementToIncludeIntoParens";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIndent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSpecAfter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSpecAt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static final class ParenBlockInfo {
        private final int keywordEndOffset;
        private final int specOffset;
        private final int contentLength;
        private final CharSequence indent;

        private ParenBlockInfo(int keywordEndOffset, int specOffset, int contentLength, @NotNull CharSequence indent) {
            if (indent == null) {
                ParenBlockInfo.$$$reportNull$$$0(0);
            }
            this.keywordEndOffset = keywordEndOffset;
            this.specOffset = specOffset;
            this.contentLength = contentLength;
            this.indent = indent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indent", "com/goide/editor/GoTypedHandlers$ParenBlockInfo", "<init>"));
        }
    }

    public static final class GoBraceHandler
    extends TypedHandlerDelegate {
        private boolean myNeedComma = false;
        private ParenBlockInfo myParenBlockInfo;
        private Integer myLParenBeforeTypeOffset;

        @NotNull
        public TypedHandlerDelegate.Result beforeSelectionRemoved(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            int offset;
            if (project == null) {
                GoBraceHandler.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                GoBraceHandler.$$$reportNull$$$0(1);
            }
            if (file == null) {
                GoBraceHandler.$$$reportNull$$$0(2);
            }
            SelectionModel selectionModel = editor.getSelectionModel();
            if (c == '<' && file instanceof GoFile && CodeInsightSettings.getInstance().SURROUND_SELECTION_ON_QUOTE_TYPED && selectionModel.hasSelection()) {
                GoEditorUtil.commitDocument(project, editor.getDocument());
                PsiElement element = PsiTreeUtil.getNonStrictParentOfType((PsiElement)file.findElementAt(selectionModel.getSelectionStart()), (Class[])new Class[]{GoStringLiteral.class, PsiComment.class});
                TextRange elementValueRange = GoBraceHandler.elementValueRange(element);
                if (!elementValueRange.contains(selectionModel.getSelectionStart()) || !elementValueRange.contains(selectionModel.getSelectionEnd())) {
                    EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)String.valueOf(c));
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                    if (result == null) {
                        GoBraceHandler.$$$reportNull$$$0(3);
                    }
                    return result;
                }
            }
            if (GoTypedHandlers.isBracket(c) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
                int offset2 = editor.getCaretModel().getOffset();
                Document document = editor.getDocument();
                if (GoBraceHandler.isAfterBlockKeyword(editor, offset2)) {
                    if (c == '(') {
                        PsiElement lastElementToInclude;
                        CharSequence indent;
                        IElementType prevType;
                        GoEditorUtil.commitDocument(project, document);
                        PsiElement spec = GoTypedHandlers.getSpecAfter(file, offset2);
                        LeafPsiElement prevLeaf = (LeafPsiElement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesBackward((PsiElement)spec), LeafPsiElement.class);
                        IElementType iElementType = prevType = prevLeaf != null ? prevLeaf.getElementType() : null;
                        if (Lazy.PAREN_BLOCK_KEYWORDS.contains(prevType) && (indent = GoTypedHandlers.getIndent(document, (PsiElement)prevLeaf)) != null && !GoTypedHandlers.hasRParenAfter(lastElementToInclude = GoTypedHandlers.getLastElementToIncludeIntoParens(spec))) {
                            int length = lastElementToInclude.getTextRange().getEndOffset() - spec.getTextRange().getStartOffset();
                            int keywordEndOffset = prevLeaf.getTextRange().getEndOffset();
                            this.myParenBlockInfo = new ParenBlockInfo(keywordEndOffset, spec.getTextRange().getStartOffset(), length, indent);
                        }
                    }
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                    if (result == null) {
                        GoBraceHandler.$$$reportNull$$$0(4);
                    }
                    return result;
                }
                if (GoBraceHandler.mightBeBeforeNewLineInCompositeLiteral(editor, offset2)) {
                    GoEditorUtil.commitDocument(project, document);
                    if (GoCompletionUtil.isAtElementValueWithNewLineCheap(file, document, offset2)) {
                        this.myNeedComma = true;
                    } else {
                        PsiWhiteSpace space = (PsiWhiteSpace)ObjectUtils.tryCast((Object)file.findElementAt(offset2), PsiWhiteSpace.class);
                        if (space != null && space.getParent() instanceof GoLiteralValue && !GoBraceHandler.isAtNewlineAfterLineComment(space)) {
                            this.myNeedComma = true;
                        }
                    }
                }
            }
            if (c == ',' && GoBraceHandler.isPossiblyAfterFuncResultType(editor, offset = editor.getCaretModel().getOffset())) {
                GoEditorUtil.commitDocument(project, editor.getDocument());
                GoResult result = (GoResult)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset - 1), GoResult.class);
                if (result != null && !result.isVoid() && result.getParameters() == null) {
                    this.myLParenBeforeTypeOffset = result.getTextRange().getStartOffset();
                }
            }
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                GoBraceHandler.$$$reportNull$$$0(5);
            }
            return result;
        }

        private static boolean isAtNewlineAfterLineComment(@NotNull PsiWhiteSpace space) {
            PsiElement prev;
            if (space == null) {
                GoBraceHandler.$$$reportNull$$$0(6);
            }
            return (prev = space.getPrevSibling()) != null && prev.getNode().getElementType() == GoParserDefinition.Lazy.LINE_COMMENT;
        }

        /*
         * Enabled aggressive block sorting
         */
        private static boolean mightBeBeforeNewLineInCompositeLiteral(@NotNull Editor editor, int offset) {
            if (editor == null) {
                GoBraceHandler.$$$reportNull$$$0(7);
            }
            if (!GoBraceHandler.isBeforeNewline(editor, offset)) {
                return false;
            }
            HighlighterIterator iterator = editor.getHighlighter().createIterator(offset);
            if (!iterator.atEnd() && iterator.getTokenType() == GoParserDefinition.Lazy.NLS) {
                iterator.retreat();
            }
            boolean seenNewLine = false;
            int braceBlockCount = 0;
            while (!iterator.atEnd()) {
                block12: {
                    IElementType token = iterator.getTokenType();
                    if (token == GoParserDefinition.Lazy.NLS) {
                        seenNewLine = true;
                    } else {
                        if (token == GoTypes.LBRACE) {
                            if (braceBlockCount > 0) {
                                --braceBlockCount;
                                break block12;
                            } else {
                                if (GoEditorUtil.findTokenBackwardOnSameLine(iterator, Lazy.BRACE_BLOCK_KEYWORDS) != null) return false;
                                return true;
                            }
                        }
                        if (seenNewLine && braceBlockCount == 0 && !GoParserDefinition.Lazy.WHITESPACES.contains(token) && !GoParserDefinition.Lazy.COMMENTS.contains(token)) {
                            if (token == GoTypes.COLON) return true;
                            if (token == GoTypes.COMMA) return true;
                            return false;
                        }
                        if (braceBlockCount == 0 && GoParserDefinition.Lazy.ASSIGN_OPERATOR_TYPES.contains(token)) {
                            return false;
                        }
                        if (token == GoTypes.RBRACE) {
                            ++braceBlockCount;
                        }
                    }
                }
                iterator.retreat();
            }
            return false;
        }

        private static boolean isBeforeNewline(@NotNull Editor editor, int offset) {
            if (editor == null) {
                GoBraceHandler.$$$reportNull$$$0(8);
            }
            HighlighterIterator iterator = editor.getHighlighter().createIterator(offset);
            while (!iterator.atEnd()) {
                IElementType token = iterator.getTokenType();
                if (token == GoParserDefinition.Lazy.NLS) {
                    return true;
                }
                if (token != GoParserDefinition.Lazy.WS && !GoParserDefinition.Lazy.COMMENTS.contains(token)) break;
                iterator.advance();
            }
            return false;
        }

        private static boolean isAfterBlockKeyword(@NotNull Editor editor, int offset) {
            if (editor == null) {
                GoBraceHandler.$$$reportNull$$$0(9);
            }
            if (offset == 0) {
                return false;
            }
            int start = offset - 1;
            HighlighterIterator iterator = editor.getHighlighter().createIterator(start);
            while (!iterator.atEnd()) {
                IElementType token = iterator.getTokenType();
                if (Lazy.PAREN_BLOCK_KEYWORDS.contains(token)) {
                    return true;
                }
                if (!GoParserDefinition.Lazy.WHITESPACES.contains(token)) {
                    return false;
                }
                iterator.retreat();
            }
            return false;
        }

        private static boolean isPossiblyAfterFuncResultType(@NotNull Editor editor, int offset) {
            HighlighterIterator iterator;
            IElementType token;
            if (editor == null) {
                GoBraceHandler.$$$reportNull$$$0(10);
            }
            if (offset == 0) {
                return false;
            }
            if (offset < editor.getDocument().getTextLength() && (token = GoEditorUtil.skipWhitespacesForward(iterator = editor.getHighlighter().createIterator(offset))) != GoTypes.LBRACE && token != GoParserDefinition.Lazy.NLS) {
                return false;
            }
            iterator = editor.getHighlighter().createIterator(offset - 1);
            boolean inFrontOfComma = true;
            boolean hasBalancedParens = false;
            while (!iterator.atEnd()) {
                IElementType token2 = iterator.getTokenType();
                if (token2 == GoParserDefinition.Lazy.NLS) {
                    return hasBalancedParens;
                }
                if (token2 == GoTypes.FUNC) {
                    return hasBalancedParens;
                }
                if (token2 == GoTypes.LPAREN) {
                    return false;
                }
                if (token2 == GoTypes.RPAREN) {
                    if (inFrontOfComma) {
                        return false;
                    }
                    hasBalancedParens = true;
                    GoEditorUtil.moveBeforeParentheses(iterator, GoTypes.LPAREN, GoTypes.RPAREN);
                }
                iterator.retreat();
                inFrontOfComma = false;
            }
            return false;
        }

        @NotNull
        private static TextRange elementValueRange(@Nullable PsiElement element) {
            TextRange textRange = element != null ? ElementManipulators.getValueTextRange((PsiElement)element).shiftRight(element.getTextRange().getStartOffset()) : TextRange.EMPTY_RANGE;
            if (textRange == null) {
                GoBraceHandler.$$$reportNull$$$0(11);
            }
            return textRange;
        }

        @NotNull
        public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            if (project == null) {
                GoBraceHandler.$$$reportNull$$$0(12);
            }
            if (editor == null) {
                GoBraceHandler.$$$reportNull$$$0(13);
            }
            if (file == null) {
                GoBraceHandler.$$$reportNull$$$0(14);
            }
            if (file instanceof GoFile && this.myNeedComma && GoTypedHandlers.isBracket(c)) {
                GoTypedHandlers.beginUndoablePostProcessing();
                int afterClosingBracket = editor.getCaretModel().getOffset() + 1;
                editor.getDocument().insertString(afterClosingBracket, (CharSequence)",");
            }
            if (file instanceof GoFile && this.myParenBlockInfo != null && c == '(') {
                GoTypedHandlers.beginUndoablePostProcessing();
                Document document = editor.getDocument();
                int offset = editor.getCaretModel().getOffset();
                boolean hasRparen = document.getImmutableCharSequence().charAt(offset) == ')';
                int newSpecOffset = this.myParenBlockInfo.specOffset + 1 + (hasRparen ? 1 : 0);
                String textBeforeCaret = " (\n" + String.valueOf(this.myParenBlockInfo.indent) + "\t";
                document.replaceString(this.myParenBlockInfo.keywordEndOffset, newSpecOffset, (CharSequence)textBeforeCaret);
                int specEnd = this.myParenBlockInfo.keywordEndOffset + textBeforeCaret.length() + this.myParenBlockInfo.contentLength;
                document.insertString(specEnd, (CharSequence)("\n" + String.valueOf(this.myParenBlockInfo.indent) + ")"));
                editor.getCaretModel().moveToOffset(this.myParenBlockInfo.keywordEndOffset + textBeforeCaret.length());
            }
            if (file instanceof GoFile && this.myLParenBeforeTypeOffset != null && c == ',') {
                GoTypedHandlers.beginUndoablePostProcessing();
                Document document = editor.getDocument();
                document.insertString(this.myLParenBeforeTypeOffset.intValue(), (CharSequence)"(");
                document.insertString(editor.getCaretModel().getOffset(), (CharSequence)")");
            }
            this.myNeedComma = false;
            this.myParenBlockInfo = null;
            this.myLParenBeforeTypeOffset = null;
            if (c == '{' && file instanceof GoFile) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    GoBraceHandler.$$$reportNull$$$0(15);
                }
                return result;
            }
            TypedHandlerDelegate.Result result = super.charTyped(c, project, editor, file);
            if (result == null) {
                GoBraceHandler.$$$reportNull$$$0(16);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 11, 15, 16 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 11: 
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/editor/GoTypedHandlers$GoBraceHandler";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "space";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/editor/GoTypedHandlers$GoBraceHandler";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "beforeSelectionRemoved";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "elementValueRange";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "charTyped";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "beforeSelectionRemoved";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 11: 
                case 15: 
                case 16: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isAtNewlineAfterLineComment";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "mightBeBeforeNewLineInCompositeLiteral";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "isBeforeNewline";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "isAfterBlockKeyword";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "isPossiblyAfterFuncResultType";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "charTyped";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5, 11, 15, 16 -> new IllegalStateException(string);
            };
        }
    }

    public static final class GoDotHandler
    extends TypedHandlerDelegate {
        public boolean isImmediatePaintingEnabled(@NotNull Editor editor, char c, @NotNull DataContext context) {
            if (editor == null) {
                GoDotHandler.$$$reportNull$$$0(0);
            }
            if (context == null) {
                GoDotHandler.$$$reportNull$$$0(1);
            }
            if (c == '.') {
                return !GoDotHandler.hasRecentlyInsertedDotAfterPackage((PsiFile)context.getData(CommonDataKeys.PSI_FILE), editor.getCaretModel().getOffset());
            }
            return super.isImmediatePaintingEnabled(editor, c, context);
        }

        @NotNull
        public TypedHandlerDelegate.Result beforeSelectionRemoved(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            if (project == null) {
                GoDotHandler.$$$reportNull$$$0(2);
            }
            if (editor == null) {
                GoDotHandler.$$$reportNull$$$0(3);
            }
            if (file == null) {
                GoDotHandler.$$$reportNull$$$0(4);
            }
            if (GoDotHandler.hasRecentlyInsertedDotAfterPackage(file, editor.getCaretModel().getOffset())) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    GoDotHandler.$$$reportNull$$$0(5);
                }
                return result;
            }
            TypedHandlerDelegate.Result result = super.beforeSelectionRemoved(c, project, editor, file);
            if (result == null) {
                GoDotHandler.$$$reportNull$$$0(6);
            }
            return result;
        }

        private static boolean hasRecentlyInsertedDotAfterPackage(@Nullable PsiFile file, int offset) {
            return file instanceof GoFile && GoPackageInsertHandler.hasRecentlyInsertedDotAfterPackage(file, offset - 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/editor/GoTypedHandlers$GoDotHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/editor/GoTypedHandlers$GoDotHandler";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "beforeSelectionRemoved";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isImmediatePaintingEnabled";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "beforeSelectionRemoved";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    public static final class GoAutoPopupController
    extends TypedHandlerDelegate {
        @NotNull
        public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            CharSequence commentPrefix;
            HighlighterIterator iterator;
            if (project == null) {
                GoAutoPopupController.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                GoAutoPopupController.$$$reportNull$$$0(1);
            }
            if (file == null) {
                GoAutoPopupController.$$$reportNull$$$0(2);
            }
            int offset = Math.max(editor.getCaretModel().getOffset() - 1, 0);
            if (charTyped == ' ' && !(iterator = editor.getHighlighter().createIterator(offset)).atEnd()) {
                IElementType type = iterator.getTokenType();
                if (type == GoTypes.DEFER || type == GoTypes.GO) {
                    AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, null);
                } else if (type == GoTypes.RAW_STRING && GoAutoPopupController.isAfterIdentifier(iterator)) {
                    AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, null);
                }
            }
            if (charTyped == ',' && !(iterator = editor.getHighlighter().createIterator(offset)).atEnd() && iterator.getTokenType() == GoTypes.RAW_STRING && GoAutoPopupController.isAfterIdentifier(iterator)) {
                AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, null);
            }
            if (charTyped == '`' && !(iterator = editor.getHighlighter().createIterator(offset)).atEnd() && iterator.getTokenType() == GoParserDefinition.Lazy.WS && GoAutoPopupController.isAfterIdentifier(iterator)) {
                AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, null);
            }
            if (charTyped == '/' && !(iterator = editor.getHighlighter().createIterator(offset)).atEnd() && iterator.getTokenType() == GoParserDefinition.Lazy.LINE_COMMENT && GoEmbedComment.isEmbedComment(commentPrefix = editor.getDocument().getCharsSequence().subSequence(iterator.getStart(), iterator.getEnd()))) {
                AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, null);
            }
            if (!(charTyped != '[' && charTyped != '{' && charTyped != ':' || (iterator = editor.getHighlighter().createIterator(offset)).atEnd() || iterator.getTokenType() == GoTypes.STRING || iterator.getTokenType() == GoTypes.RAW_STRING)) {
                AutoPopupController.getInstance((Project)project).autoPopupParameterInfo(editor, null);
            }
            TypedHandlerDelegate.Result result = super.checkAutoPopup(charTyped, project, editor, file);
            if (result == null) {
                GoAutoPopupController.$$$reportNull$$$0(3);
            }
            return result;
        }

        private static boolean isAfterIdentifier(@NotNull HighlighterIterator iterator) {
            if (iterator == null) {
                GoAutoPopupController.$$$reportNull$$$0(4);
            }
            iterator.retreat();
            IElementType prevToken = GoEditorUtil.skipWhitespacesAndCommentsBackward(iterator);
            return prevToken == GoTypes.IDENTIFIER;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/editor/GoTypedHandlers$GoAutoPopupController";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/editor/GoTypedHandlers$GoAutoPopupController";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "checkAutoPopup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "checkAutoPopup";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isAfterIdentifier";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static final class GoSwitchCaseIndentationHandler
    extends TypedHandlerDelegate {
        @NotNull
        public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            boolean success;
            if (project == null) {
                GoSwitchCaseIndentationHandler.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                GoSwitchCaseIndentationHandler.$$$reportNull$$$0(1);
            }
            if (file == null) {
                GoSwitchCaseIndentationHandler.$$$reportNull$$$0(2);
            }
            if (!(c != ':' && c != ' ' && c != '\t' || (success = GoSwitchCaseIndentationHandler.adjustLine(editor, "case")))) {
                GoSwitchCaseIndentationHandler.adjustLine(editor, "default");
            }
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                GoSwitchCaseIndentationHandler.$$$reportNull$$$0(3);
            }
            return result;
        }

        private static boolean adjustLine(@NotNull Editor editor, @NotNull String keyword) {
            if (editor == null) {
                GoSwitchCaseIndentationHandler.$$$reportNull$$$0(4);
            }
            if (keyword == null) {
                GoSwitchCaseIndentationHandler.$$$reportNull$$$0(5);
            }
            int len = keyword.length();
            Project project = editor.getProject();
            if (project == null) {
                return false;
            }
            int offset = editor.getCaretModel().getOffset();
            if (offset < len + 1) {
                return false;
            }
            TextRange keywordRange = TextRange.from((int)(offset - len - 1), (int)len);
            if (keyword.equals(editor.getDocument().getText(keywordRange))) {
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (project.isDisposed()) {
                        return;
                    }
                    PsiFile file = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
                    if (file == null) {
                        return;
                    }
                    PsiElement at = file.findElementAt(keywordRange.getStartOffset());
                    if (at == null || !(at.getParent() instanceof GoCaseClause)) {
                        return;
                    }
                    GoTypedHandlers.beginUndoablePostProcessing();
                    CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, keywordRange);
                });
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/editor/GoTypedHandlers$GoSwitchCaseIndentationHandler";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyword";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/editor/GoTypedHandlers$GoSwitchCaseIndentationHandler";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "charTyped";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "charTyped";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "adjustLine";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class Lazy {
        private static final TokenSet PAREN_BLOCK_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{GoTypes.VAR, GoTypes.CONST, GoTypes.TYPE_, GoTypes.IMPORT});
        private static final TokenSet BRACE_BLOCK_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{GoTypes.FOR, GoTypes.IF, GoTypes.ELSE, GoTypes.SELECT, GoTypes.SWITCH, GoTypes.FUNC});

        private Lazy() {
        }
    }
}

