/*
 * Decompiled with CFR 0.152.
 */
package com.goide.editor;

import com.goide.GoParserDefinition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.testFramework.TestModeFlags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoEditorUtil {
    public static final Key<Boolean> FAIL_ON_DOCUMENT_COMMIT = Key.create((String)"GO_FAIL_ON_DOCUMENT_COMMIT");

    public static void commitDocument(@NotNull Project project, @NotNull Document document) {
        if (project == null) {
            GoEditorUtil.$$$reportNull$$$0(0);
        }
        if (document == null) {
            GoEditorUtil.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && TestModeFlags.is(FAIL_ON_DOCUMENT_COMMIT)) {
            throw new RuntimeException("Document commit is not allowed");
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
    }

    @Nullable
    public static IElementType skipWhitespacesForward(@NotNull HighlighterIterator iterator) {
        if (iterator == null) {
            GoEditorUtil.$$$reportNull$$$0(2);
        }
        while (!iterator.atEnd()) {
            IElementType token = iterator.getTokenType();
            if (token != GoParserDefinition.Lazy.WS) {
                return token;
            }
            iterator.advance();
        }
        return null;
    }

    @Nullable
    public static IElementType skipWhitespacesAndCommentsBackward(@NotNull HighlighterIterator iterator) {
        if (iterator == null) {
            GoEditorUtil.$$$reportNull$$$0(3);
        }
        while (!iterator.atEnd()) {
            IElementType token = iterator.getTokenType();
            if (!GoParserDefinition.Lazy.WHITESPACES.contains(token) && !GoParserDefinition.Lazy.COMMENTS.contains(token)) {
                return token;
            }
            iterator.retreat();
        }
        return null;
    }

    public static void moveBeforeParentheses(@NotNull HighlighterIterator iterator, @NotNull IElementType leftParenthesis, @NotNull IElementType rightParenthesis) {
        if (iterator == null) {
            GoEditorUtil.$$$reportNull$$$0(4);
        }
        if (leftParenthesis == null) {
            GoEditorUtil.$$$reportNull$$$0(5);
        }
        if (rightParenthesis == null) {
            GoEditorUtil.$$$reportNull$$$0(6);
        }
        int parenLevel = 0;
        while (!iterator.atEnd()) {
            IElementType token = iterator.getTokenType();
            if (rightParenthesis.equals(token)) {
                ++parenLevel;
            } else if (leftParenthesis.equals(token) && --parenLevel < 1) break;
            iterator.retreat();
        }
    }

    @Nullable
    public static IElementType findTokenBackwardOnSameLine(@NotNull HighlighterIterator iterator, @NotNull TokenSet tokens) {
        if (iterator == null) {
            GoEditorUtil.$$$reportNull$$$0(7);
        }
        if (tokens == null) {
            GoEditorUtil.$$$reportNull$$$0(8);
        }
        while (!iterator.atEnd()) {
            IElementType token = iterator.getTokenType();
            if (token == GoParserDefinition.Lazy.NLS) {
                return null;
            }
            if (tokens.contains(token)) {
                return token;
            }
            iterator.retreat();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftParenthesis";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightParenthesis";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
        }
        objectArray2[1] = "com/goide/editor/GoEditorUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "commitDocument";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "skipWhitespacesForward";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "skipWhitespacesAndCommentsBackward";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "moveBeforeParentheses";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findTokenBackwardOnSameLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

