/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv.renderer;

import com.goide.dlv.DlvXValue;
import com.goide.dlv.protocol.DlvApi;
import com.goide.dlv.renderer.GoFmtSprintfArgument;
import com.goide.dlv.renderer.GoFmtSprintfArgumentDynamic;
import com.goide.i18n.GoBundle;
import com.goide.inspections.fmtstring.parser.GoFmtStringParser;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringBadPlaceholder;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringEscapedPercent;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringPlaceholder;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringTextParsed;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringToken;
import com.goide.util.Value;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J(\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J0\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\bH\u0002J(\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J,\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u001d0\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\bH\u0002J)\u0010\u0017\u001a\u0004\u0018\u00010\u00032\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010'J\u0019\u0010\u0019\u001a\u0004\u0018\u00010\u00032\b\u0010$\u001a\u0004\u0018\u00010%H\u0002\u00a2\u0006\u0002\u0010(J\u0019\u0010\u001a\u001a\u0004\u0018\u00010\u00032\b\u0010$\u001a\u0004\u0018\u00010%H\u0002\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006)"}, d2={"Lcom/goide/dlv/renderer/GoFmtSprintfEvaluator;", "", "format", "", "args", "", "Lcom/goide/dlv/renderer/GoFmtSprintfArgument;", "printDiagnostics", "", "<init>", "(Ljava/lang/String;Ljava/util/List;Z)V", "eval", "Lorg/jetbrains/concurrency/Promise;", "dlvXValue", "Lcom/goide/dlv/DlvXValue;", "receiver", "Lcom/goide/dlv/protocol/DlvApi$Variable;", "formatFloat", "index", "", "formatQuotedString", "formatString", "formatPointer", "formatHex", "upperCase", "formatDecimal", "formatBinary", "formatBool", "getValue", "Lcom/goide/util/Value;", "getArgument", "maxDynamicArgumentAccessorsDepth", "getMaxDynamicArgumentAccessorsDepth", "()I", "formatCharsAsHex", "s", "value", "", "zeroPaddingWidth", "(Ljava/lang/Long;IZ)Ljava/lang/String;", "(Ljava/lang/Long;)Ljava/lang/String;", "intellij.go.impl"})
public final class GoFmtSprintfEvaluator {
    @NotNull
    private final String format;
    @NotNull
    private final List<GoFmtSprintfArgument> args;
    private final boolean printDiagnostics;

    public GoFmtSprintfEvaluator(@NotNull String format, @NotNull List<? extends GoFmtSprintfArgument> args, boolean printDiagnostics) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        this.format = format;
        this.args = args;
        this.printDiagnostics = printDiagnostics;
    }

    @NotNull
    public final Promise<String> eval(@NotNull DlvXValue dlvXValue, @NotNull DlvApi.Variable receiver) {
        Intrinsics.checkNotNullParameter((Object)((Object)dlvXValue), (String)"dlvXValue");
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        List<GoFmtStringToken> list = GoFmtStringParser.parse(this.format, true);
        Intrinsics.checkNotNullExpressionValue(list, (String)"parse(...)");
        List<GoFmtStringToken> tokens = list;
        List promises = new ArrayList();
        int index = 0;
        for (GoFmtStringToken token : tokens) {
            GoFmtStringToken goFmtStringToken = token;
            if (goFmtStringToken instanceof GoFmtStringEscapedPercent) {
                promises.add(Promises.resolvedPromise(Optional.of("%")));
                continue;
            }
            if (goFmtStringToken instanceof GoFmtStringTextParsed || goFmtStringToken instanceof GoFmtStringBadPlaceholder) {
                promises.add(Promises.resolvedPromise(Optional.of(token.getText())));
                continue;
            }
            if (!(goFmtStringToken instanceof GoFmtStringPlaceholder)) continue;
            Promise<String> formattedPromise = Promises.resolvedPromise(null);
            char verb = ((GoFmtStringPlaceholder)token).getVerb();
            Ref.BooleanRef supportedVerb = new Ref.BooleanRef();
            supportedVerb.element = true;
            if (((GoFmtStringPlaceholder)token).getWidth() == null && ((GoFmtStringPlaceholder)token).getPrecision() == null && ((GoFmtStringPlaceholder)token).getVerbIndex() == null) {
                switch (verb) {
                    case 't': {
                        formattedPromise = this.formatBool(dlvXValue, receiver, index);
                        break;
                    }
                    case 'b': {
                        formattedPromise = this.formatBinary(dlvXValue, receiver, index);
                        break;
                    }
                    case 'd': {
                        formattedPromise = this.formatDecimal(dlvXValue, receiver, index);
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        formattedPromise = this.formatHex(dlvXValue, receiver, index, verb == 'X');
                        break;
                    }
                    case 's': {
                        formattedPromise = this.formatString(dlvXValue, receiver, index);
                        break;
                    }
                    case 'F': 
                    case 'f': {
                        formattedPromise = this.formatFloat(dlvXValue, receiver, index);
                        break;
                    }
                    case 'q': {
                        formattedPromise = this.formatQuotedString(dlvXValue, receiver, index);
                        break;
                    }
                    case 'p': {
                        formattedPromise = this.formatPointer(receiver, index);
                        break;
                    }
                    default: {
                        supportedVerb.element = false;
                    }
                }
            }
            Promise promise = formattedPromise.then(arg_0 -> GoFmtSprintfEvaluator.eval$lambda$1(arg_0 -> GoFmtSprintfEvaluator.eval$lambda$0(this, token, supportedVerb, verb, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
            promises.add(promise);
            ++index;
        }
        Promise promise = Promises.collectResults$default((Collection)promises, (boolean)false, (int)1, null).then(arg_0 -> GoFmtSprintfEvaluator.eval$lambda$3(GoFmtSprintfEvaluator::eval$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    private final Promise<String> formatFloat(DlvXValue dlvXValue, DlvApi.Variable receiver, int index) {
        Promise promise = this.getValue(dlvXValue, receiver, index).then(arg_0 -> GoFmtSprintfEvaluator.formatFloat$lambda$5(GoFmtSprintfEvaluator::formatFloat$lambda$4, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    private final Promise<String> formatQuotedString(DlvXValue dlvXValue, DlvApi.Variable receiver, int index) {
        Promise promise = this.getValue(dlvXValue, receiver, index).then(arg_0 -> GoFmtSprintfEvaluator.formatQuotedString$lambda$7(GoFmtSprintfEvaluator::formatQuotedString$lambda$6, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    private final Promise<String> formatString(DlvXValue dlvXValue, DlvApi.Variable receiver, int index) {
        Promise promise = this.getValue(dlvXValue, receiver, index).then(arg_0 -> GoFmtSprintfEvaluator.formatString$lambda$9(GoFmtSprintfEvaluator::formatString$lambda$8, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    private final Promise<String> formatPointer(DlvApi.Variable receiver, int index) {
        GoFmtSprintfArgumentDynamic arg;
        GoFmtSprintfArgument goFmtSprintfArgument = this.getArgument(index);
        GoFmtSprintfArgumentDynamic goFmtSprintfArgumentDynamic = arg = goFmtSprintfArgument instanceof GoFmtSprintfArgumentDynamic ? (GoFmtSprintfArgumentDynamic)goFmtSprintfArgument : null;
        if (arg != null) {
            BigInteger address;
            BigInteger bigInteger = address = arg.getValueAddress(receiver);
            return Promises.resolvedPromise((Object)(bigInteger != null ? "0x" + bigInteger.toString(16) : null));
        }
        return Promises.resolvedPromise(null);
    }

    private final Promise<String> formatHex(DlvXValue dlvXValue, DlvApi.Variable receiver, int index, boolean upperCase) {
        Promise promise = this.getValue(dlvXValue, receiver, index).then(arg_0 -> GoFmtSprintfEvaluator.formatHex$lambda$11(arg_0 -> GoFmtSprintfEvaluator.formatHex$lambda$10(this, upperCase, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    private final Promise<String> formatDecimal(DlvXValue dlvXValue, DlvApi.Variable receiver, int index) {
        Promise promise = this.getValue(dlvXValue, receiver, index).then(arg_0 -> GoFmtSprintfEvaluator.formatDecimal$lambda$13(arg_0 -> GoFmtSprintfEvaluator.formatDecimal$lambda$12(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    private final Promise<String> formatBinary(DlvXValue dlvXValue, DlvApi.Variable receiver, int index) {
        Promise promise = this.getValue(dlvXValue, receiver, index).then(arg_0 -> GoFmtSprintfEvaluator.formatBinary$lambda$15(arg_0 -> GoFmtSprintfEvaluator.formatBinary$lambda$14(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    private final Promise<String> formatBool(DlvXValue dlvXValue, DlvApi.Variable receiver, int index) {
        Promise promise = this.getValue(dlvXValue, receiver, index).then(arg_0 -> GoFmtSprintfEvaluator.formatBool$lambda$17(GoFmtSprintfEvaluator::formatBool$lambda$16, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    private final Promise<Value<?>> getValue(DlvXValue dlvXValue, DlvApi.Variable receiver, int index) {
        Promise<Value<?>> arg = this.getArgument(index);
        Promise<Value<?>> promise = arg;
        if (promise == null || (promise = promise.getValue(dlvXValue, receiver)) == null) {
            promise = Promises.resolvedPromise(null);
        }
        return promise;
    }

    private final GoFmtSprintfArgument getArgument(int index) {
        return index < this.args.size() ? this.args.get(index) : null;
    }

    public final int getMaxDynamicArgumentAccessorsDepth() {
        int result = 0;
        for (GoFmtSprintfArgument arg : this.args) {
            if (!(arg instanceof GoFmtSprintfArgumentDynamic)) continue;
            result = Math.max(result, ((GoFmtSprintfArgumentDynamic)arg).getAccessorsDepth());
        }
        return result;
    }

    private final String formatCharsAsHex(String s, boolean upperCase) {
        StringBuilder result = new StringBuilder();
        String format = upperCase ? "%02X" : "%02x";
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char element = s.charAt(i);
            Object[] objectArray = new Object[]{(int)element};
            String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            result.append(string);
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String formatHex(Long value2, int zeroPaddingWidth, boolean upperCase) {
        Object object;
        if (value2 == null) {
            return null;
        }
        Object padding = zeroPaddingWidth > 0 ? "0" + zeroPaddingWidth : "";
        String conversion = upperCase ? "X" : "x";
        String format = "%" + (String)padding + conversion;
        if (value2 < 0L) {
            Object[] objectArray = new Object[]{Math.abs(value2)};
            String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            object = "-" + string;
        } else {
            Object[] objectArray = new Object[]{value2};
            String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        }
        return object;
    }

    private final String formatDecimal(Long value2) {
        String string;
        if (value2 != null) {
            String string2 = "%d";
            Object[] objectArray = new Object[]{value2};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        } else {
            string = null;
        }
        return string;
    }

    private final String formatBinary(Long value2) {
        if (value2 == null) {
            return null;
        }
        return value2 < 0L ? "-" + Long.toBinaryString(Math.abs(value2)) : Long.toBinaryString(value2);
    }

    private static final Optional eval$lambda$0(GoFmtSprintfEvaluator this$0, GoFmtStringToken $token, Ref.BooleanRef $supportedVerb, char $verb, String formatted) {
        if (formatted != null) {
            return Optional.of(formatted);
        }
        if (this$0.printDiagnostics) {
            if (((GoFmtStringPlaceholder)$token).getWidth() != null || ((GoFmtStringPlaceholder)$token).getPrecision() != null || ((GoFmtStringPlaceholder)$token).getVerbIndex() != null) {
                return Optional.of("%!" + ((GoFmtStringPlaceholder)$token).getText() + GoBundle.message((String)"go.debugger.fmt.sprintf.unsupported.format", (Object[])new Object[0]));
            }
            if (!$supportedVerb.element) {
                return Optional.of("%!" + ((GoFmtStringPlaceholder)$token).getText() + GoBundle.message((String)"go.debugger.fmt.sprintf.unsupported.verb", (Object[])new Object[0]));
            }
            return Optional.of("%!" + $verb + GoBundle.message((String)"go.debugger.fmt.sprintf.cannot.format.value", (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    private static final Optional eval$lambda$1(Function1 $tmp0, Object p0) {
        return (Optional)$tmp0.invoke(p0);
    }

    private static final String eval$lambda$2(List values2) {
        StringBuilder result = new StringBuilder();
        for (Optional value2 : values2) {
            if (value2.isPresent()) {
                result.append((String)value2.get());
                continue;
            }
            return null;
        }
        return result.toString();
    }

    private static final String eval$lambda$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String formatFloat$lambda$4(Value value2) {
        Comparable<Value<?>> comparable = value2;
        if (comparable == null || (comparable = ((Value)comparable).getDouble()) == null) {
            return null;
        }
        double d = (Double)comparable;
        Locale locale = Locale.getDefault();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            locale = Locale.US;
        }
        String string = "%f";
        Object[] objectArray = new Object[]{d};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final String formatFloat$lambda$5(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String formatQuotedString$lambda$6(Value value2) {
        String string;
        if (value2 == null) {
            return null;
        }
        String s = value2.getString();
        if (s != null) {
            return "\"" + StringUtil.escapeStringCharacters((String)s) + "\"";
        }
        byte[] bytes = value2.getBytes();
        if (bytes != null) {
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            string = "\"" + StringUtil.escapeStringCharacters((String)new String(bytes, charset2)) + "\"";
        } else {
            string = null;
        }
        return string;
    }

    private static final String formatQuotedString$lambda$7(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String formatString$lambda$8(Value value2) {
        String string;
        if (value2 == null) {
            return null;
        }
        String s = value2.getString();
        if (s != null) {
            return s;
        }
        byte[] bytes = value2.getBytes();
        if (bytes != null) {
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            string = new String(bytes, charset2);
        } else {
            string = null;
        }
        return string;
    }

    private static final String formatString$lambda$9(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String formatHex$lambda$10(GoFmtSprintfEvaluator this$0, boolean $upperCase, Value value2) {
        if (value2 == null) {
            return null;
        }
        Long intValue = value2.getInteger();
        if (intValue != null) {
            return this$0.formatHex(intValue, 0, $upperCase);
        }
        byte[] bytes = value2.getBytes();
        if (bytes != null) {
            StringBuilder result = new StringBuilder();
            for (byte b : bytes) {
                result.append(this$0.formatHex(Long.valueOf(Byte.toUnsignedInt(b)), 2, $upperCase));
            }
            return result.toString();
        }
        String valStr = value2.getString();
        if (valStr != null) {
            return this$0.formatCharsAsHex(valStr, $upperCase);
        }
        return null;
    }

    private static final String formatHex$lambda$11(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String formatDecimal$lambda$12(GoFmtSprintfEvaluator this$0, Value value2) {
        Value value3 = value2;
        return this$0.formatDecimal(value3 != null ? value3.getInteger() : null);
    }

    private static final String formatDecimal$lambda$13(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String formatBinary$lambda$14(GoFmtSprintfEvaluator this$0, Value value2) {
        Value value3 = value2;
        return this$0.formatBinary(value3 != null ? value3.getInteger() : null);
    }

    private static final String formatBinary$lambda$15(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String formatBool$lambda$16(Value value2) {
        Comparable<Value<?>> comparable = value2;
        return comparable != null && (comparable = ((Value)comparable).getBool()) != null ? ((Boolean)comparable).toString() : null;
    }

    private static final String formatBool$lambda$17(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

