/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv.renderer;

import com.goide.dlv.DlvSettings;
import com.goide.dlv.DlvUtil;
import com.goide.dlv.DlvXValue;
import com.goide.dlv.protocol.DlvApi;
import com.goide.dlv.protocol.DlvRequest;
import com.goide.dlv.renderer.GoFmtSprintfArgument;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.impl.GoElementFactory;
import com.goide.util.Value;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigInteger;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ$\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lcom/goide/dlv/renderer/GoFmtSprintfArgumentDynamic;", "Lcom/goide/dlv/renderer/GoFmtSprintfArgument;", "project", "Lcom/intellij/openapi/project/Project;", "receiverName", "", "expression", "dereference", "", "takeAddress", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;ZZ)V", "getValueAddress", "Ljava/math/BigInteger;", "receiver", "Lcom/goide/dlv/protocol/DlvApi$Variable;", "getValue", "Lorg/jetbrains/concurrency/Promise;", "Lcom/goide/util/Value;", "dlvXValue", "Lcom/goide/dlv/DlvXValue;", "tryCreateExpression", "Lcom/goide/psi/GoExpression;", "text", "getVariable", "accessorsDepth", "", "getAccessorsDepth", "()I", "intellij.go.impl"})
public final class GoFmtSprintfArgumentDynamic
implements GoFmtSprintfArgument {
    @NotNull
    private final Project project;
    @NotNull
    private final String receiverName;
    @NotNull
    private final String expression;
    private final boolean dereference;
    private final boolean takeAddress;

    public GoFmtSprintfArgumentDynamic(@NotNull Project project, @NotNull String receiverName, @NotNull String expression, boolean dereference, boolean takeAddress) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)receiverName, (String)"receiverName");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.project = project;
        this.receiverName = receiverName;
        this.expression = expression;
        this.dereference = dereference;
        this.takeAddress = takeAddress;
    }

    @Nullable
    public final BigInteger getValueAddress(@NotNull DlvApi.Variable receiver) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        DlvApi.Variable field = this.getVariable(receiver, this.expression);
        return field != null && (field.isPtr() || this.takeAddress) ? field.addr : null;
    }

    @Override
    @NotNull
    public Promise<Value<?>> getValue(@NotNull DlvXValue dlvXValue, @NotNull DlvApi.Variable receiver) {
        Intrinsics.checkNotNullParameter((Object)((Object)dlvXValue), (String)"dlvXValue");
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Ref.ObjectRef variable = new Ref.ObjectRef();
        variable.element = this.getVariable(receiver, this.expression);
        if (variable.element == null) {
            return Promises.resolvedPromise(null);
        }
        if (this.dereference && ((DlvApi.Variable)variable.element).isPtr() && ((DlvApi.Variable)variable.element).children.length == 1) {
            variable.element = ((DlvApi.Variable)variable.element).children[0];
        }
        Object object = variable.element;
        Intrinsics.checkNotNull((Object)object);
        if (((DlvApi.Variable)object).isSlice() || ((DlvApi.Variable)variable.element).isArray()) {
            String string = ((DlvApi.Variable)variable.element).type;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type");
            if (StringsKt.endsWith$default((String)string, (String)"]uint8", (boolean)false, (int)2, null)) {
                DlvRequest.DlvLoadConfig dlvLoadConfig = new DlvRequest.DlvLoadConfig(DlvSettings.Companion.getInstance()).setMaxVariableRecurse(0);
                Intrinsics.checkNotNullExpressionValue((Object)dlvLoadConfig, (String)"setMaxVariableRecurse(...)");
                DlvRequest.DlvLoadConfig config = dlvLoadConfig;
                String string2 = DlvXValue.evaluationExpression((DlvApi.Variable)variable.element);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"evaluationExpression(...)");
                String expr = string2;
                Promise promise = dlvXValue.getProcess().send(new DlvRequest.Eval(expr, dlvXValue.myFrameId, dlvXValue.myGoroutineId, config)).thenAsync(arg_0 -> GoFmtSprintfArgumentDynamic.getValue$lambda$1(GoFmtSprintfArgumentDynamic::getValue$lambda$0, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"thenAsync(...)");
                return promise;
            }
            return Promises.resolvedPromise(null);
        }
        return Promises.resolvedPromise((Object)ReadAction.compute(() -> GoFmtSprintfArgumentDynamic.getValue$lambda$2(variable, this)));
    }

    private final GoExpression tryCreateExpression(String text) {
        GoFile goFile = GoElementFactory.createFileFromText(this.project, "package a; func a() {\n " + text + "}");
        Intrinsics.checkNotNullExpressionValue((Object)((Object)goFile), (String)"createFileFromText(...)");
        GoFile file = goFile;
        return (GoExpression)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)file), GoExpression.class);
    }

    private final DlvApi.Variable getVariable(DlvApi.Variable receiver, String expression) {
        List list = StringUtil.split((String)expression, (String)".");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"split(...)");
        List accessors = list;
        if (accessors.size() < 2) {
            return Intrinsics.areEqual((Object)expression, (Object)this.receiverName) ? receiver : null;
        }
        String first = (String)CollectionsKt.firstOrNull((List)accessors);
        if (!Intrinsics.areEqual((Object)this.receiverName, (Object)first)) {
            return null;
        }
        DlvApi.Variable result = receiver;
        List list2 = ContainerUtil.subList((List)accessors, (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"subList(...)");
        List rest = list2;
        for (String fieldName : rest) {
            if (result != null && result.isPtr() && result.children.length == 1) {
                result = result.children[0];
            }
            DlvApi.Variable variable = result;
            result = variable != null ? DlvUtil.getByName(variable.children, fieldName) : null;
        }
        return result;
    }

    public final int getAccessorsDepth() {
        List list = StringUtil.split((String)this.expression, (String)".");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"split(...)");
        List accessors = list;
        return accessors.size() > 1 ? accessors.size() - 1 : 0;
    }

    private static final Promise getValue$lambda$0(DlvApi.Variable it) {
        DlvApi.Variable variable = it;
        Intrinsics.checkNotNull((Object)variable);
        byte[] bytes = DlvUtil.readBytes(variable);
        return Promises.resolvedPromise(bytes != null ? Value.of((Comparable)new Value.ByteArray(bytes)) : null);
    }

    private static final Promise getValue$lambda$1(Function1 $tmp0, Object p0) {
        return (Promise)$tmp0.invoke(p0);
    }

    private static final Value getValue$lambda$2(Ref.ObjectRef $variable, GoFmtSprintfArgumentDynamic this$0) {
        try {
            GoExpression expression;
            GoExpression goExpression;
            if (((DlvApi.Variable)$variable.element).isString()) {
                goExpression = GoElementFactory.createStringLiteral(this$0.project, "`" + ((DlvApi.Variable)$variable.element).value + "`");
            } else {
                String string = ((DlvApi.Variable)$variable.element).value;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value");
                goExpression = this$0.tryCreateExpression(string);
            }
            GoExpression goExpression2 = expression = goExpression;
            return goExpression2 != null ? goExpression2.getValue() : null;
        }
        catch (Throwable e) {
            return null;
        }
    }
}

