/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv.renderer;

import com.goide.dlv.DlvSettings;
import com.goide.dlv.DlvStackFrame;
import com.goide.dlv.DlvXValue;
import com.goide.dlv.protocol.DlvApi;
import com.goide.dlv.protocol.DlvRequest;
import com.goide.dlv.renderer.DlvBinaryValueRenderer;
import com.goide.dlv.renderer.DlvDecimalValueRenderer;
import com.goide.dlv.renderer.DlvDefaultValueRenderer;
import com.goide.dlv.renderer.DlvDurationValueRenderer;
import com.goide.dlv.renderer.DlvFmtSprintfValueRenderer;
import com.goide.dlv.renderer.DlvHexValueRenderer;
import com.goide.dlv.renderer.DlvHttpRequestRenderer;
import com.goide.dlv.renderer.DlvIpMaskValueRenderer;
import com.goide.dlv.renderer.DlvIpNetValueRenderer;
import com.goide.dlv.renderer.DlvIpValueRenderer;
import com.goide.dlv.renderer.DlvNilValueRenderer;
import com.goide.dlv.renderer.DlvStringerValueRenderer;
import com.goide.dlv.renderer.DlvTimeValueRenderer;
import com.goide.dlv.renderer.DlvUnreadableValueRenderer;
import com.goide.dlv.renderer.DlvValueRenderer;
import com.goide.dlv.renderer.DlvValueRendererSelectableInUi;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ObjectUtils;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class DlvValueRenderers {
    @NlsSafe
    private static final String TIME_DURATION = "time.Duration";
    @NlsSafe
    private static final String TIME_TIME = "time.Time";
    @NlsSafe
    private static final String NET_IP = "net.IP";
    @NlsSafe
    private static final String NET_IPMASK = "net.IPMask";
    @NlsSafe
    private static final String NET_IPNET = "net.IPNet";
    @NlsSafe
    private static final String NET_HTTP_REQUEST = "net/http.Request";
    @NlsSafe
    static final String NIL = "<nil>";
    public static final DlvValueRendererSelectableInUi BINARY = new DlvBinaryValueRenderer();
    public static final DlvValueRendererSelectableInUi DECIMAL = new DlvDecimalValueRenderer();
    public static final DlvValueRendererSelectableInUi HEX = new DlvHexValueRenderer();
    public static final DlvValueRenderer DEFAULT = new DlvDefaultValueRenderer();
    private final ConcurrentMap<Object, DlvValueRenderer> myCustomRenderers = new ConcurrentHashMap<Object, DlvValueRenderer>();

    @NotNull
    public DlvValueRenderer getRenderer(@Nullable DlvStackFrame frame, @NotNull XValueNode node2, @NotNull DlvXValue value2) {
        if (node2 == null) {
            DlvValueRenderers.$$$reportNull$$$0(0);
        }
        if (value2 == null) {
            DlvValueRenderers.$$$reportNull$$$0(1);
        }
        if (value2.isUnreadable()) {
            return new DlvUnreadableValueRenderer();
        }
        if (value2.isNil()) {
            return new DlvNilValueRenderer();
        }
        Object id = frame != null ? DlvValueRenderers.getId(frame, node2) : null;
        DlvValueRenderer customRenderer = id != null ? (DlvValueRenderer)this.myCustomRenderers.get(id) : null;
        return customRenderer != null ? customRenderer : DlvValueRenderers.getDefaultRenderer(node2);
    }

    public void setRenderer(@NotNull DlvStackFrame frame, @NotNull XValueNode node2, @NotNull DlvValueRenderer renderer) {
        Object id;
        if (frame == null) {
            DlvValueRenderers.$$$reportNull$$$0(2);
        }
        if (node2 == null) {
            DlvValueRenderers.$$$reportNull$$$0(3);
        }
        if (renderer == null) {
            DlvValueRenderers.$$$reportNull$$$0(4);
        }
        if ((id = DlvValueRenderers.getId(frame, node2)) == null) {
            return;
        }
        DlvValueRenderer defaultRenderer = DlvValueRenderers.getDefaultRenderer(node2);
        if (renderer == defaultRenderer) {
            this.myCustomRenderers.remove(id);
        } else {
            this.myCustomRenderers.put(id, renderer);
        }
    }

    @NotNull
    public static Collection<DlvValueRendererSelectableInUi> getRenderersSelectableInUi() {
        List<DlvValueRendererSelectableInUi> list = Arrays.asList(BINARY, DECIMAL, HEX);
        if (list == null) {
            DlvValueRenderers.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private static DlvValueRenderer getDefaultRenderer(@NotNull XValueNode node2) {
        DlvXValue dlvValue;
        if (node2 == null) {
            DlvValueRenderers.$$$reportNull$$$0(6);
        }
        if ((dlvValue = DlvXValue.getNodeValue(node2)) != null) {
            String type;
            switch (type = dlvValue.getVariable().type) {
                case "time.Duration": {
                    return new DlvDurationValueRenderer();
                }
                case "time.Time": {
                    return new DlvTimeValueRenderer(dlvValue);
                }
                case "net.IP": {
                    return new DlvIpValueRenderer();
                }
                case "net.IPMask": {
                    return new DlvIpMaskValueRenderer();
                }
                case "net.IPNet": {
                    return new DlvIpNetValueRenderer();
                }
                case "net/http.Request": {
                    return new DlvHttpRequestRenderer();
                }
            }
            Project project = dlvValue.getProject();
            if (project != null) {
                DlvValueRenderer defaultRenderer = dlvValue.getVariable().isInteger() ? DlvSettings.getInstance().getDefaultIntegerRenderer() : DEFAULT;
                DlvStringerValueRenderer fallbackValueRenderer = new DlvStringerValueRenderer(project, defaultRenderer);
                return new DlvFmtSprintfValueRenderer(project, fallbackValueRenderer, dlvValue);
            }
        }
        DlvValueRenderer dlvValueRenderer = DEFAULT;
        if (dlvValueRenderer == null) {
            DlvValueRenderers.$$$reportNull$$$0(7);
        }
        return dlvValueRenderer;
    }

    @Nullable
    private static Object getId(@NotNull DlvStackFrame frame, @NotNull XValueNode node2) {
        DlvXValue dlvValue;
        if (frame == null) {
            DlvValueRenderers.$$$reportNull$$$0(8);
        }
        if (node2 == null) {
            DlvValueRenderers.$$$reportNull$$$0(9);
        }
        if (node2 instanceof XValueNodeImpl && (dlvValue = (DlvXValue)((Object)ObjectUtils.tryCast((Object)((XValueNodeImpl)node2).getValueContainer(), DlvXValue.class))) != null) {
            String functionName;
            DlvApi.Function function = frame.getLocation().function;
            String string = functionName = function != null ? function.name : null;
            if (functionName == null) {
                return null;
            }
            DlvApi.Variable var = dlvValue.getVariable();
            return Pair.create((Object)Pair.create((Object)functionName, (Object)var.addr), (Object)Pair.create((Object)var.name, (Object)(node2 instanceof WatchNodeImpl)));
        }
        return node2;
    }

    static Promise<DlvApi.Variable> loadChildrenIfNeeded(@NotNull DlvXValue value2, @NotNull DlvApi.Variable var) {
        if (value2 == null) {
            DlvValueRenderers.$$$reportNull$$$0(10);
        }
        if (var == null) {
            DlvValueRenderers.$$$reportNull$$$0(11);
        }
        return var.children.length == 0 ? value2.getProcess().send(new DlvRequest.Eval(DlvXValue.evaluationExpression(var), value2.myFrameId, value2.myGoroutineId)) : Promises.resolvedPromise((Object)var);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/dlv/renderer/DlvValueRenderers";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/dlv/renderer/DlvValueRenderers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderersSelectableInUi";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRenderer";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setRenderer";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRenderer";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getId";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadChildrenIfNeeded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7 -> new IllegalStateException(string);
        };
    }
}

