/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv.renderer;

import com.goide.dlv.DlvDebugProcess;
import com.goide.dlv.DlvSettings;
import com.goide.dlv.DlvXValue;
import com.goide.dlv.protocol.DlvApi;
import com.goide.dlv.protocol.DlvRequest;
import com.goide.dlv.renderer.DlvFmtSprintfValueRendererKt;
import com.goide.dlv.renderer.DlvRegularValuePresentation;
import com.goide.dlv.renderer.DlvValueRenderer;
import com.goide.psi.GoMethodDeclaration;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J,\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b*\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/goide/dlv/renderer/DlvStringerValueRenderer;", "Lcom/goide/dlv/renderer/DlvValueRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "fallbackRenderer", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/goide/dlv/renderer/DlvValueRenderer;)V", "getPresentation", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation;", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "value", "Lcom/goide/dlv/DlvXValue;", "makeUnsafeCall", "withFallback", "intellij.go.impl"})
public final class DlvStringerValueRenderer
implements DlvValueRenderer {
    @NotNull
    private final Project project;
    @NotNull
    private final DlvValueRenderer fallbackRenderer;

    public DlvStringerValueRenderer(@NotNull Project project, @NotNull DlvValueRenderer fallbackRenderer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fallbackRenderer, (String)"fallbackRenderer");
        this.project = project;
        this.fallbackRenderer = fallbackRenderer;
    }

    @Override
    @NotNull
    public Promise<XValuePresentation> getPresentation(@NotNull XValueNode node2, @NotNull DlvXValue value2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
        if (node2.isObsolete()) {
            return Promises.rejectedPromise();
        }
        return this.withFallback(this.makeUnsafeCall(node2, value2), node2, value2);
    }

    private final Promise<XValuePresentation> makeUnsafeCall(XValueNode node2, DlvXValue value2) {
        if (!DlvSettings.Companion.getInstance().getEnableStringView()) {
            return Promises.rejectedPromise();
        }
        Promise promise = value2.getTypePresentationAsync(node2).thenAsync(arg_0 -> DlvStringerValueRenderer.makeUnsafeCall$lambda$4(arg_0 -> DlvStringerValueRenderer.makeUnsafeCall$lambda$3(value2, this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"thenAsync(...)");
        return promise;
    }

    private final Promise<XValuePresentation> withFallback(Promise<XValuePresentation> $this$withFallback, XValueNode node2, DlvXValue value2) {
        AsyncPromise resultPromise = new AsyncPromise();
        $this$withFallback.onSuccess(arg_0 -> DlvStringerValueRenderer.withFallback$lambda$6(arg_0 -> DlvStringerValueRenderer.withFallback$lambda$5(resultPromise, arg_0), arg_0)).onError(arg_0 -> DlvStringerValueRenderer.withFallback$lambda$8(arg_0 -> DlvStringerValueRenderer.withFallback$lambda$7(this, node2, value2, resultPromise, arg_0), arg_0));
        return (Promise)resultPromise;
    }

    private static final String makeUnsafeCall$lambda$3$lambda$0(DlvStringerValueRenderer this$0, DlvXValue $value) {
        GoMethodDeclaration goMethodDeclaration = DlvFmtSprintfValueRendererKt.findStringMethod(this$0.project, $value);
        return goMethodDeclaration != null ? goMethodDeclaration.getName() : null;
    }

    private static final Promise makeUnsafeCall$lambda$3$lambda$1(String $callExpr, DlvDebugProcess $process, String $type, DlvApi.DebuggerState state) {
        Object object = state;
        if (object == null || (object = ((DlvApi.DebuggerState)object).currentThread) == null) {
            return Promises.rejectedPromise();
        }
        long goroutineId = ((DlvApi.Thread)object).goroutineID;
        Object object2 = state.currentThread;
        if (object2 == null || (object2 = ((DlvApi.Thread)object2).returnValues) == null) {
            return Promises.rejectedPromise();
        }
        Object variables = object2;
        DlvXValue dlvXValue = DlvXValue.createCallResult($callExpr, (List<DlvApi.Variable>)variables, $process, 0, goroutineId);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)dlvXValue), (String)"createCallResult(...)");
        DlvXValue result = dlvXValue;
        if (!result.getVariable().isString()) {
            return Promises.rejectedPromise();
        }
        String string = result.getVariable().value;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value");
        return Promises.resolvedPromise((Object)((Object)new DlvRegularValuePresentation(string, $type)));
    }

    private static final Promise makeUnsafeCall$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        return (Promise)$tmp0.invoke(p0);
    }

    private static final Promise makeUnsafeCall$lambda$3(DlvXValue $value, DlvStringerValueRenderer this$0, String type) {
        if (type == null) {
            return Promises.rejectedPromise();
        }
        String methodName = (String)ActionsKt.runReadAction(() -> DlvStringerValueRenderer.makeUnsafeCall$lambda$3$lambda$0(this$0, $value));
        if (methodName == null) {
            return Promises.rejectedPromise();
        }
        String callExpr = $value.getQualifiedName() + "." + methodName + "()";
        DlvDebugProcess dlvDebugProcess = $value.getProcess();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)dlvDebugProcess), (String)"getProcess(...)");
        DlvDebugProcess process = dlvDebugProcess;
        return process.send(new DlvRequest.Call(callExpr, true)).thenAsync(arg_0 -> DlvStringerValueRenderer.makeUnsafeCall$lambda$3$lambda$2(arg_0 -> DlvStringerValueRenderer.makeUnsafeCall$lambda$3$lambda$1(callExpr, process, type, arg_0), arg_0));
    }

    private static final Promise makeUnsafeCall$lambda$4(Function1 $tmp0, Object p0) {
        return (Promise)$tmp0.invoke(p0);
    }

    private static final Unit withFallback$lambda$5(AsyncPromise $resultPromise, XValuePresentation it) {
        $resultPromise.setResult((Object)it);
        return Unit.INSTANCE;
    }

    private static final void withFallback$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit withFallback$lambda$7(DlvStringerValueRenderer this$0, XValueNode $node, DlvXValue $value, AsyncPromise $resultPromise, Throwable it) {
        this$0.fallbackRenderer.getPresentation($node, $value).processed((Promise)$resultPromise);
        return Unit.INSTANCE;
    }

    private static final void withFallback$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

