/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv.renderer;

import com.intellij.openapi.util.TextRange;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"ZERO_RUN", "Ljava/util/regex/Pattern;", "formatValidAddress", "", "bytes", "", "findLongestZeroRun", "Lcom/intellij/openapi/util/TextRange;", "s", "intellij.go.impl"})
public final class DlvIpValueRendererKt {
    @NotNull
    private static final Pattern ZERO_RUN;

    @Nullable
    public static final String formatValidAddress(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (bytes.length != 4 && bytes.length != 16) {
            return null;
        }
        try {
            String address = InetAddress.getByAddress(bytes).getHostAddress();
            Intrinsics.checkNotNull((Object)address);
            TextRange range = DlvIpValueRendererKt.findLongestZeroRun(address);
            if (range == null) {
                return address;
            }
            return range.getStartOffset() == 0 ? ":" + range.replace(address, ":") : range.replace(address, ":");
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    private static final TextRange findLongestZeroRun(String s) {
        Matcher matcher = ZERO_RUN.matcher(s + ":");
        TextRange longestRun = null;
        while (matcher.find()) {
            TextRange run;
            int start = matcher.start();
            int end = matcher.end();
            if (start > 0 && s.charAt(matcher.start() - 1) != ':' && end - (start += 2) == 2) continue;
            Intrinsics.checkNotNullExpressionValue((Object)TextRange.create((int)start, (int)end), (String)"create(...)");
            if (longestRun != null && run.getLength() <= longestRun.getLength()) continue;
            longestRun = run;
        }
        TextRange textRange = longestRun;
        return textRange != null ? textRange.intersection(TextRange.allOf((String)s)) : null;
    }

    static {
        Pattern pattern = Pattern.compile("(0:){2,}");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        ZERO_RUN = pattern;
    }
}

