/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv.dump;

import com.goide.dlv.DlvDebugProcess;
import com.goide.dlv.dump.DlvStackIndex;
import com.goide.dlv.dump.DlvThreadDump;
import com.goide.dlv.protocol.DlvApi;
import com.goide.i18n.GoBundle;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import it.unimi.dsi.fastutil.ints.Int2ByteMap;
import it.unimi.dsi.fastutil.ints.Int2ByteOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DlvStack {
    private static final int FRAME_SIZE = 3;
    private static final String RUNTIME_PREFIX = "runtime.";
    private final int myHash;
    private final int[] myFrames;
    private final int myAsyncFrameIndex;

    DlvStack(@NotNull DlvStackIndex stackIndex, @NotNull List<DlvApi.Location> frames, int asyncFrameIndex) {
        if (stackIndex == null) {
            DlvStack.$$$reportNull$$$0(0);
        }
        if (frames == null) {
            DlvStack.$$$reportNull$$$0(1);
        }
        this.myFrames = new int[frames.size() * 3];
        for (int i = 0; i < frames.size(); ++i) {
            DlvApi.Location location = frames.get(i);
            DlvApi.Function function = location.function;
            String funcName = function != null ? function.name : null;
            this.myFrames[3 * i] = stackIndex.addFuncIfAbsent(funcName);
            this.myFrames[3 * i + 1] = stackIndex.addFileIfAbsent(location.file);
            this.myFrames[3 * i + 2] = location.line;
        }
        this.myAsyncFrameIndex = asyncFrameIndex;
        this.myHash = Arrays.hashCode(this.myFrames) + 31 * this.myAsyncFrameIndex;
    }

    public void renderFrame(@NotNull DlvStackIndex stackIndex, @NotNull ColoredTextContainer renderer, int frameIndex, @NotNull String unknownFuncName, boolean hidden) {
        if (stackIndex == null) {
            DlvStack.$$$reportNull$$$0(2);
        }
        if (renderer == null) {
            DlvStack.$$$reportNull$$$0(3);
        }
        if (unknownFuncName == null) {
            DlvStack.$$$reportNull$$$0(4);
        }
        @NlsSafe String funcName = (String)ObjectUtils.notNull((Object)stackIndex.getFuncName(this.myFrames[frameIndex * 3]), (Object)unknownFuncName);
        DlvThreadDump.append(renderer, funcName, hidden);
    }

    public void renderStack(@NotNull DlvDebugProcess process, @NotNull DlvStackIndex stackIndex, @NotNull ConsoleView console, @NotNull String unknownFuncName) {
        if (process == null) {
            DlvStack.$$$reportNull$$$0(5);
        }
        if (stackIndex == null) {
            DlvStack.$$$reportNull$$$0(6);
        }
        if (console == null) {
            DlvStack.$$$reportNull$$$0(7);
        }
        if (unknownFuncName == null) {
            DlvStack.$$$reportNull$$$0(8);
        }
        for (int i = 0; i < this.myFrames.length / 3; ++i) {
            int base = i * 3;
            String func = (String)ObjectUtils.notNull((Object)stackIndex.getFuncName(this.myFrames[base]), (Object)unknownFuncName);
            ConsoleViewContentType contentType = this.getLineContentType(func, i);
            console.print(func, contentType);
            String file = stackIndex.getFile(this.myFrames[base + 1]);
            int line = this.myFrames[base + 2];
            if (file != null && line >= 0) {
                console.print("(", contentType);
                console.printHyperlink(DlvStack.getShortFileName(file) + ":" + line, (HyperlinkInfo)new FileHyperlinkInfo(process, file, line));
                console.print(")", contentType);
            }
            console.print("\n", contentType);
        }
    }

    public void print(@NotNull DlvStackIndex stackIndex, @NotNull String unknownFuncName, @NotNull StringBuilder buffer) {
        if (stackIndex == null) {
            DlvStack.$$$reportNull$$$0(9);
        }
        if (unknownFuncName == null) {
            DlvStack.$$$reportNull$$$0(10);
        }
        if (buffer == null) {
            DlvStack.$$$reportNull$$$0(11);
        }
        for (int i = 0; i < this.myFrames.length / 3; ++i) {
            int base = i * 3;
            String func = (String)ObjectUtils.notNull((Object)stackIndex.getFuncName(this.myFrames[base]), (Object)unknownFuncName);
            buffer.append("  ");
            if (i == this.myAsyncFrameIndex) {
                buffer.append("created at: ");
            }
            buffer.append(func);
            String file = stackIndex.getFile(this.myFrames[base + 1]);
            int line = this.myFrames[base + 2];
            if (file != null && line >= 0) {
                buffer.append(" (");
                buffer.append(file).append(":").append(line);
                buffer.append(")");
            }
            buffer.append("\n");
        }
    }

    @NotNull
    private ConsoleViewContentType getLineContentType(@NotNull String funcName, int frameIndex) {
        if (funcName == null) {
            DlvStack.$$$reportNull$$$0(12);
        }
        if (!DlvStack.isUserLocation(funcName)) {
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.LOG_DEBUG_OUTPUT;
            if (consoleViewContentType == null) {
                DlvStack.$$$reportNull$$$0(13);
            }
            return consoleViewContentType;
        }
        if (frameIndex == this.myAsyncFrameIndex) {
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.LOG_VERBOSE_OUTPUT;
            if (consoleViewContentType == null) {
                DlvStack.$$$reportNull$$$0(14);
            }
            return consoleViewContentType;
        }
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
        if (consoleViewContentType == null) {
            DlvStack.$$$reportNull$$$0(15);
        }
        return consoleViewContentType;
    }

    private static boolean isUserLocation(@NotNull String funcName) {
        if (funcName == null) {
            DlvStack.$$$reportNull$$$0(16);
        }
        if (funcName.length() > RUNTIME_PREFIX.length() && funcName.startsWith(RUNTIME_PREFIX)) {
            return Character.isUpperCase(funcName.charAt(RUNTIME_PREFIX.length()));
        }
        return funcName.indexOf(46) >= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DlvStack stack = (DlvStack)o;
        return this.myHash == stack.myHash && Arrays.equals(this.myFrames, stack.myFrames) && this.myAsyncFrameIndex == stack.myAsyncFrameIndex;
    }

    public int hashCode() {
        return this.myHash;
    }

    @Contract(value="!null->!null")
    private static String getShortFileName(@Nullable String file) {
        if (file == null) {
            return null;
        }
        int lastSlashIndex = file.lastIndexOf("/");
        if (lastSlashIndex >= 0) {
            return file.substring(lastSlashIndex + 1);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackIndex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frames";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unknownFuncName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funcName";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/dlv/dump/DlvStack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/dlv/dump/DlvStack";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineContentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "renderFrame";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "renderStack";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLineContentType";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isUserLocation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 14, 15 -> new IllegalStateException(string);
        };
    }

    private static class FileHyperlinkInfo
    implements HyperlinkInfo {
        private final DlvDebugProcess myProcess;
        private final String myFile;
        private final int myLine;

        private FileHyperlinkInfo(@NotNull DlvDebugProcess process, @NotNull String file, int line) {
            if (process == null) {
                FileHyperlinkInfo.$$$reportNull$$$0(0);
            }
            if (file == null) {
                FileHyperlinkInfo.$$$reportNull$$$0(1);
            }
            this.myProcess = process;
            this.myFile = file;
            this.myLine = line;
        }

        public void navigate(@NotNull Project project) {
            if (project == null) {
                FileHyperlinkInfo.$$$reportNull$$$0(2);
            }
            ReadAction.nonBlocking(() -> this.myProcess.findFile(this.myFile)).expireWith((Disposable)this.myProcess).finishOnUiThread(ModalityState.defaultModalityState(), vfile -> {
                if (vfile != null) {
                    new OpenFileDescriptor(project, vfile, this.myLine - 1, 0).navigate(true);
                } else {
                    String msg = GoBundle.message((String)"go.debugger.cannot.find.file", (Object[])new Object[]{this.myFile});
                    DlvDebugProcess.showNotification(this.myProcess.getSession().getProject(), NotificationType.WARNING, msg);
                }
            }).submit((Executor)AppExecutorUtil.getAppExecutorService());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/goide/dlv/dump/DlvStack$FileHyperlinkInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "navigate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ContentMatcher {
        private static final byte NOT_COMPUTED = 0;
        private static final byte MATCHED = 1;
        private static final byte NOT_MATCHED = 2;
        private final DlvStackIndex myStackIndex;
        private final String myUnknownFunctionName;
        private final String myText;
        private final boolean myIgnoreCase;
        private final StringBuilder myStackLine;
        private final Int2ByteMap myStackMatchResults;
        private final Int2ObjectMap<Long2ByteMap> myStackLineMatchResults;

        ContentMatcher(@NotNull DlvStackIndex stackIndex, @NotNull String unknownFunctionName, @NotNull String text, boolean ignoreCase) {
            if (stackIndex == null) {
                ContentMatcher.$$$reportNull$$$0(0);
            }
            if (unknownFunctionName == null) {
                ContentMatcher.$$$reportNull$$$0(1);
            }
            if (text == null) {
                ContentMatcher.$$$reportNull$$$0(2);
            }
            this.myStackMatchResults = new Int2ByteOpenHashMap();
            this.myStackLineMatchResults = new Int2ObjectOpenHashMap();
            this.myStackIndex = stackIndex;
            this.myUnknownFunctionName = unknownFunctionName;
            this.myText = text;
            this.myIgnoreCase = ignoreCase;
            this.myStackLine = new StringBuilder();
        }

        boolean matches(int stackId) {
            byte stackResult = this.myStackMatchResults.get(stackId);
            if (stackResult != 0) {
                return stackResult == 1;
            }
            DlvStack stack = Objects.requireNonNull(this.myStackIndex.getStack(stackId));
            for (int i = 0; i < stack.myFrames.length; i += 3) {
                byte lineMatchResult;
                int funcId = stack.myFrames[i];
                int fileId = stack.myFrames[i + 1];
                int line = stack.myFrames[i + 2];
                long funcAndLine = (long)funcId << 32 | (long)line;
                Long2ByteMap funcLineTable = (Long2ByteMap)this.myStackLineMatchResults.get(fileId);
                if (funcLineTable == null) {
                    funcLineTable = new Long2ByteOpenHashMap();
                    this.myStackLineMatchResults.put(fileId, (Object)funcLineTable);
                }
                if ((lineMatchResult = funcLineTable.get(funcAndLine)) == 0) {
                    this.fillStackLine(funcId, fileId, line);
                    lineMatchResult = this.myStackLine.indexOf(this.myText) >= 0 ? (byte)1 : 2;
                    funcLineTable.put(funcAndLine, lineMatchResult);
                }
                if (lineMatchResult != 1) continue;
                this.myStackMatchResults.put(stackId, (byte)1);
                return true;
            }
            this.myStackMatchResults.put(stackId, (byte)2);
            return false;
        }

        private void fillStackLine(int funcId, int fileId, int line) {
            this.myStackLine.setLength(0);
            String funcName = (String)ObjectUtils.notNull((Object)this.myStackIndex.getFuncName(funcId), (Object)this.myUnknownFunctionName);
            this.myStackLine.append(this.myIgnoreCase ? StringUtil.toLowerCase((String)funcName) : funcName);
            String file = this.myStackIndex.getFile(fileId);
            if (file != null && line >= 0) {
                String shortFileName = DlvStack.getShortFileName(file);
                this.myStackLine.append("(").append(this.myIgnoreCase ? StringUtil.toLowerCase((String)shortFileName) : shortFileName).append(":").append(line).append(")");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stackIndex";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "unknownFunctionName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/goide/dlv/dump/DlvStack$ContentMatcher";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

