/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv;

import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.util.text.CharSequenceReader;
import java.io.Closeable;
import java.io.Reader;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonReaderEx
implements Closeable {
    private static final char[] NON_EXECUTE_PREFIX = ")]}'\n".toCharArray();
    private static final long MIN_INCOMPLETE_INTEGER = -922337203685477580L;
    private static final int PEEKED_NONE = 0;
    private static final int PEEKED_BEGIN_OBJECT = 1;
    private static final int PEEKED_END_OBJECT = 2;
    private static final int PEEKED_BEGIN_ARRAY = 3;
    private static final int PEEKED_END_ARRAY = 4;
    private static final int PEEKED_TRUE = 5;
    private static final int PEEKED_FALSE = 6;
    private static final int PEEKED_NULL = 7;
    private static final int PEEKED_SINGLE_QUOTED = 8;
    private static final int PEEKED_DOUBLE_QUOTED = 9;
    private static final int PEEKED_UNQUOTED = 10;
    private static final int PEEKED_BUFFERED = 11;
    private static final int PEEKED_SINGLE_QUOTED_NAME = 12;
    private static final int PEEKED_DOUBLE_QUOTED_NAME = 13;
    private static final int PEEKED_UNQUOTED_NAME = 14;
    private static final int PEEKED_LONG = 15;
    private static final int PEEKED_NUMBER = 16;
    private static final int PEEKED_EOF = 17;
    private static final int NUMBER_CHAR_NONE = 0;
    private static final int NUMBER_CHAR_SIGN = 1;
    private static final int NUMBER_CHAR_DIGIT = 2;
    private static final int NUMBER_CHAR_DECIMAL = 3;
    private static final int NUMBER_CHAR_FRACTION_DIGIT = 4;
    private static final int NUMBER_CHAR_EXP_E = 5;
    private static final int NUMBER_CHAR_EXP_SIGN = 6;
    private static final int NUMBER_CHAR_EXP_DIGIT = 7;
    @NotNull
    private final CharSequence in;
    private static final boolean lenient = false;
    private int position;
    private final int limit;
    private int peeked;
    private long peekedLong;
    private int peekedNumberLength;
    @Nullable
    private String peekedString;
    private int[] stack;
    private int stackSize;
    private StringBuilder builder;

    public JsonReaderEx(@NotNull CharSequence in) {
        if (in == null) {
            JsonReaderEx.$$$reportNull$$$0(0);
        }
        this(in, 0);
    }

    public JsonReaderEx(@NotNull CharSequence in, int start) {
        if (in == null) {
            JsonReaderEx.$$$reportNull$$$0(1);
        }
        this(in, start, new int[32]);
        this.stack[this.stackSize++] = 6;
    }

    private JsonReaderEx(@NotNull CharSequence in, int start, int @NotNull [] stack) {
        if (in == null) {
            JsonReaderEx.$$$reportNull$$$0(2);
        }
        if (stack == null) {
            JsonReaderEx.$$$reportNull$$$0(3);
        }
        this.peeked = 0;
        this.in = in;
        this.position = start;
        this.limit = in.length();
        this.stack = stack;
    }

    @Nullable
    public JsonReaderEx subReader() {
        JsonToken nextToken = this.peek();
        switch (nextToken) {
            case BEGIN_ARRAY: 
            case BEGIN_OBJECT: 
            case STRING: 
            case NUMBER: 
            case BOOLEAN: {
                break;
            }
            case NULL: {
                return null;
            }
            default: {
                throw this.createParseError("Cannot create sub reader, next token " + String.valueOf(nextToken) + " is not value");
            }
        }
        JsonReaderEx subReader = new JsonReaderEx(this.in, this.position, (int[])this.stack.clone());
        subReader.stackSize = this.stackSize;
        subReader.peeked = this.peeked;
        subReader.peekedLong = this.peekedLong;
        subReader.peekedNumberLength = this.peekedNumberLength;
        subReader.peekedString = this.peekedString;
        return subReader;
    }

    @NotNull
    public JsonReader asGson() {
        JsonToken nextToken = this.peek();
        int start = switch (nextToken) {
            case JsonToken.BEGIN_ARRAY, JsonToken.BEGIN_OBJECT, JsonToken.STRING -> {
                if (this.position > 0) {
                    yield this.position - 1;
                }
                yield this.position;
            }
            case JsonToken.BOOLEAN -> this.position - (this.peeked == 5 ? "true".length() : "false".length());
            case JsonToken.NUMBER -> {
                if (this.peeked == 15) {
                    yield this.position - String.valueOf(this.peekedLong).length();
                }
                yield this.position;
            }
            default -> throw this.createParseError("Cannot create sub reader, next token " + String.valueOf(nextToken) + " is not value");
        };
        return new JsonReader((Reader)new CharSequenceReader(this.in.subSequence(start, this.in.length())));
    }

    public boolean nextIsEmptyObject() {
        return this.peek() == JsonToken.BEGIN_OBJECT && this.in.charAt(this.position) == '}';
    }

    @NotNull
    public JsonReaderEx beginObject() {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p != 1) {
            throw this.createParseError("Expected BEGIN_OBJECT but was " + String.valueOf(this.peek()));
        }
        this.push(3);
        this.peeked = 0;
        JsonReaderEx jsonReaderEx = this;
        if (jsonReaderEx == null) {
            JsonReaderEx.$$$reportNull$$$0(4);
        }
        return jsonReaderEx;
    }

    public void endObject() {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 2) {
            --this.stackSize;
        } else {
            throw new IllegalStateException("Expected END_OBJECT but was " + String.valueOf(this.peek()));
        }
        this.peeked = 0;
    }

    public boolean hasNext() {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        return p != 2 && p != 4;
    }

    @NotNull
    public JsonToken peek() {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        JsonToken jsonToken = switch (p) {
            case 1 -> JsonToken.BEGIN_OBJECT;
            case 2 -> JsonToken.END_OBJECT;
            case 3 -> JsonToken.BEGIN_ARRAY;
            case 4 -> JsonToken.END_ARRAY;
            case 12, 13, 14 -> JsonToken.NAME;
            case 5, 6 -> JsonToken.BOOLEAN;
            case 7 -> JsonToken.NULL;
            case 8, 9, 10, 11 -> JsonToken.STRING;
            case 15, 16 -> JsonToken.NUMBER;
            case 17 -> JsonToken.END_DOCUMENT;
            default -> throw new AssertionError();
        };
        if (jsonToken == null) {
            JsonReaderEx.$$$reportNull$$$0(5);
        }
        return jsonToken;
    }

    private int doPeek() {
        int result;
        int c;
        int peekStack;
        block46: {
            block48: {
                block47: {
                    block45: {
                        peekStack = this.stack[this.stackSize - 1];
                        if (peekStack != 1) break block45;
                        this.stack[this.stackSize - 1] = 2;
                        break block46;
                    }
                    if (peekStack != 2) break block47;
                    c = this.nextNonWhitespace(true);
                    switch (c) {
                        case 93: {
                            this.peeked = 4;
                            return 4;
                        }
                        case 59: {
                            this.checkLenient();
                        }
                        case 44: {
                            break;
                        }
                        default: {
                            throw this.createParseError("Unterminated array");
                        }
                    }
                    break block46;
                }
                if (peekStack == 3 || peekStack == 5) {
                    int c2;
                    this.stack[this.stackSize - 1] = 4;
                    if (peekStack == 5) {
                        c2 = this.nextNonWhitespace(true);
                        switch (c2) {
                            case 125: {
                                this.peeked = 2;
                                return 2;
                            }
                            case 59: {
                                this.checkLenient();
                            }
                            case 44: {
                                break;
                            }
                            default: {
                                throw this.createParseError("Unterminated object");
                            }
                        }
                    }
                    c2 = this.nextNonWhitespace(true);
                    switch (c2) {
                        case 34: {
                            this.peeked = 13;
                            return 13;
                        }
                        case 39: {
                            this.checkLenient();
                            this.peeked = 12;
                            return 12;
                        }
                        case 125: {
                            if (peekStack != 5) {
                                this.peeked = 2;
                                return 2;
                            }
                            throw this.createParseError("Expected name");
                        }
                    }
                    this.checkLenient();
                    --this.position;
                    if (this.isLiteral((char)c2)) {
                        this.peeked = 14;
                        return 14;
                    }
                    throw this.createParseError("Expected name");
                }
                if (peekStack != 4) break block48;
                this.stack[this.stackSize - 1] = 5;
                c = this.nextNonWhitespace(true);
                switch (c) {
                    case 58: {
                        break;
                    }
                    case 61: {
                        this.checkLenient();
                        if (this.position < this.limit && this.in.charAt(this.position) == '>') {
                            ++this.position;
                            break;
                        }
                        break block46;
                    }
                    default: {
                        throw this.createParseError("Expected ':'");
                    }
                }
                break block46;
            }
            if (peekStack == 6) {
                this.stack[this.stackSize - 1] = 7;
            } else if (peekStack == 7) {
                c = this.nextNonWhitespace(false);
                if (c == -1) {
                    this.peeked = 17;
                    return 17;
                }
                this.checkLenient();
                --this.position;
            } else if (peekStack == 8) {
                throw new IllegalStateException("JsonReader is closed");
            }
        }
        c = this.nextNonWhitespace(true);
        switch (c) {
            case 93: {
                if (peekStack == 1) {
                    this.peeked = 4;
                    return 4;
                }
            }
            case 44: 
            case 59: {
                if (peekStack == 1 || peekStack == 2) {
                    this.checkLenient();
                    --this.position;
                    this.peeked = 7;
                    return 7;
                }
                throw this.createParseError("Unexpected value");
            }
            case 39: {
                this.checkLenient();
                this.peeked = 8;
                return 8;
            }
            case 34: {
                if (this.stackSize == 1) {
                    this.checkLenient();
                }
                this.peeked = 9;
                return 9;
            }
            case 91: {
                this.peeked = 3;
                return 3;
            }
            case 123: {
                this.peeked = 1;
                return 1;
            }
        }
        --this.position;
        if (this.stackSize == 1) {
            this.checkLenient();
        }
        if ((result = this.peekKeyword()) != 0) {
            return result;
        }
        result = this.peekNumber();
        if (result != 0) {
            return result;
        }
        if (!this.isLiteral(this.in.charAt(this.position))) {
            throw this.createParseError("Expected value");
        }
        this.checkLenient();
        this.peeked = 10;
        return 10;
    }

    private int peekKeyword() {
        int peeking;
        String keywordUpper;
        String keyword;
        char c = this.in.charAt(this.position);
        if (c == 't' || c == 'T') {
            keyword = "true";
            keywordUpper = "TRUE";
            peeking = 5;
        } else if (c == 'f' || c == 'F') {
            keyword = "false";
            keywordUpper = "FALSE";
            peeking = 6;
        } else if (c == 'n' || c == 'N') {
            keyword = "null";
            keywordUpper = "NULL";
            peeking = 7;
        } else {
            return 0;
        }
        int length = keyword.length();
        for (int i = 1; i < length; ++i) {
            if (this.position + i >= this.limit) {
                return 0;
            }
            c = this.in.charAt(this.position + i);
            if (c == keyword.charAt(i) || c == keywordUpper.charAt(i)) continue;
            return 0;
        }
        if (this.position + length < this.limit && this.isLiteral(this.in.charAt(this.position + length))) {
            return 0;
        }
        this.position += length;
        this.peeked = peeking;
        return this.peeked;
    }

    private int peekNumber() {
        CharSequence in = this.in;
        int p = this.position;
        int l = this.limit;
        long value2 = 0L;
        boolean negative = false;
        boolean fitsInLong = true;
        int last = 0;
        int i = 0;
        block6: while (true) {
            if (p + i == l) {
                if (i == this.limit) {
                    return 0;
                }
                p = this.position;
                l = this.limit;
            }
            char c = in.charAt(p + i);
            switch (c) {
                case '-': {
                    if (last == 0) {
                        negative = true;
                        last = 1;
                        break;
                    }
                    if (last == 5) {
                        last = 6;
                        break;
                    }
                    return 0;
                }
                case '+': {
                    if (last == 5) {
                        last = 6;
                        break;
                    }
                    return 0;
                }
                case 'E': 
                case 'e': {
                    if (last == 2 || last == 4) {
                        last = 5;
                        break;
                    }
                    return 0;
                }
                case '.': {
                    if (last == 2) {
                        last = 3;
                        break;
                    }
                    return 0;
                }
                default: {
                    if (c < '0' || c > '9') {
                        if (!this.isLiteral(c)) break block6;
                        return 0;
                    }
                    if (last == 1 || last == 0) {
                        value2 = -(c - 48);
                        last = 2;
                        break;
                    }
                    if (last == 2) {
                        if (value2 == 0L) {
                            return 0;
                        }
                        long newValue = value2 * 10L - (long)(c - 48);
                        fitsInLong &= value2 > -922337203685477580L || value2 == -922337203685477580L && newValue < value2;
                        value2 = newValue;
                        break;
                    }
                    if (last == 3) {
                        last = 4;
                        break;
                    }
                    if (last != 5 && last != 6) break;
                    last = 7;
                }
            }
            ++i;
        }
        if (last == 2 && fitsInLong && (value2 != Long.MIN_VALUE || negative)) {
            this.peekedLong = negative ? value2 : -value2;
            this.position += i;
            this.peeked = 15;
            return 15;
        }
        if (last == 2 || last == 4 || last == 7) {
            this.peekedNumberLength = i;
            this.peeked = 16;
            return 16;
        }
        return 0;
    }

    private void consumeNonExecutePrefix() {
        this.nextNonWhitespace(true);
        --this.position;
        if (this.position + NON_EXECUTE_PREFIX.length > this.limit) {
            return;
        }
        for (int i = 0; i < NON_EXECUTE_PREFIX.length; ++i) {
            if (this.in.charAt(this.position + i) == NON_EXECUTE_PREFIX[i]) continue;
            return;
        }
        this.position += NON_EXECUTE_PREFIX.length;
    }

    private boolean isLiteral(char c) {
        switch (c) {
            case '#': 
            case '/': 
            case ';': 
            case '=': 
            case '\\': {
                this.checkLenient();
            }
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case ',': 
            case ':': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public String nextName() {
        String result = this.nextNameOrNull();
        if (result == null) {
            throw this.createParseError("Expected a name but was " + String.valueOf(this.peek()));
        }
        String string = result;
        if (string == null) {
            JsonReaderEx.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public String nextNameOrNull() {
        String result;
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 14) {
            result = this.nextUnquotedValue();
        } else if (p == 12) {
            result = this.nextQuotedValue('\'');
        } else if (p == 13) {
            result = this.nextQuotedValue('\"');
        } else {
            if (p != 2 && p != 4) {
                throw this.createParseError("Expected a name but was " + String.valueOf(this.peek()));
            }
            return null;
        }
        this.peeked = 0;
        return result;
    }

    @Nullable
    public String nextString() {
        return this.nextString(false);
    }

    @Nullable
    public String nextString(boolean anyPrimitiveAsString) {
        String result;
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 10) {
            result = this.nextUnquotedValue();
        } else if (p == 8) {
            result = this.nextQuotedValue('\'');
        } else if (p == 9) {
            result = this.nextQuotedValue('\"');
        } else if (p == 11) {
            result = this.peekedString;
            this.peekedString = null;
        } else if (p == 15) {
            result = Long.toString(this.peekedLong);
        } else if (p == 16) {
            int end = this.position + this.peekedNumberLength;
            result = this.in.subSequence(this.position, end).toString();
            this.position = end;
        } else if (anyPrimitiveAsString && p == 5) {
            result = "true";
        } else if (anyPrimitiveAsString && p == 6) {
            result = "false";
        } else if (anyPrimitiveAsString && p == 7) {
            result = "null";
        } else {
            throw this.createParseError("Expected a string but was " + String.valueOf(this.peek()));
        }
        this.peeked = 0;
        return result;
    }

    public void nextNull() {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p != 7) {
            throw this.createParseError("Expected null but was " + String.valueOf(this.peek()));
        }
        this.peeked = 0;
    }

    @NotNull
    private String nextQuotedValue(char quote) {
        CharSequence in = this.in;
        int p = this.position;
        int l = this.limit;
        int start = p;
        StringBuilder builder = null;
        while (p < l) {
            char c;
            if ((c = in.charAt(p++)) == quote) {
                this.position = p;
                String string = builder == null ? in.subSequence(start, p - 1).toString() : builder.append(in, start, p - 1).toString();
                if (string == null) {
                    JsonReaderEx.$$$reportNull$$$0(7);
                }
                return string;
            }
            if (c != '\\') continue;
            this.position = p;
            if (builder == null) {
                if (this.builder == null) {
                    this.builder = new StringBuilder(p - start + 16);
                } else {
                    this.builder.setLength(0);
                }
                builder = this.builder;
            }
            builder.append(in, start, p - 1);
            builder.append(this.readEscapeCharacter());
            p = this.position;
            l = this.limit;
            start = p;
        }
        this.position = p;
        throw this.createParseError("Unterminated string");
    }

    @NotNull
    private String nextUnquotedValue() {
        int i;
        block4: for (i = this.position; i < this.limit; ++i) {
            switch (this.in.charAt(i)) {
                case '#': 
                case '/': 
                case ';': 
                case '=': 
                case '\\': {
                    this.checkLenient();
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ',': 
                case ':': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        String result = this.in.subSequence(this.position, i).toString();
        this.position = i;
        String string = result;
        if (string == null) {
            JsonReaderEx.$$$reportNull$$$0(8);
        }
        return string;
    }

    private void skipQuotedValue(char quote) {
        CharSequence in = this.in;
        int p = this.position;
        int l = this.limit;
        while (p < l) {
            char c;
            if ((c = in.charAt(p++)) == quote) {
                this.position = p;
                return;
            }
            if (c != '\\') continue;
            this.position = p;
            this.readEscapeCharacter();
            p = this.position;
            l = this.limit;
        }
        this.position = p;
        throw this.createParseError("Unterminated string");
    }

    private void skipUnquotedValue() {
        int i;
        for (i = this.position; i < this.limit; ++i) {
            switch (this.in.charAt(i)) {
                case '#': 
                case '/': 
                case ';': 
                case '=': 
                case '\\': {
                    this.checkLenient();
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ',': 
                case ':': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    this.position = i;
                    return;
                }
            }
        }
        this.position = i;
    }

    public int nextInt() {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 15) {
            int result = (int)this.peekedLong;
            if (this.peekedLong != (long)result) {
                @NonNls String message = "Expected an int but was " + this.peekedLong + " at line " + this.getLineNumber() + " column " + this.getColumnNumber();
                throw new NumberFormatException(message);
            }
            this.peeked = 0;
            return result;
        }
        if (p == 16) {
            int end = this.position + this.peekedNumberLength;
            this.peekedString = this.in.subSequence(this.position, end).toString();
            this.position = end;
        } else if (p == 8 || p == 9) {
            this.peekedString = this.nextQuotedValue(p == 8 ? (char)'\'' : '\"');
            try {
                int result = Integer.parseInt(this.peekedString);
                this.peeked = 0;
                return result;
            }
            catch (NumberFormatException end) {}
        } else {
            throw this.createParseError("Expected an int but was " + String.valueOf(this.peek()));
        }
        this.peeked = 11;
        double asDouble = Double.parseDouble(this.peekedString);
        int result = (int)asDouble;
        if ((double)result != asDouble) {
            @NonNls String message = "Expected an int but was " + this.peekedString + " at line " + this.getLineNumber() + " column " + this.getColumnNumber();
            throw new NumberFormatException(message);
        }
        this.peekedString = null;
        this.peeked = 0;
        return result;
    }

    @Override
    public void close() {
        this.peeked = 0;
        this.stack[0] = 8;
        this.stackSize = 1;
    }

    public void skipValue() {
        int count2 = 0;
        do {
            int p;
            if ((p = this.peeked) == 0) {
                p = this.doPeek();
            }
            if (p == 3) {
                this.push(1);
                ++count2;
            } else if (p == 1) {
                this.push(3);
                ++count2;
            } else if (p == 4 || p == 2) {
                --this.stackSize;
                --count2;
            } else if (p == 14 || p == 10) {
                this.skipUnquotedValue();
            } else if (p == 8 || p == 12) {
                this.skipQuotedValue('\'');
            } else if (p == 9 || p == 13) {
                this.skipQuotedValue('\"');
            } else if (p == 16) {
                this.position += this.peekedNumberLength;
            }
            this.peeked = 0;
        } while (count2 != 0);
    }

    private void push(int newTop) {
        if (this.stackSize == this.stack.length) {
            int[] newStack = new int[this.stackSize * 2];
            System.arraycopy(this.stack, 0, newStack, 0, this.stackSize);
            this.stack = newStack;
        }
        this.stack[this.stackSize++] = newTop;
    }

    private int getLineNumber() {
        int result = 1;
        for (int i = 0; i < this.position; ++i) {
            if (this.in.charAt(i) != '\n') continue;
            ++result;
        }
        return result;
    }

    private int getColumnNumber() {
        int result = 1;
        for (int i = 0; i < this.position; ++i) {
            if (this.in.charAt(i) == '\n') {
                result = 1;
                continue;
            }
            ++result;
        }
        return result;
    }

    private int nextNonWhitespace(boolean throwOnEof) {
        int p;
        block10: {
            char c;
            CharSequence in = this.in;
            p = this.position;
            int l = this.limit;
            while (true) {
                if (p == l) break block10;
                if ((c = in.charAt(p++)) == '\n' || c == ' ' || c == '\r' || c == '\t') continue;
                if (c == '/') {
                    this.position = p;
                    if (p == l) {
                        --this.position;
                        boolean charsLoaded = this.position + 3 < this.limit;
                        ++this.position;
                        if (!charsLoaded) {
                            return c;
                        }
                    }
                    this.checkLenient();
                    char peek = in.charAt(this.position);
                    switch (peek) {
                        case '*': {
                            ++this.position;
                            if (!this.skipTo("*/")) {
                                throw this.createParseError("Unterminated comment");
                            }
                            p = this.position + 2;
                            l = this.limit;
                            break;
                        }
                        case '/': {
                            ++this.position;
                            this.skipToEndOfLine();
                            p = this.position;
                            l = this.limit;
                            break;
                        }
                        default: {
                            return c;
                        }
                    }
                    continue;
                }
                if (c != '#') break;
                this.position = p;
                this.checkLenient();
                this.skipToEndOfLine();
                p = this.position;
                l = this.limit;
            }
            this.position = p;
            return c;
        }
        this.position = p;
        if (throwOnEof) {
            throw this.createParseError("End of input");
        }
        return -1;
    }

    private void checkLenient() {
        throw this.createParseError("Use JsonReaderEx.setLenient(true) to accept malformed JSON");
    }

    private void skipToEndOfLine() {
        char c;
        while (this.position < this.limit && (c = this.in.charAt(this.position++)) != '\n' && c != '\r') {
        }
    }

    private boolean skipTo(@NotNull String toFind) {
        if (toFind == null) {
            JsonReaderEx.$$$reportNull$$$0(9);
        }
        while (this.position + toFind.length() <= this.limit) {
            block5: {
                if (this.in.charAt(this.position) != '\n') {
                    for (int c = 0; c < toFind.length(); ++c) {
                        if (this.in.charAt(this.position + c) == toFind.charAt(c)) {
                            continue;
                        }
                        break block5;
                    }
                    return true;
                }
            }
            ++this.position;
        }
        return false;
    }

    @NotNull
    public String toString() {
        String string = this.getClass().getSimpleName() + " at line " + this.getLineNumber() + " column " + this.getColumnNumber();
        if (string == null) {
            JsonReaderEx.$$$reportNull$$$0(10);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private char readEscapeCharacter() {
        char c;
        if (this.position == this.limit) {
            throw this.createParseError("Unterminated escape sequence");
        }
        char escaped = this.in.charAt(this.position++);
        switch (escaped) {
            case 'u': {
                int i;
                if (this.position + 4 > this.limit) {
                    throw this.createParseError("Unterminated escape sequence");
                }
                char result = '\u0000';
                int end = i + 4;
                for (i = this.position; i < end; ++i) {
                    char c2 = this.in.charAt(i);
                    result = (char)(result << 4);
                    if (c2 >= '0' && c2 <= '9') {
                        result = (char)(result + (c2 - 48));
                        continue;
                    }
                    if (c2 >= 'a' && c2 <= 'f') {
                        result = (char)(result + (c2 - 97 + 10));
                        continue;
                    }
                    if (c2 < 'A') throw new NumberFormatException("\\u" + String.valueOf(this.in.subSequence(this.position, this.position + 4)));
                    if (c2 > 'F') throw new NumberFormatException("\\u" + String.valueOf(this.in.subSequence(this.position, this.position + 4)));
                    result = (char)(result + (c2 - 65 + 10));
                }
                this.position += 4;
                c = result;
                return c;
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            default: {
                c = escaped;
            }
        }
        return c;
    }

    @NotNull
    private JsonParseException createParseError(@NonNls String message) {
        throw new JsonParseException(message + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stack";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/dlv/JsonReaderEx";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/dlv/JsonReaderEx";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "beginObject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "peek";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "nextName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "nextQuotedValue";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "nextUnquotedValue";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "skipTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 10 -> new IllegalStateException(string);
        };
    }

    private static final class JsonScope {
        static final int EMPTY_ARRAY = 1;
        static final int NONEMPTY_ARRAY = 2;
        static final int EMPTY_OBJECT = 3;
        static final int DANGLING_NAME = 4;
        static final int NONEMPTY_OBJECT = 5;
        static final int EMPTY_DOCUMENT = 6;
        static final int NONEMPTY_DOCUMENT = 7;
        static final int CLOSED = 8;

        private JsonScope() {
        }
    }
}

