/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv;

import com.goide.GoIcons;
import com.goide.GoTypes;
import com.goide.dlv.DlvDebugProcess;
import com.goide.dlv.DlvExpressionEvaluator;
import com.goide.dlv.DlvSettings;
import com.goide.dlv.DlvStackFuncName;
import com.goide.dlv.DlvXValue;
import com.goide.dlv.protocol.DlvApi;
import com.goide.dlv.protocol.DlvRequest;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoForClause;
import com.goide.psi.GoVarDefinition;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.BitUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.impl.frame.XDebuggerFramesList;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DlvStackFrame
extends XStackFrame
implements XDebuggerFramesList.ItemWithSeparatorAbove {
    private final DlvDebugProcess myProcess;
    private final DlvApi.Location myLocation;
    private final DlvStackFuncName myDlvStackFuncName;
    private final long myGoroutineId;
    private final int myFrameId;
    @Nullable
    private volatile String myErr;
    private final boolean myAsync;
    private final XSourcePosition mySourcePosition;

    /*
     * WARNING - void declaration
     */
    DlvStackFrame(@NotNull DlvDebugProcess process, @NotNull DlvApi.Location location, @NotNull DlvStackFuncName stackFuncName, long goroutineId, int frameId, @Nullable String err, boolean bl) {
        void async;
        if (process == null) {
            DlvStackFrame.$$$reportNull$$$0(0);
        }
        if (location == null) {
            DlvStackFrame.$$$reportNull$$$0(1);
        }
        if (stackFuncName == null) {
            DlvStackFrame.$$$reportNull$$$0(2);
        }
        this.myProcess = process;
        this.myLocation = location;
        this.myDlvStackFuncName = stackFuncName;
        this.myGoroutineId = goroutineId;
        this.myFrameId = frameId;
        this.myErr = err;
        this.myAsync = async;
        this.mySourcePosition = this.computeSourcePosition();
    }

    boolean hasErr() {
        return this.myErr != null;
    }

    void setErr(@Nullable String err) {
        this.myErr = err;
    }

    public boolean hasSeparatorAbove() {
        return this.myAsync;
    }

    public String getCaptionAboveOf() {
        return GoBundle.message((String)"go.debugger.async.stacktrace.caption", (Object[])new Object[0]);
    }

    @Nullable
    public XDebuggerEvaluator getEvaluator() {
        return this.myAsync ? null : new DlvExpressionEvaluator(this.myProcess, this.myLocation, this.myFrameId, this.myGoroutineId);
    }

    @Nullable
    public Object getEqualityObject() {
        return this.myLocation.name();
    }

    public long getGoroutineId() {
        return this.myGoroutineId;
    }

    int getFrameId() {
        return this.myFrameId;
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.mySourcePosition;
    }

    @Nullable
    public XSourcePosition computeSourcePosition() {
        VirtualFile file = this.myProcess.findFile(this.myLocation);
        return file == null ? null : XDebuggerUtil.getInstance().createPosition(file, this.myLocation.line - 1);
    }

    public void customizePresentation(@NotNull ColoredTextContainer component2) {
        XSourcePosition position;
        if (component2 == null) {
            DlvStackFrame.$$$reportNull$$$0(3);
        }
        if ((position = this.getSourcePosition()) != null) {
            component2.append(this.myDlvStackFuncName.getFuncName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            component2.append(" (" + position.getFile().getName() + ":" + (position.getLine() + 1) + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            if (StringUtil.isNotEmpty((String)this.myDlvStackFuncName.getPackageImportPath())) {
                component2.append(" " + this.myDlvStackFuncName.getPackageImportPath(), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
            }
        } else {
            String file = this.myLocation.file;
            if (file != null) {
                component2.append(file + ":" + (this.myLocation.line + 1), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            } else {
                component2.append(XDebuggerBundle.message((String)"invalid.frame", (Object[])new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        }
    }

    public void computeChildren(@NotNull XCompositeNode node2) {
        String err;
        if (node2 == null) {
            DlvStackFrame.$$$reportNull$$$0(4);
        }
        if ((err = this.myErr) != null) {
            node2.setErrorMessage(err);
        }
        if (this.myAsync) {
            node2.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        VirtualFile file = this.myProcess.findFile(this.myLocation);
        Pair<Document, PsiFile> docAndFile = this.getDocumentAndFile(file);
        Document document = (Document)docAndFile.first;
        PsiFile psiFile = (PsiFile)docAndFile.second;
        ArrayList vars = new ArrayList();
        NotNullLazyValue loopVars = NotNullLazyValue.createValue(() -> DlvStackFrame.getVarNames(psiFile, document, this.myLocation.line - 1, var -> PsiTreeUtil.getParentOfType((PsiElement)var, GoForClause.class) != null));
        this.myProcess.send(new DlvRequest.ListLocalVars(this.myGoroutineId, this.myFrameId)).thenAsync(variables -> {
            for (DlvApi.Variable v : variables) {
                BigInteger varLine;
                DlvXValue xValue = DlvXValue.create(this.myProcess, null, v, this.myFrameId, this.myGoroutineId, null);
                if (xValue.isUnreadable() && !DlvSettings.getInstance().getShowUnreadableVariables() || (varLine = (BigInteger)ObjectUtils.notNull((Object)v.declLine, (Object)BigInteger.ZERO)).compareTo(BigInteger.valueOf(this.myLocation.line)) >= 0 && psiFile != null && !((List)loopVars.getValue()).contains(v.name)) continue;
                vars.add(Pair.create((Object)DlvStackFrame.getVariableName(v, xValue), (Object)((Object)xValue)));
            }
            return this.myProcess.send(new DlvRequest.ListFunctionArgs(this.myGoroutineId, this.myFrameId));
        }).onSuccess(args -> {
            XValueChildrenList xVars = new XValueChildrenList(vars.size() + args.size());
            for (DlvApi.Variable v : args) {
                DlvXValue xValue;
                if (v.name != null && v.name.startsWith("~r") || (xValue = DlvXValue.create(this.myProcess, null, v, this.myFrameId, this.myGoroutineId, GoIcons.PARAMETER)).isUnreadable() && !DlvSettings.getInstance().getShowUnreadableVariables()) continue;
                xVars.add(DlvStackFrame.getVariableName(v, xValue), (XValue)xValue);
            }
            if (!XDebuggerSettingsManager.getInstance().getDataViewSettings().isSortValues()) {
                vars.sort(DlvStackFrame.createLocalVarComparator(psiFile, document));
            }
            for (DlvApi.Variable v : vars) {
                xVars.add((String)((Pair)v).first, (XValue)((Pair)v).second);
            }
            node2.addChildren(xVars, true);
        }).onError(th -> node2.setMessage(th.getMessage(), AllIcons.General.Warning, SimpleTextAttributes.REGULAR_ATTRIBUTES, null));
    }

    private Pair<Document, PsiFile> getDocumentAndFile(@Nullable VirtualFile file) {
        return (Pair)ReadAction.compute(() -> {
            Document document = file != null ? FileDocumentManager.getInstance().getDocument(file) : null;
            PsiFile psiFile = document != null ? PsiDocumentManager.getInstance((Project)this.myProcess.getSession().getProject()).getPsiFile(document) : null;
            return Pair.create((Object)document, psiFile);
        });
    }

    @NotNull
    private static String getVariableName(@NotNull DlvApi.Variable v, @NotNull DlvXValue xValue) {
        if (v == null) {
            DlvStackFrame.$$$reportNull$$$0(5);
        }
        if (xValue == null) {
            DlvStackFrame.$$$reportNull$$$0(6);
        }
        Object varName = xValue.getName();
        if (BitUtil.isSet((int)v.flags, (int)2)) {
            varName = (String)varName + " (shadowed)";
        }
        String string = varName;
        if (string == null) {
            DlvStackFrame.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public DlvApi.Location getLocation() {
        DlvApi.Location location = this.myLocation;
        if (location == null) {
            DlvStackFrame.$$$reportNull$$$0(8);
        }
        return location;
    }

    @NotNull
    private static Comparator<Pair<String, DlvXValue>> createLocalVarComparator(@Nullable PsiFile file, @Nullable Document document) {
        HashMap varNamesPerLine = new HashMap();
        Comparator comparator = (o1, o2) -> {
            int line;
            BigInteger line2;
            DlvApi.Variable var1 = ((DlvXValue)((Object)((Object)o1.second))).getVariable();
            DlvApi.Variable var2 = ((DlvXValue)((Object)((Object)o2.second))).getVariable();
            BigInteger line1 = (BigInteger)ObjectUtils.notNull((Object)var1.declLine, (Object)BigInteger.ZERO);
            int byDeclLine = line1.compareTo(line2 = (BigInteger)ObjectUtils.notNull((Object)var2.declLine, (Object)BigInteger.ZERO));
            if (byDeclLine != 0) {
                return byDeclLine;
            }
            try {
                line = line1.intValueExact() - 1;
            }
            catch (ArithmeticException e) {
                return 0;
            }
            List varNames = varNamesPerLine.computeIfAbsent(line, it -> DlvStackFrame.getVarNames(file, document, it, __ -> true));
            return Integer.compare(varNames.indexOf(o1.first), varNames.indexOf(o2.first));
        };
        if (comparator == null) {
            DlvStackFrame.$$$reportNull$$$0(9);
        }
        return comparator;
    }

    @NotNull
    private static List<String> getVarNames(@Nullable PsiFile file, @Nullable Document document, int line, @NotNull Predicate<? super GoVarDefinition> predicate) {
        if (predicate == null) {
            DlvStackFrame.$$$reportNull$$$0(10);
        }
        ArrayList<String> result = new ArrayList<String>();
        DlvStackFrame.processIdentifiers(file, document, line, (Processor<? super PsiElement>)((Processor)identifier -> {
            GoVarDefinition definition = (GoVarDefinition)ObjectUtils.tryCast((Object)identifier.getParent(), GoVarDefinition.class);
            if (definition != null && predicate.test(definition)) {
                result.add(definition.getName());
            }
            return true;
        }));
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            DlvStackFrame.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    static void processIdentifiers(@Nullable PsiFile file, @Nullable Document document, int line, @NotNull Processor<? super PsiElement> processor2) {
        if (processor2 == null) {
            DlvStackFrame.$$$reportNull$$$0(12);
        }
        if (file == null || document == null) {
            return;
        }
        ReadAction.run(() -> {
            try {
                int lineStart = document.getLineStartOffset(line);
                int lineEnd = document.getLineEndOffset(line);
                PsiElement at = file.findElementAt(lineStart);
                while (at != null && at.getTextOffset() < lineEnd) {
                    if (at.getNode().getElementType() == GoTypes.IDENTIFIER && !processor2.process((Object)at)) {
                        return;
                    }
                    at = PsiTreeUtil.nextVisibleLeaf((PsiElement)at);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DlvStackFrame)) {
            return false;
        }
        DlvStackFrame frame = (DlvStackFrame)((Object)o);
        if (this.myGoroutineId != frame.myGoroutineId || this.myFrameId != frame.myFrameId || !((Object)((Object)this.myProcess)).equals((Object)frame.myProcess)) {
            return false;
        }
        return this.myLocation.equals(frame.myLocation);
    }

    public int hashCode() {
        int result = ((Object)((Object)this.myProcess)).hashCode();
        result = 31 * result + this.myLocation.hashCode();
        result = 31 * result + Long.hashCode(this.myGoroutineId);
        result = 31 * result + this.myFrameId;
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackFuncName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xValue";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/dlv/DlvStackFrame";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/dlv/DlvStackFrame";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocalVarComparator";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizePresentation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getVariableName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getVarNames";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processIdentifiers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 11 -> new IllegalStateException(string);
        };
    }
}

